# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from equinix.services.fabricv4.models.aws_provider_response import AWSProviderResponse
from equinix.services.fabricv4.models.fabric_provider_response import FabricProviderResponse
from equinix.services.fabricv4.models.gcp_provider_response import GCPProviderResponse
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

PROVIDERRESPONSE_ONE_OF_SCHEMAS = ["AWSProviderResponse", "FabricProviderResponse", "GCPProviderResponse"]

class ProviderResponse(BaseModel):
    """
    Describes the response structure for different orchestrator provider types, including their specific configuration details. 
    """
    # data type: FabricProviderResponse
    oneof_schema_1_validator: Optional[FabricProviderResponse] = None
    # data type: AWSProviderResponse
    oneof_schema_2_validator: Optional[AWSProviderResponse] = None
    # data type: GCPProviderResponse
    oneof_schema_3_validator: Optional[GCPProviderResponse] = None
    actual_instance: Optional[Union[AWSProviderResponse, FabricProviderResponse, GCPProviderResponse]] = None
    one_of_schemas: Set[str] = { "AWSProviderResponse", "FabricProviderResponse", "GCPProviderResponse" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ProviderResponse.model_construct()
        error_messages = []
        match = 0
        # validate data type: FabricProviderResponse
        if not isinstance(v, FabricProviderResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricProviderResponse`")
        else:
            match += 1
        # validate data type: AWSProviderResponse
        if not isinstance(v, AWSProviderResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AWSProviderResponse`")
        else:
            match += 1
        # validate data type: GCPProviderResponse
        if not isinstance(v, GCPProviderResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GCPProviderResponse`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ProviderResponse with oneOf schemas: AWSProviderResponse, FabricProviderResponse, GCPProviderResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ProviderResponse with oneOf schemas: AWSProviderResponse, FabricProviderResponse, GCPProviderResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into FabricProviderResponse
        try:
            instance.actual_instance = FabricProviderResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AWSProviderResponse
        try:
            instance.actual_instance = AWSProviderResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GCPProviderResponse
        try:
            instance.actual_instance = GCPProviderResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ProviderResponse with oneOf schemas: AWSProviderResponse, FabricProviderResponse, GCPProviderResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ProviderResponse with oneOf schemas: AWSProviderResponse, FabricProviderResponse, GCPProviderResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AWSProviderResponse, FabricProviderResponse, GCPProviderResponse]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


