# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from equinix.services.fabricv4.models.api_config import ApiConfig
from equinix.services.fabricv4.models.authentication_key import AuthenticationKey
from equinix.services.fabricv4.models.service_profile_access_point_type_enum import ServiceProfileAccessPointTypeEnum
from equinix.services.fabricv4.models.service_profile_link_protocol_config import ServiceProfileLinkProtocolConfig
from equinix.services.fabricv4.models.service_profile_metadata import ServiceProfileMetadata
from typing import Optional, Set
from typing_extensions import Self

class ServiceProfileAccessPointTypeCOLO(BaseModel):
    """
    Colo Access Point Type
    """ # noqa: E501
    uuid: Optional[StrictStr] = None
    type: ServiceProfileAccessPointTypeEnum
    supported_bandwidths: Optional[List[StrictInt]] = Field(default=None, alias="supportedBandwidths")
    allow_remote_connections: Optional[StrictBool] = Field(default=False, description="Setting to allow or prohibit remote connections to the service profile.", alias="allowRemoteConnections")
    allow_custom_bandwidth: Optional[StrictBool] = Field(default=False, description="Setting to enable or disable the ability of the buyer to customize the bandwidth.", alias="allowCustomBandwidth")
    bandwidth_alert_threshold: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="percentage of port bandwidth at which an allocation alert is generated - missing on wiki.", alias="bandwidthAlertThreshold")
    allow_bandwidth_auto_approval: Optional[StrictBool] = Field(default=False, description="Setting to enable or disable the ability of the buyer to change connection bandwidth without approval of the seller.", alias="allowBandwidthAutoApproval")
    allow_bandwidth_upgrade: Optional[StrictBool] = Field(default=None, description="Availability of a bandwidth upgrade. The default is false.", alias="allowBandwidthUpgrade")
    link_protocol_config: Optional[ServiceProfileLinkProtocolConfig] = Field(default=None, alias="linkProtocolConfig")
    enable_auto_generate_service_key: Optional[StrictBool] = Field(default=None, description="for verizon only.", alias="enableAutoGenerateServiceKey")
    connection_redundancy_required: Optional[StrictBool] = Field(default=False, description="Mandate redundant connections", alias="connectionRedundancyRequired")
    selective_redundancy: Optional[StrictBool] = Field(default=False, description="Optional redundant connections", alias="selectiveRedundancy")
    api_config: Optional[ApiConfig] = Field(default=None, alias="apiConfig")
    connection_label: Optional[StrictStr] = Field(default=None, description="custom name for \"Connection\"", alias="connectionLabel")
    authentication_key: Optional[AuthenticationKey] = Field(default=None, alias="authenticationKey")
    metadata: Optional[ServiceProfileMetadata] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["uuid", "type", "supportedBandwidths", "allowRemoteConnections", "allowCustomBandwidth", "bandwidthAlertThreshold", "allowBandwidthAutoApproval", "allowBandwidthUpgrade", "linkProtocolConfig", "enableAutoGenerateServiceKey", "connectionRedundancyRequired", "selectiveRedundancy", "apiConfig", "connectionLabel", "authenticationKey", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServiceProfileAccessPointTypeCOLO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of link_protocol_config
        if self.link_protocol_config:
            _dict['linkProtocolConfig'] = self.link_protocol_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of api_config
        if self.api_config:
            _dict['apiConfig'] = self.api_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authentication_key
        if self.authentication_key:
            _dict['authenticationKey'] = self.authentication_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServiceProfileAccessPointTypeCOLO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uuid": obj.get("uuid"),
            "type": obj.get("type"),
            "supportedBandwidths": obj.get("supportedBandwidths"),
            "allowRemoteConnections": obj.get("allowRemoteConnections") if obj.get("allowRemoteConnections") is not None else False,
            "allowCustomBandwidth": obj.get("allowCustomBandwidth") if obj.get("allowCustomBandwidth") is not None else False,
            "bandwidthAlertThreshold": obj.get("bandwidthAlertThreshold"),
            "allowBandwidthAutoApproval": obj.get("allowBandwidthAutoApproval") if obj.get("allowBandwidthAutoApproval") is not None else False,
            "allowBandwidthUpgrade": obj.get("allowBandwidthUpgrade"),
            "linkProtocolConfig": ServiceProfileLinkProtocolConfig.from_dict(obj["linkProtocolConfig"]) if obj.get("linkProtocolConfig") is not None else None,
            "enableAutoGenerateServiceKey": obj.get("enableAutoGenerateServiceKey"),
            "connectionRedundancyRequired": obj.get("connectionRedundancyRequired") if obj.get("connectionRedundancyRequired") is not None else False,
            "selectiveRedundancy": obj.get("selectiveRedundancy") if obj.get("selectiveRedundancy") is not None else False,
            "apiConfig": ApiConfig.from_dict(obj["apiConfig"]) if obj.get("apiConfig") is not None else None,
            "connectionLabel": obj.get("connectionLabel"),
            "authenticationKey": AuthenticationKey.from_dict(obj["authenticationKey"]) if obj.get("authenticationKey") is not None else None,
            "metadata": ServiceProfileMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


