# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.changelog import Changelog
from equinix.services.fabricv4.models.project import Project
from equinix.services.fabricv4.models.stream_post_request_type import StreamPostRequestType
from typing import Optional, Set
from typing_extensions import Self

class Stream(BaseModel):
    """
    Stream object
    """ # noqa: E501
    href: Optional[StrictStr] = Field(default=None, description="Stream URI")
    uuid: Optional[StrictStr] = Field(default=None, description="Equinix-assigned access point identifier")
    state: Optional[StrictStr] = Field(default=None, description="Stream provision state")
    assets_count: Optional[StrictInt] = Field(default=None, description="Stream assets count", alias="assetsCount")
    stream_subscriptions_count: Optional[StrictInt] = Field(default=None, description="Stream subscriptions count", alias="streamSubscriptionsCount")
    change_log: Optional[Changelog] = Field(default=None, alias="changeLog")
    type: Optional[StreamPostRequestType] = None
    name: Optional[StrictStr] = Field(default=None, description="Customer-provided stream name")
    description: Optional[StrictStr] = Field(default=None, description="Customer-provided stream description")
    project: Optional[Project] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["type", "name", "description", "project"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PROVISIONING', 'PROVISIONED', 'REPROVISIONING', 'DEPROVISIONING', 'DEPROVISIONED', 'FAILED']):
            raise ValueError("must be one of enum values ('PROVISIONING', 'PROVISIONED', 'REPROVISIONING', 'DEPROVISIONING', 'DEPROVISIONED', 'FAILED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Stream from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "href",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Stream from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


