# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.changelog import Changelog
from equinix.services.fabricv4.models.subscription_entitlement_response import SubscriptionEntitlementResponse
from equinix.services.fabricv4.models.subscription_response_marketplace import SubscriptionResponseMarketplace
from equinix.services.fabricv4.models.subscription_response_offer_type import SubscriptionResponseOfferType
from equinix.services.fabricv4.models.subscription_state import SubscriptionState
from equinix.services.fabricv4.models.subscription_trial import SubscriptionTrial
from typing import Optional, Set
from typing_extensions import Self

class SubscriptionResponse(BaseModel):
    """
    Subscription Response
    """ # noqa: E501
    href: Optional[StrictStr] = Field(default=None, description="Subscription URL")
    uuid: Optional[StrictStr] = Field(default=None, description="Unique identifier of the Subscription")
    state: SubscriptionState
    marketplace: SubscriptionResponseMarketplace
    offer_type: Optional[SubscriptionResponseOfferType] = Field(default=None, alias="offerType")
    is_auto_renew: Optional[StrictBool] = Field(default=None, description="Is Auto Renewal Enabled", alias="isAutoRenew")
    offer_id: Optional[StrictStr] = Field(default=None, description="Marketplace Offer Id", alias="offerId")
    trial: Optional[SubscriptionTrial] = None
    metro_codes: Optional[List[StrictStr]] = Field(default=None, description="List of available metro", alias="metroCodes")
    entitlements: List[SubscriptionEntitlementResponse] = Field(description="List of entitlements associated with the subscription")
    changelog: Optional[Changelog] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["href", "uuid", "state", "marketplace", "offerType", "isAutoRenew", "offerId", "trial", "metroCodes", "entitlements", "changelog"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubscriptionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of trial
        if self.trial:
            _dict['trial'] = self.trial.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in entitlements (list)
        _items = []
        if self.entitlements:
            for _item_entitlements in self.entitlements:
                if _item_entitlements:
                    _items.append(_item_entitlements.to_dict())
            _dict['entitlements'] = _items
        # override the default output from pydantic by calling `to_dict()` of changelog
        if self.changelog:
            _dict['changelog'] = self.changelog.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubscriptionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "href": obj.get("href"),
            "uuid": obj.get("uuid"),
            "state": obj.get("state"),
            "marketplace": obj.get("marketplace"),
            "offerType": obj.get("offerType"),
            "isAutoRenew": obj.get("isAutoRenew"),
            "offerId": obj.get("offerId"),
            "trial": SubscriptionTrial.from_dict(obj["trial"]) if obj.get("trial") is not None else None,
            "metroCodes": obj.get("metroCodes"),
            "entitlements": [SubscriptionEntitlementResponse.from_dict(_item) for _item in obj["entitlements"]] if obj.get("entitlements") is not None else None,
            "changelog": Changelog.from_dict(obj["changelog"]) if obj.get("changelog") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


