# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.bgp_dynamic_neighbor import BgpDynamicNeighbor
from equinix.services.metalv1.models.meta import Meta
from typing import Optional, Set
from typing_extensions import Self

class BgpDynamicNeighborList(BaseModel):
    """
    BgpDynamicNeighborList
    """ # noqa: E501
    bgp_dynamic_neighbors: Optional[List[BgpDynamicNeighbor]] = None
    href: Optional[StrictStr] = None
    meta: Optional[Meta] = None
    __properties: ClassVar[List[str]] = ["bgp_dynamic_neighbors", "href", "meta"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BgpDynamicNeighborList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bgp_dynamic_neighbors (list)
        _items = []
        if self.bgp_dynamic_neighbors:
            for _item_bgp_dynamic_neighbors in self.bgp_dynamic_neighbors:
                if _item_bgp_dynamic_neighbors:
                    _items.append(_item_bgp_dynamic_neighbors.to_dict())
            _dict['bgp_dynamic_neighbors'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BgpDynamicNeighborList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bgp_dynamic_neighbors": [BgpDynamicNeighbor.from_dict(_item) for _item in obj["bgp_dynamic_neighbors"]] if obj.get("bgp_dynamic_neighbors") is not None else None,
            "href": obj.get("href"),
            "meta": Meta.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


