# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DedicatedPortCreateInput(BaseModel):
    """
    DedicatedPortCreateInput
    """ # noqa: E501
    billing_account_name: Optional[StrictStr] = Field(default=None, description="The billing account name of the Equinix Fabric account.")
    contact_email: Optional[StrictStr] = Field(default=None, description="The preferred email used for communication and notifications about the Equinix Fabric interconnection. Optional and defaults to the primary user email address when using a User API key or the organization owner email address when using a Project API key.")
    description: Optional[StrictStr] = None
    facility_id: Optional[StrictStr] = None
    href: Optional[StrictStr] = None
    metro: StrictStr = Field(description="A Metro ID or code. For interconnections with Dedicated Ports, this will be the location of the issued Dedicated Ports.")
    mode: Optional[StrictStr] = Field(default=None, description="The mode of the interconnection (only relevant to Dedicated Ports). Fabric VCs won't have this field. Can be either 'standard' or 'tunnel'.   The default mode of an interconnection on a Dedicated Port is 'standard'. The mode can only be changed when there are no associated virtual circuits on the interconnection.   In tunnel mode, an 802.1q tunnel is added to a port to send/receive double tagged packets from server instances.")
    name: StrictStr
    project: Optional[StrictStr] = None
    redundancy: StrictStr = Field(description="Either 'primary' or 'redundant'.")
    speed: Optional[StrictStr] = Field(default=None, description="A interconnection speed, in bps, mbps, or gbps. For Dedicated Ports, this can be 10Gbps or 100Gbps.")
    tags: Optional[List[StrictStr]] = None
    type: StrictStr = Field(description="When requesting for a dedicated port, the value of this field should be 'dedicated'.")
    use_case: Optional[StrictStr] = Field(default=None, description="The intended use case of the dedicated port.")
    __properties: ClassVar[List[str]] = ["billing_account_name", "contact_email", "description", "facility_id", "href", "metro", "mode", "name", "project", "redundancy", "speed", "tags", "type", "use_case"]

    @field_validator('mode')
    def mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['standard', 'tunnel']):
            raise ValueError("must be one of enum values ('standard', 'tunnel')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['dedicated']):
            raise ValueError("must be one of enum values ('dedicated')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DedicatedPortCreateInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DedicatedPortCreateInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "billing_account_name": obj.get("billing_account_name"),
            "contact_email": obj.get("contact_email"),
            "description": obj.get("description"),
            "facility_id": obj.get("facility_id"),
            "href": obj.get("href"),
            "metro": obj.get("metro"),
            "mode": obj.get("mode"),
            "name": obj.get("name"),
            "project": obj.get("project"),
            "redundancy": obj.get("redundancy"),
            "speed": obj.get("speed"),
            "tags": obj.get("tags"),
            "type": obj.get("type"),
            "use_case": obj.get("use_case")
        })
        return _obj


