# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.attribute import Attribute
from equinix.services.metalv1.models.component import Component
from typing import Optional, Set
from typing_extensions import Self

class FirmwareSet(BaseModel):
    """
    Represents a Firmware Set
    """ # noqa: E501
    attributes: Optional[List[Attribute]] = Field(default=None, description="Represents a list of attributes")
    component_firmware: Optional[List[Component]] = Field(default=None, description="List of components versions")
    created_at: Optional[datetime] = Field(default=None, description="Datetime when the block was created.")
    href: Optional[StrictStr] = None
    name: StrictStr = Field(description="Firmware Set Name")
    updated_at: Optional[datetime] = Field(default=None, description="Datetime when the block was updated.")
    uuid: StrictStr = Field(description="Firmware Set UUID")
    __properties: ClassVar[List[str]] = ["attributes", "component_firmware", "created_at", "href", "name", "updated_at", "uuid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FirmwareSet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "name",
            "updated_at",
            "uuid",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['attributes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in component_firmware (list)
        _items = []
        if self.component_firmware:
            for _item_component_firmware in self.component_firmware:
                if _item_component_firmware:
                    _items.append(_item_component_firmware.to_dict())
            _dict['component_firmware'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FirmwareSet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None,
            "component_firmware": [Component.from_dict(_item) for _item in obj["component_firmware"]] if obj.get("component_firmware") is not None else None,
            "created_at": obj.get("created_at"),
            "href": obj.get("href"),
            "name": obj.get("name"),
            "updated_at": obj.get("updated_at"),
            "uuid": obj.get("uuid")
        })
        return _obj


