# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.firmware_set import FirmwareSet
from typing import Optional, Set
from typing_extensions import Self

class FirmwareSetListResponse(BaseModel):
    """
    Represents collection of Firmware Sets
    """ # noqa: E501
    href: Optional[StrictStr] = None
    page: Optional[StrictInt] = Field(default=None, description="Page returned")
    page_count: Optional[StrictInt] = Field(default=None, description="Items returned in current page")
    page_size: Optional[StrictInt] = Field(default=None, description="Max number of items returned in a page")
    records: Optional[List[FirmwareSet]] = Field(default=None, description="Represents a list of FirmwareSets")
    total_pages: Optional[StrictInt] = Field(default=None, description="Total count of pages")
    total_record_count: Optional[StrictInt] = Field(default=None, description="Total count of items")
    __properties: ClassVar[List[str]] = ["href", "page", "page_count", "page_size", "records", "total_pages", "total_record_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FirmwareSetListResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in records (list)
        _items = []
        if self.records:
            for _item_records in self.records:
                if _item_records:
                    _items.append(_item_records.to_dict())
            _dict['records'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FirmwareSetListResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "href": obj.get("href"),
            "page": obj.get("page"),
            "page_count": obj.get("page_count"),
            "page_size": obj.get("page_size"),
            "records": [FirmwareSet.from_dict(_item) for _item in obj["records"]] if obj.get("records") is not None else None,
            "total_pages": obj.get("total_pages"),
            "total_record_count": obj.get("total_record_count")
        })
        return _obj


