# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from equinix.services.metalv1.models.line_item import LineItem
from equinix.services.metalv1.models.project_id_name import ProjectIdName
from typing import Optional, Set
from typing_extensions import Self

class Invoice(BaseModel):
    """
    Invoice
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    balance: Optional[Union[StrictFloat, StrictInt]] = None
    created_on: Optional[date] = None
    credit_amount: Optional[Union[StrictFloat, StrictInt]] = None
    credits_applied: Optional[Union[StrictFloat, StrictInt]] = None
    currency: Optional[StrictStr] = None
    due_on: Optional[date] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    items: Optional[List[LineItem]] = None
    number: Optional[StrictStr] = None
    project: Optional[ProjectIdName] = None
    reference_number: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    target_date: Optional[date] = None
    __properties: ClassVar[List[str]] = ["amount", "balance", "created_on", "credit_amount", "credits_applied", "currency", "due_on", "href", "id", "items", "number", "project", "reference_number", "status", "target_date"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Invoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Invoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "balance": obj.get("balance"),
            "created_on": obj.get("created_on"),
            "credit_amount": obj.get("credit_amount"),
            "credits_applied": obj.get("credits_applied"),
            "currency": obj.get("currency"),
            "due_on": obj.get("due_on"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "items": [LineItem.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "number": obj.get("number"),
            "project": ProjectIdName.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "reference_number": obj.get("reference_number"),
            "status": obj.get("status"),
            "target_date": obj.get("target_date")
        })
        return _obj


