# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.port_convert_layer3_input_request_ips_inner import PortConvertLayer3InputRequestIpsInner
from typing import Optional, Set
from typing_extensions import Self

class PortConvertLayer3Input(BaseModel):
    """
    PortConvertLayer3Input
    """ # noqa: E501
    href: Optional[StrictStr] = None
    request_ips: Optional[List[PortConvertLayer3InputRequestIpsInner]] = None
    __properties: ClassVar[List[str]] = ["href", "request_ips"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PortConvertLayer3Input from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in request_ips (list)
        _items = []
        if self.request_ips:
            for _item_request_ips in self.request_ips:
                if _item_request_ips:
                    _items.append(_item_request_ips.to_dict())
            _dict['request_ips'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PortConvertLayer3Input from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "href": obj.get("href"),
            "request_ips": [PortConvertLayer3InputRequestIpsInner.from_dict(_item) for _item in obj["request_ips"]] if obj.get("request_ips") is not None else None
        })
        return _obj


