# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.href import Href
from equinix.services.metalv1.models.port import Port
from equinix.services.metalv1.models.port_vlan_assignment_batch_vlan_assignments_inner import PortVlanAssignmentBatchVlanAssignmentsInner
from typing import Optional, Set
from typing_extensions import Self

class PortVlanAssignmentBatch(BaseModel):
    """
    PortVlanAssignmentBatch
    """ # noqa: E501
    created_at: Optional[datetime] = None
    error_messages: Optional[List[StrictStr]] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    port: Optional[Port] = None
    project: Optional[Href] = None
    quantity: Optional[StrictInt] = None
    state: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    vlan_assignments: Optional[List[PortVlanAssignmentBatchVlanAssignmentsInner]] = None
    __properties: ClassVar[List[str]] = ["created_at", "error_messages", "href", "id", "port", "project", "quantity", "state", "updated_at", "vlan_assignments"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['queued', 'in_progress', 'completed', 'failed']):
            raise ValueError("must be one of enum values ('queued', 'in_progress', 'completed', 'failed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PortVlanAssignmentBatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of port
        if self.port:
            _dict['port'] = self.port.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in vlan_assignments (list)
        _items = []
        if self.vlan_assignments:
            for _item_vlan_assignments in self.vlan_assignments:
                if _item_vlan_assignments:
                    _items.append(_item_vlan_assignments.to_dict())
            _dict['vlan_assignments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PortVlanAssignmentBatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "error_messages": obj.get("error_messages"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "port": Port.from_dict(obj["port"]) if obj.get("port") is not None else None,
            "project": Href.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "quantity": obj.get("quantity"),
            "state": obj.get("state"),
            "updated_at": obj.get("updated_at"),
            "vlan_assignments": [PortVlanAssignmentBatchVlanAssignmentsInner.from_dict(_item) for _item in obj["vlan_assignments"]] if obj.get("vlan_assignments") is not None else None
        })
        return _obj


