# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from equinix.services.metalv1.models.plan import Plan
from typing import Optional, Set
from typing_extensions import Self

class SelfServiceReservationItemResponse(BaseModel):
    """
    SelfServiceReservationItemResponse
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    metro_code: Optional[StrictStr] = None
    metro_id: Optional[StrictStr] = None
    metro_name: Optional[StrictStr] = None
    plan: Optional[Plan] = None
    plan_categories: Optional[List[StrictStr]] = None
    plan_id: Optional[StrictStr] = None
    plan_name: Optional[StrictStr] = None
    plan_slug: Optional[StrictStr] = None
    quantity: Optional[StrictInt] = None
    term: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["amount", "href", "id", "metro_code", "metro_id", "metro_name", "plan", "plan_categories", "plan_id", "plan_name", "plan_slug", "quantity", "term"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SelfServiceReservationItemResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SelfServiceReservationItemResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "metro_code": obj.get("metro_code"),
            "metro_id": obj.get("metro_id"),
            "metro_name": obj.get("metro_name"),
            "plan": Plan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "plan_categories": obj.get("plan_categories"),
            "plan_id": obj.get("plan_id"),
            "plan_name": obj.get("plan_name"),
            "plan_slug": obj.get("plan_slug"),
            "quantity": obj.get("quantity"),
            "term": obj.get("term")
        })
        return _obj


