# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.disk import Disk
from equinix.services.metalv1.models.filesystem import Filesystem
from equinix.services.metalv1.models.raid import Raid
from typing import Optional, Set
from typing_extensions import Self

class Storage(BaseModel):
    """
    Storage
    """ # noqa: E501
    disks: Optional[List[Disk]] = None
    filesystems: Optional[List[Filesystem]] = None
    href: Optional[StrictStr] = None
    raid: Optional[List[Raid]] = None
    __properties: ClassVar[List[str]] = ["disks", "filesystems", "href", "raid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Storage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in disks (list)
        _items = []
        if self.disks:
            for _item_disks in self.disks:
                if _item_disks:
                    _items.append(_item_disks.to_dict())
            _dict['disks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in filesystems (list)
        _items = []
        if self.filesystems:
            for _item_filesystems in self.filesystems:
                if _item_filesystems:
                    _items.append(_item_filesystems.to_dict())
            _dict['filesystems'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in raid (list)
        _items = []
        if self.raid:
            for _item_raid in self.raid:
                if _item_raid:
                    _items.append(_item_raid.to_dict())
            _dict['raid'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Storage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "disks": [Disk.from_dict(_item) for _item in obj["disks"]] if obj.get("disks") is not None else None,
            "filesystems": [Filesystem.from_dict(_item) for _item in obj["filesystems"]] if obj.get("filesystems") is not None else None,
            "href": obj.get("href"),
            "raid": [Raid.from_dict(_item) for _item in obj["raid"]] if obj.get("raid") is not None else None
        })
        return _obj


