# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.href import Href
from typing import Optional, Set
from typing_extensions import Self

class User(BaseModel):
    """
    User
    """ # noqa: E501
    avatar_thumb_url: Optional[StrictStr] = None
    avatar_url: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    customdata: Optional[Dict[str, Any]] = None
    default_organization_id: Optional[StrictStr] = None
    default_project_id: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    emails: Optional[List[Href]] = None
    first_name: Optional[StrictStr] = None
    fraud_score: Optional[StrictStr] = None
    full_name: Optional[StrictStr] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    last_login_at: Optional[datetime] = None
    last_name: Optional[StrictStr] = None
    max_organizations: Optional[StrictInt] = None
    max_projects: Optional[StrictInt] = None
    phone_number: Optional[StrictStr] = None
    short_id: Optional[StrictStr] = None
    timezone: Optional[StrictStr] = None
    two_factor_auth: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["avatar_thumb_url", "avatar_url", "created_at", "customdata", "default_organization_id", "default_project_id", "email", "emails", "first_name", "fraud_score", "full_name", "href", "id", "last_login_at", "last_name", "max_organizations", "max_projects", "phone_number", "short_id", "timezone", "two_factor_auth", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in emails (list)
        _items = []
        if self.emails:
            for _item_emails in self.emails:
                if _item_emails:
                    _items.append(_item_emails.to_dict())
            _dict['emails'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatar_thumb_url": obj.get("avatar_thumb_url"),
            "avatar_url": obj.get("avatar_url"),
            "created_at": obj.get("created_at"),
            "customdata": obj.get("customdata"),
            "default_organization_id": obj.get("default_organization_id"),
            "default_project_id": obj.get("default_project_id"),
            "email": obj.get("email"),
            "emails": [Href.from_dict(_item) for _item in obj["emails"]] if obj.get("emails") is not None else None,
            "first_name": obj.get("first_name"),
            "fraud_score": obj.get("fraud_score"),
            "full_name": obj.get("full_name"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "last_login_at": obj.get("last_login_at"),
            "last_name": obj.get("last_name"),
            "max_organizations": obj.get("max_organizations"),
            "max_projects": obj.get("max_projects"),
            "phone_number": obj.get("phone_number"),
            "short_id": obj.get("short_id"),
            "timezone": obj.get("timezone"),
            "two_factor_auth": obj.get("two_factor_auth"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


