# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.href import Href
from equinix.services.metalv1.models.project import Project
from equinix.services.metalv1.models.virtual_network import VirtualNetwork
from equinix.services.metalv1.models.vrf import Vrf
from equinix.services.metalv1.models.vrf_ip_reservation import VrfIpReservation
from typing import Optional, Set
from typing_extensions import Self

class VrfMetalGateway(BaseModel):
    """
    VrfMetalGateway
    """ # noqa: E501
    created_at: Optional[datetime] = None
    created_by: Optional[Href] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    ip_reservation: Optional[VrfIpReservation] = None
    project: Optional[Project] = None
    state: Optional[StrictStr] = Field(default=None, description="The current state of the Metal Gateway. 'Ready' indicates the gateway record has been configured, but is currently not active on the network. 'Active' indicates the gateway has been configured on the network. 'Deleting' is a temporary state used to indicate that the gateway is in the process of being un-configured from the network, after which the gateway record will be deleted.")
    updated_at: Optional[datetime] = None
    virtual_network: Optional[VirtualNetwork] = None
    vrf: Optional[Vrf] = None
    __properties: ClassVar[List[str]] = ["created_at", "created_by", "href", "id", "ip_reservation", "project", "state", "updated_at", "virtual_network", "vrf"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ready', 'active', 'deleting']):
            raise ValueError("must be one of enum values ('ready', 'active', 'deleting')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VrfMetalGateway from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['created_by'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ip_reservation
        if self.ip_reservation:
            _dict['ip_reservation'] = self.ip_reservation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virtual_network
        if self.virtual_network:
            _dict['virtual_network'] = self.virtual_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vrf
        if self.vrf:
            _dict['vrf'] = self.vrf.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VrfMetalGateway from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "created_by": Href.from_dict(obj["created_by"]) if obj.get("created_by") is not None else None,
            "href": obj.get("href"),
            "id": obj.get("id"),
            "ip_reservation": VrfIpReservation.from_dict(obj["ip_reservation"]) if obj.get("ip_reservation") is not None else None,
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "state": obj.get("state"),
            "updated_at": obj.get("updated_at"),
            "virtual_network": VirtualNetwork.from_dict(obj["virtual_network"]) if obj.get("virtual_network") is not None else None,
            "vrf": Vrf.from_dict(obj["vrf"]) if obj.get("vrf") is not None else None
        })
        return _obj


