# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.metalv1.models.virtual_network import VirtualNetwork
from equinix.services.metalv1.models.vrf import Vrf
from equinix.services.metalv1.models.vrf_metal_gateway import VrfMetalGateway
from typing import Optional, Set
from typing_extensions import Self

class VrfRoute(BaseModel):
    """
    VrfRoute
    """ # noqa: E501
    created_at: Optional[datetime] = None
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the newly-created resource")
    metal_gateway: Optional[VrfMetalGateway] = None
    next_hop: Optional[StrictStr] = Field(default=None, description="The next-hop IPv4 address for the route")
    prefix: Optional[StrictStr] = Field(default=None, description="The IPv4 prefix for the route, in CIDR-style notation")
    status: Optional[StrictStr] = Field(default=None, description="The status of the route. Potential values are \"pending\", \"active\", \"deleting\", and \"error\", representing various lifecycle states of the route and whether or not it has been successfully configured on the network")
    tags: Optional[List[StrictStr]] = None
    type: Optional[StrictStr] = Field(default=None, description="VRF route type, like 'bgp', 'connected', and 'static'. Currently, only static routes are supported")
    updated_at: Optional[datetime] = None
    virtual_network: Optional[VirtualNetwork] = None
    vrf: Optional[Vrf] = None
    __properties: ClassVar[List[str]] = ["created_at", "href", "id", "metal_gateway", "next_hop", "prefix", "status", "tags", "type", "updated_at", "virtual_network", "vrf"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pending', 'active', 'deleting', 'error']):
            raise ValueError("must be one of enum values ('pending', 'active', 'deleting', 'error')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['static']):
            raise ValueError("must be one of enum values ('static')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VrfRoute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "href",
            "id",
            "status",
            "type",
            "updated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metal_gateway
        if self.metal_gateway:
            _dict['metal_gateway'] = self.metal_gateway.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virtual_network
        if self.virtual_network:
            _dict['virtual_network'] = self.virtual_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vrf
        if self.vrf:
            _dict['vrf'] = self.vrf.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VrfRoute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "metal_gateway": VrfMetalGateway.from_dict(obj["metal_gateway"]) if obj.get("metal_gateway") is not None else None,
            "next_hop": obj.get("next_hop"),
            "prefix": obj.get("prefix"),
            "status": obj.get("status"),
            "tags": obj.get("tags"),
            "type": obj.get("type"),
            "updated_at": obj.get("updated_at"),
            "virtual_network": VirtualNetwork.from_dict(obj["virtual_network"]) if obj.get("virtual_network") is not None else None,
            "vrf": Vrf.from_dict(obj["vrf"]) if obj.get("vrf") is not None else None
        })
        return _obj


