/*
Wombat.js client-side rewriting engine for web archive replay
Copyright (C) 2014-2025 Webrecorder Software, Rhizome, and Contributors. Released under the GNU Affero General Public License.

This file is part of wombat.js, see https://github.com/webrecorder/wombat.js for the full source
Wombat.js is part of the Webrecorder project (https://github.com/webrecorder)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
!function(){"use strict";function t(){this._map=[]}function e(t,e){void 0!==self.Symbol&&void 0!==self.Symbol.toStringTag&&Object.defineProperty(t.prototype,self.Symbol.toStringTag,{value:e,enumerable:!1})}function r(t){for(var e,r,i=t.__proto__||t.constructor.prototype||t.prototype,o=Object.getOwnPropertyNames(i),n=o.length,s=0;s<n;s++)r=t[e=o[s]],"constructor"!==e&&"function"==typeof r&&(t[e]=r.bind(t))}t.prototype.set=function(t,e){this._map.push([t,e])},t.prototype.get=function(t){for(var e=0;e<this._map.length;e++)if(this._map[e][0]===t)return this._map[e][1];return null},t.prototype.find=function(t){for(var e=0;e<this._map.length;e++)if(this._map[e][0]===t)return e;return-1},t.prototype.add_or_get=function(t,e){var r=this.get(t);return r||(r=e(),this.set(t,r)),r},t.prototype.remove=function(t){var e=this.find(t);return e>=0?this._map.splice(e,1)[0][1]:null},t.prototype.map=function(t){for(var e=0;e<this._map.length;e++)this._map[e][1](t)};var i={yes:!1},o=Symbol("__wb__storage_WOMBAT"),n=Symbol("__wb__storage_TYPE");function s(t,e,r){if(i.yes)throw new TypeError("Illegal constructor");if(r&&r.length)for(var s=0;s<r.length;s++)this[r[s][0]]=r[s][1].toString();Object.defineProperty(this,o,{value:t,enumerable:!1}),Object.defineProperty(this,n,{value:e,enumerable:!1})}function a(t,e,r){var i=new s(t,e,r);return t.$wbwindow.Proxy&&(i=new t.$wbwindow.Proxy(i,{get:function(t,e){var r=t.__proto__;if("__proto__"===e)return r;if(r.hasOwnProperty(e)||r.__proto__&&r.__proto__.hasOwnProperty(e)){var i=t[e];return"function"==typeof i&&(i=i.bind(t)),i}return t.hasOwnProperty(e)?t.getItem(e):void 0},set:function(t,e,r){return t.__proto__.hasOwnProperty(e)?(t[e]=r,!0):(t.setItem(e,r),!0)}})),t.defGetterProp(t.$wbwindow,e,(function(){return i})),i}function w(t,e){for(var r in Object.defineProperties(this,{_orig_loc:{configurable:!0,enumerable:!1,value:t},wombat:{configurable:!0,enumerable:!1,value:e},orig_getter:{enumerable:!1,value:function(t){return this._orig_loc[t]}},orig_setter:{enumerable:!1,value:function(t,e){this._orig_loc[t]!=e&&(this._orig_loc[t]=e)}}}),e.initLocOverride(this,this.orig_setter,this.orig_getter),e.setLoc(this,t.href),t)this.hasOwnProperty(r)||"function"==typeof t[r]||(this[r]=t[r])}function h(t,e){if(!(this instanceof h))return new h(t,e);this.elemSelector="img[srcset], img[data-srcset], img[data-src], video[srcset], video[data-srcset], video[data-src], audio[srcset], audio[data-srcset], audio[data-src], picture > source[srcset], picture > source[data-srcset], picture > source[data-src], video > source[srcset], video > source[data-srcset], video > source[data-src], audio > source[srcset], audio > source[data-srcset], audio > source[data-src]",this.wombat=t,this.$wbwindow=t.$wbwindow,this.worker=null,r(this),this._initWorker(e)}function p(t,e){return function(r){if(window==e)return t(r)}}function c(t,e,r){var i;return i="function"==typeof t?t:"object"==typeof t?t.handleEvent.bind(t):function(){},function(t){var o;if(t.data&&t.data.from&&t.data.message){if("*"!==t.data.to_origin&&e.WB_wombat_location&&!r.startsWith(t.data.to_origin,e.WB_wombat_location.origin))return void console.warn("Skipping message event to "+t.data.to_origin+" doesn't start with origin "+e.WB_wombat_location.origin);var n=t.source;t.data.from_top?n=e.__WB_top_frame:t.data.src_id&&e.__WB_win_id&&e.__WB_win_id[t.data.src_id]&&(n=e.__WB_win_id[t.data.src_id]),(o=new MessageEvent("message",{bubbles:t.bubbles,cancelable:t.cancelable,data:t.data.message,origin:t.data.from,lastEventId:t.lastEventId,source:r.proxyToObj(n),ports:t.ports}))._target=t.target,o._srcElement=t.srcElement,o._currentTarget=t.currentTarget,o._eventPhase=t.eventPhase}else o=t;return i(o)}}function l(t){let e;e="string"==typeof t?t:t?.length?t.reduce(((t,e)=>t+=String.fromCharCode(e)),""):t?t.toString():"";try{return"__wb_post_data="+btoa(e)}catch{return"__wb_post_data="}}function u(t){let{method:e,headers:r,postData:i=""}=t;if("GET"===e)return!1;let o=(t=>{let e=t.get("content-type");if(e)return e;if(!(t instanceof Headers))for(let[e,r]of t.entries())if(e&&"content-type"===e.toLowerCase())return r;return""})(r);function n(t){return t instanceof Uint8Array&&(t=(new TextDecoder).decode(t)),t}let s="";switch(o.split(";")[0]){case"application/x-www-form-urlencoded":s=n(i);break;case"application/json":s=d(n(i));break;case"text/plain":try{s=d(n(i),!1)}catch{s=l(i)}break;case"multipart/form-data":if(!o)throw new Error("utils cannot call postToGetURL when missing content-type header");s=function(t,e){return function(t="",e){let r=new URLSearchParams;t instanceof Uint8Array&&(t=(new TextDecoder).decode(t));try{let i=e.split("boundary=")[1],o=t.split(new RegExp("-*"+i+"-*","mi"));for(let t of o){let e=t.trim().match(/name="([^"]+)"\r\n\r\n(.*)/im);e&&r.set(e[1],e[2])}}catch{}return r}(t,e).toString()}(n(i),o);break;default:s=l(i)}return null!=s&&(t.url=function(t,e,r){if(!r)return t;let i=t.indexOf("?")>0?"&":"?";return`${t}${i}__wb_method=${r}&${e}`}(t.url,decodeURI(s),t.method),t.method="GET",t.requestBody=s,!0)}function _(t,e=!0){if("string"==typeof t)try{t=JSON.parse(t)}catch{t={}}let r=new URLSearchParams,i={},o=(t,e="")=>{let n="";if("object"!=typeof t||t instanceof Array){if(t instanceof Array)for(let r=0;r<t.length;r++)o(t[r],e)}else try{for(let[e,r]of Object.entries(t))o(r,e)}catch{null===t&&(n="null")}["string","number","boolean"].includes(typeof t)&&(n=t.toString()),n&&r.set((t=>r.has(t)?(t in i||(i[t]=1),t+"."+ ++i[t]+"_"):t)(e),n)};try{o(t)}catch(t){if(!e)throw t}return r}function d(t="",e=!0){return _(t,e).toString()}function f(e,i){if(!(this instanceof f))return new f(e,i);this.debug_rw=!1,this.$wbwindow=e,this.WBWindow=Window,this.URL=URL,this.origHost=e.location.host,this.origHostname=e.location.hostname,this.origProtocol=e.location.protocol,this.HTTP_PREFIX="http://",this.HTTPS_PREFIX="https://",this.REL_PREFIX="//",this.VALID_PREFIXES=[this.HTTP_PREFIX,this.HTTPS_PREFIX,this.REL_PREFIX],this.IGNORE_PREFIXES=["#","about:","data:","blob:","mailto:","javascript:","{","*"],"ignore_prefixes"in i&&(this.IGNORE_PREFIXES=this.IGNORE_PREFIXES.concat(i.ignore_prefixes)),this.WB_CHECK_THIS_FUNC="_____WB$wombat$check$this$function_____",this.WB_ASSIGN_FUNC="_____WB$wombat$assign$function_____",this.SKIP_OWN_FUNC_PROPS=["name","length","__WB_is_native_func__","arguments","caller","callee","prototype"],this.OVERRIDE_PROPS=["window","self","document","location","top","parent","frames","opener"],this.wb_setAttribute=e.Element.prototype.setAttribute,this.wb_getAttribute=e.Element.prototype.getAttribute,this.wb_funToString=Function.prototype.toString,this.WBAutoFetchWorker=null,this.wbUseAFWorker=i.enable_auto_fetch&&null!=e.Worker&&i.is_live,this.wb_rel_prefix="",this.wb_wombat_updating=!1,this.message_listeners=new t,this.storage_listeners=new t,this.linkAsTypes={script:"js_",worker:"js_",style:"cs_",image:"im_",document:"if_",fetch:"mp_",font:"oe_",audio:"oe_",video:"oe_",embed:"oe_",object:"oe_",track:"oe_","":"mp_",null:"mp_",undefined:"mp_"},this.linkTagMods={linkRelToAs:{import:this.linkAsTypes,preload:this.linkAsTypes},stylesheet:"cs_",null:"mp_",undefined:"mp_","":"mp_"},this.tagToMod={A:{href:"mp_"},AREA:{href:"mp_"},AUDIO:{src:"oe_",poster:"im_"},BASE:{href:"mp_"},EMBED:{src:"oe_"},FORM:{action:"mp_"},FRAME:{src:"fr_"},IFRAME:{src:"if_"},IMAGE:{href:"im_","xlink:href":"im_"},IMG:{src:"im_",srcset:"im_"},INPUT:{src:"oe_"},INS:{cite:"mp_"},META:{content:"mp_"},OBJECT:{data:"oe_",codebase:"oe_"},Q:{cite:"mp_"},SCRIPT:{src:"js_","xlink:href":"js_"},SOURCE:{src:"oe_",srcset:"oe_"},TRACK:{src:"oe_"},VIDEO:{src:"oe_",poster:"im_"},image:{href:"im_","xlink:href":"im_"}},this.URL_PROPS=["href","hash","pathname","host","hostname","protocol","origin","search","port"],this.wb_info=i,this.wb_opts=i.wombat_opts,this.wb_replay_prefix=i.prefix,this.wb_is_proxy=this.wb_info.proxy_magic||!this.wb_replay_prefix,this.wb_info.top_host=this.wb_info.top_host||"*",this.wb_curr_host=e.location.protocol+"//"+e.location.host,this.wb_info.wombat_opts=this.wb_info.wombat_opts||{},this.wb_orig_scheme=this.wb_info.wombat_scheme+"://",this.wb_orig_origin=this.wb_orig_scheme+this.wb_info.wombat_host,this.wb_abs_prefix=this.wb_replay_prefix,this.wb_capture_date_part="",!this.wb_info.is_live&&this.wb_info.wombat_ts&&(this.wb_capture_date_part="/"+this.wb_info.wombat_ts+"/"),this.BAD_PREFIXES=["http:"+this.wb_replay_prefix,"https:"+this.wb_replay_prefix,"http:/"+this.wb_replay_prefix,"https:/"+this.wb_replay_prefix],this.hostnamePortRe=/^[\w-]+(\.[\w-_]+)+(:\d+)(\/|$)/,this.ipPortRe=/^\d+\.\d+\.\d+\.\d+(:\d+)?(\/|$)/,this.workerBlobRe=/__WB_pmw\(.*?\)\.(?=postMessage\()/g,this.rmCheckThisInjectRe=/_____WB\$wombat\$check\$this\$function_____\(.*?\)/g,this.STYLE_REGEX=/(url\s*\(\s*[\\"']*)([^)'"]+)([\\"']*\s*\))/gi,this.IMPORT_REGEX=/(@import\s*[\\"']*)([^)'";]+)([\\"']*\s*;?)/gi,this.IMPORT_JS_REGEX=/^(import\s*\(['"]+)([^'"]+)(["'])/i,this.no_wombatRe=/WB_wombat_/g,this.srcsetRe=/\s*(\S*\s+[\d.]+[wx]),|(?:\s*,(?:\s+|(?=https?:)))/,this.cookie_path_regex=/\bPath='?"?([^;'"\s]+)/i,this.cookie_domain_regex=/\bDomain=([^;'"\s]+)/i,this.cookie_expires_regex=/\bExpires=([^;'"]+)/gi,this.SetCookieRe=/,(?![|])/,this.IP_RX=/^(\d)+\.(\d)+\.(\d)+\.(\d)+$/,this.FullHTMLRegex=/^\s*<(?:html|head|body|frameset|frame|!doctype html)/i,this.IsTagRegex=/^\s*</,this.DotPostMessageRe=/(\.postMessage\s*\()/,this.extractPageUnderModifierRE=/\/(?:[0-9]{14})?([a-z]{2, 3}_)\//,this.write_buff="";var o=(e.EventTarget||{}).prototype;this.utilFns={cspViolationListener:function(t){if(console.group("CSP Violation"),console.log("Replayed Page URL",window.WB_wombat_location.href),console.log("The documentURI",t.documentURI),console.log("The blocked URL",t.blockedURI),console.log("The directive violated",t.violatedDirective),console.log("Our policy",t.originalPolicy),t.sourceFile){var e="File: "+t.sourceFile;t.lineNumber&&t.columnNumber?e+=" @ "+t.lineNumber+":"+t.columnNumber:t.lineNumber&&(e+=" @ "+t.lineNumber),console.log(e)}console.groupEnd()},addEventListener:o.addEventListener,removeEventListener:o.removeEventListener,objToString:Object.prototype.toString,wbSheetMediaQChecker:null,XHRopen:null,XHRsend:null},this.showCSPViolations={yesNo:!1,added:!1},r(this)}s.prototype.getItem=function(t){return this.hasOwnProperty(t)?this[t]:null},s.prototype.setItem=function(t,e){var r=String(t),i=String(e),o=this.getItem(r);this[r]=e,this.fireEvent(r,o,i)},s.prototype._deleteItem=function(t){delete this[t]},s.prototype.removeItem=function(t){var e=this.getItem(t);this._deleteItem(t),this.fireEvent(t,e,null)},s.prototype.clear=function(){for(var t in this)delete this[t];this.fireEvent(null,null,null)},s.prototype.key=function(t){var e=function(t){try{switch(typeof t){case"number":case"bigint":return t}var e=Number(t);return isNaN(e)?null:e}catch(t){}return null}(t);if(null==e||e<0)return null;var r=Object.keys(this);return e<r.length?r[e]:null},s.prototype.fireEvent=function(t,e,r){var i=new StorageEvent("storage",{key:t,newValue:r,oldValue:e,url:this[o].$wbwindow.WB_wombat_location.href});Object.defineProperty(i,"storageArea",{value:this,writable:!1,configurable:!1}),i._storageArea=this,this[o].storage_listeners.map(i)},s.prototype.valueOf=function(){return this[o].$wbwindow[this[n]]},s.prototype.toString=function(){return"[object Storage]"},Object.defineProperty(s.prototype,"length",{enumerable:!1,get:function(){return Object.keys(this).length}}),e(s,"Storage"),w.prototype.replace=function(t){var e=this.wombat.rewriteUrl(t),r=this.wombat.extractOriginalURL(e);return r===this.href?r:this._orig_loc.replace(e)},w.prototype.assign=function(t){var e=this.wombat.rewriteUrl(t),r=this.wombat.extractOriginalURL(e);return r===this.href?r:this._orig_loc.assign(e)},w.prototype.reload=function(t){},w.prototype.toString=function(){return this.href},w.prototype.valueOf=function(){return this},e(w,"Location"),h.prototype._initWorker=function(t){var e=this.wombat;if(t.isTop)try{this.worker=new Worker(t.workerURL,{type:"classic",credentials:"include"})}catch(t){console.error("Failed to create auto fetch worker\n",t)}else this.worker={postMessage:function(t){t.wb_type||(t={wb_type:"aaworker",msg:t}),e.$wbwindow.__WB_replay_top.__orig_postMessage(t,"*")},terminate:function(){}}},h.prototype.extractMediaRulesFromSheet=function(t){var e,r=[];try{e=t.cssRules||t.rules}catch(t){return r}for(var i=0;i<e.length;++i){var o=e[i];o.type===CSSRule.MEDIA_RULE&&r.push(o.cssText)}return r},h.prototype.deferredSheetExtraction=function(t){var e=this;Promise.resolve().then((function(){var r=e.extractMediaRulesFromSheet(t);r.length>0&&e.preserveMedia(r)}))},h.prototype.terminate=function(){this.worker.terminate()},h.prototype.justFetch=function(t){this.worker.postMessage({type:"fetch-all",values:t})},h.prototype.fetchAsPage=function(t,e,r){if(t){var i={"X-Wombat-History-Page":e};if(r){var o=encodeURIComponent(r.trim());r&&(i["X-Wombat-History-Title"]=o)}var n={url:t,options:{headers:i,cache:"no-store"}};this.justFetch([n])}},h.prototype.postMessage=function(t,e){if(e){var r=this;Promise.resolve().then((function(){r.worker.postMessage(t)}))}else this.worker.postMessage(t)},h.prototype.preserveSrcset=function(t,e){this.postMessage({type:"values",srcset:{value:t,mod:e,presplit:!0}},!0)},h.prototype.preserveDataSrcset=function(t){this.postMessage({type:"values",srcset:{value:t.dataset.srcset,mod:this.rwMod(t),presplit:!1}},!0)},h.prototype.preserveMedia=function(t){this.postMessage({type:"values",media:t},!0)},h.prototype.getSrcset=function(t){return this.wombat.wb_getAttribute?this.wombat.wb_getAttribute.call(t,"srcset"):t.getAttribute("srcset")},h.prototype.rwMod=function(t){switch(t.tagName){case"SOURCE":return t.parentElement&&"PICTURE"===t.parentElement.tagName?"im_":"oe_";case"IMG":return"im_"}return"oe_"},h.prototype.extractFromLocalDoc=function(){var t=this;Promise.resolve().then((function(){for(var e={type:"values",context:{docBaseURI:document.baseURI}},r=[],i=0,o=document.styleSheets;i<o.length;++i)r=r.concat(t.extractMediaRulesFromSheet(o[i]));var n,s,a,w=document.querySelectorAll(t.elemSelector),h={values:[],presplit:!1},p={values:[]};for(i=0;i<w.length;++i)s=(n=w[i]).src?n.src:null,a=t.rwMod(n),n.srcset&&h.values.push({srcset:t.getSrcset(n),mod:a,tagSrc:s}),n.dataset.srcset&&h.values.push({srcset:n.dataset.srcset,mod:a,tagSrc:s}),n.dataset.src&&p.values.push({src:n.dataset.src,mod:a}),"SOURCE"===n.tagName&&s&&p.values.push({src:s,mod:a});r.length&&(e.media=r),h.values.length&&(e.srcset=h),p.values.length&&(e.src=p),(e.media||e.srcset||e.src)&&t.postMessage(e)}))},f.prototype._internalInit=function(){this.initTopFrame(this.$wbwindow),this.initWombatLoc(this.$wbwindow),this.initWombatTop(this.$wbwindow);var t=this.$wbwindow.__WB_replay_top.location.origin,e=this.$wbwindow.__WB_replay_top.location.host,r=this.$wbwindow.__WB_replay_top.location.protocol;this.wb_replay_prefix&&0===this.wb_replay_prefix.indexOf(t)?this.wb_rel_prefix=this.wb_replay_prefix.substring(t.length):this.wb_rel_prefix=this.wb_replay_prefix,this.wb_prefixes=[this.wb_abs_prefix,this.wb_rel_prefix];var i="(("+r+")?//"+e+")?"+this.wb_rel_prefix+"[^/]+/";this.wb_unrewrite_rx=new RegExp(i,"g"),this.wb_info.is_framed&&"bn_"!==this.wb_info.mod&&this.initTopFrameNotify(this.wb_info),this.initAutoFetchWorker()},f.prototype._addRemoveCSPViolationListener=function(t){this.showCSPViolations.yesNo=t,this.showCSPViolations.yesNo&&!this.showCSPViolations.added?(this.showCSPViolations.added=!0,this._addEventListener(document,"securitypolicyviolation",this.utilFns.cspViolationListener)):(this.showCSPViolations.added=!1,this._removeEventListener(document,"securitypolicyviolation",this.utilFns.cspViolationListener))},f.prototype._addEventListener=function(t,e,r){if(this.utilFns.addEventListener)return this.utilFns.addEventListener.call(t,e,r);t.addEventListener(e,r)},f.prototype._removeEventListener=function(t,e,r){if(this.utilFns.removeEventListener)return this.utilFns.removeEventListener.call(t,e,r);t.removeEventListener(e,r)},f.prototype.getPageUnderModifier=function(){try{var t=this.extractPageUnderModifierRE.exec(location.pathname);if(t&&t[1])return t[1].trim()||"mp_"}catch(t){}return"mp_"},f.prototype.isNativeFunction=function(t){return!(!t||"function"!=typeof t)&&(-1!=this.wb_funToString.call(t).indexOf("[native code]")&&(void 0===t.__WB_is_native_func__||!!t.__WB_is_native_func__))},f.prototype.isString=function(t){return null!=t&&Object.getPrototypeOf(t)===String.prototype},f.prototype.blobUrlForIframe=function(t,e){var r=new Blob([e],{type:"text/html"}),i=this.URL.createObjectURL(r),o=this.URL;t.__wb_blobSrc=i,t.addEventListener("load",(function(){t.__wb_blobSrc&&(o.revokeObjectURL(t.__wb_blobSrc),t.__wb_blobSrc=null)}),{once:!0}),t.__wb_origSrc=t.src;var n=i.slice(i.lastIndexOf("/")+1)+"/"+this.wb_info.url;t.src=this.wb_info.prefix+this.wb_info.request_ts+"mp_/blob:"+n},f.prototype.isSavedSrcSrcset=function(t){switch(t.tagName){case"IMG":case"VIDEO":case"AUDIO":return!0;case"SOURCE":if(!t.parentElement)return!1;switch(t.parentElement.tagName){case"PICTURE":case"VIDEO":case"AUDIO":return!0;default:return!1}default:return!1}},f.prototype.isSavedDataSrcSrcset=function(t){return!(!t.dataset||null==t.dataset.srcset)&&this.isSavedSrcSrcset(t)},f.prototype.isHostUrl=function(t){if(0===t.indexOf("www."))return!0;var e=t.match(this.hostnamePortRe);return!!(e&&e[0].length<64)||!!(e=t.match(this.ipPortRe))&&e[0].length<64},f.prototype.isArgumentsObj=function(t){if(!t||"function"!=typeof t.toString)return!1;try{return"[object Arguments]"===this.utilFns.objToString.call(t)}catch(t){return!1}},f.prototype.deproxyArrayHandlingArgumentsObj=function(t){if(!t||t instanceof NodeList||!t.length)return t;for(var e=this.isArgumentsObj(t)?new Array(t.length):t,r=0;r<t.length;++r){const i=this.proxyToObj(t[r]);i!==e[r]&&(e[r]=i)}return e},f.prototype.startsWith=function(t,e){if(t)return 0===t.indexOf(e)?e:void 0},f.prototype.startsWithOneOf=function(t,e){if(t)for(var r=0;r<e.length;r++)if(0===t.indexOf(e[r]))return e[r]},f.prototype.endsWith=function(t,e){if(t)return-1!==t.indexOf(e,t.length-e.length)?e:void 0},f.prototype.shouldRewriteAttr=function(t,e){switch(e){case"href":case"src":case"xlink:href":return!0}return!(!t||!this.tagToMod[t]||void 0===this.tagToMod[t][e])||("VIDEO"===t&&"poster"===e||"META"===t&&"content"===e)},f.prototype.skipWrapScriptBasedOnType=function(t){return!!t&&(!(t.indexOf("javascript")>=0||t.indexOf("ecmascript")>=0)&&(t.indexOf("json")>=0||t.indexOf("text/")>=0))},f.prototype.skipWrapScriptTextBasedOnText=function(t,e){if(!t||t.indexOf(this.WB_ASSIGN_FUNC)>=0||0===t.indexOf("<"))return!0;let r=!1;for(const i of this.OVERRIDE_PROPS){t.indexOf(i)>=0&&(t.indexOf("var "+i)>=0&&e.push(i),r=!0)}return!r},f.prototype.nodeHasChildren=function(t){if(!t)return!1;if("function"==typeof t.hasChildNodes)return t.hasChildNodes();var e=t.children||t.childNodes;return!!e&&e.length>0},f.prototype.rwModForElement=function(t,e){if(t){var r="mp_";if("LINK"===t.tagName&&"href"===e){if(t.rel){var i=t.rel.trim().toLowerCase(),o=this.wb_getAttribute.call(t,"as");if(o&&null!=this.linkTagMods.linkRelToAs[i])r=this.linkTagMods.linkRelToAs[i][o.toLowerCase()];else null!=this.linkTagMods[i]&&(r=this.linkTagMods[i])}}else{if("SCRIPT"===t.tagName)return"module"===t.type?"esm_":"js_";var n=this.tagToMod[t.tagName];null!=n&&(r=n[e])}return r}},f.prototype.removeWBOSRC=function(t){"SCRIPT"!==t.tagName||t.__$removedWBOSRC$__||(t.hasAttribute("__wb_orig_src")&&t.removeAttribute("__wb_orig_src"),t.__$removedWBOSRC$__=!0)},f.prototype.retrieveWBOSRC=function(t){var e;if("SCRIPT"===t.tagName&&!t.__$removedWBOSRC$__)return null==(e=this.wb_getAttribute?this.wb_getAttribute.call(t,"__wb_orig_src"):t.getAttribute("__wb_orig_src"))&&(t.__$removedWBOSRC$__=!0),e},f.prototype.wrapScriptTextJsProxy=function(t,e=[]){let r="var _____WB$wombat$assign$function_____ = function(name) {return (self._wb_wombat && self._wb_wombat.local_init && self._wb_wombat.local_init(name)) || self[name]; };\nif (!self.__WB_pmw) { self.__WB_pmw = function(obj) { this.__WB_source = obj; return this; } }\n{\n";for(const t of this.OVERRIDE_PROPS)e.includes(t)||(r+=`let ${t} = _____WB$wombat$assign$function_____("${t}");\n`);return r+="{\n",r+t.replace(this.DotPostMessageRe,".__WB_pmw(self.window)$1")+"\n\n}}"},f.prototype.watchElem=function(t,e){if(!this.$wbwindow.MutationObserver)return!1;new this.$wbwindow.MutationObserver((function(t,r){for(var i=0;i<t.length;i++){var o=t[i];if("childList"===o.type)for(var n=0;n<o.addedNodes.length;n++)e(o.addedNodes[n])}})).observe(t,{childList:!0,subtree:!0})},f.prototype.reconstructDocType=function(t){return null==t?"":"<!doctype "+t.name+(t.publicId?' PUBLIC "'+t.publicId+'"':"")+(!t.publicId&&t.systemId?" SYSTEM":"")+(t.systemId?' "'+t.systemId+'"':"")+">"},f.prototype.getFinalUrl=function(t,e,r){var i=t?this.wb_rel_prefix:this.wb_abs_prefix;return null==e&&(e=this.wb_info.mod),this.wb_info.is_live||(i+=this.wb_info.wombat_ts),"/"!==(i+=e)[i.length-1]&&(i+="/"),i+r},f.prototype.resolveRelUrl=function(t,e){var r=this;function i(t){return!(!t||!t.baseURI)&&(t.baseURI.startsWith(r.HTTPS_PREFIX)||t.baseURI.startsWith(r.HTTP_PREFIX))}var o=null;return o=i(e)?e.baseURI:i(this.$wbwindow.document)?this.$wbwindow.document.baseURI:this.$wbwindow.__WB_replay_top.document.baseURI,new this.URL(t,o).href},f.prototype.extractOriginalURL=function(t){if(!t)return"";if(this.wb_is_proxy)return t;var e,r=t.toString(),i=r;if(this.startsWithOneOf(i,this.IGNORE_PREFIXES))return i;if(i.startsWith(this.wb_info.static_prefix))return i;e=this.startsWith(i,this.wb_abs_prefix)?this.wb_abs_prefix.length:this.wb_rel_prefix&&this.startsWith(i,this.wb_rel_prefix)?this.wb_rel_prefix.length:this.wb_rel_prefix?1:0;var o=i.indexOf("/http",e);return o<0&&(o=i.indexOf("///",e)),o<0&&(o=i.indexOf("/blob:",e)),o<0&&(o=i.indexOf("/about:blank",e)),o>=0?i=i.substr(o+1):((o=i.indexOf(this.wb_replay_prefix))>=0&&(i=i.substr(o+this.wb_replay_prefix.length)),i.length>4&&"_"===i.charAt(2)&&"/"===i.charAt(3)&&(i=i.substr(4)),i===r||this.startsWithOneOf(i,this.VALID_PREFIXES)||this.startsWith(i,"blob:")||(i=this.wb_orig_scheme+i)),"/"===r.charAt(0)&&"/"!==r.charAt(1)&&this.startsWith(i,this.wb_orig_origin)&&(i=i.substr(this.wb_orig_origin.length)),this.startsWith(i,this.REL_PREFIX)?this.wb_info.wombat_scheme+":"+i:i},f.prototype.makeParser=function(t,e){var r=this.extractOriginalURL(t),i=e;return e||(i="about:blank"===this.$wbwindow.location.href&&this.$wbwindow.opener?this.$wbwindow.opener.document:this.$wbwindow.document),this._makeURLParser(r,i)},f.prototype._makeURLParser=function(t,e){try{return new this.URL(t,e.baseURI)}catch(t){}var r=e.createElement("a");return r._no_rewrite=!0,r.href=t,r},f.prototype.defProp=function(t,e,r,i,o){var n=Object.getOwnPropertyDescriptor(t,e);if(n&&!n.configurable)return!1;if(!i)return!1;var s={configurable:!0,enumerable:o||!1,get:i};r&&(s.set=r);try{return Object.defineProperty(t,e,s),!0}catch(t){return console.warn("Failed to redefine property %s",e,t.message),!1}},f.prototype.defGetterProp=function(t,e,r,i){var o=Object.getOwnPropertyDescriptor(t,e);if(o&&!o.configurable)return!1;if(!r)return!1;try{return Object.defineProperty(t,e,{configurable:!0,enumerable:i||!1,get:r}),!0}catch(t){return console.warn("Failed to redefine property %s",e,t.message),!1}},f.prototype.getOrigGetter=function(t,e){var r;if(t.__lookupGetter__&&(r=t.__lookupGetter__(e)),!r&&Object.getOwnPropertyDescriptor){var i=Object.getOwnPropertyDescriptor(t,e);i&&(r=i.get)}return r},f.prototype.getOrigSetter=function(t,e){var r;if(t.__lookupSetter__&&(r=t.__lookupSetter__(e)),!r&&Object.getOwnPropertyDescriptor){var i=Object.getOwnPropertyDescriptor(t,e);i&&(r=i.set)}return r},f.prototype.getAllOwnProps=function(t){for(var e=[],r=Object.getOwnPropertyNames(t),i=0;i<r.length;i++){var o=r[i];try{t[o]&&!t[o].prototype&&e.push(o)}catch(t){}}for(var n=Object.getPrototypeOf(t);n;){for(r=Object.getOwnPropertyNames(n),i=0;i<r.length;i++)e.push(r[i]);n=Object.getPrototypeOf(n)}return e},f.prototype.sendTopMessage=function(t,e,r){(r=r||this.$wbwindow).__WB_top_frame&&(e||r==r.__WB_replay_top)&&r.__WB_top_frame.postMessage(t,this.wb_info.top_host)},f.prototype.sendHistoryUpdate=function(t,e,r){this.sendTopMessage({url:t,ts:this.wb_info.timestamp,request_ts:this.wb_info.request_ts,is_live:this.wb_info.is_live,title:e,wb_type:"replace-url"},!1,r)},f.prototype.updateLocation=function(t,e,r){if(t&&t!==e){var i=this.extractOriginalURL(e),o=this.extractOriginalURL(t);if(i&&i!==o){var n=this.rewriteUrl(t);console.log(r.href+" -> "+n),r.href=n}}},f.prototype.checkLocationChange=function(t,e){var r=typeof t,i=e?this.$wbwindow.__WB_replay_top.location:this.$wbwindow.location;"string"===r?this.updateLocation(t,i.href,i):"object"===r&&this.updateLocation(t.href,t._orig_href,i)},f.prototype.checkAllLocations=function(){if(this.wb_wombat_updating)return!1;this.wb_wombat_updating=!0,this.checkLocationChange(this.$wbwindow.WB_wombat_location,!1),this.$wbwindow.WB_wombat_location!=this.$wbwindow.__WB_replay_top.WB_wombat_location&&this.checkLocationChange(this.$wbwindow.__WB_replay_top.WB_wombat_location,!0),this.wb_wombat_updating=!1},f.prototype.proxyToObj=function(t){if(t)try{var e=t.__WBProxyRealObj__;if(e)return e}catch(t){}return t},f.prototype.objToProxy=function(t){if(t)try{var e=t._WB_wombat_obj_proxy;if(e)return e}catch(t){}return t},f.prototype.defaultProxyGet=function(t,e,r,i){switch(e){case"__WBProxyRealObj__":return t;case"location":case"WB_wombat_location":return t.WB_wombat_location;case"_WB_wombat_obj_proxy":return t._WB_wombat_obj_proxy;case"__WB_pmw":case this.WB_ASSIGN_FUNC:case this.WB_CHECK_THIS_FUNC:return t[e];case"origin":return t.WB_wombat_location.origin;case"constructor":return t.constructor}var o=Reflect.get(t,e),n=typeof o;if("string"===n&&o){var s=parseInt(e);if(o&&!isNaN(s))try{return this.initNewWindowWombat(o),o._WB_wombat_obj_proxy}catch(t){}}else{if("function"===n&&-1!==r.indexOf(e)){switch(e){case"requestAnimationFrame":case"cancelAnimationFrame":if(!this.isNativeFunction(o))return o;break;case"eval":if(this.isNativeFunction(o))return this.wrappedEval(o)}var a=i[e];if(!a||a.original!==o){const r=o.bind(t);for(const t of Object.getOwnPropertyNames(o))if(!this.SKIP_OWN_FUNC_PROPS.includes(t))try{r[t]=o[t]}catch(t){}return i[e]={original:o,boundFn:r},r}return a.boundFn}if("object"===n&&o&&o._WB_wombat_obj_proxy)return o instanceof this.WBWindow&&this.initNewWindowWombat(o),o._WB_wombat_obj_proxy}return o},f.prototype.setLoc=function(t,e){var r=this.makeParser(e,t.ownerDocument);t._orig_href=e,t._parser=r;var i=r.href;t._hash=r.hash,t._href=i,t._host=r.host,t._hostname=r.hostname,r.origin?t._origin=r.host?r.origin:"null":t._origin=r.protocol+"//"+r.hostname+(r.port?":"+r.port:""),t._pathname=r.pathname,t._port=r.port,t._protocol=r.protocol,t._search=r.search,Object.defineProperty||(t.href=i,t.hash=r.hash,t.host=t._host,t.hostname=t._hostname,t.origin=t._origin,t.pathname=t._pathname,t.port=t._port,t.protocol=t._protocol,t.search=t._search)},f.prototype.makeGetLocProp=function(t,e){var r=this;return function(){if(this._no_rewrite)return e.call(this,t);var i=e.call(this,"href");return"href"===t?r.extractOriginalURL(i):"ancestorOrigins"===t?[]:(this._orig_href!==i&&r.setLoc(this,i),this["_"+t])}},f.prototype.makeSetLocProp=function(t,e,r){var i=this;return function(o){if(this._no_rewrite)return e.call(this,t,o);if(this["_"+t]!==o){this["_"+t]=o;var n=r.call(this),s=i.makeParser(n,this.ownerDocument),a=!1;if("href"===t&&"string"==typeof o)if(o&&s instanceof i.URL)try{o=new i.URL(o,s).href}catch(t){console.warn("Error resolving URL",t)}else o&&("."===o[0]||"#"===o[0]?o=i.resolveRelUrl(o,this.ownerDocument):"/"===o[0]&&(o.length>1&&"/"===o[1]?o=s.protocol+o:(a=!0,o=WB_wombat_location.origin+o)));try{s[t]=o}catch(e){console.log("Error setting "+t+" = "+o)}"hash"===t?(o=s[t],e.call(this,"hash",o)):(a=a||o===s.pathname,o=i.rewriteUrl(s.href,a),e.call(this,"href",o))}}},f.prototype.styleReplacer=function(t,e,r,i,o,n){return e+this.rewriteUrl(r)+i},f.prototype.domConstructorErrorChecker=function(t,e,r,i){var o,n="number"==typeof i?i:1;if(t instanceof this.WBWindow?o="Failed to construct '"+e+"': Please use the 'new' operator, this DOM object constructor cannot be called as a function.":r&&r.length<n&&(o="Failed to construct '"+e+"': "+n+" argument required, but only 0 present."),o)throw new TypeError(o)},f.prototype.rewriteNodeFuncArgs=function(t,e,r,i){if(r)switch(r.nodeType){case Node.ELEMENT_NODE:this.rewriteElemComplete(r);break;case Node.TEXT_NODE:("STYLE"===t.tagName||r.parentNode&&"STYLE"===r.parentNode.tagName)&&(r.textContent=this.rewriteStyle(r.textContent));break;case Node.DOCUMENT_FRAGMENT_NODE:this.recurseRewriteElem(r)}var o=e.call(t,r,i);if(o&&"IFRAME"===o.tagName){const t=o.allow?`; ${o.allow}`:"";o.allow=`autoplay 'self'; fullscreen 'self'${t}`,this.initIframeWombat(o)}return o},f.prototype.rewriteWSURL=function(t){if(!t)return t;var e=typeof t,r=t;if("object"===e)r=t.toString();else if("string"!==e)return t;if(!r)return r;var i="ws://",o="wss://";if(this.wb_is_proxy)return this.wb_orig_scheme===this.HTTP_PREFIX&&this.startsWith(r,o)?i+r.substr(6):this.wb_orig_scheme===this.HTTPS_PREFIX&&this.startsWith(r,i)?o+r.substr(5):r;var n=0===this.wb_abs_prefix.indexOf(this.HTTPS_PREFIX),s=this.wb_abs_prefix.replace(n?this.HTTPS_PREFIX:this.HTTP_PREFIX,n?o:i);return s+=this.wb_info.wombat_ts+"ws_","/"!==r[r.length-1]&&(s+="/"),s+r.replace("WB_wombat_","")},f.prototype.rewriteUrl_=function(t,e,r,i){if(!t)return t;var o,n,s=typeof t;if("object"===s)o=t.toString();else{if("string"!==s)return t;o=t}if(!o)return o;if(this.wb_is_proxy)return this.wb_orig_scheme===this.HTTP_PREFIX&&this.startsWith(o,this.HTTPS_PREFIX)?this.HTTP_PREFIX+o.substr(this.HTTPS_PREFIX.length):this.wb_orig_scheme===this.HTTPS_PREFIX&&this.startsWith(o,this.HTTP_PREFIX)?this.HTTPS_PREFIX+o.substr(this.HTTP_PREFIX.length):o;if(o=o.replace("WB_wombat_",""),"if_"===r&&this.wb_info.isSW&&this.startsWith(o,"blob:"))return this.wb_info.prefix+this.wb_info.request_ts+"if_/"+o;if(this.startsWithOneOf(o.toLowerCase(),this.IGNORE_PREFIXES))return o;if(this.wb_opts.no_rewrite_prefixes&&this.startsWithOneOf(o,this.wb_opts.no_rewrite_prefixes))return o;if(n=0===o.indexOf("//")?this.origProtocol+o:o,this.startsWith(n,this.wb_abs_prefix)||this.startsWith(n,this.wb_rel_prefix))return o;if(this.origHost!==this.origHostname&&this.startsWith(o,this.origProtocol+"//"+this.origHostname+"/"))return o.replace("/"+this.origHostname+"/","/"+this.origHost+"/");if("/"===o.charAt(0)&&!this.startsWith(o,this.REL_PREFIX)){if(this.wb_capture_date_part&&o.indexOf(this.wb_capture_date_part)>=0)return o;if(0===o.indexOf(this.wb_rel_prefix)&&o.indexOf("http")>1){var a=o.indexOf(":/");return a>0&&"/"!==o[a+2]?o.substring(0,a+2)+"/"+o.substring(a+2):o}return this.getFinalUrl(!0,r,this.wb_orig_origin+o)}"."===o.charAt(0)&&(o=this.resolveRelUrl(o,i));var w=this.startsWithOneOf(o.toLowerCase(),this.VALID_PREFIXES);if(w){var h=this.replayTopHost,p=this.replayTopProtocol,c=w+h+"/";if(this.startsWith(o,c)){if(this.startsWith(o,this.wb_replay_prefix))return o;var l=p+"//",u=o.substring(c.length),_=!1;return u.indexOf(this.wb_rel_prefix)<0&&o.indexOf("/static/")<0&&(u=this.getFinalUrl(!0,r,WB_wombat_location.origin+"/"+u),_=!0),w!==l&&w!==this.REL_PREFIX&&(_=!0),_&&(o=e?"":l+h,u&&"/"!==u[0]&&(o+="/"),o+=u),o}return this.getFinalUrl(e,r,o)}return(w=this.startsWithOneOf(o,this.BAD_PREFIXES))?this.getFinalUrl(e,r,this.extractOriginalURL(o)):o},f.prototype.rewriteUrl=function(t,e,r,i){var o;return o=this.wb_info.rewrite_function?this.wb_info.rewrite_function(t,e,r,i):this.rewriteUrl_(t,e,r,i),this.debug_rw&&(t!==o?console.log("REWRITE: "+t+" -> "+o):console.log("NOT REWRITTEN "+t)),o},f.prototype.performAttributeRewrite=function(t,e,r,i,o){switch(e){case"innerHTML":case"outerHTML":return this.rewriteHtml(r);case"filter":return this.rewriteInlineStyle(r);case"style":return this.rewriteStyle(r);case"srcset":return this.rewriteSrcset(r,t)}if(o&&!this.startsWithOneOf(r,this.VALID_PREFIXES))return r;var n=this.rwModForElement(t,e);t&&this.wbUseAFWorker&&this.WBAutoFetchWorker&&this.isSavedDataSrcSrcset(t)&&this.WBAutoFetchWorker.preserveDataSrcset(t);var s=this.rewriteUrl(r,!1,n,i);return"esm_"===n&&s&&s.indexOf("esm_/")<0&&(s=s.replace(/(\/[\d]*)([\w]+_)(?=\/)/,"$1esm_")),s},f.prototype.rewriteAttr=function(t,e,r){var i=!1;if(!t||!t.getAttribute||t._no_rewrite||t["_"+e]||t.tagName&&t.tagName.indexOf("-")>0)return i;var o=this.wb_getAttribute.call(this.proxyToObj(t),e);if(!o||this.startsWith(o,"javascript:"))return i;var n=this.performAttributeRewrite(t,e,o,t.ownerDocument,r);return n!==o&&(this.removeWBOSRC(t),this.wb_setAttribute.call(t,e,n),i=!0),i},f.prototype.noExceptRewriteStyle=function(t){try{return this.rewriteStyle(t)}catch(e){return t}},f.prototype.rewriteStyle=function(t){if(!t)return t;var e=t;return"object"==typeof t&&(e=t.toString()),"string"==typeof e?e.replace(this.STYLE_REGEX,this.styleReplacer).replace(this.IMPORT_REGEX,this.styleReplacer).replace(this.no_wombatRe,""):e},f.prototype.rewriteSrcset=function(t,e){if(!t)return"";for(var r=t.split(this.srcsetRe),i=[],o=this.rwModForElement(e,"srcset"),n=0;n<r.length;n++){var s=r[n];if(s){var a=s.trim().split(" ");a[0]=this.rewriteUrl(a[0],!0,o),i.push(a.join(" "))}}return this.wbUseAFWorker&&this.WBAutoFetchWorker&&this.isSavedSrcSrcset(e)&&this.WBAutoFetchWorker.preserveSrcset(i,this.WBAutoFetchWorker.rwMod(e)),i.join(", ")},f.prototype.rewriteFrameSrc=function(t,e){var r,i=this.wb_getAttribute.call(t,e);if(this.startsWith(i,"javascript:")&&i.indexOf("WB_wombat_")>=0){var o="javascript:";r=o+"window.parent._wb_wombat.initNewWindowWombat(window);"+i.substr(11)}return r||(r=this.rewriteUrl(i,!1,this.rwModForElement(t,e))),r!==i&&(this.wb_setAttribute.call(t,e,r),!0)},f.prototype.rewriteScript=function(t){if(t.hasAttribute("src")||!t.textContent||!this.$wbwindow.Proxy)return this.rewriteAttr(t,"src");if(this.skipWrapScriptBasedOnType(t.type))return!1;var e=t.textContent.trim(),r=[];return!this.skipWrapScriptTextBasedOnText(e,r)&&(t.textContent=this.wrapScriptTextJsProxy(e,r),this.wb_info.injectDocClose&&t.textContent.trim().length&&(t.textContent+=";document.close();"),!0)},f.prototype.rewriteSVGElem=function(t){var e=this.rewriteAttr(t,"filter");return e=this.rewriteAttr(t,"style")||e,e=this.rewriteAttr(t,"xlink:href")||e,e=this.rewriteAttr(t,"href")||e,e=this.rewriteAttr(t,"src")||e},f.prototype.rewriteElem=function(t){var e=!1;if(!t)return e;if(t instanceof SVGElement)e=this.rewriteSVGElem(t);else switch(t.tagName){case"META":var r=this.wb_getAttribute.call(t,"http-equiv");r&&"content-security-policy"===r.toLowerCase()&&(this.wb_setAttribute.call(t,"http-equiv","_"+r),e=!0);break;case"STYLE":var i=this.rewriteStyle(t.textContent);t.textContent!==i&&(t.textContent=i,e=!0,this.wbUseAFWorker&&this.WBAutoFetchWorker&&null!=t.sheet&&this.WBAutoFetchWorker.deferredSheetExtraction(t.sheet));break;case"LINK":e=this.rewriteAttr(t,"href"),this.wbUseAFWorker&&"stylesheet"===t.rel&&this._addEventListener(t,"load",this.utilFns.wbSheetMediaQChecker);break;case"IMG":e=this.rewriteAttr(t,"src"),e=this.rewriteAttr(t,"srcset")||e,e=this.rewriteAttr(t,"style")||e,this.wbUseAFWorker&&this.WBAutoFetchWorker&&t.dataset.srcset&&this.WBAutoFetchWorker.preserveDataSrcset(t);break;case"OBJECT":var o;if(this.wb_info.isSW&&t.parentElement)if("application/pdf"===t.getAttribute("type")?o="IFRAME":"image/svg+xml"===t.getAttribute("type")&&(o="IMG"),o){for(var n=this.$wbwindow.document.createElement(o),s=0;s<t.attributes.length;s++){var a=t.attributes[s],w=a.name;"data"===w&&(w="src"),this.wb_setAttribute.call(n,w,a.value)}t.parentElement.replaceChild(n,t),e=!0;break}e=this.rewriteAttr(t,"data",!0),e=this.rewriteAttr(t,"style")||e;break;case"FORM":e=this.rewriteAttr(t,"poster"),e=this.rewriteAttr(t,"action")||e,e=this.rewriteAttr(t,"style")||e;break;case"IFRAME":if(e=this.rewriteFrameSrc(t,"src"),this.wb_info.isSW&&!e){var h=t.getAttribute("srcdoc");if(t.hasAttribute("srcdoc")&&t.removeAttribute("srcdoc"),h)this.blobUrlForIframe(t,h);else{var p=t.getAttribute("src");p&&"about:blank"!==p||(p||(t.__WB_blank=!0),t.src=this.wb_info.prefix+this.wb_info.request_ts+"mp_/about:blank")}}e=this.rewriteAttr(t,"style")||e;break;case"FRAME":e=this.rewriteFrameSrc(t,"src"),e=this.rewriteAttr(t,"style")||e;break;case"SCRIPT":e=this.rewriteScript(t);break;case"A":if(e=this.rewriteAttr(t,"href")||e,e=this.rewriteAttr(t,"style")||e,t.hasAttribute("target")){var c=this.rewriteAttrTarget(t.target);c!==t.target&&(t.target=c,e=!0)}break;default:e=this.rewriteAttr(t,"src"),e=this.rewriteAttr(t,"srcset")||e,e=this.rewriteAttr(t,"href")||e,e=this.rewriteAttr(t,"style")||e,e=this.rewriteAttr(t,"poster")||e,e=this.rewriteAttr(t,"background")||e}return t.hasAttribute&&t.removeAttribute&&(t.hasAttribute("crossorigin")&&(t.removeAttribute("crossorigin"),e=!0),t.hasAttribute("integrity")&&(t.removeAttribute("integrity"),e=!0)),e},f.prototype.recurseRewriteElem=function(t){if(!this.nodeHasChildren(t))return!1;for(var e=!1,r=[t.children||t.childNodes];r.length>0;)for(var i=r.shift(),o=0;o<i.length;o++){var n=i[o];n.nodeType===Node.ELEMENT_NODE&&(e=this.rewriteElem(n)||e,this.nodeHasChildren(n)&&r.push(n.children||n.childNodes))}return e},f.prototype.rewriteElemComplete=function(t){if(!t)return!1;var e=this.rewriteElem(t),r=this.recurseRewriteElem(t);return e||r},f.prototype.rewriteElementsInArguments=function(t){for(var e=new Array(t.length),r=0;r<t.length;r++){var i=t[r];i instanceof Node?(this.rewriteElemComplete(i),e[r]=i):e[r]="string"==typeof i?this.rewriteHtml(i):i}return e},f.prototype.rewriteHtml=function(t,e){if(!t)return t;var r=t;if("string"!=typeof t&&(r=t.toString()),this.write_buff&&(r=this.write_buff+r,this.write_buff=""),r.indexOf("<script")<=0&&r.indexOf("WB_wombat_")>=0&&(r=r.replace(/((id|class)=".*)WB_wombat_([^"]+)/,"$1$3")),!this.$wbwindow.HTMLTemplateElement||this.FullHTMLRegex.test(r))return this.rewriteHtmlFull(r,e);var i=(new DOMParser).parseFromString("<template>"+r+"</template>","text/html");if(!i||!this.nodeHasChildren(i.head)||!i.head.children[0].content)return r;var o=i.head.children[0];if(o._no_rewrite=!0,this.recurseRewriteElem(o.content)){var n=o.innerHTML;if(e){var s=o.content.children&&o.content.children[0];if(s){var a="</"+s.tagName.toLowerCase()+">";if(this.endsWith(n,a)&&!this.endsWith(r.toLowerCase(),a))n=n.substring(0,n.length-a.length);else if(n.trimEnd().endsWith(a)&&!r.trimEnd().endsWith(a)){var w=r.lastIndexOf(a);w>0&&(n+=r.slice(w+a.length))}}else if("<"!==r[0]||">"!==r[r.length-1])return void(this.write_buff+=r)}return n}return r},f.prototype.rewriteHtmlFull=function(t,e){var r=(new DOMParser).parseFromString(t,"text/html");if(!r)return t;for(var i=!1,o=0;o<r.all.length;o++)i=this.rewriteElem(r.all[o])||i;if(i){var n;if(t&&t.indexOf("<html")>=0)r.documentElement._no_rewrite=!0,n=this.reconstructDocType(r.doctype)+r.documentElement.outerHTML;else{r.head._no_rewrite=!0,r.body._no_rewrite=!0;var s=this.nodeHasChildren(r.head),a=this.nodeHasChildren(r.body);if(n=(s?r.head.outerHTML:"")+(a?r.body.outerHTML:""),e)if(r.all.length>3){var w="</"+r.all[3].tagName.toLowerCase()+">";this.endsWith(n,w)&&!this.endsWith(t.toLowerCase(),w)&&(n=n.substring(0,n.length-w.length))}else if("<"!==t[0]||">"!==t[t.length-1])return void(this.write_buff+=t);n=this.reconstructDocType(r.doctype)+n}return n}return t},f.prototype.rewriteInlineStyle=function(t){var e;try{e=decodeURIComponent(t)}catch(r){e=t}if(e!==t){var r=this.rewriteStyle(e).split(",",2);return r[0]+","+encodeURIComponent(r[1])}return this.rewriteStyle(t)},f.prototype.rewriteCookie=function(t){var e=this,r=t.replace(this.wb_abs_prefix,"").replace(this.wb_rel_prefix,"");return r=r.replace(this.cookie_domain_regex,(function(t,i){var o={domain:i,cookie:r,wb_type:"cookie"};return e.sendTopMessage(o,!0),e.$wbwindow.location.hostname.indexOf(".")>=0&&!e.IP_RX.test(e.$wbwindow.location.hostname)?"Domain=."+e.$wbwindow.location.hostname:""})).replace(this.cookie_path_regex,(function(t,r){var i=e.rewriteUrl(r);return 0===i.indexOf(e.wb_curr_host)&&(i=i.substring(e.wb_curr_host.length)),"Path="+i})),"https:"!==e.$wbwindow.location.protocol&&(r=r.replace("secure","")),r.replace(",|",",")},f.prototype.rewriteWorker=function(t){if(!t)return t;var e=0===(t=t.toString()).indexOf("blob:"),r=0===t.indexOf("javascript:");if(!e&&!r){if(!this.startsWithOneOf(t,this.VALID_PREFIXES)&&!this.startsWith(t,"/")&&!this.startsWithOneOf(t,this.BAD_PREFIXES)){var i=this.resolveRelUrl(t,this.$wbwindow.document);return this.rewriteUrl(i,!1,"wkr_",this.$wbwindow.document)}return this.rewriteUrl(t,!1,"wkr_",this.$wbwindow.document)}var o=r?t.replace("javascript:",""):null;if(e){var n=new XMLHttpRequest;this.utilFns.XHRopen.call(n,"GET",t,!1),this.utilFns.XHRsend.call(n),o=n.responseText.replace(this.workerBlobRe,"").replace(this.rmCheckThisInjectRe,"this")}if(this.wb_info.static_prefix||this.wb_info.ww_rw_script){var s=this.$wbwindow.document.baseURI;o="(function() { self.importScripts('"+(this.wb_info.ww_rw_script||this.wb_info.static_prefix+"wombatWorkers.js")+"'); new WBWombat({'prefix': '"+this.wb_abs_prefix+"', 'prefixMod': '"+this.wb_abs_prefix+"wkrf_/', 'originalURL': "+JSON.stringify(s)+"}); })();"+o}var a=new Blob([o],{type:"application/javascript"});return this.URL.createObjectURL(a)},f.prototype.rewriteTextNodeFn=function(t,e,r){var i,o=this.proxyToObj(t);if(r.length>0&&o.parentElement&&"STYLE"===o.parentElement.tagName){i=new Array(r.length);var n=r.length-1;2===n?(i[0]=r[0],i[1]=r[1]):1===n&&(i[0]=r[0]),i[n]=this.rewriteStyle(r[n])}else i=r;return e.__WB_orig_apply?e.__WB_orig_apply(o,i):e.apply(o,i)},f.prototype.rewriteChildNodeFn=function(t,e,r){var i=this.proxyToObj(t);if(0===r.length)return e.call(i);var o=this.rewriteElementsInArguments(r);return e.__WB_orig_apply?e.__WB_orig_apply(i,o):e.apply(i,o)},f.prototype.rewriteInsertAdjHTMLOrElemArgs=function(t,e,r,i,o){var n=this.proxyToObj(t);return n._no_rewrite?e.call(n,r,i):o?e.call(n,r,this.rewriteHtml(i)):(this.rewriteElemComplete(i),e.call(n,r,i))},f.prototype.rewriteSetTimeoutInterval=function(t,e,r){var i=this.isString(r[0]),o=i?new Array(r.length):r;if(i){this.$wbwindow.Proxy?o[0]=this.wrapScriptTextJsProxy(r[0]):o[0]=r[0].replace(/\blocation\b/g,"WB_wombat_$&");for(var n=1;n<r.length;++n)o[n]=this.proxyToObj(r[n])}var s=this.proxyToObj(t);return e.__WB_orig_apply?e.__WB_orig_apply(s,o):e.apply(s,o)},f.prototype.rewriteHTMLAssign=function(t,e,r){var i=r,o=t.tagName;if(!(t._no_rewrite||t instanceof this.$wbwindow.HTMLTemplateElement))if("STYLE"===o)i=this.rewriteStyle(r);else if("SCRIPT"===o){r&&this.IsTagRegex.test(r)&&(i=this.rewriteHtml(r));var n=[];i===r&&(this.skipWrapScriptBasedOnType(t.type)||this.skipWrapScriptTextBasedOnText(r,n)||(i=this.wrapScriptTextJsProxy(i,n)))}else i=this.rewriteHtml(r);e.call(t,i),this.wbUseAFWorker&&this.WBAutoFetchWorker&&"STYLE"===o&&null!=t.sheet&&this.WBAutoFetchWorker.deferredSheetExtraction(t.sheet)},f.prototype.rewriteEvalArg=function(t,e,r){this.$wbwindow.TrustedScript&&e instanceof this.$wbwindow.TrustedScript&&(e=e.toString());var i=[];return t(this.isString(e)&&!this.skipWrapScriptTextBasedOnText(e,i)?this.wrapScriptTextJsProxy(e,i):this.otherEvalRewrite(e),r)},f.prototype.otherEvalRewrite=function(t){return"string"!=typeof t?t:t.replace(this.IMPORT_JS_REGEX,this.styleReplacer)},f.prototype.addEventOverride=function(t,e){var r=e;e||(r=this.$wbwindow.MessageEvent.prototype);var i=this.getOrigGetter(r,t);i&&this.defGetterProp(r,t,(function(){return null!=this["_"+t]?this["_"+t]:i.call(this)}))},f.prototype.isAttrObjRewrite=function(t){if(!t)return!1;var e=t.ownerElement&&t.ownerElement.tagName;return this.shouldRewriteAttr(e,t.nodeName)},f.prototype.newAttrObjGetSet=function(t,e){var r=this,i=this.getOrigGetter(t,e),o=this.getOrigSetter(t,e);this.defProp(t,e,(function(t){var e=r.proxyToObj(this),i=t;return r.isAttrObjRewrite(e)&&(i=r.performAttributeRewrite(e.ownerElement,e.name,t,e.ownerDocument,!1)),o.call(e,i)}),(function(){var t=r.proxyToObj(this),e=i.call(t);return r.isAttrObjRewrite(t)?r.extractOriginalURL(e):e}))},f.prototype.overrideAttrProps=function(){var t=this.$wbwindow.Attr.prototype;this.newAttrObjGetSet(t,"value"),this.newAttrObjGetSet(t,"nodeValue"),this.newAttrObjGetSet(t,"textContent")},f.prototype.overrideAttr=function(t,e,r){var i=this.getOrigGetter(t,e),o=this.getOrigSetter(t,e),n=this;this.defProp(t,e,(function(t){"js_"===r&&(this.__$removedWBOSRC$__||n.removeWBOSRC(this),"module"===this.type&&(r="esm_"));var i=n.rewriteUrl(t,!1,r);return o?o.call(this,i):n.wb_setAttribute?n.wb_setAttribute.call(this,e,i):void 0}),(function(){var t;return i?t=i.call(this):n.wb_getAttribute&&(t=n.wb_getAttribute.call(this,e)),t=n.extractOriginalURL(t),this.__WB_blank&&"about:blank"===t?"":t}))},f.prototype.overridePropExtract=function(t,e){var r=this.getOrigGetter(t,e),i=this;if(r){this.defGetterProp(t,e,(function(){var t=i.proxyToObj(this),e=r.call(t);return t.__WB_no_unrewrite?e:i.extractOriginalURL(e)}))}},f.prototype.overrideDeProxyPropAssign=function(t,e){var r=this.getOrigSetter(t,e),i=this.getOrigGetter(t,e),o=this;if(r){this.defProp(t,e,(function(t){return r.call(o.proxyToObj(this),o.proxyToObj(t))}),i)}},f.prototype.overrideReferrer=function(t){var e=this.getOrigGetter(t,"referrer"),r=this;if(e){this.defGetterProp(t,"referrer",(function(){var t=r.proxyToObj(this),i=this.defaultView;if(i===i.__WB_replay_top)return"";var o=e.call(t);return r.extractOriginalURL(o)}))}},f.prototype.overridePropToProxy=function(t,e){var r=this.getOrigGetter(t,e);if(r){var i=this;this.defGetterProp(t,e,(function(){return i.objToProxy(r.call(this))}))}},f.prototype.overrideHistoryFunc=function(t){if(this.$wbwindow.history){var e=this.$wbwindow.history[t];if(e){this.$wbwindow.history["_orig_"+t]=e,this.$wbwindow.history.___wb_ownWindow=this.$wbwindow;var r=this,i=function(t,i,o){var n=this.___wb_ownWindow||r.$wbwindow;o=r.extractOriginalURL(o);var s,a,w=n.WB_wombat_location;if(o){var h=r._makeURLParser(o,n.document);if(a=h.href,s=r.rewriteUrl(a),a!==w.origin&&"about:blank"!==w.href&&!r.startsWith(a,w.origin+"/"))throw new DOMException("Invalid history change: "+a)}else a=w.href;e.call(this,t,i,s);var p=n.document.title;r.WBAutoFetchWorker&&n.setTimeout((function(){i||n.document.title===p||(i=n.document.title),r.WBAutoFetchWorker.fetchAsPage(s,a,i)}),100),r.sendHistoryUpdate(a,i,n)};return this.$wbwindow.history[t]=i,this.$wbwindow.History&&this.$wbwindow.History.prototype&&(this.$wbwindow.History.prototype[t]=i),i}}},f.prototype.overrideStyleAttr=function(t,e,r){var i=this.getOrigGetter(t,e),o=this.getOrigSetter(t,e),n=this,s=i,a=function(t,e,r,i,o){return e+(r||"")+n.extractOriginalURL(i)+o},w=/(url\()(['"])?(.*?)(\2\))/;i||(s=function(){var t=this.getPropertyValue(r);return t&&t.startsWith("url(")&&(t=t.replace(w,a)),t}),(o&&i||r)&&this.defProp(t,e,(function(t){var e=n.rewriteStyle(t);return o?o.call(this,e):this.setProperty(r,e),e}),s)},f.prototype.overrideStyleSetProp=function(t){var e=t.setProperty,r=this;t.setProperty=function(t,i,o){var n=r.rewriteStyle(i);return e.call(this,t,n,o)}},f.prototype.overrideAnchorAreaElem=function(t){if(t&&t.prototype){for(var e={},r=t.prototype,i=function(t,r){var i=e["set_"+t];return i?i.call(this,r):""},o=function(t){var r=e["get_"+t];return r?r.call(this):""},n=0;n<this.URL_PROPS.length;n++){var s=this.URL_PROPS[n];e["get_"+s]=this.getOrigGetter(r,s),e["set_"+s]=this.getOrigSetter(r,s),Object.defineProperty&&this.defProp(r,s,this.makeSetLocProp(s,i,o),this.makeGetLocProp(s,o),!0)}r.toString=function(){return this.href}}},f.prototype.overrideHtmlAssign=function(t,e,r){if(this.$wbwindow.DOMParser&&t&&t.prototype){var i=t.prototype,o=this.getOrigGetter(i,e),n=this.getOrigSetter(i,e);if(n){var s=this.rewriteHTMLAssign,a=this.wb_unrewrite_rx;this.defProp(i,e,(function(t){return s(this,n,t)}),r?function(){var t=o.call(this);return this._no_rewrite?t:t.replace(a,"")}:o)}}},f.prototype.overrideHtmlAssignSrcDoc=function(t,e){var r=t.prototype;this.getOrigGetter(r,e);var i=this.getOrigSetter(r,e),o=this;this.defProp(r,e,(function(t){return this.__wb_srcdoc=t,o.wb_info.isSW?(o.blobUrlForIframe(this,t),t):o.rewriteHTMLAssign(this,i,t)}),(function(){return this.__wb_srcdoc}))},f.prototype.overrideDataSet=function(){var t=this.$wbwindow.HTMLElement.prototype,e=this.getOrigGetter(t,"dataset"),r=this;this.defProp(t,"dataset",null,(function(){var t=e.call(this);return new Proxy(t,{get(t,e,i){var o=t[e];return"string"==typeof o&&r.startsWithOneOf(o,r.wb_prefixes)?r.extractOriginalURL(o):o}})}))},f.prototype.overrideStyleProxy=function(t){var e=this.$wbwindow.HTMLElement.prototype,r=this.getOrigSetter(e,"style"),i=this.getOrigGetter(e,"style"),o=this;this.defProp(e,"style",r,(function(){var e=i.call(this),r={};return new Proxy(e,{set:(e,r,i)=>(t.includes(r)&&(i=o.rewriteStyle(i)),e[r]=i,!0),get(t,i,n){var s=t[i];return"function"!=typeof s||"setProperty"!==i&&!o.isNativeFunction(s)?s:(r[i]||(r[i]=s.bind(e)),r[i])}})}))},f.prototype.overrideIframeContentAccess=function(t){if(this.$wbwindow.HTMLIFrameElement&&this.$wbwindow.HTMLIFrameElement.prototype){var e=this.$wbwindow.HTMLIFrameElement.prototype,r=this.getOrigGetter(e,t);if(r){var i=this.getOrigSetter(e,t),o=this;this.defProp(e,t,i,(function(){return o.initIframeWombat(this),o.objToProxy(r.call(this))})),e["_get_"+t]=r}}},f.prototype.overrideSWAccess=function(t){if(t.navigator.serviceWorker&&t.navigator.serviceWorker.controller){t._WB_wombat_sw=t.navigator.serviceWorker;var e={controller:null,ready:Promise.resolve({unregister:function(){}}),register:function(){return Promise.reject()},addEventListener:function(){},removeEventListener:function(){},onmessage:null,oncontrollerchange:null,getRegistrations:function(){return Promise.resolve([])},getRegistration:function(){return Promise.resolve(void 0)},startMessages:function(){}};this.defGetterProp(t.navigator,"serviceWorker",(function(){return e}))}},f.prototype.overrideFuncThisProxyToObj=function(t,e,r){if(t){var i=r;if(!r&&t.prototype&&t.prototype[e]?i=t.prototype:!r&&t[e]&&(i=t),i){var o=this,n=i[e];i[e]=function(){return n.apply(o.proxyToObj(this),arguments)}}}},f.prototype.overrideFuncArgProxyToObj=function(t,e,r){if(t&&t.prototype){var i=r||0,o=t.prototype[e];if(o){var n=this;t.prototype[e]=function(){for(var t=new Array(arguments.length),e=0;e<t.length;e++)t[e]=e===i?n.proxyToObj(arguments[e]):arguments[e];var r=n.proxyToObj(this);return o.__WB_orig_apply?o.__WB_orig_apply(r,t):o.apply(r,t)}}}},f.prototype.overrideFunctionApply=function(t){if(!t.Function.prototype.__WB_orig_apply){var e=t.Function.prototype.apply;t.Function.prototype.__WB_orig_apply=e;var r=this;t.Function.prototype.apply=function(t,e){return r.isNativeFunction(this)&&(t=r.proxyToObj(t),e=r.deproxyArrayHandlingArgumentsObj(e)),this.__WB_orig_apply(t,e)},this.wb_funToString.apply=e}},f.prototype.overrideFunctionCall=function(t){if(!t.Function.prototype.__WB_orig_call){var e=t.Function.prototype.call;t.Function.prototype.__WB_orig_call=e;var r=this;t.Function.prototype.call=function(t,...e){return r.isNativeFunction(this)&&(t=r.proxyToObj(t),e=r.deproxyArrayHandlingArgumentsObj(e)),this.__WB_orig_call(t,...e)},this.wb_funToString.call=e}},f.prototype.overrideFunctionBind=function(t){if(!t.Function.prototype.__WB_orig_bind){var e=t.Function.prototype.bind;t.Function.prototype.__WB_orig_bind=e;var r=this;t.Function.prototype.bind=function(t){var e=r.isNativeFunction(this),i=e?this.__WB_orig_bind.apply(this,arguments):this.__WB_orig_bind.__WB_orig_apply(this,arguments);return i.__WB_is_native_func__=e,i}}},f.prototype.overrideSrcsetAttr=function(t,e){var r="srcset",i=this.getOrigGetter(t,r),o=this.getOrigSetter(t,r),n=this;this.defProp(t,r,(function(t){var e=n.rewriteSrcset(t,this);return o?o.call(this,e):n.wb_setAttribute?n.wb_setAttribute.call(this,r,e):void 0}),(function(){var t;return i?t=i.call(this):n.wb_getAttribute&&(t=n.wb_getAttribute.call(this,r)),t=n.extractOriginalURL(t)}))},f.prototype.overrideHrefAttr=function(t,e){var r=this.getOrigGetter(t,"href"),i=this.getOrigSetter(t,"href"),o=this;this.defProp(t,"href",(function(t){var r;return r="cs_"===e&&0===t.indexOf("data:text/css")?o.rewriteInlineStyle(t):"LINK"===this.tagName?o.rewriteUrl(t,!1,o.rwModForElement(this,"href")):o.rewriteUrl(t,!1,e,this.ownerDocument),i?i.call(this,r):o.wb_setAttribute?o.wb_setAttribute.call(this,"href",r):void 0}),(function(){var t;return r?t=r.call(this):o.wb_getAttribute&&(t=o.wb_getAttribute.call(this,"href")),this._no_rewrite?t:o.extractOriginalURL(t)}))},f.prototype.overrideTextProtoGetSet=function(t,e){var r,i=this.getOrigGetter(t,e),o=this;if("data"===e){var n=this.getOrigSetter(t,e);r=function(t){var e=t;return!this._no_rewrite&&this.parentElement&&"STYLE"===this.parentElement.tagName&&(e=o.rewriteStyle(t)),n.call(this,e)}}this.defProp(t,e,r,(function(){var t=i.call(this);return!this._no_rewrite&&this.parentElement&&"STYLE"===this.parentElement.tagName?t.replace(o.wb_unrewrite_rx,""):t}))},f.prototype.overrideAnUIEvent=function(t){var e="__wb_"+t+"_overridden",r=this.$wbwindow[t];if(r&&r.prototype&&!r.prototype[e]){var i=this;this.overridePropToProxy(r.prototype,"view");var o,n="init"+t;if(r.prototype[n]){var s=r.prototype[n];r.prototype[n]=function(){var t=i.proxyToObj(this);if(0===arguments.length||arguments.length<3)return s.__WB_orig_apply?s.__WB_orig_apply(t,arguments):s.apply(t,arguments);for(var e=new Array(arguments.length),r=0;r<arguments.length;r++)e[r]=3===r?i.proxyToObj(arguments[r]):arguments[r];return s.__WB_orig_apply?s.__WB_orig_apply(t,e):s.apply(t,e)}}this.$wbwindow[t]=(o=r,function(e,r){return i.domConstructorErrorChecker(this,t,arguments),r&&(null!=r.view&&(r.view=i.proxyToObj(r.view)),null!=r.relatedTarget&&(r.relatedTarget=i.proxyToObj(r.relatedTarget)),null!=r.target&&(r.target=i.proxyToObj(r.target))),new o(e,r)}),this.$wbwindow[t].prototype=r.prototype,Object.defineProperty(this.$wbwindow[t].prototype,"constructor",{value:this.$wbwindow[t]}),this.$wbwindow[t].prototype[e]=!0}},f.prototype.rewriteParentNodeFn=function(t,e,r){var i=this._no_rewrite?r:this.rewriteElementsInArguments(r),o=this.proxyToObj(t);return e.__WB_orig_apply?e.__WB_orig_apply(o,i):e.apply(o,i)},f.prototype.overrideParentNodeAppendPrepend=function(t){var e=this.rewriteParentNodeFn;if(t.prototype.append){var r=t.prototype.append;t.prototype.append=function(){return e(this,r,arguments)}}if(t.prototype.prepend){var i=t.prototype.prepend;t.prototype.prepend=function(){return e(this,i,arguments)}}},f.prototype.overrideShadowDom=function(){this.$wbwindow.ShadowRoot&&this.$wbwindow.ShadowRoot.prototype&&(this.overrideHtmlAssign(this.$wbwindow.ShadowRoot,"innerHTML",!0),this.overrideParentNodeAppendPrepend(this.$wbwindow.ShadowRoot))},f.prototype.overrideChildNodeInterface=function(t,e){if(t&&t.prototype){var r=e?this.rewriteTextNodeFn:this.rewriteChildNodeFn;if(t.prototype.before){var i=t.prototype.before;t.prototype.before=function(){return r(this,i,arguments)}}if(t.prototype.after){var o=t.prototype.after;t.prototype.after=function(){return r(this,o,arguments)}}if(t.prototype.replaceWith){var n=t.prototype.replaceWith;t.prototype.replaceWith=function(){return r(this,n,arguments)}}}},f.prototype.initTextNodeOverrides=function(){var t=this.$wbwindow.Text;if(t&&t.prototype){var e=t.prototype,r=this.rewriteTextNodeFn;if(e.appendData){var i=e.appendData;e.appendData=function(){return r(this,i,arguments)}}if(e.insertData){var o=e.insertData;e.insertData=function(){return r(this,o,arguments)}}if(e.replaceData){var n=e.replaceData;e.replaceData=function(){return r(this,n,arguments)}}this.overrideChildNodeInterface(t,!0),this.overrideTextProtoGetSet(e,"data"),this.overrideTextProtoGetSet(e,"wholeText")}},f.prototype.initAttrOverrides=function(){this.overrideHrefAttr(this.$wbwindow.HTMLLinkElement.prototype,"cs_"),this.overrideHrefAttr(this.$wbwindow.CSSStyleSheet.prototype,"cs_"),this.overrideHrefAttr(this.$wbwindow.HTMLBaseElement.prototype,"mp_"),this.overrideSrcsetAttr(this.$wbwindow.HTMLImageElement.prototype,"im_"),this.overrideSrcsetAttr(this.$wbwindow.HTMLSourceElement.prototype,"oe_"),this.overrideAttr(this.$wbwindow.HTMLVideoElement.prototype,"poster","im_"),this.overrideAttr(this.$wbwindow.HTMLAudioElement.prototype,"poster","im_"),this.overrideAttr(this.$wbwindow.HTMLImageElement.prototype,"src","im_"),this.overrideAttr(this.$wbwindow.HTMLInputElement.prototype,"src","oe_"),this.overrideAttr(this.$wbwindow.HTMLEmbedElement.prototype,"src","oe_"),this.overrideAttr(this.$wbwindow.HTMLMediaElement.prototype,"src","oe_"),this.overrideAttr(this.$wbwindow.HTMLVideoElement.prototype,"src","oe_"),this.overrideAttr(this.$wbwindow.HTMLAudioElement.prototype,"src","oe_"),this.overrideAttr(this.$wbwindow.HTMLSourceElement.prototype,"src","oe_"),window.HTMLTrackElement&&window.HTMLTrackElement.prototype&&this.overrideAttr(this.$wbwindow.HTMLTrackElement.prototype,"src","oe_"),this.overrideAttr(this.$wbwindow.HTMLIFrameElement.prototype,"src","if_"),this.$wbwindow.HTMLFrameElement&&this.$wbwindow.HTMLFrameElement.prototype&&this.overrideAttr(this.$wbwindow.HTMLFrameElement.prototype,"src","fr_"),this.overrideAttr(this.$wbwindow.HTMLScriptElement.prototype,"src","js_"),this.overrideAttr(this.$wbwindow.HTMLObjectElement.prototype,"data","oe_"),this.overrideAttr(this.$wbwindow.HTMLObjectElement.prototype,"codebase","oe_"),this.overrideAttr(this.$wbwindow.HTMLMetaElement.prototype,"content","mp_"),this.overrideAttr(this.$wbwindow.HTMLFormElement.prototype,"action","mp_"),this.overrideAttr(this.$wbwindow.HTMLQuoteElement.prototype,"cite","mp_"),this.overrideAttr(this.$wbwindow.HTMLModElement.prototype,"cite","mp_"),this.overrideAnchorAreaElem(this.$wbwindow.HTMLAnchorElement),this.overrideAnchorAreaElem(this.$wbwindow.HTMLAreaElement);var t=this.$wbwindow.CSSStyleDeclaration.prototype,e={background:"background",backgroundImage:"background-image",cursor:"cursor",listStyle:"list-style",listStyleImage:"list-style-image",border:"border",borderImage:"border-image",borderImageSource:"border-image-source",maskImage:"mask-image"};for(var[r,i]of(this.overrideStyleProxy(Object.values(e)),this.$wbwindow.CSS2Properties&&(t=this.$wbwindow.CSS2Properties.prototype),this.overrideStyleAttr(t,"cssText"),Object.entries(e)))this.overrideStyleAttr(t,r,i);if(this.overrideStyleSetProp(t),this.$wbwindow.CSSStyleSheet&&this.$wbwindow.CSSStyleSheet.prototype){var o=this,n=this.$wbwindow.CSSStyleSheet.prototype.insertRule;this.$wbwindow.CSSStyleSheet.prototype.insertRule=function(t,e){return n.call(this,o.rewriteStyle(t),e)}}this.$wbwindow.CSSRule&&this.$wbwindow.CSSRule.prototype&&this.overrideStyleAttr(this.$wbwindow.CSSRule.prototype,"cssText")},f.prototype.initCSSOMOverrides=function(){var t,r=this;if(this.$wbwindow.CSSStyleValue){var i=function(t,e){var i=t[e];t[e]=function(t,e){if(null==e)return i.call(this,t,e);var o=r.noExceptRewriteStyle(e);return i.call(this,t,o)}};this.$wbwindow.CSSStyleValue.parse&&this.$wbwindow.CSSStyleValue.parse.toString().indexOf("[native code]")>0&&i(this.$wbwindow.CSSStyleValue,"parse"),this.$wbwindow.CSSStyleValue.parseAll&&this.$wbwindow.CSSStyleValue.parseAll.toString().indexOf("[native code]")>0&&i(this.$wbwindow.CSSStyleValue,"parseAll")}if(this.$wbwindow.CSSKeywordValue&&this.$wbwindow.CSSKeywordValue.prototype){var o=this.$wbwindow.CSSKeywordValue;this.$wbwindow.CSSKeywordValue=(t=this.$wbwindow.CSSKeywordValue,function(e){return r.domConstructorErrorChecker(this,"CSSKeywordValue",arguments),new t(r.rewriteStyle(e))}),this.$wbwindow.CSSKeywordValue.prototype=o.prototype,Object.defineProperty(this.$wbwindow.CSSKeywordValue.prototype,"constructor",{value:this.$wbwindow.CSSKeywordValue}),e(this.$wbwindow.CSSKeywordValue,"CSSKeywordValue")}if(this.$wbwindow.StylePropertyMap&&this.$wbwindow.StylePropertyMap.prototype){var n=this.$wbwindow.StylePropertyMap.prototype.set;this.$wbwindow.StylePropertyMap.prototype.set=function(){if(arguments.length<=1)return n.__WB_orig_apply?n.__WB_orig_apply(this,arguments):n.apply(this,arguments);var t=new Array(arguments.length);t[0]=arguments[0];for(var e=1;e<arguments.length;e++)t[e]=r.noExceptRewriteStyle(arguments[e]);return n.__WB_orig_apply?n.__WB_orig_apply(this,t):n.apply(this,t)};var s=this.$wbwindow.StylePropertyMap.prototype.append;this.$wbwindow.StylePropertyMap.prototype.append=function(){if(arguments.length<=1)return n.__WB_orig_apply?s.__WB_orig_apply(this,arguments):s.apply(this,arguments);var t=new Array(arguments.length);t[0]=arguments[0];for(var e=1;e<arguments.length;e++)t[e]=r.noExceptRewriteStyle(arguments[e]);return s.__WB_orig_apply?s.__WB_orig_apply(this,t):s.apply(this,t)}}},f.prototype.initAudioOverride=function(){if(this.$wbwindow.Audio){var t,r=this.$wbwindow.Audio,i=this;this.$wbwindow.Audio=(t=this.$wbwindow.Audio,function(e){return i.domConstructorErrorChecker(this,"Audio"),new t(i.rewriteUrl(e,!0,"oe_"))}),this.$wbwindow.Audio.prototype=r.prototype,Object.defineProperty(this.$wbwindow.Audio.prototype,"constructor",{value:this.$wbwindow.Audio}),e(this.$wbwindow.Audio,"HTMLAudioElement")}},f.prototype.initBadPrefixes=function(t){this.BAD_PREFIXES=["http:"+t,"https:"+t,"http:/"+t,"https:/"+t]},f.prototype.initCryptoRandom=function(){if(this.$wbwindow.crypto&&this.$wbwindow.Crypto){var t=this,e=function(e){for(var r=0;r<e.length;r++)e[r]=parseInt(4294967296*t.$wbwindow.Math.random());return e};this.$wbwindow.Crypto.prototype.getRandomValues=e,this.$wbwindow.crypto.getRandomValues=e}},f.prototype.initDateOverride=function(t){if(!this.$wbwindow.__wb_Date_now){var e,r=1e3*parseInt(t),i=this.$wbwindow.Date.now()-(r-0),o=this.$wbwindow.Date,n=this.$wbwindow.Date.UTC,s=this.$wbwindow.Date.parse,a=this.$wbwindow.Date.now;this.$wbwindow.__wb_Date_now=a,this.$wbwindow.Date=(e=this.$wbwindow.Date,function(t,r,o,n,s,w,h){return void 0===t?new e(a()-i):void 0===r?new e(t):void 0===o?new e(t,r):void 0===n?new e(t,r,o):void 0===s?new e(t,r,o,n):void 0===w?new e(t,r,o,n,s):void 0===h?new e(t,r,o,n,s,w):new e(t,r,o,n,s,w,h)}),this.$wbwindow.Date.prototype=o.prototype,this.$wbwindow.Date.now=function(){return a()-i},this.$wbwindow.Date.UTC=n,this.$wbwindow.Date.parse=s,this.$wbwindow.Date.__WB_timediff=i,this.$wbwindow.Date.prototype.getTimezoneOffset=function(){return 0};var w=this.$wbwindow.Date.prototype.toString;this.$wbwindow.Date.prototype.toString=function(){return w.call(this).split(" GMT")[0]+" GMT+0000 (Coordinated Universal Time)"};var h=this.$wbwindow.Date.prototype.toTimeString;this.$wbwindow.Date.prototype.toTimeString=function(){return h.call(this).split(" GMT")[0]+" GMT+0000 (Coordinated Universal Time)"},Object.defineProperty(this.$wbwindow.Date.prototype,"constructor",{value:this.$wbwindow.Date})}},f.prototype.initBlobOverride=function(){if(this.$wbwindow.Blob&&!this.wb_info.isSW){var t,e=this.$wbwindow.Blob,r=this;this.$wbwindow.Blob=(t=this.$wbwindow.Blob,function(e,i){return!i||"application/xhtml+xml"!==i.type&&"text/html"!==i.type||1===e.length&&"string"==typeof e[0]&&r.startsWith(e[0],"<!DOCTYPE html>")&&(e[0]=r.rewriteHtml(e[0]),i.type="text/html"),new t(e,i)}),this.$wbwindow.Blob.prototype=e.prototype}},f.prototype.initIntersectionObsOverride=function(){var t,e=this.$wbwindow.IntersectionObserver,r=this;this.$wbwindow.IntersectionObserver=(t=this.$wbwindow.IntersectionObserver,function(e,i){return i&&i.root&&(i.root=r.proxyToObj(i.root)),new t(e,i)}),this.$wbwindow.IntersectionObserver.prototype=e.prototype,Object.defineProperty(this.$wbwindow.IntersectionObserver.prototype,"constructor",{value:this.$wbwindow.IntersectionObserver})},f.prototype.initWSOverride=function(){this.$wbwindow.WebSocket&&this.$wbwindow.WebSocket.prototype&&(this.$wbwindow.WebSocket=function(){function t(e,r){this.openCallbacks=[],this.addEventListener=function(e,r){"open"===e&&t.openCallbacks.push(r)},this.removeEventListener=function(){},this.close=function(){},this.send=function(t){console.log("ws send",t)},this.protocol=r&&r.length?r[0]:"",this.url=e,this.readyState=1;var i=this;setTimeout((function(){var t=new CustomEvent("open");i.onopen&&i.onopen(t),i.openCallbacks.forEach((e=>e(t)))}),500)}return t.CONNECTING=0,t.OPEN=1,t.CLOSING=2,t.CLOSED=3,t}(this.$wbwindow.WebSocket),Object.defineProperty(this.$wbwindow.WebSocket.prototype,"constructor",{value:this.$wbwindow.WebSocket}),e(this.$wbwindow.WebSocket,"WebSocket"))},f.prototype.initDocTitleOverride=function(){var t=this.getOrigGetter(this.$wbwindow.document,"title"),e=this.getOrigSetter(this.$wbwindow.document,"title"),r=this;this.defProp(this.$wbwindow.document,"title",(function(t){var i=e.call(this,t),o={wb_type:"title",title:t};return r.sendTopMessage(o),i}),t)},f.prototype.initFontFaceOverride=function(){if(this.$wbwindow.FontFace){var t,r=this,i=this.$wbwindow.FontFace;this.$wbwindow.FontFace=(t=this.$wbwindow.FontFace,function(e,i,o){r.domConstructorErrorChecker(this,"FontFace",arguments,2);var n=i;return null!=i&&(n="string"!=typeof i?r.rewriteInlineStyle(i.toString()):r.rewriteInlineStyle(i)),new t(e,n,o)}),this.$wbwindow.FontFace.prototype=i.prototype,Object.defineProperty(this.$wbwindow.FontFace.prototype,"constructor",{value:this.$wbwindow.FontFace}),e(this.$wbwindow.FontFace,"FontFace")}},f.prototype.initFixedRatio=function(t){try{this.$wbwindow.devicePixelRatio=t}catch(t){}if(Object.defineProperty)try{Object.defineProperty(this.$wbwindow,"devicePixelRatio",{value:t,writable:!1})}catch(t){}},f.prototype.initPaths=function(t){t.wombat_opts=t.wombat_opts||{},Object.assign(this.wb_info,t),this.wb_opts=t.wombat_opts,this.wb_replay_prefix=t.prefix,this.wb_is_proxy=t.proxy_magic||!this.wb_replay_prefix,this.wb_info.top_host=this.wb_info.top_host||"*",this.wb_curr_host=this.$wbwindow.location.protocol+"//"+this.$wbwindow.location.host,this.wb_info.wombat_opts=this.wb_info.wombat_opts||{},this.wb_orig_scheme=t.wombat_scheme+"://",this.wb_orig_origin=this.wb_orig_scheme+t.wombat_host,this.wb_abs_prefix=this.wb_replay_prefix,!t.is_live&&t.wombat_ts?this.wb_capture_date_part="/"+t.wombat_ts+"/":this.wb_capture_date_part="",this.initBadPrefixes(this.wb_replay_prefix),this.initCookiePreset()},f.prototype.initSeededRandom=function(t){this.$wbwindow.Math.seed=parseInt(t);var e=this;this.$wbwindow.Math.random=function(){return e.$wbwindow.Math.seed=(9301*e.$wbwindow.Math.seed+49297)%233280,e.$wbwindow.Math.seed/233280}},f.prototype.initHistoryOverrides=function(){this.overrideHistoryFunc("pushState"),this.overrideHistoryFunc("replaceState");var t=this;this.$wbwindow.addEventListener("popstate",(function(e){t.sendHistoryUpdate(t.$wbwindow.WB_wombat_location.href,t.$wbwindow.document.title)}))},f.prototype.initCookiePreset=function(){if(this.wb_info.presetCookie)for(var t=this.wb_info.presetCookie.split(";"),e=0;e<t.length;e++)this.$wbwindow.document.cookie=t[e].trim()+"; Path="+this.rewriteUrl("./",!0)},f.prototype.initHTTPOverrides=function(){var t=this;this.overridePropExtract(this.$wbwindow.XMLHttpRequest.prototype,"responseURL");var r,i,o=!!this.wb_info.convert_post_to_get;if(this.wb_info.isSW||o){var n=this.$wbwindow.XMLHttpRequest.prototype.open,s=this.$wbwindow.XMLHttpRequest.prototype.setRequestHeader,a=this.$wbwindow.XMLHttpRequest.prototype.send;this.utilFns.XHRopen=n,this.utilFns.XHRsend=a,this.$wbwindow.XMLHttpRequest.prototype.open=function(){this.__WB_xhr_open_arguments=arguments,this.__WB_xhr_headers=new Headers},this.$wbwindow.XMLHttpRequest.prototype.setAttributionReporting=function(){},this.$wbwindow.XMLHttpRequest.prototype.setRequestHeader=function(t,e){this.__WB_xhr_headers.set(t,e)},this.$wbwindow.XMLHttpRequest.prototype.send=async function(e){if(o&&("POST"===this.__WB_xhr_open_arguments[0]||"PUT"===this.__WB_xhr_open_arguments[0])){var r={url:this.__WB_xhr_open_arguments[1],method:this.__WB_xhr_open_arguments[0],headers:this.__WB_xhr_headers,postData:e};u(r)&&(this.__WB_xhr_open_arguments[1]=r.url,this.__WB_xhr_open_arguments[0]="GET",e=null)}if(this.__WB_xhr_open_arguments.length>2&&!this.__WB_xhr_open_arguments[2]&&-1===navigator.userAgent.indexOf("Firefox")&&(this.__WB_xhr_open_arguments[2]=!0,console.warn("wombat.js: Sync XHR not supported in SW-based replay in this browser, converted to async")),this._no_rewrite||(this.__WB_xhr_open_arguments[1]=t.rewriteUrl(this.__WB_xhr_open_arguments[1])),n.apply(this,this.__WB_xhr_open_arguments),!t.startsWith(this.__WB_xhr_open_arguments[1],"data:")){for(const[t,e]of this.__WB_xhr_headers.entries())s.call(this,t,e);s.call(this,"X-Pywb-Requested-With","XMLHttpRequest")}return a.call(this,e)}}else if(this.$wbwindow.XMLHttpRequest.prototype.open){var w=this.$wbwindow.XMLHttpRequest.prototype.open;this.utilFns.XHRopen=w,this.utilFns.XHRsend=this.$wbwindow.XMLHttpRequest.prototype.send,this.$wbwindow.XMLHttpRequest.prototype.open=function(e,r,i,o,n){var s=this._no_rewrite?r:t.rewriteUrl(r),a=!0;null==i||i||(a=!1),w.call(this,e,s,a,o,n),t.startsWith(s,"data:")||this.setRequestHeader("X-Pywb-Requested-With","XMLHttpRequest")}}if(this.$wbwindow.fetch){var h=this.$wbwindow.fetch;this.$wbwindow.fetch=function(e,r){var i;if(e instanceof Request){var o=t.rewriteUrl(e.url);e.__WB_no_unrewrite=!0,i=o===e.url?e:new Request(o,e),delete e.__WB_no_unrewrite}else e=t.rewriteUrl(e.toString()),i=new Request(e,r);return h.call(t.proxyToObj(this),i)}}if(this.$wbwindow.Request&&this.$wbwindow.Request.prototype){var p=this.$wbwindow.Request;this.$wbwindow.Request=(r=this.$wbwindow.Request,function e(i,o){t.domConstructorErrorChecker(this,"Request",arguments);var n=o||{},s=i;switch(typeof i){case"string":s=t.rewriteUrl(i);break;case"object":if(s=i,i.url){var a=t.rewriteUrl(i.url);a!==i.url&&(s=new r(a,i))}else i.href&&(s=t.rewriteUrl(i.toString(),!0))}let w=!1;if(n&&n.referrer){var h=t.rewriteUrl(n.referrer);h!==n.referrer&&(n instanceof e?(n.__WB_no_unrewrite=!0,w=!0):n.referrer=h)}var p=new r(s,n);return w&&delete n.__WB_no_unrewrite,p}),this.$wbwindow.Request.prototype=p.prototype,Object.defineProperty(this.$wbwindow.Request.prototype,"constructor",{value:this.$wbwindow.Request}),this.overridePropExtract(this.$wbwindow.Request.prototype,"url"),this.overridePropExtract(this.$wbwindow.Request.prototype,"referrer")}if(this.$wbwindow.Response&&this.$wbwindow.Response.prototype){var c=this.$wbwindow.Response.prototype.redirect;this.$wbwindow.Response.prototype.redirect=function(e,r){var i=t.rewriteUrl(e,!0,null,t.$wbwindow.document);return c.call(this,i,r)},this.overridePropExtract(this.$wbwindow.Response.prototype,"url")}if(this.$wbwindow.EventSource&&this.$wbwindow.EventSource.prototype){var l=this.$wbwindow.EventSource;this.$wbwindow.EventSource=(i=this.$wbwindow.EventSource,function(e,r){t.domConstructorErrorChecker(this,"EventSource",arguments);var o=e;return null!=e&&(o=t.rewriteUrl(e)),new i(o,r)}),this.$wbwindow.EventSource.prototype=l.prototype,Object.defineProperty(this.$wbwindow.EventSource.prototype,"constructor",{value:this.$wbwindow.EventSource}),e(this.$wbwindow.EventSource,"EventSource")}},f.prototype.initElementGetSetAttributeOverride=function(){if(!this.wb_opts.skip_setAttribute&&this.$wbwindow.Element&&this.$wbwindow.Element.prototype){var t=this,e=this.$wbwindow.Element.prototype;if(e.setAttribute){var r=e.setAttribute;e._orig_setAttribute=r,e.setAttribute=function(e,i){var o=i;if(e&&"string"==typeof o){var n=e.toLowerCase();if("LINK"===this.tagName&&"href"===n&&0===o.indexOf("data:text/css"))o=t.rewriteInlineStyle(i);else if("style"===n)o=t.rewriteStyle(i);else if("srcset"===n||"imagesrcset"===n&&"LINK"===this.tagName)o=t.rewriteSrcset(i,this);else{t.shouldRewriteAttr(this.tagName,n)&&(t.removeWBOSRC(this),this._no_rewrite||(o=t.rewriteUrl(i,!1,t.rwModForElement(this,n))))}}return r.call(this,e,o)}}if(e.getAttribute){var i=e.getAttribute;this.wb_getAttribute=i,e.getAttribute=function(e){var r=i.call(this,e);if(null===r)return r;var o=e;if(e&&(o=e.toLowerCase()),t.shouldRewriteAttr(this.tagName,o)){var n=t.retrieveWBOSRC(this);return n||t.extractOriginalURL(r)}return t.startsWith(o,"data-")&&t.startsWithOneOf(r,t.wb_prefixes)?t.extractOriginalURL(r):r}}}},f.prototype.initSvgImageOverrides=function(){if(this.$wbwindow.SVGImageElement){var t=this.$wbwindow.SVGImageElement.prototype,e=t.getAttribute,r=t.getAttributeNS,i=t.setAttribute,o=t.setAttributeNS,n=this;t.getAttribute=function(t){var r=e.call(this,t);return t.indexOf("xlink:href")>=0||"href"===t?n.extractOriginalURL(r):r},t.getAttributeNS=function(t,e){var i=r.call(this,t,e);return e.indexOf("xlink:href")>=0||"href"===e?n.extractOriginalURL(i):i},t.setAttribute=function(t,e){var r=e;return(t.indexOf("xlink:href")>=0||"href"===t)&&(r=n.rewriteUrl(e)),i.call(this,t,r)},t.setAttributeNS=function(t,e,r){var i=r;return(e.indexOf("xlink:href")>=0||"href"===e)&&(i=n.rewriteUrl(r)),o.call(this,t,e,i)}}},f.prototype.initCreateElementNSFix=function(){if(this.$wbwindow.document.createElementNS&&this.$wbwindow.Document.prototype.createElementNS){var t=this.$wbwindow.document.createElementNS,e=this,r=function(r,i){return t.call(e.proxyToObj(this),e.extractOriginalURL(r),i)};this.$wbwindow.Document.prototype.createElementNS=r,this.$wbwindow.document.createElementNS=r}},f.prototype.initQuerySelectorOverride=function(){if(this.$wbwindow.document.querySelector&&this.$wbwindow.Document.prototype.querySelector){var t=this,e=this.$wbwindow.document.querySelector,r=function(r){return e.call(t.proxyToObj(this),n(r))},i=this.$wbwindow.document.querySelectorAll,o=function(e){return i.call(t.proxyToObj(this),n(e))};this.$wbwindow.Document.prototype.querySelector=r,this.$wbwindow.document.querySelector=r,this.$wbwindow.Document.prototype.querySelectorAll=o,this.$wbwindow.document.querySelectorAll=o}function n(t){if("string"==typeof t)try{t=t.replace(/((?:^|\s)\b\w+\[(?:src|href|data-href))[\^]?(=['"]?(?:https?[:])?\/\/)/,"$1*$2")}catch(t){}return t}},f.prototype.initInsertAdjacentElementHTMLOverrides=function(){var t=this.$wbwindow.Element;if(t&&t.prototype){var e=t.prototype,r=this.rewriteInsertAdjHTMLOrElemArgs;if(e.insertAdjacentHTML){var i=e.insertAdjacentHTML;e.insertAdjacentHTML=function(t,e){return r(this,i,t,e,!0)}}if(e.insertAdjacentElement){var o=e.insertAdjacentElement;e.insertAdjacentElement=function(t,e){return r(this,o,t,e,!1)}}}},f.prototype.initDomOverride=function(){var t=this.$wbwindow.Node;if(t&&t.prototype){var e=this.rewriteNodeFuncArgs;if(t.prototype.appendChild){var r=t.prototype.appendChild;t.prototype.appendChild=function(t,i){return e(this,r,t,i)}}if(t.prototype.insertBefore){var i=t.prototype.insertBefore;t.prototype.insertBefore=function(t,r){return e(this,i,t,r)}}if(t.prototype.replaceChild){var o=t.prototype.replaceChild;t.prototype.replaceChild=function(t,r){return e(this,o,t,r)}}this.overridePropToProxy(t.prototype,"ownerDocument"),this.overridePropToProxy(this.$wbwindow.HTMLHtmlElement.prototype,"parentNode"),this.overridePropToProxy(this.$wbwindow.Event.prototype,"target");var n=t.prototype.getRootNode,s=this;t.prototype.getRootNode=function(){return s.objToProxy(n.call(this))}}this.$wbwindow.Element&&this.$wbwindow.Element.prototype&&(this.overrideParentNodeAppendPrepend(this.$wbwindow.Element),this.overrideChildNodeInterface(this.$wbwindow.Element,!1)),this.$wbwindow.DocumentFragment&&this.$wbwindow.DocumentFragment.prototype&&this.overrideParentNodeAppendPrepend(this.$wbwindow.DocumentFragment)},f.prototype.initDocOverrides=function(t){if(Object.defineProperty){this.overrideReferrer(t),this.defGetterProp(t,"origin",(function(){return this.WB_wombat_location.origin})),this.defGetterProp(this.$wbwindow,"origin",(function(){return this.WB_wombat_location.origin}));var e=this;this.defProp(t,"domain",(function(t){var r=this.WB_wombat_location;r&&e.endsWith(r.hostname,t)&&(this.__wb_domain=t)}),(function(){return this.__wb_domain||this.WB_wombat_location.hostname}))}},f.prototype.initDocWriteOpenCloseOverride=function(){if(this.$wbwindow.DOMParser){var t=this.$wbwindow.Document.prototype,e=this.$wbwindow.document;this._writeBuff="";var r=this,i=e.write,o=function(){return d(this,i,_(arguments))};e.write=o,t.write=o;var n=e.writeln,s=function(){return d(this,n,_(arguments))};e.writeln=s,t.writeln=s;var a=e.open,w=function(){var t,e=r.proxyToObj(this);if(3===arguments.length){var i=r.rewriteUrl(arguments[0],!1,"mp_");t=a.call(e,i,arguments[1],arguments[2]),r.initNewWindowWombat(t,arguments[0])}else t=a.call(e),u()?r._writeBuff="":r.initNewWindowWombat(e.defaultView);return t};e.open=w,t.open=w;var h=e.close,p=function(){if(!r._writeBuff){var t=r.proxyToObj(this);return r.initNewWindowWombat(t.defaultView),h.__WB_orig_apply?h.__WB_orig_apply(t,arguments):h.apply(t,arguments)}if("loading"===this.readyState&&i.call(e,r.rewriteHtml(r._writeBuff,!0)),u()){r.blobUrlForIframe(r.$wbwindow.frameElement,r._writeBuff);const t=this;try{if(t.documentElement){new r.$wbwindow.MutationObserver(((e,i)=>{r.blobUrlForIframe(r.$wbwindow.frameElement,t.documentElement.outerHTML)})).observe(t.documentElement,{childList:!0,subtree:!0})}}catch(t){}}r._writeBuff=""};e.close=p,t.close=p;var c=this.getOrigGetter(t,"body"),l=this.getOrigSetter(t,"body");c&&l&&this.defProp(t,"body",(function(t){return t&&(t instanceof HTMLBodyElement||t instanceof HTMLFrameSetElement)&&r.rewriteElemComplete(t),l.call(r.proxyToObj(this),t)}),c)}function u(){return r.wb_info.isSW&&r.$wbwindow.frameElement}function _(t){return 0===t.length?"":1===t.length?t[0]:Array.prototype.join.call(t,"")}function d(t,e,i){r.$wbwindow;var o=r.proxyToObj(t);if("loading"===t.readyState&&i&&-1!==i.startsWith("\x3c!--")&&-1===i.indexOf("--\x3e"))return e.call(o,i);if(!(u()||"loading"===t.readyState&&r.wb_info.injectDocClose)){i=r.rewriteHtml(i,!0);o=r.proxyToObj(t);var n=e.call(o,i);return r.initNewWindowWombat(o.defaultView),n}r._writeBuff+=i}},f.prototype.initIframeWombat=function(t){var e;e=t._get_contentWindow?t._get_contentWindow.call(t):t.contentWindow;try{if(!e||e===this.$wbwindow||e._skip_wombat||e._wb_wombat)return}catch(t){return}var r=t.src;this.initNewWindowWombat(e,r)},f.prototype.initNewWindowWombat=function(t,e){var r=!1;if(t&&!t._wb_wombat){if(e&&""!==e&&!this.startsWithOneOf(e,["about:blank","javascript:"])||(r=!0),!r&&this.wb_info.isSW){var i=this.extractOriginalURL(e);("about:blank"===i||i.startsWith("srcdoc:")||i.startsWith("blob:"))&&(r=!0)}if(r){var o={};Object.assign(o,this.wb_info);var n=new f(t,o);t._wb_wombat=n.wombatInit()}else this.initProtoPmOrigin(t),this.initPostMessageOverride(t),this.initMessageEventOverride(t),this.initCheckThisFunc(t),this.initImportWrapperFunc(t)}},f.prototype.initTimeoutIntervalOverrides=function(){var t=this.rewriteSetTimeoutInterval;if(this.$wbwindow.setTimeout&&!this.$wbwindow.setTimeout.__$wbpatched$__){var e=this.$wbwindow.setTimeout;this.$wbwindow.setTimeout=function(){return t(this,e,arguments)},this.$wbwindow.setTimeout.__$wbpatched$__=!0}if(this.$wbwindow.setInterval&&!this.$wbwindow.setInterval.__$wbpatched$__){var r=this.$wbwindow.setInterval;this.$wbwindow.setInterval=function(){return t(this,r,arguments)},this.$wbwindow.setInterval.__$wbpatched$__=!0}},f.prototype.initWorkerOverrides=function(){var t,e,r=this;if(this.$wbwindow.Worker&&!this.$wbwindow.Worker._wb_worker_overridden){var i=this.$wbwindow.Worker;this.$wbwindow.Worker=(t=i,function(e,i){return r.domConstructorErrorChecker(this,"Worker",arguments),new t(r.rewriteWorker(e),i)}),this.$wbwindow.Worker.prototype=i.prototype,Object.defineProperty(this.$wbwindow.Worker.prototype,"constructor",{value:this.$wbwindow.Worker}),this.$wbwindow.Worker._wb_worker_overridden=!0}if(this.$wbwindow.SharedWorker&&!this.$wbwindow.SharedWorker.__wb_sharedWorker_overridden){var o=this.$wbwindow.SharedWorker;this.$wbwindow.SharedWorker=(e=o,function(t,i){return r.domConstructorErrorChecker(this,"SharedWorker",arguments),new e(r.rewriteWorker(t),i)}),this.$wbwindow.SharedWorker.prototype=o.prototype,Object.defineProperty(this.$wbwindow.SharedWorker.prototype,"constructor",{value:this.$wbwindow.SharedWorker}),this.$wbwindow.SharedWorker.__wb_sharedWorker_overridden=!0}if(this.$wbwindow.ServiceWorkerContainer&&this.$wbwindow.ServiceWorkerContainer.prototype&&this.$wbwindow.ServiceWorkerContainer.prototype.register){var n=this.$wbwindow.ServiceWorkerContainer.prototype.register;this.$wbwindow.ServiceWorkerContainer.prototype.register=function(t,e){var i=new r.URL(t,r.$wbwindow.document.baseURI).href,o=r.getPageUnderModifier();return e&&e.scope?e.scope=r.rewriteUrl(e.scope,!1,o):e={scope:r.rewriteUrl("/",!1,o)},n.call(this,r.rewriteUrl(i,!1,"sw_"),e)}}if(this.$wbwindow.Worklet&&this.$wbwindow.Worklet.prototype&&this.$wbwindow.Worklet.prototype.addModule&&!this.$wbwindow.Worklet.__wb_workerlet_overridden){var s=this.$wbwindow.Worklet.prototype.addModule;this.$wbwindow.Worklet.prototype.addModule=function(t,e){var i=r.rewriteUrl(t,!1,"js_");return s.call(this,i,e)},this.$wbwindow.Worklet.__wb_workerlet_overridden=!0}},f.prototype.initLocOverride=function(t,e,r){if(Object.defineProperty)for(var i=0;i<this.URL_PROPS.length;i++){var o=this.URL_PROPS[i];this.defProp(t,o,this.makeSetLocProp(o,e,r),this.makeGetLocProp(o,r),!0)}},f.prototype.initWombatLoc=function(t){if(!(!t||t.WB_wombat_location&&t.document.WB_wombat_location)){var e=new w(t.location,this),r=this;if(Object.defineProperty){this.defProp(t.Object.prototype,"WB_wombat_location",(function(e){var i=this._WB_wombat_location||this.defaultView&&this.defaultView._WB_wombat_location;i&&(i.href=e),t.location=r.rewriteUrl(e)}),(function(){return this._WB_wombat_location||this.defaultView&&this.defaultView._WB_wombat_location||this.location})),this.initProtoPmOrigin(t),t._WB_wombat_location=e}else t.WB_wombat_location=e,setTimeout(this.checkAllLocations,500),setInterval(this.checkAllLocations,500)}},f.prototype.initProtoPmOrigin=function(t){if(!t.Object.prototype.__WB_pmw){var e=function(t){return this.__WB_source=t,this};try{t.Object.defineProperty(t.Object.prototype,"__WB_pmw",{get:function(){return e},set:function(){},configurable:!0,enumerable:!1})}catch(t){}t.__WB_check_loc=function(t,e){if(t instanceof Location||t instanceof w){if(e)for(var r=0;r<e.length;r++)if(t===e[r])return{};return this.WB_wombat_location}return{}}}},f.prototype.initCheckThisFunc=function(t){try{t.Object.prototype[this.WB_CHECK_THIS_FUNC]||t.Object.defineProperty(t.Object.prototype,this.WB_CHECK_THIS_FUNC,{configutable:!1,enumerable:!1,value:function(t){try{return t&&t._WB_wombat_obj_proxy?t._WB_wombat_obj_proxy:t}catch(e){return t}}})}catch(t){}},f.prototype.initImportWrapperFunc=function(t){var e=this;t.____wb_rewrite_import__=function(t,r){return t&&(r=new e.URL(r,t).href),import(e.rewriteUrl(r,!1,"esm_"))}},f.prototype.overrideGetOwnPropertyNames=function(t){var e=t.Object.getOwnPropertyNames,r=[this.WB_CHECK_THIS_FUNC,"WB_wombat_location","__WB_pmw","WB_wombat_top","WB_wombat_eval","WB_wombat_runEval"];try{t.Object.defineProperty(t.Object,"getOwnPropertyNames",{value:function(t){for(var i=e(t),o=0;o<r.length;o++){var n=i.indexOf(r[o]);n>=0&&i.splice(n,1)}return i}})}catch(t){console.log(t)}},f.prototype.initHashChange=function(){if(this.$wbwindow.__WB_top_frame){var t=this;this.$wbwindow.addEventListener("message",(function(e){if(e.data&&e.data.from_top){var r=e.data.message;r.wb_type&&"outer_hashchange"===r.wb_type&&t.$wbwindow.location.hash!=r.hash&&(t.$wbwindow.location.hash=r.hash)}})),this.$wbwindow.addEventListener("hashchange",(function(){var e={wb_type:"hashchange",hash:t.$wbwindow.location.hash};t.sendTopMessage(e)}))}},f.prototype.initPostMessageOverride=function(t){if(t.postMessage&&!t.__orig_postMessage){var e=t.postMessage,r=this;t.__orig_postMessage=e;var i=function(i,o,n,s){var a,w,h,p=r.proxyToObj(this);if(p||((p=t).__WB_source=t),p.__WB_source&&p.__WB_source.WB_wombat_location){var c=p.__WB_source;if(a=c.WB_wombat_location.origin,p.__WB_win_id||(p.__WB_win_id={},p.__WB_counter=0),!c.__WB_id){var l=p.__WB_counter;c.__WB_id=l+c.WB_wombat_location.href,p.__WB_counter+=1}p.__WB_win_id[c.__WB_id]=c,w=c.__WB_id,p.__WB_source=void 0}else a=window.WB_wombat_location.origin;"object"==typeof o?(h=o.targetOrigin,n=o.transfer):h=o;var u=h;u===p.location.origin&&(u=a);var _={from:a,to_origin:u,src_id:w,message:i,from_top:s};if("*"!==h){if("null"===p.location.origin||""===p.location.origin)return;h=p.location.origin}return e.call(p,_,h,n)};t.postMessage=i,t.Window.prototype.postMessage=i;var o=null,n=(o=t.EventTarget&&t.EventTarget.prototype?t.EventTarget.prototype:t).addEventListener;o.addEventListener=function(t,e,i){var o,s=r.proxyToObj(this);if("message"===t?o=r.message_listeners.add_or_get(e,(function(){return c(e,s,r)})):"storage"===t?r.storage_listeners.add_or_get(e,(function(){return p(e,s)})):"online"===t||"offline"===t||(o=e),o)return n.call(s,t,o,i)};var s=o.removeEventListener;o.removeEventListener=function(t,e,i){var o,n=r.proxyToObj(this);if("message"===t?o=r.message_listeners.remove(e):"storage"===t?r.storage_listeners.remove(e):o=e,o)return s.call(n,t,o,i)};var a=function(e,i){var o=r.getOrigSetter(t,e);r.defProp(t,e,(function(t){this["__orig_"+e]=t;var n=r.proxyToObj(this),s=t?i(t,n,r):t;return o.call(n,s)}),(function(){return this["__orig_"+e]}))};a("onmessage",c),a("onstorage",p)}},f.prototype.initMessageEventOverride=function(t){t.MessageEvent&&!t.MessageEvent.prototype.__extended&&(this.addEventOverride("target"),this.addEventOverride("srcElement"),this.addEventOverride("currentTarget"),this.addEventOverride("eventPhase"),this.addEventOverride("path"),this.overridePropToProxy(t.MessageEvent.prototype,"source"),t.MessageEvent.prototype.__extended=!0)},f.prototype.initUIEventsOverrides=function(){this.overrideAnUIEvent("UIEvent"),this.overrideAnUIEvent("MouseEvent"),this.overrideAnUIEvent("TouchEvent"),this.overrideAnUIEvent("FocusEvent"),this.overrideAnUIEvent("KeyboardEvent"),this.overrideAnUIEvent("WheelEvent"),this.overrideAnUIEvent("InputEvent"),this.overrideAnUIEvent("CompositionEvent")},f.prototype.initOpenOverride=function(){var t=this.$wbwindow.open;this.$wbwindow.Window.prototype.open&&(t=this.$wbwindow.Window.prototype.open);var e=this,r=function(r,i,o){i&&(i=e.rewriteAttrTarget(i));var n=e.rewriteUrl(r,!1),s=t.call(e.proxyToObj(this),n,i,o);return e.initNewWindowWombat(s,r),s};this.$wbwindow.open=r,this.$wbwindow.Window.prototype.open&&(this.$wbwindow.Window.prototype.open=r);for(var i=0;i<this.$wbwindow.frames.length;i++)try{this.$wbwindow.frames[i].open=r}catch(t){console.log(t)}},f.prototype.rewriteAttrTarget=function(t){return this.wb_info.target_frame&&("_blank"===t||"_parent"===t||"_top"===t||t&&this.$wbwindow===this.$wbwindow.__WB_replay_top)?this.wb_info.target_frame:t},f.prototype.initCookiesOverride=function(){var t=this.getOrigGetter(this.$wbwindow.document,"cookie"),e=this.getOrigSetter(this.$wbwindow.document,"cookie");t||(t=this.getOrigGetter(this.$wbwindow.Document.prototype,"cookie")),e||(e=this.getOrigSetter(this.$wbwindow.Document.prototype,"cookie"));var r=function(t,e){var r=new Date(e);return isNaN(r.getTime())?"Expires=Thu,| 01 Jan 1970 00:00:00 GMT":"Expires="+new Date(r.getTime()+Date.__WB_timediff).toUTCString().replace(",",",|")},i=this;this.defProp(this.$wbwindow.document,"cookie",(function(t){if(t){for(var o=t.replace(i.cookie_expires_regex,r).split(i.SetCookieRe),n=0;n<o.length;n++)o[n]=i.rewriteCookie(o[n]);return e.call(i.proxyToObj(this),o.join(","))}}),(function(){return t.call(i.proxyToObj(this))}))},f.prototype.initRegisterUnRegPHOverride=function(){var t=this,e=this.$wbwindow.navigator;if(e.registerProtocolHandler){var r=e.registerProtocolHandler;e.registerProtocolHandler=function(e,i,o){return r.call(this,e,t.rewriteUrl(i),o)}}if(e.unregisterProtocolHandler){var i=e.unregisterProtocolHandler;e.unregisterProtocolHandler=function(e,r){return i.call(this,e,t.rewriteUrl(r))}}},f.prototype.initMiscNavigatorOverrides=function(){this.$wbwindow.navigator.sendBeacon&&(this.$wbwindow.navigator.sendBeacon=function(){return!0}),Object.defineProperty(navigator,"onLine",{value:!0}),this.$wbwindow.navigator.mediaDevices&&(this.$wbwindow.navigator.mediaDevices.setCaptureHandleConfig=function(){}),this.$wbwindow.navigator.getInstalledRelatedApps&&(this.$wbwindow.navigator.getInstalledRelatedApps=function(){return Promise.resolve([])})},f.prototype.initPresentationRequestOverride=function(){if(this.$wbwindow.PresentationRequest&&this.$wbwindow.PresentationRequest.prototype){var t=this,e=this.$wbwindow.PresentationRequest;this.$wbwindow.PresentationRequest=(r=this.$wbwindow.PresentationRequest,function(e){t.domConstructorErrorChecker(this,"PresentationRequest",arguments);var i=e;if(null!=e)if(Array.isArray(i))for(var o=0;o<i.length;o++)i[o]=t.rewriteUrl(i[o],!0,"mp_");else i=t.rewriteUrl(e,!0,"mp_");return new r(i)}),this.$wbwindow.PresentationRequest.prototype=e.prototype,Object.defineProperty(this.$wbwindow.PresentationRequest.prototype,"constructor",{value:this.$wbwindow.PresentationRequest})}var r},f.prototype.initDisableNotificationsGeoLocation=function(){window.Notification&&(window.Notification.requestPermission=function(t){return t&&t("denied"),Promise.resolve("denied")});var t=function(t){t&&(t.getCurrentPosition&&(t.getCurrentPosition=function(t,e,r){e&&e({code:2,message:"not available"})}),t.watchPosition&&(t.watchPosition=function(t,e,r){e&&e({code:2,message:"not available"})}))};window.geolocation&&t(window.geolocation),window.navigator.geolocation&&t(window.navigator.geolocation)},f.prototype.initStorageOverride=function(){this.addEventOverride("storageArea",this.$wbwindow.StorageEvent.prototype),i.yes=!1;var t={};if(this.wb_info.storage)try{t=JSON.parse(this.wb_info.storage)}catch(t){console.warn("Error parsing storage, storages not loaded")}a(this,"localStorage",t.local),a(this,"sessionStorage",t.session),this.$wbwindow.Storage=s,i.yes=!0},f.prototype.initIndexedDBOverride=function(){if(this.$wbwindow.IDBFactory){var t=this.$wbwindow.IDBFactory.prototype,e="wb-"+this.wb_orig_origin+"-",r=t.open;t.open=function(t,i){return r.call(this,e+t,i)};var i=t.deleteDatabase;t.delete=function(t){return i.call(this,e+t,options)};var o=t.databases;t.databases=function(){var t=this;return new Promise((function(r,i){o.call(t).then((function(t){for(var i=[],o=0;o<t.length;o++)0===t[o].name.indexOf(e)&&i.push({name:t[o].name.substring(e.length),version:t[o].version});r(i)})).catch((function(t){i(t)}))}))}}},f.prototype.initCachesOverride=function(){if(this.$wbwindow.Cache){var t=this.$wbwindow.Cache.prototype;t.match=function(){return Promise.resolve(void 0)},t.matchAll=function(){return Promise.resolve([])},t.add=function(){return Promise.resolve(void 0)},t.put=function(){return Promise.resolve(void 0)},t.delete=function(){return Promise.resolve(!1)},t.keys=function(){return Promise.resolve([])}}},f.prototype.initCacheStorageOverride=function(){if(this.$wbwindow.CacheStorage){this.$wbwindow.chrome&&(this.$wbwindow.chrome={});var t=this.$wbwindow.CacheStorage.prototype,e="wb-"+this.wb_orig_origin+"-",r=t.open;t.open=function(t){return r.call(this,e+t)};var i=t.has;t.has=function(t){return i.call(this,e+t)};var o=t.delete;t.delete=function(t){return o.call(this,e+t)};var n=t.keys;t.keys=function(){var t=this;return new Promise((function(r,i){n.call(t).then((function(t){for(var i=[],o=0;o<t.length;o++)0===t[o].indexOf(e)&&i.push(t[o].substring(e.length));r(i)})).catch((function(t){i(t)}))}))},t.match,t.match=function(t,e){var r=this;return this.keys().then((function(i){var o;return i.reduce((function(i,n){return i.then((function(){return o||r.open(n).then((function(r){return r.match(t,e)})).then((function(t){return o=t}))}))}),Promise.resolve())}))}}},f.prototype.initWindowObjProxy=function(t){if(t.Proxy){var e=this.getAllOwnProps(t),r={},i=this,o=new t.Proxy({},{get:function(o,n){switch(n){case"top":return i.$wbwindow.WB_wombat_top._WB_wombat_obj_proxy;case"parent":if(i.$wbwindow===i.$wbwindow.WB_wombat_top)return i.$wbwindow.WB_wombat_top._WB_wombat_obj_proxy;try{var s=i.$wbwindow.parent._WB_wombat_obj_proxy;if(s)return s}catch(t){}return i.$wbwindow.WB_wombat_top._WB_wombat_obj_proxy}return i.defaultProxyGet(t,n,e,r)},set:function(e,r,i){switch(r){case"location":return t.WB_wombat_location=i,!0;case"postMessage":case"document":return!0}try{if(!Reflect.set(e,r,i))return!1}catch(t){}return Reflect.set(t,r,i)},has:function(e,r){return r in t},ownKeys:function(e){return Object.getOwnPropertyNames(t).concat(Object.getOwnPropertySymbols(t))},getOwnPropertyDescriptor:function(e,r){var i=Object.getOwnPropertyDescriptor(e,r);return i||(i=Object.getOwnPropertyDescriptor(t,r))&&(i.configurable=!0),i},getPrototypeOf:function(e){return Object.getPrototypeOf(t)},setPrototypeOf:function(t,e){return!1},isExtensible:function(e){return Object.isExtensible(t)},preventExtensions:function(e){return Object.preventExtensions(t),!0},deleteProperty:function(e,r){var i=Object.getOwnPropertyDescriptor(t,r);return void 0===i||!1!==i.configurable&&(delete e[r],delete t[r],!0)},defineProperty:function(e,r,i){var o=i||{};return o.hasOwnProperty("value")||o.hasOwnProperty("get")||o.hasOwnProperty("set")||(o.value=t[r]),Reflect.defineProperty(t,r,o),Reflect.defineProperty(e,r,o)}});return t._WB_wombat_obj_proxy=o,o}},f.prototype.initDocumentObjProxy=function(t){if(this.initDocOverrides(t),this.$wbwindow.Proxy){var e={},r=this.getAllOwnProps(t),i=this,o=new this.$wbwindow.Proxy(t,{get:function(o,n){return i.defaultProxyGet(t,n,r,e)},set:function(e,r,i){return"location"===r?(t.WB_wombat_location=i,!0):Reflect.set(e,r,i)}});return t._WB_wombat_obj_proxy=o,o}},f.prototype.initAutoFetchWorker=function(){if(this.wbUseAFWorker){var t=new h(this,{isTop:this.$wbwindow===this.$wbwindow.__WB_replay_top,workerURL:(this.wb_info.auto_fetch_worker_prefix||this.wb_info.static_prefix)+"autoFetchWorker.js?init="+encodeURIComponent(JSON.stringify({mod:this.wb_info.mod,prefix:this.wb_abs_prefix,rwRe:this.wb_unrewrite_rx.source}))});this.WBAutoFetchWorker=t,this.$wbwindow.$WBAutoFetchWorker$=t;var e=this;this.utilFns.wbSheetMediaQChecker=function(){e._removeEventListener(this,"load",e.utilFns.wbSheetMediaQChecker),null!=this.sheet&&e.WBAutoFetchWorker&&e.WBAutoFetchWorker.deferredSheetExtraction(this.sheet)}}},f.prototype.initTopFrameNotify=function(t){var e=this,r=function(r){if(e.$wbwindow.__WB_top_frame){if(e.$wbwindow.WB_wombat_location){var i=e.$wbwindow.WB_wombat_location.href;if("string"==typeof i&&"about:blank"!==i&&0!==i.indexOf("javascript:")&&("complete"===e.$wbwindow.document.readyState&&e.wbUseAFWorker&&e.WBAutoFetchWorker&&e.WBAutoFetchWorker.extractFromLocalDoc(),e.$wbwindow===e.$wbwindow.__WB_replay_top)){for(var o=[],n=e.$wbwindow.document.querySelectorAll("link[rel*='icon']"),s=0;s<n.length;s++){var a=n[s];o.push({rel:a.rel,href:e.wb_getAttribute.call(a,"href")})}o.push({rel:"icon",href:e.rewriteUrl("/favicon.ico")});var w={icons:o,url:e.$wbwindow.WB_wombat_location.href,ts:e.wb_info.timestamp,request_ts:e.wb_info.request_ts,is_live:e.wb_info.is_live,title:e.$wbwindow.document?e.$wbwindow.document.title:"",readyState:e.$wbwindow.document.readyState,wb_type:"load"};e.sendTopMessage(w)}}}else{var h=e.$wbwindow.location.hash;e.$wbwindow.location.replace(t.top_url+h)}};"complete"===this.$wbwindow.document.readyState?r():this.$wbwindow.addEventListener?this.$wbwindow.document.addEventListener("readystatechange",r):this.$wbwindow.attachEvent&&this.$wbwindow.document.attachEvent("onreadystatechange",r)},f.prototype.initTopFrame=function(t){if(this.wb_is_proxy)return t.__WB_replay_top=t.top,t.__WB_top_frame=void 0,this.replayTopHost=r.location.host,void(this.replayTopProtocol=r.location.protocol);for(var e=function(t){try{return!!t&&(t.wbinfo?t.wbinfo.is_framed:null!=t._wb_wombat)}catch(t){return!1}},r=t;r.parent!=r&&e(r.parent);)r=r.parent;t.__WB_replay_top=r,this.replayTopHost=r.location.host,this.replayTopProtocol=r.location.protocol;var i=r.parent;if(i!=t&&this.wb_info.is_framed||(i=void 0),i?(t.__WB_top_frame=i,this.initFrameElementOverride(t)):t.__WB_top_frame=void 0,!this.wb_opts.embedded&&r==t&&this.wbUseAFWorker){var o=this;this.$wbwindow.addEventListener("message",(function(t){t.data&&"aaworker"===t.data.wb_type&&o.WBAutoFetchWorker&&o.WBAutoFetchWorker.postMessage(t.data.msg)}),!1)}},f.prototype.initFrameElementOverride=function(t){if(Object.defineProperty&&this.proxyToObj(t.__WB_replay_top)==this.proxyToObj(t))try{Object.defineProperty(t,"frameElement",{value:null,configurable:!1})}catch(t){}},f.prototype.initWombatTop=function(t){if(Object.defineProperty){this.defProp(t.Object.prototype,"WB_wombat_top",(function(t){this.top=t}),(function(){return this.__WB_replay_top?this.__WB_replay_top:(t=this,(void 0===window.constructor?t instanceof window.constructor:t.window==t)?this:this.top);var t}))}},f.prototype.initEvalOverride=function(){var t=this.rewriteEvalArg,e=function(){};this.wrappedEval=function(e){return function(r){return t(e,r)}};var r=this,i=function(e){var r=this;return r&&r.eval&&r.eval!==eval?{eval:function(){return r.eval.__WB_orig_apply(r,arguments)}}:{eval:function(r){return t(e,r)}}},o=function(e){var i=this;return i&&i.eval&&i.eval!==eval?{eval:function(){return i.eval.__WB_orig_apply(i,[].slice.call(arguments,2))}}:{eval:function(i,o,n){var s=i===r.proxyToObj(r.$wbwindow);try{s=s&&!o.callee.caller}catch(t){s=!1}return t(e,n,s)}}};this.defProp(this.$wbwindow.Object.prototype,"WB_wombat_runEval",e,(function(){return i})),this.defProp(this.$wbwindow.Object.prototype,"WB_wombat_runEval2",e,(function(){return o}))},f.prototype.wombatInit=function(){this._internalInit(),this.initCookiePreset(),this.initHistoryOverrides(),this.overrideFunctionApply(this.$wbwindow),this.overrideFunctionCall(this.$wbwindow),this.overrideFunctionBind(this.$wbwindow),this.initDocTitleOverride(),this.initHashChange(),this.wb_opts.skip_postmessage||(this.initPostMessageOverride(this.$wbwindow),this.initMessageEventOverride(this.$wbwindow)),this.initCheckThisFunc(this.$wbwindow),this.initImportWrapperFunc(this.$wbwindow),this.overrideGetOwnPropertyNames(this.$wbwindow),this.initUIEventsOverrides(),this.initDocWriteOpenCloseOverride(),this.initEvalOverride(),this.initHTTPOverrides(),this.initAudioOverride(),this.initFontFaceOverride(this.$wbwindow),this.initWorkerOverrides(),this.initTextNodeOverrides(),this.initCSSOMOverrides(),this.overrideHtmlAssign(this.$wbwindow.Element,"innerHTML",!0),this.overrideHtmlAssign(this.$wbwindow.Element,"outerHTML",!0),this.overrideHtmlAssignSrcDoc(this.$wbwindow.HTMLIFrameElement,"srcdoc",!0),this.overrideHtmlAssign(this.$wbwindow.HTMLStyleElement,"textContent"),this.overrideShadowDom(),this.overridePropExtract(this.$wbwindow.Document.prototype,"URL"),this.overridePropExtract(this.$wbwindow.Document.prototype,"documentURI"),this.overridePropExtract(this.$wbwindow.Node.prototype,"baseURI"),this.overrideAttrProps(),this.overrideDataSet(),this.initInsertAdjacentElementHTMLOverrides(),this.overrideIframeContentAccess("contentWindow"),this.overrideIframeContentAccess("contentDocument"),this.initIntersectionObsOverride(),this.overrideFuncArgProxyToObj(this.$wbwindow.MutationObserver,"observe"),this.overrideFuncArgProxyToObj(this.$wbwindow.Node,"compareDocumentPosition"),this.overrideFuncArgProxyToObj(this.$wbwindow.Node,"contains"),this.overrideFuncArgProxyToObj(this.$wbwindow.Document,"createTreeWalker"),this.overrideFuncArgProxyToObj(this.$wbwindow.Document,"evaluate",1),this.overrideFuncArgProxyToObj(this.$wbwindow.XSLTProcessor,"transformToFragment",1),this.overrideFuncThisProxyToObj(this.$wbwindow,"getComputedStyle",this.$wbwindow),this.overrideFuncThisProxyToObj(this.$wbwindow,"clearTimeout"),this.overrideFuncThisProxyToObj(this.$wbwindow,"clearInterval"),this.overrideFuncThisProxyToObj(this.$wbwindow.EventTarget.prototype,"dispatchEvent"),this.overrideDeProxyPropAssign(this.$wbwindow.TreeWalker.prototype,"currentNode"),this.initTimeoutIntervalOverrides(),this.initQuerySelectorOverride(),this.overrideSWAccess(this.$wbwindow),this.initElementGetSetAttributeOverride(),this.initSvgImageOverrides(),this.initAttrOverrides(),this.initCookiesOverride(),this.initCreateElementNSFix(),this.wb_opts.skip_dom||this.initDomOverride(),this.initRegisterUnRegPHOverride(),this.initPresentationRequestOverride(),this.initMiscNavigatorOverrides(),this.initSeededRandom(this.wb_info.wombat_sec),this.initCryptoRandom(),this.initFixedRatio(this.wb_info.pixel_ratio||1),this.initDateOverride(this.wb_info.wombat_sec),this.initBlobOverride(),this.initWSOverride(),this.initOpenOverride(),this.initDisableNotificationsGeoLocation(),this.initStorageOverride(),this.initCacheStorageOverride(),this.initCachesOverride(),this.initIndexedDBOverride(),this.initWindowObjProxy(this.$wbwindow),this.initDocumentObjProxy(this.$wbwindow.document);var t=this;return{extract_orig:this.extractOriginalURL,rewrite_url:this.rewriteUrl,watch_elem:this.watchElem,init_new_window_wombat:this.initNewWindowWombat,init_paths:this.initPaths,local_init:function(e){var r=t.$wbwindow._WB_wombat_obj_proxy[e];return"document"===e&&r&&!r._WB_wombat_obj_proxy&&t.initDocumentObjProxy(r)||r},showCSPViolations:function(e){t._addRemoveCSPViolationListener(e)}}},window._WBWombat=f,window._WBWombatInit=function(t){if(this._wb_wombat)this._wb_wombat.init_paths(t);else{var e=new f(this,t);this._wb_wombat=e.wombatInit()}}}();
