# EMS manuscript build notes

This directory contains the LaTeX source and generated outputs for the EMS manuscript.

## Prerequisites (Debian/Ubuntu)

On Debian/Ubuntu TeX Live installations, tlmgr is disabled by design. Install LaTeX packages via apt:

```bash
sudo apt-get update
sudo apt-get install -y \
  latexmk \
  texlive-latex-base \
  texlive-latex-recommended \
  texlive-latex-extra \
  texlive-fonts-recommended \
  texlive-fonts-extra \
  texlive-bibtex-extra \
  texlive-science \
  texlive-publishers
```

Notes:
- siunitx is provided by texlive-latex-extra
- elsarticle is provided by texlive-publishers

If you are on macOS with MacTeX (not Debian/Ubuntu), you can use tlmgr:
```bash
sudo tlmgr update --self
sudo tlmgr install siunitx elsarticle
```

## Build

A Makefile is provided to avoid stale-state issues with latexmk.

Common targets:
- make        # clean intermediates, then build PDF
- make pdf    # build PDF without cleaning
- make clean  # remove intermediates, keep paper.pdf
- make distclean  # remove everything including paper.pdf

The build uses:
```bash
latexmk -pdf -interaction=nonstopmode -f paper.tex
```

## Outputs

- paper.pdf: compiled manuscript
- figs/: figures generated by the repro workflow and/or by the LaTeX source
- tables/: CSV or other tabular outputs generated by the repro workflow

## Repro case study

See papers/ems/repro for a deterministic reproduction of the libCBM case study (derived from examples/031_ws3_libcbm_sequential-builtin.ipynb). The repro script exports figures and tables to papers/ems/figs and papers/ems/tables respectively.

Run from repo root:
```bash
bash papers/ems/repro/make_repro.sh
```

## Troubleshooting

- If latexmk reports “Nothing to do” after an earlier failure, run:
  - make (performs a clean + rebuild), or
  - make distclean (full reset) followed by make

- If LaTeX packages are missing, re-run the apt commands above and rebuild.