from django.test import TestCase, RequestFactory
from django.http import HttpRequest
from django.contrib.auth.models import User as UserModel
from django.contrib.auth.models import AnonymousUser

from src.newsflash.base import get_user_from_request, User, Widget


class TestGetUserFromRequest(TestCase):

    def setUp(self) -> None:
        user = UserModel.objects.create_user(
            username="testuser",
            first_name="Test",
            last_name="User",
            password="password123"
        )
        self.user = user

    def test_get_user_from_authenticated_request(self) -> None:
        factory = RequestFactory()
        request: HttpRequest = factory.get("/some-path/")
        request.user = self.user

        result = get_user_from_request(request)

        expected = User(
            username="testuser",
            first_name="Test",
            last_name="User"
        )

        self.assertEqual(result, expected)

    def test_get_user_from_unauthenticated_request(self) -> None:
        factory = RequestFactory()
        request: HttpRequest = factory.get("/some-path/")
        request.user = AnonymousUser()

        result = get_user_from_request(request)

        self.assertIsNone(result)

    def test_set_widget_height_and_width(self) -> None:
        widget = Widget()
        widget.update_dimensions(100.0, 200.0)
        self.assertEqual(widget.width_in_px, 100.0)
        self.assertEqual(widget.height_in_px, 200.0)
