import unittest
from pathlib import Path

from fontTools.ttLib import TTFont
from newsflash.fonts import get_text_height, get_text_width


class TestFonts(unittest.TestCase):
    def setUp(self) -> None:
        path_to_font = Path(__file__).parent.parent.parent / "src" / "newsflash" / "fonts" / "noto-serif" / "NotoSerif.ttf"
        self.font = TTFont(path_to_font)

    def test_get_text_width(self):
        text = "Hello, World!"
        font_size = 12

        width = get_text_width(self.font, text, font_size)
        self.assertIsInstance(width, float)
        self.assertGreater(width, 0)

    def test_get_text_height(self):
        text = "Hello, World!"
        font_size = 12

        y_min, y_max = get_text_height(self.font, text, font_size)
        self.assertIsInstance(y_min, float)
        self.assertIsInstance(y_max, float)
        self.assertLess(y_min, y_max)
