from django.test import TestCase, Client
from django.contrib.auth.models import User


class TestAccountEndpoints(TestCase):

    def setUp(self) -> None:
        user = User.objects.create_user(
            username="testuser",
            first_name="Test",
            last_name="User",
            password="password123"
        )
        self.user = user
    
    def test_login_page_get(self):
        c = Client()
        response = c.get("/accounts/login")
        self.assertEqual(response.status_code, 200)
        self.assertTemplateUsed(response, "accounts/login.html")

    def test_auth_request_post_success(self):
        c = Client()
        response = c.post("/accounts/auth", {
            "username": "testuser",
            "password": "password123"
        })
        
        self.assertEqual(response.wsgi_request.user.is_authenticated, True)
        self.assertEqual(response.wsgi_request.user, self.user)

    def test_auth_request_post_failure(self):
        c = Client()
        response = c.post("/accounts/auth", {
            "username": "testuser",
            "password": "wrongpassword"
        })

        self.assertEqual(response.wsgi_request.user.is_authenticated, False)
        self.assertEqual(response.status_code, 302)  # Redirect on failure

    def test_logout_view(self):
        c = Client()
        # First, log in the user
        c.login(username="testuser", password="password123")
        response = c.get("/accounts/logout")

        self.assertEqual(response.wsgi_request.user.is_authenticated, False)
        self.assertEqual(response.status_code, 302)  # Redirect after logout
