'''
# Terraform CDK datadog Provider ~> 3.0

This repo builds and publishes the Terraform datadog Provider bindings for [cdktf](https://cdk.tf).

## Available Packages

### NPM

The npm package is available at [https://www.npmjs.com/package/@cdktf/provider-datadog](https://www.npmjs.com/package/@cdktf/provider-datadog).

`npm install @cdktf/provider-datadog`

### PyPI

The PyPI package is available at [https://pypi.org/project/cdktf-cdktf-provider-datadog](https://pypi.org/project/cdktf-cdktf-provider-datadog).

`pipenv install cdktf-cdktf-provider-datadog`

### Nuget

The Nuget package is available at [https://www.nuget.org/packages/HashiCorp.Cdktf.Providers.Datadog](https://www.nuget.org/packages/HashiCorp.Cdktf.Providers.Datadog).

`dotnet add package HashiCorp.Cdktf.Providers.Datadog`

### Maven

The Maven package is available at [https://mvnrepository.com/artifact/com.hashicorp/cdktf-provider-datadog](https://mvnrepository.com/artifact/com.hashicorp/cdktf-provider-datadog).

```
<dependency>
    <groupId>com.hashicorp</groupId>
    <artifactId>cdktf-provider-datadog</artifactId>
    <version>[REPLACE WITH DESIRED VERSION]</version>
</dependency>
```

## Docs

Find auto-generated docs for this provider here: [./API.md](./API.md)

## Versioning

This project is explicitly not tracking the Terraform datadog Provider version 1:1. In fact, it always tracks `latest` of `~> 3.0` with every release. If there are scenarios where you explicitly have to pin your provider version, you can do so by generating the [provider constructs manually](https://cdk.tf/imports).

These are the upstream dependencies:

* [Terraform CDK](https://cdk.tf)
* [Terraform datadog Provider](https://github.com/terraform-providers/terraform-provider-datadog)
* [Terraform Engine](https://terraform.io)

If there are breaking changes (backward incompatible) in any of the above, the major version of this project will be bumped. While the Terraform Engine and the Terraform datadog Provider are relatively stable, the Terraform CDK is in an early stage. Therefore, it's likely that there will be breaking changes.

## Features / Issues / Bugs

Please report bugs and issues to the [terraform cdk](https://cdk.tf) project:

* [Create bug report](https://cdk.tf/bug)
* [Create feature request](https://cdk.tf/feature)

## Contributing

### projen

This is mostly based on [projen](https://github.com/eladb/projen), which takes care of generating the entire repository.

### cdktf-provider-project based on projen

There's a custom [project builder](https://github.com/hashicorp/cdktf-provider-project) which encapsulate the common settings for all `cdktf` providers.

### Provider Version

The provider version can be adjusted in [./.projenrc.js](./.projenrc.js).

### Repository Management

The repository is managed by [Repository Manager](https://github.com/hashicorp/cdktf-repository-manager/)
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from ._jsii import *

import cdktf
import constructs


class ApiKey(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ApiKey",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/datadog/r/api_key datadog_api_key}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        name: builtins.str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/datadog/r/api_key datadog_api_key} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: Name for API Key. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/api_key#name ApiKey#name}
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ApiKeyConfig(
            name=name,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.ApiKeyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
    },
)
class ApiKeyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: builtins.str,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: Name for API Key. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/api_key#name ApiKey#name}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name for API Key.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/api_key#name ApiKey#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiKeyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApplicationKey(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ApplicationKey",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/datadog/r/application_key datadog_application_key}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        name: builtins.str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/datadog/r/application_key datadog_application_key} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: Name for Application Key. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/application_key#name ApplicationKey#name}
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ApplicationKeyConfig(
            name=name,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.ApplicationKeyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
    },
)
class ApplicationKeyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: builtins.str,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: Name for Application Key. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/application_key#name ApplicationKey#name}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name for Application Key.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/application_key#name ApplicationKey#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApplicationKeyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ChildOrganization(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganization",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/datadog/r/child_organization datadog_child_organization}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        name: builtins.str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/datadog/r/child_organization datadog_child_organization} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: Name for Child Organization after creation. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/child_organization#name ChildOrganization#name}
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ChildOrganizationConfig(
            name=name,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="apiKey")
    def api_key(self, index: builtins.str) -> "ChildOrganizationApiKey":
        '''
        :param index: -
        '''
        return typing.cast("ChildOrganizationApiKey", jsii.invoke(self, "apiKey", [index]))

    @jsii.member(jsii_name="applicationKey")
    def application_key(self, index: builtins.str) -> "ChildOrganizationApplicationKey":
        '''
        :param index: -
        '''
        return typing.cast("ChildOrganizationApplicationKey", jsii.invoke(self, "applicationKey", [index]))

    @jsii.member(jsii_name="settings")
    def settings(self, index: builtins.str) -> "ChildOrganizationSettings":
        '''
        :param index: -
        '''
        return typing.cast("ChildOrganizationSettings", jsii.invoke(self, "settings", [index]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="user")
    def user(self, index: builtins.str) -> "ChildOrganizationUser":
        '''
        :param index: -
        '''
        return typing.cast("ChildOrganizationUser", jsii.invoke(self, "user", [index]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "description"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="publicId")
    def public_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "publicId"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)


class ChildOrganizationApiKey(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganizationApiKey",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))


class ChildOrganizationApplicationKey(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganizationApplicationKey",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="hash")
    def hash(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "hash"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="owner")
    def owner(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "owner"))


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.ChildOrganizationConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
    },
)
class ChildOrganizationConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: builtins.str,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: Name for Child Organization after creation. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/child_organization#name ChildOrganization#name}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name for Child Organization after creation.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/child_organization#name ChildOrganization#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ChildOrganizationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ChildOrganizationSettings(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganizationSettings",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="privateWidgetShare")
    def private_widget_share(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "privateWidgetShare"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="saml")
    def saml(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "saml"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="samlAutocreateAccessRole")
    def saml_autocreate_access_role(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "samlAutocreateAccessRole"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="samlAutocreateUsersDomains")
    def saml_autocreate_users_domains(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "samlAutocreateUsersDomains"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="samlCanBeEnabled")
    def saml_can_be_enabled(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "samlCanBeEnabled"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="samlIdpEndpoint")
    def saml_idp_endpoint(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "samlIdpEndpoint"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="samlIdpInitiatedLogin")
    def saml_idp_initiated_login(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "samlIdpInitiatedLogin"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="samlIdpMetadataUploaded")
    def saml_idp_metadata_uploaded(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "samlIdpMetadataUploaded"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="samlLoginUrl")
    def saml_login_url(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "samlLoginUrl"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="samlStrictMode")
    def saml_strict_mode(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "samlStrictMode"))


class ChildOrganizationSettingsSaml(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganizationSettingsSaml",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "enabled"))


class ChildOrganizationSettingsSamlAutocreateUsersDomains(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganizationSettingsSamlAutocreateUsersDomains",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="domains")
    def domains(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "domains"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "enabled"))


class ChildOrganizationSettingsSamlIdpInitiatedLogin(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganizationSettingsSamlIdpInitiatedLogin",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "enabled"))


class ChildOrganizationSettingsSamlStrictMode(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganizationSettingsSamlStrictMode",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> cdktf.IResolvable:
        return typing.cast(cdktf.IResolvable, jsii.get(self, "enabled"))


class ChildOrganizationUser(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.ChildOrganizationUser",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="accessRole")
    def access_role(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "accessRole"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="email")
    def email(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "email"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))


class Dashboard(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.Dashboard",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        layout_type: builtins.str,
        title: builtins.str,
        dashboard_lists: typing.Optional[typing.Sequence[jsii.Number]] = None,
        description: typing.Optional[builtins.str] = None,
        is_read_only: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        notify_list: typing.Optional[typing.Sequence[builtins.str]] = None,
        reflow_type: typing.Optional[builtins.str] = None,
        restricted_roles: typing.Optional[typing.Sequence[builtins.str]] = None,
        template_variable: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardTemplateVariable"]]] = None,
        template_variable_preset: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardTemplateVariablePreset"]]] = None,
        url: typing.Optional[builtins.str] = None,
        widget: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidget"]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param layout_type: The layout type of the dashboard. Valid values are ``ordered``, ``free``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
        :param title: The title of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param dashboard_lists: A list of dashboard lists this dashboard belongs to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dashboard_lists Dashboard#dashboard_lists}
        :param description: The description of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#description Dashboard#description}
        :param is_read_only: Whether this dashboard is read-only. **Deprecated.** Prefer using ``restricted_roles`` to define which roles are required to edit the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_read_only Dashboard#is_read_only}
        :param notify_list: The list of handles for the users to notify when changes are made to this dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#notify_list Dashboard#notify_list}
        :param reflow_type: The reflow type of a new dashboard layout. Set this only when layout type is ``ordered``. If set to ``fixed``, the dashboard expects all widgets to have a layout, and if it's set to ``auto``, widgets should not have layouts. Valid values are ``auto``, ``fixed``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#reflow_type Dashboard#reflow_type}
        :param restricted_roles: UUIDs of roles whose associated users are authorized to edit the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#restricted_roles Dashboard#restricted_roles}
        :param template_variable: template_variable block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        :param template_variable_preset: template_variable_preset block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable_preset Dashboard#template_variable_preset}
        :param url: The URL of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
        :param widget: widget block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = DashboardConfig(
            layout_type=layout_type,
            title=title,
            dashboard_lists=dashboard_lists,
            description=description,
            is_read_only=is_read_only,
            notify_list=notify_list,
            reflow_type=reflow_type,
            restricted_roles=restricted_roles,
            template_variable=template_variable,
            template_variable_preset=template_variable_preset,
            url=url,
            widget=widget,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="resetDashboardLists")
    def reset_dashboard_lists(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDashboardLists", []))

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDescription", []))

    @jsii.member(jsii_name="resetIsReadOnly")
    def reset_is_read_only(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsReadOnly", []))

    @jsii.member(jsii_name="resetNotifyList")
    def reset_notify_list(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNotifyList", []))

    @jsii.member(jsii_name="resetReflowType")
    def reset_reflow_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetReflowType", []))

    @jsii.member(jsii_name="resetRestrictedRoles")
    def reset_restricted_roles(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRestrictedRoles", []))

    @jsii.member(jsii_name="resetTemplateVariable")
    def reset_template_variable(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTemplateVariable", []))

    @jsii.member(jsii_name="resetTemplateVariablePreset")
    def reset_template_variable_preset(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTemplateVariablePreset", []))

    @jsii.member(jsii_name="resetUrl")
    def reset_url(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUrl", []))

    @jsii.member(jsii_name="resetWidget")
    def reset_widget(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetWidget", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashboardListsRemoved")
    def dashboard_lists_removed(self) -> typing.List[jsii.Number]:
        return typing.cast(typing.List[jsii.Number], jsii.get(self, "dashboardListsRemoved"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashboardListsInput")
    def dashboard_lists_input(self) -> typing.Optional[typing.List[jsii.Number]]:
        return typing.cast(typing.Optional[typing.List[jsii.Number]], jsii.get(self, "dashboardListsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "descriptionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isReadOnlyInput")
    def is_read_only_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "isReadOnlyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="layoutTypeInput")
    def layout_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "layoutTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="notifyListInput")
    def notify_list_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "notifyListInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="reflowTypeInput")
    def reflow_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "reflowTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="restrictedRolesInput")
    def restricted_roles_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "restrictedRolesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="templateVariableInput")
    def template_variable_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariable"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariable"]]], jsii.get(self, "templateVariableInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="templateVariablePresetInput")
    def template_variable_preset_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePreset"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePreset"]]], jsii.get(self, "templateVariablePresetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="urlInput")
    def url_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "urlInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="widgetInput")
    def widget_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidget"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidget"]]], jsii.get(self, "widgetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashboardLists")
    def dashboard_lists(self) -> typing.List[jsii.Number]:
        return typing.cast(typing.List[jsii.Number], jsii.get(self, "dashboardLists"))

    @dashboard_lists.setter
    def dashboard_lists(self, value: typing.List[jsii.Number]) -> None:
        jsii.set(self, "dashboardLists", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "description"))

    @description.setter
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isReadOnly")
    def is_read_only(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "isReadOnly"))

    @is_read_only.setter
    def is_read_only(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "isReadOnly", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="layoutType")
    def layout_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "layoutType"))

    @layout_type.setter
    def layout_type(self, value: builtins.str) -> None:
        jsii.set(self, "layoutType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="notifyList")
    def notify_list(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "notifyList"))

    @notify_list.setter
    def notify_list(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "notifyList", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="reflowType")
    def reflow_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "reflowType"))

    @reflow_type.setter
    def reflow_type(self, value: builtins.str) -> None:
        jsii.set(self, "reflowType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="restrictedRoles")
    def restricted_roles(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "restrictedRoles"))

    @restricted_roles.setter
    def restricted_roles(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "restrictedRoles", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="templateVariable")
    def template_variable(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariable"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariable"]], jsii.get(self, "templateVariable"))

    @template_variable.setter
    def template_variable(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariable"]],
    ) -> None:
        jsii.set(self, "templateVariable", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="templateVariablePreset")
    def template_variable_preset(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePreset"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePreset"]], jsii.get(self, "templateVariablePreset"))

    @template_variable_preset.setter
    def template_variable_preset(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePreset"]],
    ) -> None:
        jsii.set(self, "templateVariablePreset", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="url")
    def url(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "url"))

    @url.setter
    def url(self, value: builtins.str) -> None:
        jsii.set(self, "url", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="widget")
    def widget(self) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidget"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidget"]], jsii.get(self, "widget"))

    @widget.setter
    def widget(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardWidget"]],
    ) -> None:
        jsii.set(self, "widget", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "layout_type": "layoutType",
        "title": "title",
        "dashboard_lists": "dashboardLists",
        "description": "description",
        "is_read_only": "isReadOnly",
        "notify_list": "notifyList",
        "reflow_type": "reflowType",
        "restricted_roles": "restrictedRoles",
        "template_variable": "templateVariable",
        "template_variable_preset": "templateVariablePreset",
        "url": "url",
        "widget": "widget",
    },
)
class DashboardConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        layout_type: builtins.str,
        title: builtins.str,
        dashboard_lists: typing.Optional[typing.Sequence[jsii.Number]] = None,
        description: typing.Optional[builtins.str] = None,
        is_read_only: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        notify_list: typing.Optional[typing.Sequence[builtins.str]] = None,
        reflow_type: typing.Optional[builtins.str] = None,
        restricted_roles: typing.Optional[typing.Sequence[builtins.str]] = None,
        template_variable: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardTemplateVariable"]]] = None,
        template_variable_preset: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardTemplateVariablePreset"]]] = None,
        url: typing.Optional[builtins.str] = None,
        widget: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidget"]]] = None,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param layout_type: The layout type of the dashboard. Valid values are ``ordered``, ``free``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
        :param title: The title of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param dashboard_lists: A list of dashboard lists this dashboard belongs to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dashboard_lists Dashboard#dashboard_lists}
        :param description: The description of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#description Dashboard#description}
        :param is_read_only: Whether this dashboard is read-only. **Deprecated.** Prefer using ``restricted_roles`` to define which roles are required to edit the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_read_only Dashboard#is_read_only}
        :param notify_list: The list of handles for the users to notify when changes are made to this dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#notify_list Dashboard#notify_list}
        :param reflow_type: The reflow type of a new dashboard layout. Set this only when layout type is ``ordered``. If set to ``fixed``, the dashboard expects all widgets to have a layout, and if it's set to ``auto``, widgets should not have layouts. Valid values are ``auto``, ``fixed``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#reflow_type Dashboard#reflow_type}
        :param restricted_roles: UUIDs of roles whose associated users are authorized to edit the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#restricted_roles Dashboard#restricted_roles}
        :param template_variable: template_variable block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        :param template_variable_preset: template_variable_preset block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable_preset Dashboard#template_variable_preset}
        :param url: The URL of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
        :param widget: widget block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values: typing.Dict[str, typing.Any] = {
            "layout_type": layout_type,
            "title": title,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if dashboard_lists is not None:
            self._values["dashboard_lists"] = dashboard_lists
        if description is not None:
            self._values["description"] = description
        if is_read_only is not None:
            self._values["is_read_only"] = is_read_only
        if notify_list is not None:
            self._values["notify_list"] = notify_list
        if reflow_type is not None:
            self._values["reflow_type"] = reflow_type
        if restricted_roles is not None:
            self._values["restricted_roles"] = restricted_roles
        if template_variable is not None:
            self._values["template_variable"] = template_variable
        if template_variable_preset is not None:
            self._values["template_variable_preset"] = template_variable_preset
        if url is not None:
            self._values["url"] = url
        if widget is not None:
            self._values["widget"] = widget

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def layout_type(self) -> builtins.str:
        '''The layout type of the dashboard. Valid values are ``ordered``, ``free``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
        '''
        result = self._values.get("layout_type")
        assert result is not None, "Required property 'layout_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def title(self) -> builtins.str:
        '''The title of the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        assert result is not None, "Required property 'title' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def dashboard_lists(self) -> typing.Optional[typing.List[jsii.Number]]:
        '''A list of dashboard lists this dashboard belongs to.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dashboard_lists Dashboard#dashboard_lists}
        '''
        result = self._values.get("dashboard_lists")
        return typing.cast(typing.Optional[typing.List[jsii.Number]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''The description of the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#description Dashboard#description}
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def is_read_only(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Whether this dashboard is read-only. **Deprecated.** Prefer using ``restricted_roles`` to define which roles are required to edit the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_read_only Dashboard#is_read_only}
        '''
        result = self._values.get("is_read_only")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def notify_list(self) -> typing.Optional[typing.List[builtins.str]]:
        '''The list of handles for the users to notify when changes are made to this dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#notify_list Dashboard#notify_list}
        '''
        result = self._values.get("notify_list")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reflow_type(self) -> typing.Optional[builtins.str]:
        '''The reflow type of a new dashboard layout.

        Set this only when layout type is ``ordered``. If set to ``fixed``, the dashboard expects all widgets to have a layout, and if it's set to ``auto``, widgets should not have layouts. Valid values are ``auto``, ``fixed``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#reflow_type Dashboard#reflow_type}
        '''
        result = self._values.get("reflow_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def restricted_roles(self) -> typing.Optional[typing.List[builtins.str]]:
        '''UUIDs of roles whose associated users are authorized to edit the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#restricted_roles Dashboard#restricted_roles}
        '''
        result = self._values.get("restricted_roles")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def template_variable(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariable"]]]:
        '''template_variable block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        '''
        result = self._values.get("template_variable")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariable"]]], result)

    @builtins.property
    def template_variable_preset(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePreset"]]]:
        '''template_variable_preset block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable_preset Dashboard#template_variable_preset}
        '''
        result = self._values.get("template_variable_preset")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePreset"]]], result)

    @builtins.property
    def url(self) -> typing.Optional[builtins.str]:
        '''The URL of the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
        '''
        result = self._values.get("url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def widget(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidget"]]]:
        '''widget block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
        '''
        result = self._values.get("widget")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidget"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardJson(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardJson",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json datadog_dashboard_json}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        dashboard: builtins.str,
        dashboard_lists: typing.Optional[typing.Sequence[jsii.Number]] = None,
        url: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json datadog_dashboard_json} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param dashboard: The JSON formatted definition of the Dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#dashboard DashboardJson#dashboard}
        :param dashboard_lists: The list of dashboard lists this dashboard belongs to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#dashboard_lists DashboardJson#dashboard_lists}
        :param url: The URL of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#url DashboardJson#url}
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = DashboardJsonConfig(
            dashboard=dashboard,
            dashboard_lists=dashboard_lists,
            url=url,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="resetDashboardLists")
    def reset_dashboard_lists(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDashboardLists", []))

    @jsii.member(jsii_name="resetUrl")
    def reset_url(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUrl", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashboardListsRemoved")
    def dashboard_lists_removed(self) -> typing.List[jsii.Number]:
        return typing.cast(typing.List[jsii.Number], jsii.get(self, "dashboardListsRemoved"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashboardInput")
    def dashboard_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dashboardInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashboardListsInput")
    def dashboard_lists_input(self) -> typing.Optional[typing.List[jsii.Number]]:
        return typing.cast(typing.Optional[typing.List[jsii.Number]], jsii.get(self, "dashboardListsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="urlInput")
    def url_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "urlInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashboard")
    def dashboard(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dashboard"))

    @dashboard.setter
    def dashboard(self, value: builtins.str) -> None:
        jsii.set(self, "dashboard", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashboardLists")
    def dashboard_lists(self) -> typing.List[jsii.Number]:
        return typing.cast(typing.List[jsii.Number], jsii.get(self, "dashboardLists"))

    @dashboard_lists.setter
    def dashboard_lists(self, value: typing.List[jsii.Number]) -> None:
        jsii.set(self, "dashboardLists", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="url")
    def url(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "url"))

    @url.setter
    def url(self, value: builtins.str) -> None:
        jsii.set(self, "url", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardJsonConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "dashboard": "dashboard",
        "dashboard_lists": "dashboardLists",
        "url": "url",
    },
)
class DashboardJsonConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        dashboard: builtins.str,
        dashboard_lists: typing.Optional[typing.Sequence[jsii.Number]] = None,
        url: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param dashboard: The JSON formatted definition of the Dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#dashboard DashboardJson#dashboard}
        :param dashboard_lists: The list of dashboard lists this dashboard belongs to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#dashboard_lists DashboardJson#dashboard_lists}
        :param url: The URL of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#url DashboardJson#url}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values: typing.Dict[str, typing.Any] = {
            "dashboard": dashboard,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if dashboard_lists is not None:
            self._values["dashboard_lists"] = dashboard_lists
        if url is not None:
            self._values["url"] = url

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def dashboard(self) -> builtins.str:
        '''The JSON formatted definition of the Dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#dashboard DashboardJson#dashboard}
        '''
        result = self._values.get("dashboard")
        assert result is not None, "Required property 'dashboard' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def dashboard_lists(self) -> typing.Optional[typing.List[jsii.Number]]:
        '''The list of dashboard lists this dashboard belongs to.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#dashboard_lists DashboardJson#dashboard_lists}
        '''
        result = self._values.get("dashboard_lists")
        return typing.cast(typing.Optional[typing.List[jsii.Number]], result)

    @builtins.property
    def url(self) -> typing.Optional[builtins.str]:
        '''The URL of the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#url DashboardJson#url}
        '''
        result = self._values.get("url")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardJsonConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardList(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardList",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list datadog_dashboard_list}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        name: builtins.str,
        dash_item: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardListDashItem"]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list datadog_dashboard_list} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: The name of the Dashboard List. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#name DashboardList#name}
        :param dash_item: dash_item block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_item DashboardList#dash_item}
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = DashboardListConfig(
            name=name,
            dash_item=dash_item,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="resetDashItem")
    def reset_dash_item(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDashItem", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashItemInput")
    def dash_item_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardListDashItem"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardListDashItem"]]], jsii.get(self, "dashItemInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dashItem")
    def dash_item(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardListDashItem"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardListDashItem"]], jsii.get(self, "dashItem"))

    @dash_item.setter
    def dash_item(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardListDashItem"]],
    ) -> None:
        jsii.set(self, "dashItem", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardListConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "dash_item": "dashItem",
    },
)
class DashboardListConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: builtins.str,
        dash_item: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardListDashItem"]]] = None,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: The name of the Dashboard List. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#name DashboardList#name}
        :param dash_item: dash_item block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_item DashboardList#dash_item}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if dash_item is not None:
            self._values["dash_item"] = dash_item

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the Dashboard List.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#name DashboardList#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def dash_item(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardListDashItem"]]]:
        '''dash_item block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_item DashboardList#dash_item}
        '''
        result = self._values.get("dash_item")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardListDashItem"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardListConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardListDashItem",
    jsii_struct_bases=[],
    name_mapping={"dash_id": "dashId", "type": "type"},
)
class DashboardListDashItem:
    def __init__(self, *, dash_id: builtins.str, type: builtins.str) -> None:
        '''
        :param dash_id: The ID of the dashboard to add. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_id DashboardList#dash_id}
        :param type: The type of this dashboard. Valid values are ``custom_timeboard``, ``custom_screenboard``, ``integration_screenboard``, ``integration_timeboard``, ``host_timeboard``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#type DashboardList#type}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "dash_id": dash_id,
            "type": type,
        }

    @builtins.property
    def dash_id(self) -> builtins.str:
        '''The ID of the dashboard to add.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_id DashboardList#dash_id}
        '''
        result = self._values.get("dash_id")
        assert result is not None, "Required property 'dash_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''The type of this dashboard. Valid values are ``custom_timeboard``, ``custom_screenboard``, ``integration_screenboard``, ``integration_timeboard``, ``host_timeboard``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#type DashboardList#type}
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardListDashItem(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardTemplateVariable",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "available_values": "availableValues",
        "default": "default",
        "prefix": "prefix",
    },
)
class DashboardTemplateVariable:
    def __init__(
        self,
        *,
        name: builtins.str,
        available_values: typing.Optional[typing.Sequence[builtins.str]] = None,
        default: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: The name of the variable. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param available_values: The list of values that the template variable drop-down is be limited to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#available_values Dashboard#available_values}
        :param default: The default value for the template variable on dashboard load. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#default Dashboard#default}
        :param prefix: The tag prefix associated with the variable. Only tags with this prefix appear in the variable dropdown. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#prefix Dashboard#prefix}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if available_values is not None:
            self._values["available_values"] = available_values
        if default is not None:
            self._values["default"] = default
        if prefix is not None:
            self._values["prefix"] = prefix

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the variable.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def available_values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''The list of values that the template variable drop-down is be limited to.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#available_values Dashboard#available_values}
        '''
        result = self._values.get("available_values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def default(self) -> typing.Optional[builtins.str]:
        '''The default value for the template variable on dashboard load.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#default Dashboard#default}
        '''
        result = self._values.get("default")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''The tag prefix associated with the variable. Only tags with this prefix appear in the variable dropdown.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#prefix Dashboard#prefix}
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardTemplateVariable(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardTemplateVariablePreset",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "template_variable": "templateVariable"},
)
class DashboardTemplateVariablePreset:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        template_variable: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardTemplateVariablePresetTemplateVariable"]]] = None,
    ) -> None:
        '''
        :param name: The name of the preset. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param template_variable: template_variable block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if template_variable is not None:
            self._values["template_variable"] = template_variable

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the preset.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def template_variable(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePresetTemplateVariable"]]]:
        '''template_variable block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        '''
        result = self._values.get("template_variable")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardTemplateVariablePresetTemplateVariable"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardTemplateVariablePreset(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardTemplateVariablePresetTemplateVariable",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class DashboardTemplateVariablePresetTemplateVariable:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: The name of the template variable. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param value: The value that should be assumed by the template variable in this preset. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the template variable.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''The value that should be assumed by the template variable in this preset.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardTemplateVariablePresetTemplateVariable(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidget",
    jsii_struct_bases=[],
    name_mapping={
        "alert_graph_definition": "alertGraphDefinition",
        "alert_value_definition": "alertValueDefinition",
        "change_definition": "changeDefinition",
        "check_status_definition": "checkStatusDefinition",
        "distribution_definition": "distributionDefinition",
        "event_stream_definition": "eventStreamDefinition",
        "event_timeline_definition": "eventTimelineDefinition",
        "free_text_definition": "freeTextDefinition",
        "geomap_definition": "geomapDefinition",
        "group_definition": "groupDefinition",
        "heatmap_definition": "heatmapDefinition",
        "hostmap_definition": "hostmapDefinition",
        "iframe_definition": "iframeDefinition",
        "image_definition": "imageDefinition",
        "log_stream_definition": "logStreamDefinition",
        "manage_status_definition": "manageStatusDefinition",
        "note_definition": "noteDefinition",
        "query_table_definition": "queryTableDefinition",
        "query_value_definition": "queryValueDefinition",
        "scatterplot_definition": "scatterplotDefinition",
        "service_level_objective_definition": "serviceLevelObjectiveDefinition",
        "servicemap_definition": "servicemapDefinition",
        "sunburst_definition": "sunburstDefinition",
        "timeseries_definition": "timeseriesDefinition",
        "toplist_definition": "toplistDefinition",
        "trace_service_definition": "traceServiceDefinition",
        "widget_layout": "widgetLayout",
    },
)
class DashboardWidget:
    def __init__(
        self,
        *,
        alert_graph_definition: typing.Optional["DashboardWidgetAlertGraphDefinition"] = None,
        alert_value_definition: typing.Optional["DashboardWidgetAlertValueDefinition"] = None,
        change_definition: typing.Optional["DashboardWidgetChangeDefinition"] = None,
        check_status_definition: typing.Optional["DashboardWidgetCheckStatusDefinition"] = None,
        distribution_definition: typing.Optional["DashboardWidgetDistributionDefinition"] = None,
        event_stream_definition: typing.Optional["DashboardWidgetEventStreamDefinition"] = None,
        event_timeline_definition: typing.Optional["DashboardWidgetEventTimelineDefinition"] = None,
        free_text_definition: typing.Optional["DashboardWidgetFreeTextDefinition"] = None,
        geomap_definition: typing.Optional["DashboardWidgetGeomapDefinition"] = None,
        group_definition: typing.Optional["DashboardWidgetGroupDefinition"] = None,
        heatmap_definition: typing.Optional["DashboardWidgetHeatmapDefinition"] = None,
        hostmap_definition: typing.Optional["DashboardWidgetHostmapDefinition"] = None,
        iframe_definition: typing.Optional["DashboardWidgetIframeDefinition"] = None,
        image_definition: typing.Optional["DashboardWidgetImageDefinition"] = None,
        log_stream_definition: typing.Optional["DashboardWidgetLogStreamDefinition"] = None,
        manage_status_definition: typing.Optional["DashboardWidgetManageStatusDefinition"] = None,
        note_definition: typing.Optional["DashboardWidgetNoteDefinition"] = None,
        query_table_definition: typing.Optional["DashboardWidgetQueryTableDefinition"] = None,
        query_value_definition: typing.Optional["DashboardWidgetQueryValueDefinition"] = None,
        scatterplot_definition: typing.Optional["DashboardWidgetScatterplotDefinition"] = None,
        service_level_objective_definition: typing.Optional["DashboardWidgetServiceLevelObjectiveDefinition"] = None,
        servicemap_definition: typing.Optional["DashboardWidgetServicemapDefinition"] = None,
        sunburst_definition: typing.Optional["DashboardWidgetSunburstDefinition"] = None,
        timeseries_definition: typing.Optional["DashboardWidgetTimeseriesDefinition"] = None,
        toplist_definition: typing.Optional["DashboardWidgetToplistDefinition"] = None,
        trace_service_definition: typing.Optional["DashboardWidgetTraceServiceDefinition"] = None,
        widget_layout: typing.Optional["DashboardWidgetWidgetLayout"] = None,
    ) -> None:
        '''
        :param alert_graph_definition: alert_graph_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_graph_definition Dashboard#alert_graph_definition}
        :param alert_value_definition: alert_value_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_value_definition Dashboard#alert_value_definition}
        :param change_definition: change_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_definition Dashboard#change_definition}
        :param check_status_definition: check_status_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check_status_definition Dashboard#check_status_definition}
        :param distribution_definition: distribution_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#distribution_definition Dashboard#distribution_definition}
        :param event_stream_definition: event_stream_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_stream_definition Dashboard#event_stream_definition}
        :param event_timeline_definition: event_timeline_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_timeline_definition Dashboard#event_timeline_definition}
        :param free_text_definition: free_text_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#free_text_definition Dashboard#free_text_definition}
        :param geomap_definition: geomap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#geomap_definition Dashboard#geomap_definition}
        :param group_definition: group_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_definition Dashboard#group_definition}
        :param heatmap_definition: heatmap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#heatmap_definition Dashboard#heatmap_definition}
        :param hostmap_definition: hostmap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hostmap_definition Dashboard#hostmap_definition}
        :param iframe_definition: iframe_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#iframe_definition Dashboard#iframe_definition}
        :param image_definition: image_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_definition Dashboard#image_definition}
        :param log_stream_definition: log_stream_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_stream_definition Dashboard#log_stream_definition}
        :param manage_status_definition: manage_status_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#manage_status_definition Dashboard#manage_status_definition}
        :param note_definition: note_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#note_definition Dashboard#note_definition}
        :param query_table_definition: query_table_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_table_definition Dashboard#query_table_definition}
        :param query_value_definition: query_value_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_value_definition Dashboard#query_value_definition}
        :param scatterplot_definition: scatterplot_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scatterplot_definition Dashboard#scatterplot_definition}
        :param service_level_objective_definition: service_level_objective_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service_level_objective_definition Dashboard#service_level_objective_definition}
        :param servicemap_definition: servicemap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#servicemap_definition Dashboard#servicemap_definition}
        :param sunburst_definition: sunburst_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sunburst_definition Dashboard#sunburst_definition}
        :param timeseries_definition: timeseries_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeseries_definition Dashboard#timeseries_definition}
        :param toplist_definition: toplist_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#toplist_definition Dashboard#toplist_definition}
        :param trace_service_definition: trace_service_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#trace_service_definition Dashboard#trace_service_definition}
        :param widget_layout: widget_layout block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget_layout Dashboard#widget_layout}
        '''
        if isinstance(alert_graph_definition, dict):
            alert_graph_definition = DashboardWidgetAlertGraphDefinition(**alert_graph_definition)
        if isinstance(alert_value_definition, dict):
            alert_value_definition = DashboardWidgetAlertValueDefinition(**alert_value_definition)
        if isinstance(change_definition, dict):
            change_definition = DashboardWidgetChangeDefinition(**change_definition)
        if isinstance(check_status_definition, dict):
            check_status_definition = DashboardWidgetCheckStatusDefinition(**check_status_definition)
        if isinstance(distribution_definition, dict):
            distribution_definition = DashboardWidgetDistributionDefinition(**distribution_definition)
        if isinstance(event_stream_definition, dict):
            event_stream_definition = DashboardWidgetEventStreamDefinition(**event_stream_definition)
        if isinstance(event_timeline_definition, dict):
            event_timeline_definition = DashboardWidgetEventTimelineDefinition(**event_timeline_definition)
        if isinstance(free_text_definition, dict):
            free_text_definition = DashboardWidgetFreeTextDefinition(**free_text_definition)
        if isinstance(geomap_definition, dict):
            geomap_definition = DashboardWidgetGeomapDefinition(**geomap_definition)
        if isinstance(group_definition, dict):
            group_definition = DashboardWidgetGroupDefinition(**group_definition)
        if isinstance(heatmap_definition, dict):
            heatmap_definition = DashboardWidgetHeatmapDefinition(**heatmap_definition)
        if isinstance(hostmap_definition, dict):
            hostmap_definition = DashboardWidgetHostmapDefinition(**hostmap_definition)
        if isinstance(iframe_definition, dict):
            iframe_definition = DashboardWidgetIframeDefinition(**iframe_definition)
        if isinstance(image_definition, dict):
            image_definition = DashboardWidgetImageDefinition(**image_definition)
        if isinstance(log_stream_definition, dict):
            log_stream_definition = DashboardWidgetLogStreamDefinition(**log_stream_definition)
        if isinstance(manage_status_definition, dict):
            manage_status_definition = DashboardWidgetManageStatusDefinition(**manage_status_definition)
        if isinstance(note_definition, dict):
            note_definition = DashboardWidgetNoteDefinition(**note_definition)
        if isinstance(query_table_definition, dict):
            query_table_definition = DashboardWidgetQueryTableDefinition(**query_table_definition)
        if isinstance(query_value_definition, dict):
            query_value_definition = DashboardWidgetQueryValueDefinition(**query_value_definition)
        if isinstance(scatterplot_definition, dict):
            scatterplot_definition = DashboardWidgetScatterplotDefinition(**scatterplot_definition)
        if isinstance(service_level_objective_definition, dict):
            service_level_objective_definition = DashboardWidgetServiceLevelObjectiveDefinition(**service_level_objective_definition)
        if isinstance(servicemap_definition, dict):
            servicemap_definition = DashboardWidgetServicemapDefinition(**servicemap_definition)
        if isinstance(sunburst_definition, dict):
            sunburst_definition = DashboardWidgetSunburstDefinition(**sunburst_definition)
        if isinstance(timeseries_definition, dict):
            timeseries_definition = DashboardWidgetTimeseriesDefinition(**timeseries_definition)
        if isinstance(toplist_definition, dict):
            toplist_definition = DashboardWidgetToplistDefinition(**toplist_definition)
        if isinstance(trace_service_definition, dict):
            trace_service_definition = DashboardWidgetTraceServiceDefinition(**trace_service_definition)
        if isinstance(widget_layout, dict):
            widget_layout = DashboardWidgetWidgetLayout(**widget_layout)
        self._values: typing.Dict[str, typing.Any] = {}
        if alert_graph_definition is not None:
            self._values["alert_graph_definition"] = alert_graph_definition
        if alert_value_definition is not None:
            self._values["alert_value_definition"] = alert_value_definition
        if change_definition is not None:
            self._values["change_definition"] = change_definition
        if check_status_definition is not None:
            self._values["check_status_definition"] = check_status_definition
        if distribution_definition is not None:
            self._values["distribution_definition"] = distribution_definition
        if event_stream_definition is not None:
            self._values["event_stream_definition"] = event_stream_definition
        if event_timeline_definition is not None:
            self._values["event_timeline_definition"] = event_timeline_definition
        if free_text_definition is not None:
            self._values["free_text_definition"] = free_text_definition
        if geomap_definition is not None:
            self._values["geomap_definition"] = geomap_definition
        if group_definition is not None:
            self._values["group_definition"] = group_definition
        if heatmap_definition is not None:
            self._values["heatmap_definition"] = heatmap_definition
        if hostmap_definition is not None:
            self._values["hostmap_definition"] = hostmap_definition
        if iframe_definition is not None:
            self._values["iframe_definition"] = iframe_definition
        if image_definition is not None:
            self._values["image_definition"] = image_definition
        if log_stream_definition is not None:
            self._values["log_stream_definition"] = log_stream_definition
        if manage_status_definition is not None:
            self._values["manage_status_definition"] = manage_status_definition
        if note_definition is not None:
            self._values["note_definition"] = note_definition
        if query_table_definition is not None:
            self._values["query_table_definition"] = query_table_definition
        if query_value_definition is not None:
            self._values["query_value_definition"] = query_value_definition
        if scatterplot_definition is not None:
            self._values["scatterplot_definition"] = scatterplot_definition
        if service_level_objective_definition is not None:
            self._values["service_level_objective_definition"] = service_level_objective_definition
        if servicemap_definition is not None:
            self._values["servicemap_definition"] = servicemap_definition
        if sunburst_definition is not None:
            self._values["sunburst_definition"] = sunburst_definition
        if timeseries_definition is not None:
            self._values["timeseries_definition"] = timeseries_definition
        if toplist_definition is not None:
            self._values["toplist_definition"] = toplist_definition
        if trace_service_definition is not None:
            self._values["trace_service_definition"] = trace_service_definition
        if widget_layout is not None:
            self._values["widget_layout"] = widget_layout

    @builtins.property
    def alert_graph_definition(
        self,
    ) -> typing.Optional["DashboardWidgetAlertGraphDefinition"]:
        '''alert_graph_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_graph_definition Dashboard#alert_graph_definition}
        '''
        result = self._values.get("alert_graph_definition")
        return typing.cast(typing.Optional["DashboardWidgetAlertGraphDefinition"], result)

    @builtins.property
    def alert_value_definition(
        self,
    ) -> typing.Optional["DashboardWidgetAlertValueDefinition"]:
        '''alert_value_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_value_definition Dashboard#alert_value_definition}
        '''
        result = self._values.get("alert_value_definition")
        return typing.cast(typing.Optional["DashboardWidgetAlertValueDefinition"], result)

    @builtins.property
    def change_definition(self) -> typing.Optional["DashboardWidgetChangeDefinition"]:
        '''change_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_definition Dashboard#change_definition}
        '''
        result = self._values.get("change_definition")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinition"], result)

    @builtins.property
    def check_status_definition(
        self,
    ) -> typing.Optional["DashboardWidgetCheckStatusDefinition"]:
        '''check_status_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check_status_definition Dashboard#check_status_definition}
        '''
        result = self._values.get("check_status_definition")
        return typing.cast(typing.Optional["DashboardWidgetCheckStatusDefinition"], result)

    @builtins.property
    def distribution_definition(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinition"]:
        '''distribution_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#distribution_definition Dashboard#distribution_definition}
        '''
        result = self._values.get("distribution_definition")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinition"], result)

    @builtins.property
    def event_stream_definition(
        self,
    ) -> typing.Optional["DashboardWidgetEventStreamDefinition"]:
        '''event_stream_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_stream_definition Dashboard#event_stream_definition}
        '''
        result = self._values.get("event_stream_definition")
        return typing.cast(typing.Optional["DashboardWidgetEventStreamDefinition"], result)

    @builtins.property
    def event_timeline_definition(
        self,
    ) -> typing.Optional["DashboardWidgetEventTimelineDefinition"]:
        '''event_timeline_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_timeline_definition Dashboard#event_timeline_definition}
        '''
        result = self._values.get("event_timeline_definition")
        return typing.cast(typing.Optional["DashboardWidgetEventTimelineDefinition"], result)

    @builtins.property
    def free_text_definition(
        self,
    ) -> typing.Optional["DashboardWidgetFreeTextDefinition"]:
        '''free_text_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#free_text_definition Dashboard#free_text_definition}
        '''
        result = self._values.get("free_text_definition")
        return typing.cast(typing.Optional["DashboardWidgetFreeTextDefinition"], result)

    @builtins.property
    def geomap_definition(self) -> typing.Optional["DashboardWidgetGeomapDefinition"]:
        '''geomap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#geomap_definition Dashboard#geomap_definition}
        '''
        result = self._values.get("geomap_definition")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinition"], result)

    @builtins.property
    def group_definition(self) -> typing.Optional["DashboardWidgetGroupDefinition"]:
        '''group_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_definition Dashboard#group_definition}
        '''
        result = self._values.get("group_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinition"], result)

    @builtins.property
    def heatmap_definition(self) -> typing.Optional["DashboardWidgetHeatmapDefinition"]:
        '''heatmap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#heatmap_definition Dashboard#heatmap_definition}
        '''
        result = self._values.get("heatmap_definition")
        return typing.cast(typing.Optional["DashboardWidgetHeatmapDefinition"], result)

    @builtins.property
    def hostmap_definition(self) -> typing.Optional["DashboardWidgetHostmapDefinition"]:
        '''hostmap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hostmap_definition Dashboard#hostmap_definition}
        '''
        result = self._values.get("hostmap_definition")
        return typing.cast(typing.Optional["DashboardWidgetHostmapDefinition"], result)

    @builtins.property
    def iframe_definition(self) -> typing.Optional["DashboardWidgetIframeDefinition"]:
        '''iframe_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#iframe_definition Dashboard#iframe_definition}
        '''
        result = self._values.get("iframe_definition")
        return typing.cast(typing.Optional["DashboardWidgetIframeDefinition"], result)

    @builtins.property
    def image_definition(self) -> typing.Optional["DashboardWidgetImageDefinition"]:
        '''image_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_definition Dashboard#image_definition}
        '''
        result = self._values.get("image_definition")
        return typing.cast(typing.Optional["DashboardWidgetImageDefinition"], result)

    @builtins.property
    def log_stream_definition(
        self,
    ) -> typing.Optional["DashboardWidgetLogStreamDefinition"]:
        '''log_stream_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_stream_definition Dashboard#log_stream_definition}
        '''
        result = self._values.get("log_stream_definition")
        return typing.cast(typing.Optional["DashboardWidgetLogStreamDefinition"], result)

    @builtins.property
    def manage_status_definition(
        self,
    ) -> typing.Optional["DashboardWidgetManageStatusDefinition"]:
        '''manage_status_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#manage_status_definition Dashboard#manage_status_definition}
        '''
        result = self._values.get("manage_status_definition")
        return typing.cast(typing.Optional["DashboardWidgetManageStatusDefinition"], result)

    @builtins.property
    def note_definition(self) -> typing.Optional["DashboardWidgetNoteDefinition"]:
        '''note_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#note_definition Dashboard#note_definition}
        '''
        result = self._values.get("note_definition")
        return typing.cast(typing.Optional["DashboardWidgetNoteDefinition"], result)

    @builtins.property
    def query_table_definition(
        self,
    ) -> typing.Optional["DashboardWidgetQueryTableDefinition"]:
        '''query_table_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_table_definition Dashboard#query_table_definition}
        '''
        result = self._values.get("query_table_definition")
        return typing.cast(typing.Optional["DashboardWidgetQueryTableDefinition"], result)

    @builtins.property
    def query_value_definition(
        self,
    ) -> typing.Optional["DashboardWidgetQueryValueDefinition"]:
        '''query_value_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_value_definition Dashboard#query_value_definition}
        '''
        result = self._values.get("query_value_definition")
        return typing.cast(typing.Optional["DashboardWidgetQueryValueDefinition"], result)

    @builtins.property
    def scatterplot_definition(
        self,
    ) -> typing.Optional["DashboardWidgetScatterplotDefinition"]:
        '''scatterplot_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scatterplot_definition Dashboard#scatterplot_definition}
        '''
        result = self._values.get("scatterplot_definition")
        return typing.cast(typing.Optional["DashboardWidgetScatterplotDefinition"], result)

    @builtins.property
    def service_level_objective_definition(
        self,
    ) -> typing.Optional["DashboardWidgetServiceLevelObjectiveDefinition"]:
        '''service_level_objective_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service_level_objective_definition Dashboard#service_level_objective_definition}
        '''
        result = self._values.get("service_level_objective_definition")
        return typing.cast(typing.Optional["DashboardWidgetServiceLevelObjectiveDefinition"], result)

    @builtins.property
    def servicemap_definition(
        self,
    ) -> typing.Optional["DashboardWidgetServicemapDefinition"]:
        '''servicemap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#servicemap_definition Dashboard#servicemap_definition}
        '''
        result = self._values.get("servicemap_definition")
        return typing.cast(typing.Optional["DashboardWidgetServicemapDefinition"], result)

    @builtins.property
    def sunburst_definition(
        self,
    ) -> typing.Optional["DashboardWidgetSunburstDefinition"]:
        '''sunburst_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sunburst_definition Dashboard#sunburst_definition}
        '''
        result = self._values.get("sunburst_definition")
        return typing.cast(typing.Optional["DashboardWidgetSunburstDefinition"], result)

    @builtins.property
    def timeseries_definition(
        self,
    ) -> typing.Optional["DashboardWidgetTimeseriesDefinition"]:
        '''timeseries_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeseries_definition Dashboard#timeseries_definition}
        '''
        result = self._values.get("timeseries_definition")
        return typing.cast(typing.Optional["DashboardWidgetTimeseriesDefinition"], result)

    @builtins.property
    def toplist_definition(self) -> typing.Optional["DashboardWidgetToplistDefinition"]:
        '''toplist_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#toplist_definition Dashboard#toplist_definition}
        '''
        result = self._values.get("toplist_definition")
        return typing.cast(typing.Optional["DashboardWidgetToplistDefinition"], result)

    @builtins.property
    def trace_service_definition(
        self,
    ) -> typing.Optional["DashboardWidgetTraceServiceDefinition"]:
        '''trace_service_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#trace_service_definition Dashboard#trace_service_definition}
        '''
        result = self._values.get("trace_service_definition")
        return typing.cast(typing.Optional["DashboardWidgetTraceServiceDefinition"], result)

    @builtins.property
    def widget_layout(self) -> typing.Optional["DashboardWidgetWidgetLayout"]:
        '''widget_layout block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget_layout Dashboard#widget_layout}
        '''
        result = self._values.get("widget_layout")
        return typing.cast(typing.Optional["DashboardWidgetWidgetLayout"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetAlertGraphDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "alert_id": "alertId",
        "viz_type": "vizType",
        "live_span": "liveSpan",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetAlertGraphDefinition:
    def __init__(
        self,
        *,
        alert_id: builtins.str,
        viz_type: builtins.str,
        live_span: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alert_id: The ID of the monitor used by the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        :param viz_type: Type of visualization to use when displaying the widget. Valid values are ``timeseries``, ``toplist``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alert_id": alert_id,
            "viz_type": viz_type,
        }
        if live_span is not None:
            self._values["live_span"] = live_span
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def alert_id(self) -> builtins.str:
        '''The ID of the monitor used by the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        '''
        result = self._values.get("alert_id")
        assert result is not None, "Required property 'alert_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def viz_type(self) -> builtins.str:
        '''Type of visualization to use when displaying the widget. Valid values are ``timeseries``, ``toplist``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
        '''
        result = self._values.get("viz_type")
        assert result is not None, "Required property 'viz_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetAlertGraphDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetAlertGraphDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetAlertGraphDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alertIdInput")
    def alert_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alertIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="vizTypeInput")
    def viz_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "vizTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alertId")
    def alert_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alertId"))

    @alert_id.setter
    def alert_id(self, value: builtins.str) -> None:
        jsii.set(self, "alertId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="vizType")
    def viz_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "vizType"))

    @viz_type.setter
    def viz_type(self, value: builtins.str) -> None:
        jsii.set(self, "vizType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetAlertGraphDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetAlertGraphDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetAlertGraphDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetAlertValueDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "alert_id": "alertId",
        "precision": "precision",
        "text_align": "textAlign",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
        "unit": "unit",
    },
)
class DashboardWidgetAlertValueDefinition:
    def __init__(
        self,
        *,
        alert_id: builtins.str,
        precision: typing.Optional[jsii.Number] = None,
        text_align: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alert_id: The ID of the monitor used by the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        :param precision: The precision to use when displaying the value. Use ``*`` for maximum precision. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
        :param text_align: The alignment of the text in the widget. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        :param unit: The unit for the value displayed in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alert_id": alert_id,
        }
        if precision is not None:
            self._values["precision"] = precision
        if text_align is not None:
            self._values["text_align"] = text_align
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def alert_id(self) -> builtins.str:
        '''The ID of the monitor used by the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        '''
        result = self._values.get("alert_id")
        assert result is not None, "Required property 'alert_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def precision(self) -> typing.Optional[jsii.Number]:
        '''The precision to use when displaying the value. Use ``*`` for maximum precision.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
        '''
        result = self._values.get("precision")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def text_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the text in the widget. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
        '''
        result = self._values.get("text_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''The unit for the value displayed in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
        '''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetAlertValueDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetAlertValueDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetAlertValueDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetPrecision")
    def reset_precision(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrecision", []))

    @jsii.member(jsii_name="resetTextAlign")
    def reset_text_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTextAlign", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @jsii.member(jsii_name="resetUnit")
    def reset_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUnit", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alertIdInput")
    def alert_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alertIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="precisionInput")
    def precision_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "precisionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textAlignInput")
    def text_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "textAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="unitInput")
    def unit_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "unitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alertId")
    def alert_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alertId"))

    @alert_id.setter
    def alert_id(self, value: builtins.str) -> None:
        jsii.set(self, "alertId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="precision")
    def precision(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "precision"))

    @precision.setter
    def precision(self, value: jsii.Number) -> None:
        jsii.set(self, "precision", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textAlign")
    def text_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "textAlign"))

    @text_align.setter
    def text_align(self, value: builtins.str) -> None:
        jsii.set(self, "textAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="unit")
    def unit(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "unit"))

    @unit.setter
    def unit(self, value: builtins.str) -> None:
        jsii.set(self, "unit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetAlertValueDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetAlertValueDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetAlertValueDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "custom_link": "customLink",
        "live_span": "liveSpan",
        "request": "request",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetChangeDefinition:
    def __init__(
        self,
        *,
        custom_link: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionCustomLink"]]] = None,
        live_span: typing.Optional[builtins.str] = None,
        request: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequest"]]] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param custom_link: custom_link block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param request: request block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if custom_link is not None:
            self._values["custom_link"] = custom_link
        if live_span is not None:
            self._values["live_span"] = live_span
        if request is not None:
            self._values["request"] = request
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def custom_link(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionCustomLink"]]]:
        '''custom_link block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
        '''
        result = self._values.get("custom_link")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionCustomLink"]]], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def request(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]]:
        '''request block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        '''
        result = self._values.get("request")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionCustomLink",
    jsii_struct_bases=[],
    name_mapping={
        "is_hidden": "isHidden",
        "label": "label",
        "link": "link",
        "override_label": "overrideLabel",
    },
)
class DashboardWidgetChangeDefinitionCustomLink:
    def __init__(
        self,
        *,
        is_hidden: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        label: typing.Optional[builtins.str] = None,
        link: typing.Optional[builtins.str] = None,
        override_label: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param is_hidden: The flag for toggling context menu link visibility. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
        :param label: The label for the custom link URL. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
        :param link: The URL of the custom link. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
        :param override_label: The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if is_hidden is not None:
            self._values["is_hidden"] = is_hidden
        if label is not None:
            self._values["label"] = label
        if link is not None:
            self._values["link"] = link
        if override_label is not None:
            self._values["override_label"] = override_label

    @builtins.property
    def is_hidden(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''The flag for toggling context menu link visibility.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
        '''
        result = self._values.get("is_hidden")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def label(self) -> typing.Optional[builtins.str]:
        '''The label for the custom link URL.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
        '''
        result = self._values.get("label")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def link(self) -> typing.Optional[builtins.str]:
        '''The URL of the custom link.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
        '''
        result = self._values.get("link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def override_label(self) -> typing.Optional[builtins.str]:
        '''The label id that refers to a context menu link item.

        When override_label is provided, the client request omits the label field.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
        '''
        result = self._values.get("override_label")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionCustomLink(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetCustomLink")
    def reset_custom_link(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomLink", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetRequest")
    def reset_request(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRequest", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customLinkInput")
    def custom_link_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]]], jsii.get(self, "customLinkInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="requestInput")
    def request_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]], jsii.get(self, "requestInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customLink")
    def custom_link(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]], jsii.get(self, "customLink"))

    @custom_link.setter
    def custom_link(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]],
    ) -> None:
        jsii.set(self, "customLink", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="request")
    def request(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]], jsii.get(self, "request"))

    @request.setter
    def request(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]],
    ) -> None:
        jsii.set(self, "request", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetChangeDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequest",
    jsii_struct_bases=[],
    name_mapping={
        "apm_query": "apmQuery",
        "change_type": "changeType",
        "compare_to": "compareTo",
        "formula": "formula",
        "increase_good": "increaseGood",
        "log_query": "logQuery",
        "order_by": "orderBy",
        "order_dir": "orderDir",
        "process_query": "processQuery",
        "q": "q",
        "query": "query",
        "rum_query": "rumQuery",
        "security_query": "securityQuery",
        "show_present": "showPresent",
    },
)
class DashboardWidgetChangeDefinitionRequest:
    def __init__(
        self,
        *,
        apm_query: typing.Optional["DashboardWidgetChangeDefinitionRequestApmQuery"] = None,
        change_type: typing.Optional[builtins.str] = None,
        compare_to: typing.Optional[builtins.str] = None,
        formula: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestFormula"]]] = None,
        increase_good: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        log_query: typing.Optional["DashboardWidgetChangeDefinitionRequestLogQuery"] = None,
        order_by: typing.Optional[builtins.str] = None,
        order_dir: typing.Optional[builtins.str] = None,
        process_query: typing.Optional["DashboardWidgetChangeDefinitionRequestProcessQuery"] = None,
        q: typing.Optional[builtins.str] = None,
        query: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestQuery"]]] = None,
        rum_query: typing.Optional["DashboardWidgetChangeDefinitionRequestRumQuery"] = None,
        security_query: typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQuery"] = None,
        show_present: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param apm_query: apm_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        :param change_type: Whether to show absolute or relative change. Valid values are ``absolute``, ``relative``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
        :param compare_to: Choose from when to compare current data to. Valid values are ``hour_before``, ``day_before``, ``week_before``, ``month_before``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
        :param formula: formula block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
        :param increase_good: A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
        :param log_query: log_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        :param order_by: What to order by. Valid values are ``change``, ``name``, ``present``, ``past``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
        :param order_dir: Widget sorting method. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
        :param process_query: process_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        :param q: The metric query to use for this widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        :param query: query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param rum_query: rum_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        :param security_query: security_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        :param show_present: If set to ``true``, displays the current value. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
        '''
        if isinstance(apm_query, dict):
            apm_query = DashboardWidgetChangeDefinitionRequestApmQuery(**apm_query)
        if isinstance(log_query, dict):
            log_query = DashboardWidgetChangeDefinitionRequestLogQuery(**log_query)
        if isinstance(process_query, dict):
            process_query = DashboardWidgetChangeDefinitionRequestProcessQuery(**process_query)
        if isinstance(rum_query, dict):
            rum_query = DashboardWidgetChangeDefinitionRequestRumQuery(**rum_query)
        if isinstance(security_query, dict):
            security_query = DashboardWidgetChangeDefinitionRequestSecurityQuery(**security_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if apm_query is not None:
            self._values["apm_query"] = apm_query
        if change_type is not None:
            self._values["change_type"] = change_type
        if compare_to is not None:
            self._values["compare_to"] = compare_to
        if formula is not None:
            self._values["formula"] = formula
        if increase_good is not None:
            self._values["increase_good"] = increase_good
        if log_query is not None:
            self._values["log_query"] = log_query
        if order_by is not None:
            self._values["order_by"] = order_by
        if order_dir is not None:
            self._values["order_dir"] = order_dir
        if process_query is not None:
            self._values["process_query"] = process_query
        if q is not None:
            self._values["q"] = q
        if query is not None:
            self._values["query"] = query
        if rum_query is not None:
            self._values["rum_query"] = rum_query
        if security_query is not None:
            self._values["security_query"] = security_query
        if show_present is not None:
            self._values["show_present"] = show_present

    @builtins.property
    def apm_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestApmQuery"]:
        '''apm_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        '''
        result = self._values.get("apm_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestApmQuery"], result)

    @builtins.property
    def change_type(self) -> typing.Optional[builtins.str]:
        '''Whether to show absolute or relative change. Valid values are ``absolute``, ``relative``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
        '''
        result = self._values.get("change_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def compare_to(self) -> typing.Optional[builtins.str]:
        '''Choose from when to compare current data to. Valid values are ``hour_before``, ``day_before``, ``week_before``, ``month_before``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
        '''
        result = self._values.get("compare_to")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def formula(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestFormula"]]]:
        '''formula block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
        '''
        result = self._values.get("formula")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestFormula"]]], result)

    @builtins.property
    def increase_good(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
        '''
        result = self._values.get("increase_good")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def log_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestLogQuery"]:
        '''log_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        '''
        result = self._values.get("log_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestLogQuery"], result)

    @builtins.property
    def order_by(self) -> typing.Optional[builtins.str]:
        '''What to order by. Valid values are ``change``, ``name``, ``present``, ``past``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
        '''
        result = self._values.get("order_by")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def order_dir(self) -> typing.Optional[builtins.str]:
        '''Widget sorting method. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
        '''
        result = self._values.get("order_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def process_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestProcessQuery"]:
        '''process_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        result = self._values.get("process_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestProcessQuery"], result)

    @builtins.property
    def q(self) -> typing.Optional[builtins.str]:
        '''The metric query to use for this widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        '''
        result = self._values.get("q")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def query(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQuery"]]]:
        '''query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQuery"]]], result)

    @builtins.property
    def rum_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestRumQuery"]:
        '''rum_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        '''
        result = self._values.get("rum_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestRumQuery"], result)

    @builtins.property
    def security_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQuery"]:
        '''security_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        '''
        result = self._values.get("security_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQuery"], result)

    @builtins.property
    def show_present(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''If set to ``true``, displays the current value.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
        '''
        result = self._values.get("show_present")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestApmQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestApmQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestApmQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestApmQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestApmQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestApmQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetChangeDefinitionRequestApmQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestApmQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestApmQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestApmQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestFormula",
    jsii_struct_bases=[],
    name_mapping={
        "formula_expression": "formulaExpression",
        "alias": "alias",
        "cell_display_mode": "cellDisplayMode",
        "conditional_formats": "conditionalFormats",
        "limit": "limit",
    },
)
class DashboardWidgetChangeDefinitionRequestFormula:
    def __init__(
        self,
        *,
        formula_expression: builtins.str,
        alias: typing.Optional[builtins.str] = None,
        cell_display_mode: typing.Optional[builtins.str] = None,
        conditional_formats: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats"]]] = None,
        limit: typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaLimit"] = None,
    ) -> None:
        '''
        :param formula_expression: A string expression built from queries, formulas, and functions. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
        :param alias: An expression alias. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        :param cell_display_mode: A list of display modes for each table cell. Valid values are ``number``, ``bar``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        :param conditional_formats: conditional_formats block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
        :param limit: limit block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        if isinstance(limit, dict):
            limit = DashboardWidgetChangeDefinitionRequestFormulaLimit(**limit)
        self._values: typing.Dict[str, typing.Any] = {
            "formula_expression": formula_expression,
        }
        if alias is not None:
            self._values["alias"] = alias
        if cell_display_mode is not None:
            self._values["cell_display_mode"] = cell_display_mode
        if conditional_formats is not None:
            self._values["conditional_formats"] = conditional_formats
        if limit is not None:
            self._values["limit"] = limit

    @builtins.property
    def formula_expression(self) -> builtins.str:
        '''A string expression built from queries, formulas, and functions.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
        '''
        result = self._values.get("formula_expression")
        assert result is not None, "Required property 'formula_expression' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alias(self) -> typing.Optional[builtins.str]:
        '''An expression alias.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        '''
        result = self._values.get("alias")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cell_display_mode(self) -> typing.Optional[builtins.str]:
        '''A list of display modes for each table cell. Valid values are ``number``, ``bar``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        '''
        result = self._values.get("cell_display_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def conditional_formats(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats"]]]:
        '''conditional_formats block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
        '''
        result = self._values.get("conditional_formats")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats"]]], result)

    @builtins.property
    def limit(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaLimit"]:
        '''limit block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaLimit"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestFormula(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats",
    jsii_struct_bases=[],
    name_mapping={
        "comparator": "comparator",
        "palette": "palette",
        "value": "value",
        "custom_bg_color": "customBgColor",
        "custom_fg_color": "customFgColor",
        "hide_value": "hideValue",
        "image_url": "imageUrl",
        "metric": "metric",
        "timeframe": "timeframe",
    },
)
class DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats:
    def __init__(
        self,
        *,
        comparator: builtins.str,
        palette: builtins.str,
        value: jsii.Number,
        custom_bg_color: typing.Optional[builtins.str] = None,
        custom_fg_color: typing.Optional[builtins.str] = None,
        hide_value: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        image_url: typing.Optional[builtins.str] = None,
        metric: typing.Optional[builtins.str] = None,
        timeframe: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param comparator: The comparator to use. Valid values are ``>``, ``>=``, ``<``, ``<=``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
        :param palette: The color palette to apply. Valid values are ``blue``, ``custom_bg``, ``custom_image``, ``custom_text``, ``gray_on_white``, ``grey``, ``green``, ``orange``, ``red``, ``red_on_white``, ``white_on_gray``, ``white_on_green``, ``green_on_white``, ``white_on_red``, ``white_on_yellow``, ``yellow_on_white``, ``black_on_light_yellow``, ``black_on_light_green``, ``black_on_light_red``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        :param value: A value for the comparator. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        :param custom_bg_color: The color palette to apply to the background, same values available as palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
        :param custom_fg_color: The color palette to apply to the foreground, same values available as palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
        :param hide_value: Setting this to True hides values. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
        :param image_url: Displays an image as the background. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
        :param metric: The metric from the request to correlate with this conditional format. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param timeframe: Defines the displayed timeframe. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "comparator": comparator,
            "palette": palette,
            "value": value,
        }
        if custom_bg_color is not None:
            self._values["custom_bg_color"] = custom_bg_color
        if custom_fg_color is not None:
            self._values["custom_fg_color"] = custom_fg_color
        if hide_value is not None:
            self._values["hide_value"] = hide_value
        if image_url is not None:
            self._values["image_url"] = image_url
        if metric is not None:
            self._values["metric"] = metric
        if timeframe is not None:
            self._values["timeframe"] = timeframe

    @builtins.property
    def comparator(self) -> builtins.str:
        '''The comparator to use. Valid values are ``>``, ``>=``, ``<``, ``<=``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
        '''
        result = self._values.get("comparator")
        assert result is not None, "Required property 'comparator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def palette(self) -> builtins.str:
        '''The color palette to apply.

        Valid values are ``blue``, ``custom_bg``, ``custom_image``, ``custom_text``, ``gray_on_white``, ``grey``, ``green``, ``orange``, ``red``, ``red_on_white``, ``white_on_gray``, ``white_on_green``, ``green_on_white``, ``white_on_red``, ``white_on_yellow``, ``yellow_on_white``, ``black_on_light_yellow``, ``black_on_light_green``, ``black_on_light_red``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        result = self._values.get("palette")
        assert result is not None, "Required property 'palette' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> jsii.Number:
        '''A value for the comparator.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def custom_bg_color(self) -> typing.Optional[builtins.str]:
        '''The color palette to apply to the background, same values available as palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
        '''
        result = self._values.get("custom_bg_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def custom_fg_color(self) -> typing.Optional[builtins.str]:
        '''The color palette to apply to the foreground, same values available as palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
        '''
        result = self._values.get("custom_fg_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def hide_value(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Setting this to True hides values.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
        '''
        result = self._values.get("hide_value")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def image_url(self) -> typing.Optional[builtins.str]:
        '''Displays an image as the background.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
        '''
        result = self._values.get("image_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The metric from the request to correlate with this conditional format.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def timeframe(self) -> typing.Optional[builtins.str]:
        '''Defines the displayed timeframe.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
        '''
        result = self._values.get("timeframe")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestFormulaLimit",
    jsii_struct_bases=[],
    name_mapping={"count": "count", "order": "order"},
)
class DashboardWidgetChangeDefinitionRequestFormulaLimit:
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param count: The number of results to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        :param order: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if count is not None:
            self._values["count"] = count
        if order is not None:
            self._values["order"] = order

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''The number of results to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def order(self) -> typing.Optional[builtins.str]:
        '''The direction of the sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestFormulaLimit(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetCount")
    def reset_count(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCount", []))

    @jsii.member(jsii_name="resetOrder")
    def reset_order(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrder", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="countInput")
    def count_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "countInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="count")
    def count(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "count"))

    @count.setter
    def count(self, value: jsii.Number) -> None:
        jsii.set(self, "count", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaLimit]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaLimit], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaLimit],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestLogQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestLogQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestLogQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestLogQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestLogQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestLogQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetChangeDefinitionRequestLogQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestLogQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestLogQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestLogQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestProcessQuery",
    jsii_struct_bases=[],
    name_mapping={
        "metric": "metric",
        "filter_by": "filterBy",
        "limit": "limit",
        "search_by": "searchBy",
    },
)
class DashboardWidgetChangeDefinitionRequestProcessQuery:
    def __init__(
        self,
        *,
        metric: builtins.str,
        filter_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        limit: typing.Optional[jsii.Number] = None,
        search_by: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric: Your chosen metric. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param filter_by: A list of processes. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        :param limit: The max number of items in the filter list. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param search_by: Your chosen search term. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "metric": metric,
        }
        if filter_by is not None:
            self._values["filter_by"] = filter_by
        if limit is not None:
            self._values["limit"] = limit
        if search_by is not None:
            self._values["search_by"] = search_by

    @builtins.property
    def metric(self) -> builtins.str:
        '''Your chosen metric.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def filter_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of processes.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        '''
        result = self._values.get("filter_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The max number of items in the filter list.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def search_by(self) -> typing.Optional[builtins.str]:
        '''Your chosen search term.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        result = self._values.get("search_by")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestProcessQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFilterBy")
    def reset_filter_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFilterBy", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSearchBy")
    def reset_search_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchBy", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="filterByInput")
    def filter_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "filterByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchByInput")
    def search_by_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="filterBy")
    def filter_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "filterBy"))

    @filter_by.setter
    def filter_by(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "filterBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        jsii.set(self, "limit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        jsii.set(self, "metric", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchBy")
    def search_by(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchBy"))

    @search_by.setter
    def search_by(self, value: builtins.str) -> None:
        jsii.set(self, "searchBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestProcessQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestProcessQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestProcessQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQuery",
    jsii_struct_bases=[],
    name_mapping={
        "apm_dependency_stats_query": "apmDependencyStatsQuery",
        "apm_resource_stats_query": "apmResourceStatsQuery",
        "event_query": "eventQuery",
        "metric_query": "metricQuery",
        "process_query": "processQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestQuery:
    def __init__(
        self,
        *,
        apm_dependency_stats_query: typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery"] = None,
        apm_resource_stats_query: typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery"] = None,
        event_query: typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuery"] = None,
        metric_query: typing.Optional["DashboardWidgetChangeDefinitionRequestQueryMetricQuery"] = None,
        process_query: typing.Optional["DashboardWidgetChangeDefinitionRequestQueryProcessQuery"] = None,
    ) -> None:
        '''
        :param apm_dependency_stats_query: apm_dependency_stats_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
        :param apm_resource_stats_query: apm_resource_stats_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
        :param event_query: event_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
        :param metric_query: metric_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
        :param process_query: process_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        if isinstance(apm_dependency_stats_query, dict):
            apm_dependency_stats_query = DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery(**apm_dependency_stats_query)
        if isinstance(apm_resource_stats_query, dict):
            apm_resource_stats_query = DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery(**apm_resource_stats_query)
        if isinstance(event_query, dict):
            event_query = DashboardWidgetChangeDefinitionRequestQueryEventQuery(**event_query)
        if isinstance(metric_query, dict):
            metric_query = DashboardWidgetChangeDefinitionRequestQueryMetricQuery(**metric_query)
        if isinstance(process_query, dict):
            process_query = DashboardWidgetChangeDefinitionRequestQueryProcessQuery(**process_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if apm_dependency_stats_query is not None:
            self._values["apm_dependency_stats_query"] = apm_dependency_stats_query
        if apm_resource_stats_query is not None:
            self._values["apm_resource_stats_query"] = apm_resource_stats_query
        if event_query is not None:
            self._values["event_query"] = event_query
        if metric_query is not None:
            self._values["metric_query"] = metric_query
        if process_query is not None:
            self._values["process_query"] = process_query

    @builtins.property
    def apm_dependency_stats_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery"]:
        '''apm_dependency_stats_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
        '''
        result = self._values.get("apm_dependency_stats_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery"], result)

    @builtins.property
    def apm_resource_stats_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery"]:
        '''apm_resource_stats_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
        '''
        result = self._values.get("apm_resource_stats_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery"], result)

    @builtins.property
    def event_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuery"]:
        '''event_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
        '''
        result = self._values.get("event_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuery"], result)

    @builtins.property
    def metric_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryMetricQuery"]:
        '''metric_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
        '''
        result = self._values.get("metric_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryMetricQuery"], result)

    @builtins.property
    def process_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryProcessQuery"]:
        '''process_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        result = self._values.get("process_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryProcessQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "env": "env",
        "name": "name",
        "operation_name": "operationName",
        "resource_name": "resourceName",
        "service": "service",
        "stat": "stat",
        "is_upstream": "isUpstream",
        "primary_tag_name": "primaryTagName",
        "primary_tag_value": "primaryTagValue",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        env: builtins.str,
        name: builtins.str,
        operation_name: builtins.str,
        resource_name: builtins.str,
        service: builtins.str,
        stat: builtins.str,
        is_upstream: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        primary_tag_name: typing.Optional[builtins.str] = None,
        primary_tag_value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for APM Dependency Stats queries. Valid values are ``apm_dependency_stats``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param env: APM Environment. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param operation_name: Name of operation on service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        :param resource_name: APM resource. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        :param service: APM service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param stat: APM statistic. Valid values are ``avg_duration``, ``avg_root_duration``, ``avg_spans_per_trace``, ``error_rate``, ``pct_exec_time``, ``pct_of_traces``, ``total_traces_count``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        :param is_upstream: Determines whether stats for upstream or downstream dependencies should be queried. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
        :param primary_tag_name: The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        :param primary_tag_value: Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "data_source": data_source,
            "env": env,
            "name": name,
            "operation_name": operation_name,
            "resource_name": resource_name,
            "service": service,
            "stat": stat,
        }
        if is_upstream is not None:
            self._values["is_upstream"] = is_upstream
        if primary_tag_name is not None:
            self._values["primary_tag_name"] = primary_tag_name
        if primary_tag_value is not None:
            self._values["primary_tag_value"] = primary_tag_value

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for APM Dependency Stats queries. Valid values are ``apm_dependency_stats``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def env(self) -> builtins.str:
        '''APM Environment.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        '''
        result = self._values.get("env")
        assert result is not None, "Required property 'env' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operation_name(self) -> builtins.str:
        '''Name of operation on service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        '''
        result = self._values.get("operation_name")
        assert result is not None, "Required property 'operation_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_name(self) -> builtins.str:
        '''APM resource.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        result = self._values.get("resource_name")
        assert result is not None, "Required property 'resource_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def service(self) -> builtins.str:
        '''APM service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stat(self) -> builtins.str:
        '''APM statistic. Valid values are ``avg_duration``, ``avg_root_duration``, ``avg_spans_per_trace``, ``error_rate``, ``pct_exec_time``, ``pct_of_traces``, ``total_traces_count``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        '''
        result = self._values.get("stat")
        assert result is not None, "Required property 'stat' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def is_upstream(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Determines whether stats for upstream or downstream dependencies should be queried.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
        '''
        result = self._values.get("is_upstream")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def primary_tag_name(self) -> typing.Optional[builtins.str]:
        '''The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        '''
        result = self._values.get("primary_tag_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_value(self) -> typing.Optional[builtins.str]:
        '''Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        result = self._values.get("primary_tag_value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetIsUpstream")
    def reset_is_upstream(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsUpstream", []))

    @jsii.member(jsii_name="resetPrimaryTagName")
    def reset_primary_tag_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagName", []))

    @jsii.member(jsii_name="resetPrimaryTagValue")
    def reset_primary_tag_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagValue", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="envInput")
    def env_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "envInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isUpstreamInput")
    def is_upstream_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "isUpstreamInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="operationNameInput")
    def operation_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "operationNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagNameInput")
    def primary_tag_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagValueInput")
    def primary_tag_value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagValueInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceNameInput")
    def resource_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="serviceInput")
    def service_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serviceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statInput")
    def stat_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "statInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="env")
    def env(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "env"))

    @env.setter
    def env(self, value: builtins.str) -> None:
        jsii.set(self, "env", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isUpstream")
    def is_upstream(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "isUpstream"))

    @is_upstream.setter
    def is_upstream(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "isUpstream", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operationName"))

    @operation_name.setter
    def operation_name(self, value: builtins.str) -> None:
        jsii.set(self, "operationName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagName")
    def primary_tag_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagName"))

    @primary_tag_name.setter
    def primary_tag_name(self, value: builtins.str) -> None:
        jsii.set(self, "primaryTagName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagValue")
    def primary_tag_value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagValue"))

    @primary_tag_value.setter
    def primary_tag_value(self, value: builtins.str) -> None:
        jsii.set(self, "primaryTagValue", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceName"))

    @resource_name.setter
    def resource_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="service")
    def service(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "service"))

    @service.setter
    def service(self, value: builtins.str) -> None:
        jsii.set(self, "service", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="stat")
    def stat(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "stat"))

    @stat.setter
    def stat(self, value: builtins.str) -> None:
        jsii.set(self, "stat", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "env": "env",
        "name": "name",
        "service": "service",
        "stat": "stat",
        "group_by": "groupBy",
        "operation_name": "operationName",
        "primary_tag_name": "primaryTagName",
        "primary_tag_value": "primaryTagValue",
        "resource_name": "resourceName",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        env: builtins.str,
        name: builtins.str,
        service: builtins.str,
        stat: builtins.str,
        group_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        primary_tag_name: typing.Optional[builtins.str] = None,
        primary_tag_value: typing.Optional[builtins.str] = None,
        resource_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for APM Resource Stats queries. Valid values are ``apm_resource_stats``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param env: APM Environment. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param service: APM service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param stat: APM statistic. Valid values are ``errors``, ``error_rate``, ``hits``, ``latency_avg``, ``latency_max``, ``latency_p50``, ``latency_p75``, ``latency_p90``, ``latency_p95``, ``latency_p99``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        :param group_by: Array of fields to group results by. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param operation_name: Name of operation on service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        :param primary_tag_name: The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        :param primary_tag_value: Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        :param resource_name: APM resource. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "data_source": data_source,
            "env": env,
            "name": name,
            "service": service,
            "stat": stat,
        }
        if group_by is not None:
            self._values["group_by"] = group_by
        if operation_name is not None:
            self._values["operation_name"] = operation_name
        if primary_tag_name is not None:
            self._values["primary_tag_name"] = primary_tag_name
        if primary_tag_value is not None:
            self._values["primary_tag_value"] = primary_tag_value
        if resource_name is not None:
            self._values["resource_name"] = resource_name

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for APM Resource Stats queries. Valid values are ``apm_resource_stats``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def env(self) -> builtins.str:
        '''APM Environment.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        '''
        result = self._values.get("env")
        assert result is not None, "Required property 'env' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def service(self) -> builtins.str:
        '''APM service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stat(self) -> builtins.str:
        '''APM statistic. Valid values are ``errors``, ``error_rate``, ``hits``, ``latency_avg``, ``latency_max``, ``latency_p50``, ``latency_p75``, ``latency_p90``, ``latency_p95``, ``latency_p99``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        '''
        result = self._values.get("stat")
        assert result is not None, "Required property 'stat' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def group_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Array of fields to group results by.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def operation_name(self) -> typing.Optional[builtins.str]:
        '''Name of operation on service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        '''
        result = self._values.get("operation_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_name(self) -> typing.Optional[builtins.str]:
        '''The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        '''
        result = self._values.get("primary_tag_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_value(self) -> typing.Optional[builtins.str]:
        '''Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        result = self._values.get("primary_tag_value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''APM resource.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        result = self._values.get("resource_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetOperationName")
    def reset_operation_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOperationName", []))

    @jsii.member(jsii_name="resetPrimaryTagName")
    def reset_primary_tag_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagName", []))

    @jsii.member(jsii_name="resetPrimaryTagValue")
    def reset_primary_tag_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagValue", []))

    @jsii.member(jsii_name="resetResourceName")
    def reset_resource_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetResourceName", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="envInput")
    def env_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "envInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="operationNameInput")
    def operation_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "operationNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagNameInput")
    def primary_tag_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagValueInput")
    def primary_tag_value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagValueInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceNameInput")
    def resource_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="serviceInput")
    def service_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serviceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statInput")
    def stat_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "statInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="env")
    def env(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "env"))

    @env.setter
    def env(self, value: builtins.str) -> None:
        jsii.set(self, "env", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operationName"))

    @operation_name.setter
    def operation_name(self, value: builtins.str) -> None:
        jsii.set(self, "operationName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagName")
    def primary_tag_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagName"))

    @primary_tag_name.setter
    def primary_tag_name(self, value: builtins.str) -> None:
        jsii.set(self, "primaryTagName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagValue")
    def primary_tag_value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagValue"))

    @primary_tag_value.setter
    def primary_tag_value(self, value: builtins.str) -> None:
        jsii.set(self, "primaryTagValue", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceName"))

    @resource_name.setter
    def resource_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="service")
    def service(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "service"))

    @service.setter
    def service(self, value: builtins.str) -> None:
        jsii.set(self, "service", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="stat")
    def stat(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "stat"))

    @stat.setter
    def stat(self, value: builtins.str) -> None:
        jsii.set(self, "stat", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryEventQuery",
    jsii_struct_bases=[],
    name_mapping={
        "compute": "compute",
        "data_source": "dataSource",
        "name": "name",
        "group_by": "groupBy",
        "indexes": "indexes",
        "search": "search",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryEventQuery:
    def __init__(
        self,
        *,
        compute: typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute"]],
        data_source: builtins.str,
        name: builtins.str,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy"]]] = None,
        indexes: typing.Optional[typing.Sequence[builtins.str]] = None,
        search: typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"] = None,
    ) -> None:
        '''
        :param compute: compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
        :param data_source: The data source for event platform-based queries. Valid values are ``logs``, ``spans``, ``network``, ``rum``, ``security_signals``, ``profiles``, ``audit``, ``events``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param indexes: An array of index names to query in the stream. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
        :param search: search block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
        '''
        if isinstance(search, dict):
            search = DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch(**search)
        self._values: typing.Dict[str, typing.Any] = {
            "compute": compute,
            "data_source": data_source,
            "name": name,
        }
        if group_by is not None:
            self._values["group_by"] = group_by
        if indexes is not None:
            self._values["indexes"] = indexes
        if search is not None:
            self._values["search"] = search

    @builtins.property
    def compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute"]]:
        '''compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
        '''
        result = self._values.get("compute")
        assert result is not None, "Required property 'compute' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute"]], result)

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for event platform-based queries. Valid values are ``logs``, ``spans``, ``network``, ``rum``, ``security_signals``, ``profiles``, ``audit``, ``events``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy"]]], result)

    @builtins.property
    def indexes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of index names to query in the stream.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
        '''
        result = self._values.get("indexes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def search(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"]:
        '''search block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
        '''
        result = self._values.get("search")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "interval": "interval",
        "metric": "metric",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        interval: typing.Optional[jsii.Number] = None,
        metric: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation methods for event platform queries. Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param interval: A time interval in milliseconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        :param metric: The measurable attribute to compute. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if interval is not None:
            self._values["interval"] = interval
        if metric is not None:
            self._values["metric"] = metric

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation methods for event platform queries.

        Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''A time interval in milliseconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The measurable attribute to compute.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort": "sort"},
)
class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy:
    def __init__(
        self,
        *,
        facet: builtins.str,
        limit: typing.Optional[jsii.Number] = None,
        sort: typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort"] = None,
    ) -> None:
        '''
        :param facet: The event facet. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The number of groups to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort: sort block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        if isinstance(sort, dict):
            sort = DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort(**sort)
        self._values: typing.Dict[str, typing.Any] = {
            "facet": facet,
        }
        if limit is not None:
            self._values["limit"] = limit
        if sort is not None:
            self._values["sort"] = sort

    @builtins.property
    def facet(self) -> builtins.str:
        '''The event facet.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        assert result is not None, "Required property 'facet' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The number of groups to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort"]:
        '''sort block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        result = self._values.get("sort")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "metric": "metric", "order": "order"},
)
class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        metric: typing.Optional[builtins.str] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation methods for the event platform queries. Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param metric: The metric used for sorting group by results. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param order: Direction of sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if metric is not None:
            self._values["metric"] = metric
        if order is not None:
            self._values["order"] = order

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation methods for the event platform queries.

        Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The metric used for sorting group by results.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def order(self) -> typing.Optional[builtins.str]:
        '''Direction of sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetMetric")
    def reset_metric(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMetric", []))

    @jsii.member(jsii_name="resetOrder")
    def reset_order(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrder", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        jsii.set(self, "metric", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort],
    ) -> None:
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putSearch")
    def put_search(self, *, query: builtins.str) -> None:
        '''
        :param query: The events search string. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        value = DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch(
            query=query
        )

        return typing.cast(None, jsii.invoke(self, "putSearch", [value]))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetIndexes")
    def reset_indexes(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIndexes", []))

    @jsii.member(jsii_name="resetSearch")
    def reset_search(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearch", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="search")
    def search(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference", jsii.get(self, "search"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeInput")
    def compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]]], jsii.get(self, "computeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexesInput")
    def indexes_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "indexesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchInput")
    def search_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"], jsii.get(self, "searchInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="compute")
    def compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]], jsii.get(self, "compute"))

    @compute.setter
    def compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]],
    ) -> None:
        jsii.set(self, "compute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexes")
    def indexes(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "indexes"))

    @indexes.setter
    def indexes(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "indexes", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch",
    jsii_struct_bases=[],
    name_mapping={"query": "query"},
)
class DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch:
    def __init__(self, *, query: builtins.str) -> None:
        '''
        :param query: The events search string. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "query": query,
        }

    @builtins.property
    def query(self) -> builtins.str:
        '''The events search string.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="queryInput")
    def query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "queryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="query")
    def query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "query"))

    @query.setter
    def query(self, value: builtins.str) -> None:
        jsii.set(self, "query", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryMetricQuery",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "query": "query",
        "aggregator": "aggregator",
        "data_source": "dataSource",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryMetricQuery:
    def __init__(
        self,
        *,
        name: builtins.str,
        query: builtins.str,
        aggregator: typing.Optional[builtins.str] = None,
        data_source: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: The name of the query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param query: The metrics query definition. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param aggregator: The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        :param data_source: The data source for metrics queries. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "query": query,
        }
        if aggregator is not None:
            self._values["aggregator"] = aggregator
        if data_source is not None:
            self._values["data_source"] = data_source

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def query(self) -> builtins.str:
        '''The metrics query definition.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aggregator(self) -> typing.Optional[builtins.str]:
        '''The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        '''
        result = self._values.get("aggregator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def data_source(self) -> typing.Optional[builtins.str]:
        '''The data source for metrics queries.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryMetricQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetAggregator")
    def reset_aggregator(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAggregator", []))

    @jsii.member(jsii_name="resetDataSource")
    def reset_data_source(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDataSource", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregatorInput")
    def aggregator_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregatorInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="queryInput")
    def query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "queryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregator")
    def aggregator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregator"))

    @aggregator.setter
    def aggregator(self, value: builtins.str) -> None:
        jsii.set(self, "aggregator", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="query")
    def query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "query"))

    @query.setter
    def query(self, value: builtins.str) -> None:
        jsii.set(self, "query", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryMetricQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryMetricQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryMetricQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryProcessQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "metric": "metric",
        "name": "name",
        "aggregator": "aggregator",
        "is_normalized_cpu": "isNormalizedCpu",
        "limit": "limit",
        "sort": "sort",
        "tag_filters": "tagFilters",
        "text_filter": "textFilter",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryProcessQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        metric: builtins.str,
        name: builtins.str,
        aggregator: typing.Optional[builtins.str] = None,
        is_normalized_cpu: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort: typing.Optional[builtins.str] = None,
        tag_filters: typing.Optional[typing.Sequence[builtins.str]] = None,
        text_filter: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for process queries. Valid values are ``process``, ``container``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param metric: The process metric name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param aggregator: The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        :param is_normalized_cpu: Whether to normalize the CPU percentages. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
        :param limit: The number of hits to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        :param tag_filters: An array of tags to filter by. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
        :param text_filter: The text to use as a filter. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "data_source": data_source,
            "metric": metric,
            "name": name,
        }
        if aggregator is not None:
            self._values["aggregator"] = aggregator
        if is_normalized_cpu is not None:
            self._values["is_normalized_cpu"] = is_normalized_cpu
        if limit is not None:
            self._values["limit"] = limit
        if sort is not None:
            self._values["sort"] = sort
        if tag_filters is not None:
            self._values["tag_filters"] = tag_filters
        if text_filter is not None:
            self._values["text_filter"] = text_filter

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for process queries. Valid values are ``process``, ``container``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def metric(self) -> builtins.str:
        '''The process metric name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aggregator(self) -> typing.Optional[builtins.str]:
        '''The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        '''
        result = self._values.get("aggregator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def is_normalized_cpu(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Whether to normalize the CPU percentages.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
        '''
        result = self._values.get("is_normalized_cpu")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The number of hits to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort(self) -> typing.Optional[builtins.str]:
        '''The direction of the sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        result = self._values.get("sort")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tag_filters(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of tags to filter by.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
        '''
        result = self._values.get("tag_filters")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def text_filter(self) -> typing.Optional[builtins.str]:
        '''The text to use as a filter.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
        '''
        result = self._values.get("text_filter")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryProcessQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetAggregator")
    def reset_aggregator(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAggregator", []))

    @jsii.member(jsii_name="resetIsNormalizedCpu")
    def reset_is_normalized_cpu(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsNormalizedCpu", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSort")
    def reset_sort(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSort", []))

    @jsii.member(jsii_name="resetTagFilters")
    def reset_tag_filters(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTagFilters", []))

    @jsii.member(jsii_name="resetTextFilter")
    def reset_text_filter(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTextFilter", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregatorInput")
    def aggregator_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregatorInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isNormalizedCpuInput")
    def is_normalized_cpu_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "isNormalizedCpuInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="sortInput")
    def sort_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "sortInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagFiltersInput")
    def tag_filters_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "tagFiltersInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textFilterInput")
    def text_filter_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "textFilterInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregator")
    def aggregator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregator"))

    @aggregator.setter
    def aggregator(self, value: builtins.str) -> None:
        jsii.set(self, "aggregator", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isNormalizedCpu")
    def is_normalized_cpu(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "isNormalizedCpu"))

    @is_normalized_cpu.setter
    def is_normalized_cpu(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "isNormalizedCpu", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        jsii.set(self, "limit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        jsii.set(self, "metric", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="sort")
    def sort(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "sort"))

    @sort.setter
    def sort(self, value: builtins.str) -> None:
        jsii.set(self, "sort", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagFilters")
    def tag_filters(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "tagFilters"))

    @tag_filters.setter
    def tag_filters(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "tagFilters", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textFilter")
    def text_filter(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "textFilter"))

    @text_filter.setter
    def text_filter(self, value: builtins.str) -> None:
        jsii.set(self, "textFilter", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryProcessQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryProcessQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryProcessQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestRumQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestRumQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestRumQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestRumQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestRumQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestRumQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetChangeDefinitionRequestRumQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestRumQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestRumQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestRumQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestRumQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestRumQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestSecurityQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestSecurityQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetCheckStatusDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "check": "check",
        "grouping": "grouping",
        "group": "group",
        "group_by": "groupBy",
        "live_span": "liveSpan",
        "tags": "tags",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetCheckStatusDefinition:
    def __init__(
        self,
        *,
        check: builtins.str,
        grouping: builtins.str,
        group: typing.Optional[builtins.str] = None,
        group_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        live_span: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param check: The check to use in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check Dashboard#check}
        :param grouping: The kind of grouping to use. Valid values are ``check``, ``cluster``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#grouping Dashboard#grouping}
        :param group: The check group to use in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group Dashboard#group}
        :param group_by: When ``grouping = "cluster"``, indicates a list of tags to use for grouping. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param tags: A list of tags to use in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags Dashboard#tags}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "check": check,
            "grouping": grouping,
        }
        if group is not None:
            self._values["group"] = group
        if group_by is not None:
            self._values["group_by"] = group_by
        if live_span is not None:
            self._values["live_span"] = live_span
        if tags is not None:
            self._values["tags"] = tags
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def check(self) -> builtins.str:
        '''The check to use in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check Dashboard#check}
        '''
        result = self._values.get("check")
        assert result is not None, "Required property 'check' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def grouping(self) -> builtins.str:
        '''The kind of grouping to use. Valid values are ``check``, ``cluster``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#grouping Dashboard#grouping}
        '''
        result = self._values.get("grouping")
        assert result is not None, "Required property 'grouping' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def group(self) -> typing.Optional[builtins.str]:
        '''The check group to use in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group Dashboard#group}
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def group_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''When ``grouping = "cluster"``, indicates a list of tags to use for grouping.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of tags to use in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags Dashboard#tags}
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetCheckStatusDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetCheckStatusDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetCheckStatusDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetGroup")
    def reset_group(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroup", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTags", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="checkInput")
    def check_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "checkInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupingInput")
    def grouping_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "groupingInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupInput")
    def group_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "groupInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "tagsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="check")
    def check(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "check"))

    @check.setter
    def check(self, value: builtins.str) -> None:
        jsii.set(self, "check", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="group")
    def group(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "group"))

    @group.setter
    def group(self, value: builtins.str) -> None:
        jsii.set(self, "group", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="grouping")
    def grouping(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "grouping"))

    @grouping.setter
    def grouping(self, value: builtins.str) -> None:
        jsii.set(self, "grouping", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "tags"))

    @tags.setter
    def tags(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetCheckStatusDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetCheckStatusDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetCheckStatusDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "legend_size": "legendSize",
        "live_span": "liveSpan",
        "request": "request",
        "show_legend": "showLegend",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetDistributionDefinition:
    def __init__(
        self,
        *,
        legend_size: typing.Optional[builtins.str] = None,
        live_span: typing.Optional[builtins.str] = None,
        request: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequest"]]] = None,
        show_legend: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param legend_size: The size of the legend displayed in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#legend_size Dashboard#legend_size}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param request: request block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        :param show_legend: Whether or not to show the legend on this widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_legend Dashboard#show_legend}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if legend_size is not None:
            self._values["legend_size"] = legend_size
        if live_span is not None:
            self._values["live_span"] = live_span
        if request is not None:
            self._values["request"] = request
        if show_legend is not None:
            self._values["show_legend"] = show_legend
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def legend_size(self) -> typing.Optional[builtins.str]:
        '''The size of the legend displayed in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#legend_size Dashboard#legend_size}
        '''
        result = self._values.get("legend_size")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def request(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]]:
        '''request block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        '''
        result = self._values.get("request")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]], result)

    @builtins.property
    def show_legend(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Whether or not to show the legend on this widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_legend Dashboard#show_legend}
        '''
        result = self._values.get("show_legend")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetLegendSize")
    def reset_legend_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLegendSize", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetRequest")
    def reset_request(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRequest", []))

    @jsii.member(jsii_name="resetShowLegend")
    def reset_show_legend(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShowLegend", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="legendSizeInput")
    def legend_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "legendSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="requestInput")
    def request_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]], jsii.get(self, "requestInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="showLegendInput")
    def show_legend_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "showLegendInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="legendSize")
    def legend_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "legendSize"))

    @legend_size.setter
    def legend_size(self, value: builtins.str) -> None:
        jsii.set(self, "legendSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="request")
    def request(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]], jsii.get(self, "request"))

    @request.setter
    def request(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]],
    ) -> None:
        jsii.set(self, "request", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="showLegend")
    def show_legend(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "showLegend"))

    @show_legend.setter
    def show_legend(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "showLegend", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetDistributionDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequest",
    jsii_struct_bases=[],
    name_mapping={
        "apm_query": "apmQuery",
        "log_query": "logQuery",
        "process_query": "processQuery",
        "q": "q",
        "rum_query": "rumQuery",
        "security_query": "securityQuery",
        "style": "style",
    },
)
class DashboardWidgetDistributionDefinitionRequest:
    def __init__(
        self,
        *,
        apm_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQuery"] = None,
        log_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQuery"] = None,
        process_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestProcessQuery"] = None,
        q: typing.Optional[builtins.str] = None,
        rum_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQuery"] = None,
        security_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQuery"] = None,
        style: typing.Optional["DashboardWidgetDistributionDefinitionRequestStyle"] = None,
    ) -> None:
        '''
        :param apm_query: apm_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        :param log_query: log_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        :param process_query: process_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        :param q: The metric query to use for this widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        :param rum_query: rum_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        :param security_query: security_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        :param style: style block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
        '''
        if isinstance(apm_query, dict):
            apm_query = DashboardWidgetDistributionDefinitionRequestApmQuery(**apm_query)
        if isinstance(log_query, dict):
            log_query = DashboardWidgetDistributionDefinitionRequestLogQuery(**log_query)
        if isinstance(process_query, dict):
            process_query = DashboardWidgetDistributionDefinitionRequestProcessQuery(**process_query)
        if isinstance(rum_query, dict):
            rum_query = DashboardWidgetDistributionDefinitionRequestRumQuery(**rum_query)
        if isinstance(security_query, dict):
            security_query = DashboardWidgetDistributionDefinitionRequestSecurityQuery(**security_query)
        if isinstance(style, dict):
            style = DashboardWidgetDistributionDefinitionRequestStyle(**style)
        self._values: typing.Dict[str, typing.Any] = {}
        if apm_query is not None:
            self._values["apm_query"] = apm_query
        if log_query is not None:
            self._values["log_query"] = log_query
        if process_query is not None:
            self._values["process_query"] = process_query
        if q is not None:
            self._values["q"] = q
        if rum_query is not None:
            self._values["rum_query"] = rum_query
        if security_query is not None:
            self._values["security_query"] = security_query
        if style is not None:
            self._values["style"] = style

    @builtins.property
    def apm_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQuery"]:
        '''apm_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        '''
        result = self._values.get("apm_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQuery"], result)

    @builtins.property
    def log_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQuery"]:
        '''log_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        '''
        result = self._values.get("log_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQuery"], result)

    @builtins.property
    def process_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestProcessQuery"]:
        '''process_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        result = self._values.get("process_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestProcessQuery"], result)

    @builtins.property
    def q(self) -> typing.Optional[builtins.str]:
        '''The metric query to use for this widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        '''
        result = self._values.get("q")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rum_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQuery"]:
        '''rum_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        '''
        result = self._values.get("rum_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQuery"], result)

    @builtins.property
    def security_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQuery"]:
        '''security_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        '''
        result = self._values.get("security_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQuery"], result)

    @builtins.property
    def style(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestStyle"]:
        '''style block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
        '''
        result = self._values.get("style")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestStyle"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestApmQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetDistributionDefinitionRequestApmQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestLogQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetDistributionDefinitionRequestLogQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestProcessQuery",
    jsii_struct_bases=[],
    name_mapping={
        "metric": "metric",
        "filter_by": "filterBy",
        "limit": "limit",
        "search_by": "searchBy",
    },
)
class DashboardWidgetDistributionDefinitionRequestProcessQuery:
    def __init__(
        self,
        *,
        metric: builtins.str,
        filter_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        limit: typing.Optional[jsii.Number] = None,
        search_by: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric: Your chosen metric. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param filter_by: A list of processes. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        :param limit: The max number of items in the filter list. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param search_by: Your chosen search term. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "metric": metric,
        }
        if filter_by is not None:
            self._values["filter_by"] = filter_by
        if limit is not None:
            self._values["limit"] = limit
        if search_by is not None:
            self._values["search_by"] = search_by

    @builtins.property
    def metric(self) -> builtins.str:
        '''Your chosen metric.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def filter_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of processes.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        '''
        result = self._values.get("filter_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The max number of items in the filter list.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def search_by(self) -> typing.Optional[builtins.str]:
        '''Your chosen search term.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        result = self._values.get("search_by")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestProcessQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFilterBy")
    def reset_filter_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFilterBy", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSearchBy")
    def reset_search_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchBy", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="filterByInput")
    def filter_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "filterByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchByInput")
    def search_by_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="filterBy")
    def filter_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "filterBy"))

    @filter_by.setter
    def filter_by(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "filterBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        jsii.set(self, "limit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        jsii.set(self, "metric", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchBy")
    def search_by(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchBy"))

    @search_by.setter
    def search_by(self, value: builtins.str) -> None:
        jsii.set(self, "searchBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestProcessQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestProcessQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestProcessQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestRumQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetDistributionDefinitionRequestRumQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestSecurityQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetDistributionDefinitionRequestSecurityQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestSecurityQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestSecurityQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestStyle",
    jsii_struct_bases=[],
    name_mapping={"palette": "palette"},
)
class DashboardWidgetDistributionDefinitionRequestStyle:
    def __init__(self, *, palette: typing.Optional[builtins.str] = None) -> None:
        '''
        :param palette: A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if palette is not None:
            self._values["palette"] = palette

    @builtins.property
    def palette(self) -> typing.Optional[builtins.str]:
        '''A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        result = self._values.get("palette")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestStyle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestStyleOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetDistributionDefinitionRequestStyleOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetPalette")
    def reset_palette(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPalette", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="paletteInput")
    def palette_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "paletteInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="palette")
    def palette(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "palette"))

    @palette.setter
    def palette(self, value: builtins.str) -> None:
        jsii.set(self, "palette", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestStyle]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestStyle], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestStyle],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetEventStreamDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "query": "query",
        "event_size": "eventSize",
        "live_span": "liveSpan",
        "tags_execution": "tagsExecution",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetEventStreamDefinition:
    def __init__(
        self,
        *,
        query: builtins.str,
        event_size: typing.Optional[builtins.str] = None,
        live_span: typing.Optional[builtins.str] = None,
        tags_execution: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param query: The query to use in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param event_size: The size to use to display an event. Valid values are ``s``, ``l``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_size Dashboard#event_size}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param tags_execution: The execution method for multi-value filters, options: ``and`` or ``or``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "query": query,
        }
        if event_size is not None:
            self._values["event_size"] = event_size
        if live_span is not None:
            self._values["live_span"] = live_span
        if tags_execution is not None:
            self._values["tags_execution"] = tags_execution
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def query(self) -> builtins.str:
        '''The query to use in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def event_size(self) -> typing.Optional[builtins.str]:
        '''The size to use to display an event. Valid values are ``s``, ``l``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_size Dashboard#event_size}
        '''
        result = self._values.get("event_size")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags_execution(self) -> typing.Optional[builtins.str]:
        '''The execution method for multi-value filters, options: ``and`` or ``or``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
        '''
        result = self._values.get("tags_execution")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetEventStreamDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetEventStreamDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetEventStreamDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetEventSize")
    def reset_event_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEventSize", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetTagsExecution")
    def reset_tags_execution(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTagsExecution", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="eventSizeInput")
    def event_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "eventSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="queryInput")
    def query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "queryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagsExecutionInput")
    def tags_execution_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "tagsExecutionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="eventSize")
    def event_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "eventSize"))

    @event_size.setter
    def event_size(self, value: builtins.str) -> None:
        jsii.set(self, "eventSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="query")
    def query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "query"))

    @query.setter
    def query(self, value: builtins.str) -> None:
        jsii.set(self, "query", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagsExecution")
    def tags_execution(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "tagsExecution"))

    @tags_execution.setter
    def tags_execution(self, value: builtins.str) -> None:
        jsii.set(self, "tagsExecution", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetEventStreamDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetEventStreamDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetEventStreamDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetEventTimelineDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "query": "query",
        "live_span": "liveSpan",
        "tags_execution": "tagsExecution",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetEventTimelineDefinition:
    def __init__(
        self,
        *,
        query: builtins.str,
        live_span: typing.Optional[builtins.str] = None,
        tags_execution: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param query: The query to use in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param tags_execution: The execution method for multi-value filters, options: ``and`` or ``or``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "query": query,
        }
        if live_span is not None:
            self._values["live_span"] = live_span
        if tags_execution is not None:
            self._values["tags_execution"] = tags_execution
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def query(self) -> builtins.str:
        '''The query to use in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags_execution(self) -> typing.Optional[builtins.str]:
        '''The execution method for multi-value filters, options: ``and`` or ``or``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
        '''
        result = self._values.get("tags_execution")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetEventTimelineDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetEventTimelineDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetEventTimelineDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetTagsExecution")
    def reset_tags_execution(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTagsExecution", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="queryInput")
    def query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "queryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagsExecutionInput")
    def tags_execution_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "tagsExecutionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="query")
    def query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "query"))

    @query.setter
    def query(self, value: builtins.str) -> None:
        jsii.set(self, "query", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagsExecution")
    def tags_execution(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "tagsExecution"))

    @tags_execution.setter
    def tags_execution(self, value: builtins.str) -> None:
        jsii.set(self, "tagsExecution", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetEventTimelineDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetEventTimelineDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetEventTimelineDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetFreeTextDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "text": "text",
        "color": "color",
        "font_size": "fontSize",
        "text_align": "textAlign",
    },
)
class DashboardWidgetFreeTextDefinition:
    def __init__(
        self,
        *,
        text: builtins.str,
        color: typing.Optional[builtins.str] = None,
        font_size: typing.Optional[builtins.str] = None,
        text_align: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param text: The text to display in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text Dashboard#text}
        :param color: The color of the text in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#color Dashboard#color}
        :param font_size: The size of the text in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#font_size Dashboard#font_size}
        :param text_align: The alignment of the text in the widget. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "text": text,
        }
        if color is not None:
            self._values["color"] = color
        if font_size is not None:
            self._values["font_size"] = font_size
        if text_align is not None:
            self._values["text_align"] = text_align

    @builtins.property
    def text(self) -> builtins.str:
        '''The text to display in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text Dashboard#text}
        '''
        result = self._values.get("text")
        assert result is not None, "Required property 'text' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def color(self) -> typing.Optional[builtins.str]:
        '''The color of the text in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#color Dashboard#color}
        '''
        result = self._values.get("color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def font_size(self) -> typing.Optional[builtins.str]:
        '''The size of the text in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#font_size Dashboard#font_size}
        '''
        result = self._values.get("font_size")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def text_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the text in the widget. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
        '''
        result = self._values.get("text_align")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetFreeTextDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetFreeTextDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetFreeTextDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetColor")
    def reset_color(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetColor", []))

    @jsii.member(jsii_name="resetFontSize")
    def reset_font_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFontSize", []))

    @jsii.member(jsii_name="resetTextAlign")
    def reset_text_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTextAlign", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="colorInput")
    def color_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "colorInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fontSizeInput")
    def font_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "fontSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textAlignInput")
    def text_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "textAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textInput")
    def text_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "textInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="color")
    def color(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "color"))

    @color.setter
    def color(self, value: builtins.str) -> None:
        jsii.set(self, "color", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fontSize")
    def font_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "fontSize"))

    @font_size.setter
    def font_size(self, value: builtins.str) -> None:
        jsii.set(self, "fontSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="text")
    def text(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "text"))

    @text.setter
    def text(self, value: builtins.str) -> None:
        jsii.set(self, "text", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textAlign")
    def text_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "textAlign"))

    @text_align.setter
    def text_align(self, value: builtins.str) -> None:
        jsii.set(self, "textAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetFreeTextDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetFreeTextDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetFreeTextDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "view": "view",
        "custom_link": "customLink",
        "live_span": "liveSpan",
        "request": "request",
        "style": "style",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetGeomapDefinition:
    def __init__(
        self,
        *,
        view: "DashboardWidgetGeomapDefinitionView",
        custom_link: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionCustomLink"]]] = None,
        live_span: typing.Optional[builtins.str] = None,
        request: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequest"]]] = None,
        style: typing.Optional["DashboardWidgetGeomapDefinitionStyle"] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param view: view block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#view Dashboard#view}
        :param custom_link: custom_link block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param request: request block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        :param style: style block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        if isinstance(view, dict):
            view = DashboardWidgetGeomapDefinitionView(**view)
        if isinstance(style, dict):
            style = DashboardWidgetGeomapDefinitionStyle(**style)
        self._values: typing.Dict[str, typing.Any] = {
            "view": view,
        }
        if custom_link is not None:
            self._values["custom_link"] = custom_link
        if live_span is not None:
            self._values["live_span"] = live_span
        if request is not None:
            self._values["request"] = request
        if style is not None:
            self._values["style"] = style
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def view(self) -> "DashboardWidgetGeomapDefinitionView":
        '''view block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#view Dashboard#view}
        '''
        result = self._values.get("view")
        assert result is not None, "Required property 'view' is missing"
        return typing.cast("DashboardWidgetGeomapDefinitionView", result)

    @builtins.property
    def custom_link(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionCustomLink"]]]:
        '''custom_link block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
        '''
        result = self._values.get("custom_link")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionCustomLink"]]], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def request(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequest"]]]:
        '''request block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        '''
        result = self._values.get("request")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequest"]]], result)

    @builtins.property
    def style(self) -> typing.Optional["DashboardWidgetGeomapDefinitionStyle"]:
        '''style block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
        '''
        result = self._values.get("style")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionStyle"], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionCustomLink",
    jsii_struct_bases=[],
    name_mapping={
        "is_hidden": "isHidden",
        "label": "label",
        "link": "link",
        "override_label": "overrideLabel",
    },
)
class DashboardWidgetGeomapDefinitionCustomLink:
    def __init__(
        self,
        *,
        is_hidden: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        label: typing.Optional[builtins.str] = None,
        link: typing.Optional[builtins.str] = None,
        override_label: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param is_hidden: The flag for toggling context menu link visibility. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
        :param label: The label for the custom link URL. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
        :param link: The URL of the custom link. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
        :param override_label: The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if is_hidden is not None:
            self._values["is_hidden"] = is_hidden
        if label is not None:
            self._values["label"] = label
        if link is not None:
            self._values["link"] = link
        if override_label is not None:
            self._values["override_label"] = override_label

    @builtins.property
    def is_hidden(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''The flag for toggling context menu link visibility.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
        '''
        result = self._values.get("is_hidden")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def label(self) -> typing.Optional[builtins.str]:
        '''The label for the custom link URL.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
        '''
        result = self._values.get("label")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def link(self) -> typing.Optional[builtins.str]:
        '''The URL of the custom link.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
        '''
        result = self._values.get("link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def override_label(self) -> typing.Optional[builtins.str]:
        '''The label id that refers to a context menu link item.

        When override_label is provided, the client request omits the label field.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
        '''
        result = self._values.get("override_label")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionCustomLink(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putStyle")
    def put_style(
        self,
        *,
        palette: builtins.str,
        palette_flip: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        '''
        :param palette: The color palette to apply to the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        :param palette_flip: A Boolean indicating whether to flip the palette tones. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_flip Dashboard#palette_flip}
        '''
        value = DashboardWidgetGeomapDefinitionStyle(
            palette=palette, palette_flip=palette_flip
        )

        return typing.cast(None, jsii.invoke(self, "putStyle", [value]))

    @jsii.member(jsii_name="putView")
    def put_view(self, *, focus: builtins.str) -> None:
        '''
        :param focus: The two-letter ISO code of a country to focus the map on (or ``WORLD``). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#focus Dashboard#focus}
        '''
        value = DashboardWidgetGeomapDefinitionView(focus=focus)

        return typing.cast(None, jsii.invoke(self, "putView", [value]))

    @jsii.member(jsii_name="resetCustomLink")
    def reset_custom_link(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomLink", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetRequest")
    def reset_request(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRequest", []))

    @jsii.member(jsii_name="resetStyle")
    def reset_style(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStyle", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="style")
    def style(self) -> "DashboardWidgetGeomapDefinitionStyleOutputReference":
        return typing.cast("DashboardWidgetGeomapDefinitionStyleOutputReference", jsii.get(self, "style"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="view")
    def view(self) -> "DashboardWidgetGeomapDefinitionViewOutputReference":
        return typing.cast("DashboardWidgetGeomapDefinitionViewOutputReference", jsii.get(self, "view"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customLinkInput")
    def custom_link_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionCustomLink]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionCustomLink]]], jsii.get(self, "customLinkInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="requestInput")
    def request_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequest"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequest"]]], jsii.get(self, "requestInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="styleInput")
    def style_input(self) -> typing.Optional["DashboardWidgetGeomapDefinitionStyle"]:
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionStyle"], jsii.get(self, "styleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="viewInput")
    def view_input(self) -> typing.Optional["DashboardWidgetGeomapDefinitionView"]:
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionView"], jsii.get(self, "viewInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customLink")
    def custom_link(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionCustomLink]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionCustomLink]], jsii.get(self, "customLink"))

    @custom_link.setter
    def custom_link(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionCustomLink]],
    ) -> None:
        jsii.set(self, "customLink", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="request")
    def request(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequest"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequest"]], jsii.get(self, "request"))

    @request.setter
    def request(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequest"]],
    ) -> None:
        jsii.set(self, "request", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetGeomapDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequest",
    jsii_struct_bases=[],
    name_mapping={
        "formula": "formula",
        "log_query": "logQuery",
        "q": "q",
        "query": "query",
        "rum_query": "rumQuery",
    },
)
class DashboardWidgetGeomapDefinitionRequest:
    def __init__(
        self,
        *,
        formula: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestFormula"]]] = None,
        log_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQuery"] = None,
        q: typing.Optional[builtins.str] = None,
        query: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestQuery"]]] = None,
        rum_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQuery"] = None,
    ) -> None:
        '''
        :param formula: formula block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
        :param log_query: log_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        :param q: The metric query to use for this widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        :param query: query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param rum_query: rum_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        '''
        if isinstance(log_query, dict):
            log_query = DashboardWidgetGeomapDefinitionRequestLogQuery(**log_query)
        if isinstance(rum_query, dict):
            rum_query = DashboardWidgetGeomapDefinitionRequestRumQuery(**rum_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if formula is not None:
            self._values["formula"] = formula
        if log_query is not None:
            self._values["log_query"] = log_query
        if q is not None:
            self._values["q"] = q
        if query is not None:
            self._values["query"] = query
        if rum_query is not None:
            self._values["rum_query"] = rum_query

    @builtins.property
    def formula(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestFormula"]]]:
        '''formula block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
        '''
        result = self._values.get("formula")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestFormula"]]], result)

    @builtins.property
    def log_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQuery"]:
        '''log_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        '''
        result = self._values.get("log_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQuery"], result)

    @builtins.property
    def q(self) -> typing.Optional[builtins.str]:
        '''The metric query to use for this widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        '''
        result = self._values.get("q")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def query(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestQuery"]]]:
        '''query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestQuery"]]], result)

    @builtins.property
    def rum_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQuery"]:
        '''rum_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        '''
        result = self._values.get("rum_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestFormula",
    jsii_struct_bases=[],
    name_mapping={
        "formula_expression": "formulaExpression",
        "alias": "alias",
        "cell_display_mode": "cellDisplayMode",
        "conditional_formats": "conditionalFormats",
        "limit": "limit",
    },
)
class DashboardWidgetGeomapDefinitionRequestFormula:
    def __init__(
        self,
        *,
        formula_expression: builtins.str,
        alias: typing.Optional[builtins.str] = None,
        cell_display_mode: typing.Optional[builtins.str] = None,
        conditional_formats: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats"]]] = None,
        limit: typing.Optional["DashboardWidgetGeomapDefinitionRequestFormulaLimit"] = None,
    ) -> None:
        '''
        :param formula_expression: A string expression built from queries, formulas, and functions. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
        :param alias: An expression alias. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        :param cell_display_mode: A list of display modes for each table cell. Valid values are ``number``, ``bar``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        :param conditional_formats: conditional_formats block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
        :param limit: limit block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        if isinstance(limit, dict):
            limit = DashboardWidgetGeomapDefinitionRequestFormulaLimit(**limit)
        self._values: typing.Dict[str, typing.Any] = {
            "formula_expression": formula_expression,
        }
        if alias is not None:
            self._values["alias"] = alias
        if cell_display_mode is not None:
            self._values["cell_display_mode"] = cell_display_mode
        if conditional_formats is not None:
            self._values["conditional_formats"] = conditional_formats
        if limit is not None:
            self._values["limit"] = limit

    @builtins.property
    def formula_expression(self) -> builtins.str:
        '''A string expression built from queries, formulas, and functions.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
        '''
        result = self._values.get("formula_expression")
        assert result is not None, "Required property 'formula_expression' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alias(self) -> typing.Optional[builtins.str]:
        '''An expression alias.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        '''
        result = self._values.get("alias")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cell_display_mode(self) -> typing.Optional[builtins.str]:
        '''A list of display modes for each table cell. Valid values are ``number``, ``bar``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        '''
        result = self._values.get("cell_display_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def conditional_formats(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats"]]]:
        '''conditional_formats block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
        '''
        result = self._values.get("conditional_formats")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats"]]], result)

    @builtins.property
    def limit(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestFormulaLimit"]:
        '''limit block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestFormulaLimit"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestFormula(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats",
    jsii_struct_bases=[],
    name_mapping={
        "comparator": "comparator",
        "palette": "palette",
        "value": "value",
        "custom_bg_color": "customBgColor",
        "custom_fg_color": "customFgColor",
        "hide_value": "hideValue",
        "image_url": "imageUrl",
        "metric": "metric",
        "timeframe": "timeframe",
    },
)
class DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats:
    def __init__(
        self,
        *,
        comparator: builtins.str,
        palette: builtins.str,
        value: jsii.Number,
        custom_bg_color: typing.Optional[builtins.str] = None,
        custom_fg_color: typing.Optional[builtins.str] = None,
        hide_value: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        image_url: typing.Optional[builtins.str] = None,
        metric: typing.Optional[builtins.str] = None,
        timeframe: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param comparator: The comparator to use. Valid values are ``>``, ``>=``, ``<``, ``<=``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
        :param palette: The color palette to apply. Valid values are ``blue``, ``custom_bg``, ``custom_image``, ``custom_text``, ``gray_on_white``, ``grey``, ``green``, ``orange``, ``red``, ``red_on_white``, ``white_on_gray``, ``white_on_green``, ``green_on_white``, ``white_on_red``, ``white_on_yellow``, ``yellow_on_white``, ``black_on_light_yellow``, ``black_on_light_green``, ``black_on_light_red``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        :param value: A value for the comparator. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        :param custom_bg_color: The color palette to apply to the background, same values available as palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
        :param custom_fg_color: The color palette to apply to the foreground, same values available as palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
        :param hide_value: Setting this to True hides values. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
        :param image_url: Displays an image as the background. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
        :param metric: The metric from the request to correlate with this conditional format. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param timeframe: Defines the displayed timeframe. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "comparator": comparator,
            "palette": palette,
            "value": value,
        }
        if custom_bg_color is not None:
            self._values["custom_bg_color"] = custom_bg_color
        if custom_fg_color is not None:
            self._values["custom_fg_color"] = custom_fg_color
        if hide_value is not None:
            self._values["hide_value"] = hide_value
        if image_url is not None:
            self._values["image_url"] = image_url
        if metric is not None:
            self._values["metric"] = metric
        if timeframe is not None:
            self._values["timeframe"] = timeframe

    @builtins.property
    def comparator(self) -> builtins.str:
        '''The comparator to use. Valid values are ``>``, ``>=``, ``<``, ``<=``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
        '''
        result = self._values.get("comparator")
        assert result is not None, "Required property 'comparator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def palette(self) -> builtins.str:
        '''The color palette to apply.

        Valid values are ``blue``, ``custom_bg``, ``custom_image``, ``custom_text``, ``gray_on_white``, ``grey``, ``green``, ``orange``, ``red``, ``red_on_white``, ``white_on_gray``, ``white_on_green``, ``green_on_white``, ``white_on_red``, ``white_on_yellow``, ``yellow_on_white``, ``black_on_light_yellow``, ``black_on_light_green``, ``black_on_light_red``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        result = self._values.get("palette")
        assert result is not None, "Required property 'palette' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> jsii.Number:
        '''A value for the comparator.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def custom_bg_color(self) -> typing.Optional[builtins.str]:
        '''The color palette to apply to the background, same values available as palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
        '''
        result = self._values.get("custom_bg_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def custom_fg_color(self) -> typing.Optional[builtins.str]:
        '''The color palette to apply to the foreground, same values available as palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
        '''
        result = self._values.get("custom_fg_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def hide_value(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Setting this to True hides values.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
        '''
        result = self._values.get("hide_value")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def image_url(self) -> typing.Optional[builtins.str]:
        '''Displays an image as the background.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
        '''
        result = self._values.get("image_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The metric from the request to correlate with this conditional format.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def timeframe(self) -> typing.Optional[builtins.str]:
        '''Defines the displayed timeframe.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
        '''
        result = self._values.get("timeframe")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestFormulaLimit",
    jsii_struct_bases=[],
    name_mapping={"count": "count", "order": "order"},
)
class DashboardWidgetGeomapDefinitionRequestFormulaLimit:
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param count: The number of results to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        :param order: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if count is not None:
            self._values["count"] = count
        if order is not None:
            self._values["order"] = order

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''The number of results to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def order(self) -> typing.Optional[builtins.str]:
        '''The direction of the sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestFormulaLimit(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestFormulaLimitOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestFormulaLimitOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetCount")
    def reset_count(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCount", []))

    @jsii.member(jsii_name="resetOrder")
    def reset_order(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrder", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="countInput")
    def count_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "countInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="count")
    def count(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "count"))

    @count.setter
    def count(self, value: jsii.Number) -> None:
        jsii.set(self, "count", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestFormulaLimit]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestFormulaLimit], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestFormulaLimit],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestLogQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetGeomapDefinitionRequestLogQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestLogQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestLogQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestLogQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestLogQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQuery",
    jsii_struct_bases=[],
    name_mapping={
        "apm_dependency_stats_query": "apmDependencyStatsQuery",
        "apm_resource_stats_query": "apmResourceStatsQuery",
        "event_query": "eventQuery",
        "metric_query": "metricQuery",
        "process_query": "processQuery",
    },
)
class DashboardWidgetGeomapDefinitionRequestQuery:
    def __init__(
        self,
        *,
        apm_dependency_stats_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery"] = None,
        apm_resource_stats_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery"] = None,
        event_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQuery"] = None,
        metric_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryMetricQuery"] = None,
        process_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryProcessQuery"] = None,
    ) -> None:
        '''
        :param apm_dependency_stats_query: apm_dependency_stats_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
        :param apm_resource_stats_query: apm_resource_stats_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
        :param event_query: event_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
        :param metric_query: metric_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
        :param process_query: process_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        if isinstance(apm_dependency_stats_query, dict):
            apm_dependency_stats_query = DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery(**apm_dependency_stats_query)
        if isinstance(apm_resource_stats_query, dict):
            apm_resource_stats_query = DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery(**apm_resource_stats_query)
        if isinstance(event_query, dict):
            event_query = DashboardWidgetGeomapDefinitionRequestQueryEventQuery(**event_query)
        if isinstance(metric_query, dict):
            metric_query = DashboardWidgetGeomapDefinitionRequestQueryMetricQuery(**metric_query)
        if isinstance(process_query, dict):
            process_query = DashboardWidgetGeomapDefinitionRequestQueryProcessQuery(**process_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if apm_dependency_stats_query is not None:
            self._values["apm_dependency_stats_query"] = apm_dependency_stats_query
        if apm_resource_stats_query is not None:
            self._values["apm_resource_stats_query"] = apm_resource_stats_query
        if event_query is not None:
            self._values["event_query"] = event_query
        if metric_query is not None:
            self._values["metric_query"] = metric_query
        if process_query is not None:
            self._values["process_query"] = process_query

    @builtins.property
    def apm_dependency_stats_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery"]:
        '''apm_dependency_stats_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
        '''
        result = self._values.get("apm_dependency_stats_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery"], result)

    @builtins.property
    def apm_resource_stats_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery"]:
        '''apm_resource_stats_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
        '''
        result = self._values.get("apm_resource_stats_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery"], result)

    @builtins.property
    def event_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQuery"]:
        '''event_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
        '''
        result = self._values.get("event_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQuery"], result)

    @builtins.property
    def metric_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryMetricQuery"]:
        '''metric_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
        '''
        result = self._values.get("metric_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryMetricQuery"], result)

    @builtins.property
    def process_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryProcessQuery"]:
        '''process_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        result = self._values.get("process_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryProcessQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "env": "env",
        "name": "name",
        "operation_name": "operationName",
        "resource_name": "resourceName",
        "service": "service",
        "stat": "stat",
        "is_upstream": "isUpstream",
        "primary_tag_name": "primaryTagName",
        "primary_tag_value": "primaryTagValue",
    },
)
class DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        env: builtins.str,
        name: builtins.str,
        operation_name: builtins.str,
        resource_name: builtins.str,
        service: builtins.str,
        stat: builtins.str,
        is_upstream: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        primary_tag_name: typing.Optional[builtins.str] = None,
        primary_tag_value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for APM Dependency Stats queries. Valid values are ``apm_dependency_stats``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param env: APM Environment. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param operation_name: Name of operation on service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        :param resource_name: APM resource. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        :param service: APM service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param stat: APM statistic. Valid values are ``avg_duration``, ``avg_root_duration``, ``avg_spans_per_trace``, ``error_rate``, ``pct_exec_time``, ``pct_of_traces``, ``total_traces_count``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        :param is_upstream: Determines whether stats for upstream or downstream dependencies should be queried. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
        :param primary_tag_name: The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        :param primary_tag_value: Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "data_source": data_source,
            "env": env,
            "name": name,
            "operation_name": operation_name,
            "resource_name": resource_name,
            "service": service,
            "stat": stat,
        }
        if is_upstream is not None:
            self._values["is_upstream"] = is_upstream
        if primary_tag_name is not None:
            self._values["primary_tag_name"] = primary_tag_name
        if primary_tag_value is not None:
            self._values["primary_tag_value"] = primary_tag_value

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for APM Dependency Stats queries. Valid values are ``apm_dependency_stats``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def env(self) -> builtins.str:
        '''APM Environment.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        '''
        result = self._values.get("env")
        assert result is not None, "Required property 'env' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operation_name(self) -> builtins.str:
        '''Name of operation on service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        '''
        result = self._values.get("operation_name")
        assert result is not None, "Required property 'operation_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_name(self) -> builtins.str:
        '''APM resource.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        result = self._values.get("resource_name")
        assert result is not None, "Required property 'resource_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def service(self) -> builtins.str:
        '''APM service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stat(self) -> builtins.str:
        '''APM statistic. Valid values are ``avg_duration``, ``avg_root_duration``, ``avg_spans_per_trace``, ``error_rate``, ``pct_exec_time``, ``pct_of_traces``, ``total_traces_count``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        '''
        result = self._values.get("stat")
        assert result is not None, "Required property 'stat' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def is_upstream(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Determines whether stats for upstream or downstream dependencies should be queried.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
        '''
        result = self._values.get("is_upstream")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def primary_tag_name(self) -> typing.Optional[builtins.str]:
        '''The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        '''
        result = self._values.get("primary_tag_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_value(self) -> typing.Optional[builtins.str]:
        '''Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        result = self._values.get("primary_tag_value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetIsUpstream")
    def reset_is_upstream(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsUpstream", []))

    @jsii.member(jsii_name="resetPrimaryTagName")
    def reset_primary_tag_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagName", []))

    @jsii.member(jsii_name="resetPrimaryTagValue")
    def reset_primary_tag_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagValue", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="envInput")
    def env_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "envInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isUpstreamInput")
    def is_upstream_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "isUpstreamInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="operationNameInput")
    def operation_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "operationNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagNameInput")
    def primary_tag_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagValueInput")
    def primary_tag_value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagValueInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceNameInput")
    def resource_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="serviceInput")
    def service_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serviceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statInput")
    def stat_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "statInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="env")
    def env(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "env"))

    @env.setter
    def env(self, value: builtins.str) -> None:
        jsii.set(self, "env", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isUpstream")
    def is_upstream(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "isUpstream"))

    @is_upstream.setter
    def is_upstream(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "isUpstream", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operationName"))

    @operation_name.setter
    def operation_name(self, value: builtins.str) -> None:
        jsii.set(self, "operationName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagName")
    def primary_tag_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagName"))

    @primary_tag_name.setter
    def primary_tag_name(self, value: builtins.str) -> None:
        jsii.set(self, "primaryTagName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagValue")
    def primary_tag_value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagValue"))

    @primary_tag_value.setter
    def primary_tag_value(self, value: builtins.str) -> None:
        jsii.set(self, "primaryTagValue", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceName"))

    @resource_name.setter
    def resource_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="service")
    def service(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "service"))

    @service.setter
    def service(self, value: builtins.str) -> None:
        jsii.set(self, "service", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="stat")
    def stat(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "stat"))

    @stat.setter
    def stat(self, value: builtins.str) -> None:
        jsii.set(self, "stat", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "env": "env",
        "name": "name",
        "service": "service",
        "stat": "stat",
        "group_by": "groupBy",
        "operation_name": "operationName",
        "primary_tag_name": "primaryTagName",
        "primary_tag_value": "primaryTagValue",
        "resource_name": "resourceName",
    },
)
class DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        env: builtins.str,
        name: builtins.str,
        service: builtins.str,
        stat: builtins.str,
        group_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        primary_tag_name: typing.Optional[builtins.str] = None,
        primary_tag_value: typing.Optional[builtins.str] = None,
        resource_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for APM Resource Stats queries. Valid values are ``apm_resource_stats``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param env: APM Environment. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param service: APM service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param stat: APM statistic. Valid values are ``errors``, ``error_rate``, ``hits``, ``latency_avg``, ``latency_max``, ``latency_p50``, ``latency_p75``, ``latency_p90``, ``latency_p95``, ``latency_p99``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        :param group_by: Array of fields to group results by. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param operation_name: Name of operation on service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        :param primary_tag_name: The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        :param primary_tag_value: Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        :param resource_name: APM resource. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "data_source": data_source,
            "env": env,
            "name": name,
            "service": service,
            "stat": stat,
        }
        if group_by is not None:
            self._values["group_by"] = group_by
        if operation_name is not None:
            self._values["operation_name"] = operation_name
        if primary_tag_name is not None:
            self._values["primary_tag_name"] = primary_tag_name
        if primary_tag_value is not None:
            self._values["primary_tag_value"] = primary_tag_value
        if resource_name is not None:
            self._values["resource_name"] = resource_name

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for APM Resource Stats queries. Valid values are ``apm_resource_stats``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def env(self) -> builtins.str:
        '''APM Environment.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        '''
        result = self._values.get("env")
        assert result is not None, "Required property 'env' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def service(self) -> builtins.str:
        '''APM service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stat(self) -> builtins.str:
        '''APM statistic. Valid values are ``errors``, ``error_rate``, ``hits``, ``latency_avg``, ``latency_max``, ``latency_p50``, ``latency_p75``, ``latency_p90``, ``latency_p95``, ``latency_p99``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        '''
        result = self._values.get("stat")
        assert result is not None, "Required property 'stat' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def group_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Array of fields to group results by.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def operation_name(self) -> typing.Optional[builtins.str]:
        '''Name of operation on service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        '''
        result = self._values.get("operation_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_name(self) -> typing.Optional[builtins.str]:
        '''The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        '''
        result = self._values.get("primary_tag_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_value(self) -> typing.Optional[builtins.str]:
        '''Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        result = self._values.get("primary_tag_value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''APM resource.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        result = self._values.get("resource_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetOperationName")
    def reset_operation_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOperationName", []))

    @jsii.member(jsii_name="resetPrimaryTagName")
    def reset_primary_tag_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagName", []))

    @jsii.member(jsii_name="resetPrimaryTagValue")
    def reset_primary_tag_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagValue", []))

    @jsii.member(jsii_name="resetResourceName")
    def reset_resource_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetResourceName", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="envInput")
    def env_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "envInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="operationNameInput")
    def operation_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "operationNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagNameInput")
    def primary_tag_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagValueInput")
    def primary_tag_value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagValueInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceNameInput")
    def resource_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="serviceInput")
    def service_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serviceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statInput")
    def stat_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "statInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="env")
    def env(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "env"))

    @env.setter
    def env(self, value: builtins.str) -> None:
        jsii.set(self, "env", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operationName"))

    @operation_name.setter
    def operation_name(self, value: builtins.str) -> None:
        jsii.set(self, "operationName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagName")
    def primary_tag_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagName"))

    @primary_tag_name.setter
    def primary_tag_name(self, value: builtins.str) -> None:
        jsii.set(self, "primaryTagName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="primaryTagValue")
    def primary_tag_value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagValue"))

    @primary_tag_value.setter
    def primary_tag_value(self, value: builtins.str) -> None:
        jsii.set(self, "primaryTagValue", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceName"))

    @resource_name.setter
    def resource_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="service")
    def service(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "service"))

    @service.setter
    def service(self, value: builtins.str) -> None:
        jsii.set(self, "service", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="stat")
    def stat(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "stat"))

    @stat.setter
    def stat(self, value: builtins.str) -> None:
        jsii.set(self, "stat", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryEventQuery",
    jsii_struct_bases=[],
    name_mapping={
        "compute": "compute",
        "data_source": "dataSource",
        "name": "name",
        "group_by": "groupBy",
        "indexes": "indexes",
        "search": "search",
    },
)
class DashboardWidgetGeomapDefinitionRequestQueryEventQuery:
    def __init__(
        self,
        *,
        compute: typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute"]],
        data_source: builtins.str,
        name: builtins.str,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy"]]] = None,
        indexes: typing.Optional[typing.Sequence[builtins.str]] = None,
        search: typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch"] = None,
    ) -> None:
        '''
        :param compute: compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
        :param data_source: The data source for event platform-based queries. Valid values are ``logs``, ``spans``, ``network``, ``rum``, ``security_signals``, ``profiles``, ``audit``, ``events``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param indexes: An array of index names to query in the stream. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
        :param search: search block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
        '''
        if isinstance(search, dict):
            search = DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch(**search)
        self._values: typing.Dict[str, typing.Any] = {
            "compute": compute,
            "data_source": data_source,
            "name": name,
        }
        if group_by is not None:
            self._values["group_by"] = group_by
        if indexes is not None:
            self._values["indexes"] = indexes
        if search is not None:
            self._values["search"] = search

    @builtins.property
    def compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute"]]:
        '''compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
        '''
        result = self._values.get("compute")
        assert result is not None, "Required property 'compute' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute"]], result)

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for event platform-based queries. Valid values are ``logs``, ``spans``, ``network``, ``rum``, ``security_signals``, ``profiles``, ``audit``, ``events``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy"]]], result)

    @builtins.property
    def indexes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of index names to query in the stream.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
        '''
        result = self._values.get("indexes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def search(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch"]:
        '''search block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
        '''
        result = self._values.get("search")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryEventQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "interval": "interval",
        "metric": "metric",
    },
)
class DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        interval: typing.Optional[jsii.Number] = None,
        metric: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation methods for event platform queries. Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param interval: A time interval in milliseconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        :param metric: The measurable attribute to compute. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if interval is not None:
            self._values["interval"] = interval
        if metric is not None:
            self._values["metric"] = metric

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation methods for event platform queries.

        Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''A time interval in milliseconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The measurable attribute to compute.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort": "sort"},
)
class DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy:
    def __init__(
        self,
        *,
        facet: builtins.str,
        limit: typing.Optional[jsii.Number] = None,
        sort: typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort"] = None,
    ) -> None:
        '''
        :param facet: The event facet. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The number of groups to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort: sort block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        if isinstance(sort, dict):
            sort = DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort(**sort)
        self._values: typing.Dict[str, typing.Any] = {
            "facet": facet,
        }
        if limit is not None:
            self._values["limit"] = limit
        if sort is not None:
            self._values["sort"] = sort

    @builtins.property
    def facet(self) -> builtins.str:
        '''The event facet.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        assert result is not None, "Required property 'facet' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The number of groups to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort"]:
        '''sort block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        result = self._values.get("sort")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "metric": "metric", "order": "order"},
)
class DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        metric: typing.Optional[builtins.str] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation methods for the event platform queries. Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param metric: The metric used for sorting group by results. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param order: Direction of sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if metric is not None:
            self._values["metric"] = metric
        if order is not None:
            self._values["order"] = order

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation methods for the event platform queries.

        Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The metric used for sorting group by results.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def order(self) -> typing.Optional[builtins.str]:
        '''Direction of sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetMetric")
    def reset_metric(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMetric", []))

    @jsii.member(jsii_name="resetOrder")
    def reset_order(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrder", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        jsii.set(self, "metric", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort],
    ) -> None:
        jsii.set(self, "internalValue", value)


class DashboardWidgetGeomapDefinitionRequestQueryEventQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryEventQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putSearch")
    def put_search(self, *, query: builtins.str) -> None:
        '''
        :param query: The events search string. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        value = DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch(
            query=query
        )

        return typing.cast(None, jsii.invoke(self, "putSearch", [value]))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetIndexes")
    def reset_indexes(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIndexes", []))

    @jsii.member(jsii_name="resetSearch")
    def reset_search(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearch", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="search")
    def search(
        self,
    ) -> "DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference":
        return typing.cast("DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference", jsii.get(self, "search"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeInput")
    def compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute]]], jsii.get(self, "computeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexesInput")
    def indexes_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "indexesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchInput")
    def search_input(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch"]:
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch"], jsii.get(self, "searchInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="compute")
    def compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute]], jsii.get(self, "compute"))

    @compute.setter
    def compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute]],
    ) -> None:
        jsii.set(self, "compute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexes")
    def indexes(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "indexes"))

    @indexes.setter
    def indexes(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "indexes", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch",
    jsii_struct_bases=[],
    name_mapping={"query": "query"},
)
class DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch:
    def __init__(self, *, query: builtins.str) -> None:
        '''
        :param query: The events search string. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "query": query,
        }

    @builtins.property
    def query(self) -> builtins.str:
        '''The events search string.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="queryInput")
    def query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "queryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="query")
    def query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "query"))

    @query.setter
    def query(self, value: builtins.str) -> None:
        jsii.set(self, "query", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryMetricQuery",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "query": "query",
        "aggregator": "aggregator",
        "data_source": "dataSource",
    },
)
class DashboardWidgetGeomapDefinitionRequestQueryMetricQuery:
    def __init__(
        self,
        *,
        name: builtins.str,
        query: builtins.str,
        aggregator: typing.Optional[builtins.str] = None,
        data_source: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: The name of the query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param query: The metrics query definition. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param aggregator: The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        :param data_source: The data source for metrics queries. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "query": query,
        }
        if aggregator is not None:
            self._values["aggregator"] = aggregator
        if data_source is not None:
            self._values["data_source"] = data_source

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def query(self) -> builtins.str:
        '''The metrics query definition.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aggregator(self) -> typing.Optional[builtins.str]:
        '''The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        '''
        result = self._values.get("aggregator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def data_source(self) -> typing.Optional[builtins.str]:
        '''The data source for metrics queries.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryMetricQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetAggregator")
    def reset_aggregator(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAggregator", []))

    @jsii.member(jsii_name="resetDataSource")
    def reset_data_source(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDataSource", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregatorInput")
    def aggregator_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregatorInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="queryInput")
    def query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "queryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregator")
    def aggregator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregator"))

    @aggregator.setter
    def aggregator(self, value: builtins.str) -> None:
        jsii.set(self, "aggregator", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="query")
    def query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "query"))

    @query.setter
    def query(self, value: builtins.str) -> None:
        jsii.set(self, "query", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryMetricQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryMetricQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryMetricQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryProcessQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "metric": "metric",
        "name": "name",
        "aggregator": "aggregator",
        "is_normalized_cpu": "isNormalizedCpu",
        "limit": "limit",
        "sort": "sort",
        "tag_filters": "tagFilters",
        "text_filter": "textFilter",
    },
)
class DashboardWidgetGeomapDefinitionRequestQueryProcessQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        metric: builtins.str,
        name: builtins.str,
        aggregator: typing.Optional[builtins.str] = None,
        is_normalized_cpu: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort: typing.Optional[builtins.str] = None,
        tag_filters: typing.Optional[typing.Sequence[builtins.str]] = None,
        text_filter: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for process queries. Valid values are ``process``, ``container``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param metric: The process metric name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param aggregator: The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        :param is_normalized_cpu: Whether to normalize the CPU percentages. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
        :param limit: The number of hits to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        :param tag_filters: An array of tags to filter by. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
        :param text_filter: The text to use as a filter. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "data_source": data_source,
            "metric": metric,
            "name": name,
        }
        if aggregator is not None:
            self._values["aggregator"] = aggregator
        if is_normalized_cpu is not None:
            self._values["is_normalized_cpu"] = is_normalized_cpu
        if limit is not None:
            self._values["limit"] = limit
        if sort is not None:
            self._values["sort"] = sort
        if tag_filters is not None:
            self._values["tag_filters"] = tag_filters
        if text_filter is not None:
            self._values["text_filter"] = text_filter

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for process queries. Valid values are ``process``, ``container``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def metric(self) -> builtins.str:
        '''The process metric name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aggregator(self) -> typing.Optional[builtins.str]:
        '''The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        '''
        result = self._values.get("aggregator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def is_normalized_cpu(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Whether to normalize the CPU percentages.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
        '''
        result = self._values.get("is_normalized_cpu")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The number of hits to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort(self) -> typing.Optional[builtins.str]:
        '''The direction of the sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        result = self._values.get("sort")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tag_filters(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of tags to filter by.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
        '''
        result = self._values.get("tag_filters")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def text_filter(self) -> typing.Optional[builtins.str]:
        '''The text to use as a filter.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
        '''
        result = self._values.get("text_filter")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestQueryProcessQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetAggregator")
    def reset_aggregator(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAggregator", []))

    @jsii.member(jsii_name="resetIsNormalizedCpu")
    def reset_is_normalized_cpu(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsNormalizedCpu", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSort")
    def reset_sort(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSort", []))

    @jsii.member(jsii_name="resetTagFilters")
    def reset_tag_filters(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTagFilters", []))

    @jsii.member(jsii_name="resetTextFilter")
    def reset_text_filter(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTextFilter", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregatorInput")
    def aggregator_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregatorInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isNormalizedCpuInput")
    def is_normalized_cpu_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "isNormalizedCpuInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="sortInput")
    def sort_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "sortInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagFiltersInput")
    def tag_filters_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "tagFiltersInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textFilterInput")
    def text_filter_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "textFilterInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregator")
    def aggregator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregator"))

    @aggregator.setter
    def aggregator(self, value: builtins.str) -> None:
        jsii.set(self, "aggregator", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isNormalizedCpu")
    def is_normalized_cpu(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "isNormalizedCpu"))

    @is_normalized_cpu.setter
    def is_normalized_cpu(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "isNormalizedCpu", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        jsii.set(self, "limit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        jsii.set(self, "metric", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="sort")
    def sort(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "sort"))

    @sort.setter
    def sort(self, value: builtins.str) -> None:
        jsii.set(self, "sort", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagFilters")
    def tag_filters(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "tagFilters"))

    @tag_filters.setter
    def tag_filters(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "tagFilters", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textFilter")
    def text_filter(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "textFilter"))

    @text_filter.setter
    def text_filter(self, value: builtins.str) -> None:
        jsii.set(self, "textFilter", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryProcessQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryProcessQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestQueryProcessQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestRumQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetGeomapDefinitionRequestRumQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestRumQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionRequestRumQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionRequestRumQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionRequestRumQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionStyle",
    jsii_struct_bases=[],
    name_mapping={"palette": "palette", "palette_flip": "paletteFlip"},
)
class DashboardWidgetGeomapDefinitionStyle:
    def __init__(
        self,
        *,
        palette: builtins.str,
        palette_flip: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        '''
        :param palette: The color palette to apply to the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        :param palette_flip: A Boolean indicating whether to flip the palette tones. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_flip Dashboard#palette_flip}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "palette": palette,
            "palette_flip": palette_flip,
        }

    @builtins.property
    def palette(self) -> builtins.str:
        '''The color palette to apply to the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        result = self._values.get("palette")
        assert result is not None, "Required property 'palette' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def palette_flip(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''A Boolean indicating whether to flip the palette tones.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_flip Dashboard#palette_flip}
        '''
        result = self._values.get("palette_flip")
        assert result is not None, "Required property 'palette_flip' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionStyle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionStyleOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionStyleOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="paletteFlipInput")
    def palette_flip_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "paletteFlipInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="paletteInput")
    def palette_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "paletteInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="palette")
    def palette(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "palette"))

    @palette.setter
    def palette(self, value: builtins.str) -> None:
        jsii.set(self, "palette", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="paletteFlip")
    def palette_flip(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "paletteFlip"))

    @palette_flip.setter
    def palette_flip(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "paletteFlip", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetGeomapDefinitionStyle]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionStyle], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionStyle],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionView",
    jsii_struct_bases=[],
    name_mapping={"focus": "focus"},
)
class DashboardWidgetGeomapDefinitionView:
    def __init__(self, *, focus: builtins.str) -> None:
        '''
        :param focus: The two-letter ISO code of a country to focus the map on (or ``WORLD``). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#focus Dashboard#focus}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "focus": focus,
        }

    @builtins.property
    def focus(self) -> builtins.str:
        '''The two-letter ISO code of a country to focus the map on (or ``WORLD``).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#focus Dashboard#focus}
        '''
        result = self._values.get("focus")
        assert result is not None, "Required property 'focus' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGeomapDefinitionView(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGeomapDefinitionViewOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGeomapDefinitionViewOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="focusInput")
    def focus_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "focusInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="focus")
    def focus(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "focus"))

    @focus.setter
    def focus(self, value: builtins.str) -> None:
        jsii.set(self, "focus", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetGeomapDefinitionView]:
        return typing.cast(typing.Optional[DashboardWidgetGeomapDefinitionView], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGeomapDefinitionView],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "layout_type": "layoutType",
        "widget": "widget",
        "background_color": "backgroundColor",
        "banner_img": "bannerImg",
        "show_title": "showTitle",
        "title": "title",
    },
)
class DashboardWidgetGroupDefinition:
    def __init__(
        self,
        *,
        layout_type: builtins.str,
        widget: typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidget"]],
        background_color: typing.Optional[builtins.str] = None,
        banner_img: typing.Optional[builtins.str] = None,
        show_title: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        title: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param layout_type: The layout type of the group. Valid values are ``ordered``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
        :param widget: widget block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
        :param background_color: The background color of the group title, options: ``vivid_blue``, ``vivid_purple``, ``vivid_pink``, ``vivid_orange``, ``vivid_yellow``, ``vivid_green``, ``blue``, ``purple``, ``pink``, ``orange``, ``yellow``, ``green``, ``gray`` or ``white``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#background_color Dashboard#background_color}
        :param banner_img: The image URL to display as a banner for the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#banner_img Dashboard#banner_img}
        :param show_title: Whether to show the title or not. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_title Dashboard#show_title}
        :param title: The title of the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "layout_type": layout_type,
            "widget": widget,
        }
        if background_color is not None:
            self._values["background_color"] = background_color
        if banner_img is not None:
            self._values["banner_img"] = banner_img
        if show_title is not None:
            self._values["show_title"] = show_title
        if title is not None:
            self._values["title"] = title

    @builtins.property
    def layout_type(self) -> builtins.str:
        '''The layout type of the group. Valid values are ``ordered``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
        '''
        result = self._values.get("layout_type")
        assert result is not None, "Required property 'layout_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def widget(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidget"]]:
        '''widget block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
        '''
        result = self._values.get("widget")
        assert result is not None, "Required property 'widget' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidget"]], result)

    @builtins.property
    def background_color(self) -> typing.Optional[builtins.str]:
        '''The background color of the group title, options: ``vivid_blue``, ``vivid_purple``, ``vivid_pink``, ``vivid_orange``, ``vivid_yellow``, ``vivid_green``, ``blue``, ``purple``, ``pink``, ``orange``, ``yellow``, ``green``, ``gray`` or ``white``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#background_color Dashboard#background_color}
        '''
        result = self._values.get("background_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def banner_img(self) -> typing.Optional[builtins.str]:
        '''The image URL to display as a banner for the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#banner_img Dashboard#banner_img}
        '''
        result = self._values.get("banner_img")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def show_title(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Whether to show the title or not.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_title Dashboard#show_title}
        '''
        result = self._values.get("show_title")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetBackgroundColor")
    def reset_background_color(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBackgroundColor", []))

    @jsii.member(jsii_name="resetBannerImg")
    def reset_banner_img(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBannerImg", []))

    @jsii.member(jsii_name="resetShowTitle")
    def reset_show_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShowTitle", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="backgroundColorInput")
    def background_color_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "backgroundColorInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="bannerImgInput")
    def banner_img_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "bannerImgInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="layoutTypeInput")
    def layout_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "layoutTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="showTitleInput")
    def show_title_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "showTitleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="widgetInput")
    def widget_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidget"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidget"]]], jsii.get(self, "widgetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="backgroundColor")
    def background_color(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "backgroundColor"))

    @background_color.setter
    def background_color(self, value: builtins.str) -> None:
        jsii.set(self, "backgroundColor", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="bannerImg")
    def banner_img(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "bannerImg"))

    @banner_img.setter
    def banner_img(self, value: builtins.str) -> None:
        jsii.set(self, "bannerImg", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="layoutType")
    def layout_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "layoutType"))

    @layout_type.setter
    def layout_type(self, value: builtins.str) -> None:
        jsii.set(self, "layoutType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="showTitle")
    def show_title(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "showTitle"))

    @show_title.setter
    def show_title(self, value: typing.Union[builtins.bool, cdktf.IResolvable]) -> None:
        jsii.set(self, "showTitle", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="widget")
    def widget(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidget"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidget"]], jsii.get(self, "widget"))

    @widget.setter
    def widget(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidget"]],
    ) -> None:
        jsii.set(self, "widget", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetGroupDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidget",
    jsii_struct_bases=[],
    name_mapping={
        "alert_graph_definition": "alertGraphDefinition",
        "alert_value_definition": "alertValueDefinition",
        "change_definition": "changeDefinition",
        "check_status_definition": "checkStatusDefinition",
        "distribution_definition": "distributionDefinition",
        "event_stream_definition": "eventStreamDefinition",
        "event_timeline_definition": "eventTimelineDefinition",
        "free_text_definition": "freeTextDefinition",
        "geomap_definition": "geomapDefinition",
        "heatmap_definition": "heatmapDefinition",
        "hostmap_definition": "hostmapDefinition",
        "iframe_definition": "iframeDefinition",
        "image_definition": "imageDefinition",
        "log_stream_definition": "logStreamDefinition",
        "manage_status_definition": "manageStatusDefinition",
        "note_definition": "noteDefinition",
        "query_table_definition": "queryTableDefinition",
        "query_value_definition": "queryValueDefinition",
        "scatterplot_definition": "scatterplotDefinition",
        "service_level_objective_definition": "serviceLevelObjectiveDefinition",
        "servicemap_definition": "servicemapDefinition",
        "sunburst_definition": "sunburstDefinition",
        "timeseries_definition": "timeseriesDefinition",
        "toplist_definition": "toplistDefinition",
        "trace_service_definition": "traceServiceDefinition",
        "widget_layout": "widgetLayout",
    },
)
class DashboardWidgetGroupDefinitionWidget:
    def __init__(
        self,
        *,
        alert_graph_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition"] = None,
        alert_value_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetAlertValueDefinition"] = None,
        change_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinition"] = None,
        check_status_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition"] = None,
        distribution_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetDistributionDefinition"] = None,
        event_stream_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetEventStreamDefinition"] = None,
        event_timeline_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition"] = None,
        free_text_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetFreeTextDefinition"] = None,
        geomap_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetGeomapDefinition"] = None,
        heatmap_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetHeatmapDefinition"] = None,
        hostmap_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetHostmapDefinition"] = None,
        iframe_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetIframeDefinition"] = None,
        image_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetImageDefinition"] = None,
        log_stream_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetLogStreamDefinition"] = None,
        manage_status_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetManageStatusDefinition"] = None,
        note_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetNoteDefinition"] = None,
        query_table_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetQueryTableDefinition"] = None,
        query_value_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetQueryValueDefinition"] = None,
        scatterplot_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetScatterplotDefinition"] = None,
        service_level_objective_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetServiceLevelObjectiveDefinition"] = None,
        servicemap_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetServicemapDefinition"] = None,
        sunburst_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetSunburstDefinition"] = None,
        timeseries_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetTimeseriesDefinition"] = None,
        toplist_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetToplistDefinition"] = None,
        trace_service_definition: typing.Optional["DashboardWidgetGroupDefinitionWidgetTraceServiceDefinition"] = None,
        widget_layout: typing.Optional["DashboardWidgetGroupDefinitionWidgetWidgetLayout"] = None,
    ) -> None:
        '''
        :param alert_graph_definition: alert_graph_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_graph_definition Dashboard#alert_graph_definition}
        :param alert_value_definition: alert_value_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_value_definition Dashboard#alert_value_definition}
        :param change_definition: change_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_definition Dashboard#change_definition}
        :param check_status_definition: check_status_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check_status_definition Dashboard#check_status_definition}
        :param distribution_definition: distribution_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#distribution_definition Dashboard#distribution_definition}
        :param event_stream_definition: event_stream_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_stream_definition Dashboard#event_stream_definition}
        :param event_timeline_definition: event_timeline_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_timeline_definition Dashboard#event_timeline_definition}
        :param free_text_definition: free_text_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#free_text_definition Dashboard#free_text_definition}
        :param geomap_definition: geomap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#geomap_definition Dashboard#geomap_definition}
        :param heatmap_definition: heatmap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#heatmap_definition Dashboard#heatmap_definition}
        :param hostmap_definition: hostmap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hostmap_definition Dashboard#hostmap_definition}
        :param iframe_definition: iframe_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#iframe_definition Dashboard#iframe_definition}
        :param image_definition: image_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_definition Dashboard#image_definition}
        :param log_stream_definition: log_stream_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_stream_definition Dashboard#log_stream_definition}
        :param manage_status_definition: manage_status_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#manage_status_definition Dashboard#manage_status_definition}
        :param note_definition: note_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#note_definition Dashboard#note_definition}
        :param query_table_definition: query_table_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_table_definition Dashboard#query_table_definition}
        :param query_value_definition: query_value_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_value_definition Dashboard#query_value_definition}
        :param scatterplot_definition: scatterplot_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scatterplot_definition Dashboard#scatterplot_definition}
        :param service_level_objective_definition: service_level_objective_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service_level_objective_definition Dashboard#service_level_objective_definition}
        :param servicemap_definition: servicemap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#servicemap_definition Dashboard#servicemap_definition}
        :param sunburst_definition: sunburst_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sunburst_definition Dashboard#sunburst_definition}
        :param timeseries_definition: timeseries_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeseries_definition Dashboard#timeseries_definition}
        :param toplist_definition: toplist_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#toplist_definition Dashboard#toplist_definition}
        :param trace_service_definition: trace_service_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#trace_service_definition Dashboard#trace_service_definition}
        :param widget_layout: widget_layout block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget_layout Dashboard#widget_layout}
        '''
        if isinstance(alert_graph_definition, dict):
            alert_graph_definition = DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition(**alert_graph_definition)
        if isinstance(alert_value_definition, dict):
            alert_value_definition = DashboardWidgetGroupDefinitionWidgetAlertValueDefinition(**alert_value_definition)
        if isinstance(change_definition, dict):
            change_definition = DashboardWidgetGroupDefinitionWidgetChangeDefinition(**change_definition)
        if isinstance(check_status_definition, dict):
            check_status_definition = DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition(**check_status_definition)
        if isinstance(distribution_definition, dict):
            distribution_definition = DashboardWidgetGroupDefinitionWidgetDistributionDefinition(**distribution_definition)
        if isinstance(event_stream_definition, dict):
            event_stream_definition = DashboardWidgetGroupDefinitionWidgetEventStreamDefinition(**event_stream_definition)
        if isinstance(event_timeline_definition, dict):
            event_timeline_definition = DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition(**event_timeline_definition)
        if isinstance(free_text_definition, dict):
            free_text_definition = DashboardWidgetGroupDefinitionWidgetFreeTextDefinition(**free_text_definition)
        if isinstance(geomap_definition, dict):
            geomap_definition = DashboardWidgetGroupDefinitionWidgetGeomapDefinition(**geomap_definition)
        if isinstance(heatmap_definition, dict):
            heatmap_definition = DashboardWidgetGroupDefinitionWidgetHeatmapDefinition(**heatmap_definition)
        if isinstance(hostmap_definition, dict):
            hostmap_definition = DashboardWidgetGroupDefinitionWidgetHostmapDefinition(**hostmap_definition)
        if isinstance(iframe_definition, dict):
            iframe_definition = DashboardWidgetGroupDefinitionWidgetIframeDefinition(**iframe_definition)
        if isinstance(image_definition, dict):
            image_definition = DashboardWidgetGroupDefinitionWidgetImageDefinition(**image_definition)
        if isinstance(log_stream_definition, dict):
            log_stream_definition = DashboardWidgetGroupDefinitionWidgetLogStreamDefinition(**log_stream_definition)
        if isinstance(manage_status_definition, dict):
            manage_status_definition = DashboardWidgetGroupDefinitionWidgetManageStatusDefinition(**manage_status_definition)
        if isinstance(note_definition, dict):
            note_definition = DashboardWidgetGroupDefinitionWidgetNoteDefinition(**note_definition)
        if isinstance(query_table_definition, dict):
            query_table_definition = DashboardWidgetGroupDefinitionWidgetQueryTableDefinition(**query_table_definition)
        if isinstance(query_value_definition, dict):
            query_value_definition = DashboardWidgetGroupDefinitionWidgetQueryValueDefinition(**query_value_definition)
        if isinstance(scatterplot_definition, dict):
            scatterplot_definition = DashboardWidgetGroupDefinitionWidgetScatterplotDefinition(**scatterplot_definition)
        if isinstance(service_level_objective_definition, dict):
            service_level_objective_definition = DashboardWidgetGroupDefinitionWidgetServiceLevelObjectiveDefinition(**service_level_objective_definition)
        if isinstance(servicemap_definition, dict):
            servicemap_definition = DashboardWidgetGroupDefinitionWidgetServicemapDefinition(**servicemap_definition)
        if isinstance(sunburst_definition, dict):
            sunburst_definition = DashboardWidgetGroupDefinitionWidgetSunburstDefinition(**sunburst_definition)
        if isinstance(timeseries_definition, dict):
            timeseries_definition = DashboardWidgetGroupDefinitionWidgetTimeseriesDefinition(**timeseries_definition)
        if isinstance(toplist_definition, dict):
            toplist_definition = DashboardWidgetGroupDefinitionWidgetToplistDefinition(**toplist_definition)
        if isinstance(trace_service_definition, dict):
            trace_service_definition = DashboardWidgetGroupDefinitionWidgetTraceServiceDefinition(**trace_service_definition)
        if isinstance(widget_layout, dict):
            widget_layout = DashboardWidgetGroupDefinitionWidgetWidgetLayout(**widget_layout)
        self._values: typing.Dict[str, typing.Any] = {}
        if alert_graph_definition is not None:
            self._values["alert_graph_definition"] = alert_graph_definition
        if alert_value_definition is not None:
            self._values["alert_value_definition"] = alert_value_definition
        if change_definition is not None:
            self._values["change_definition"] = change_definition
        if check_status_definition is not None:
            self._values["check_status_definition"] = check_status_definition
        if distribution_definition is not None:
            self._values["distribution_definition"] = distribution_definition
        if event_stream_definition is not None:
            self._values["event_stream_definition"] = event_stream_definition
        if event_timeline_definition is not None:
            self._values["event_timeline_definition"] = event_timeline_definition
        if free_text_definition is not None:
            self._values["free_text_definition"] = free_text_definition
        if geomap_definition is not None:
            self._values["geomap_definition"] = geomap_definition
        if heatmap_definition is not None:
            self._values["heatmap_definition"] = heatmap_definition
        if hostmap_definition is not None:
            self._values["hostmap_definition"] = hostmap_definition
        if iframe_definition is not None:
            self._values["iframe_definition"] = iframe_definition
        if image_definition is not None:
            self._values["image_definition"] = image_definition
        if log_stream_definition is not None:
            self._values["log_stream_definition"] = log_stream_definition
        if manage_status_definition is not None:
            self._values["manage_status_definition"] = manage_status_definition
        if note_definition is not None:
            self._values["note_definition"] = note_definition
        if query_table_definition is not None:
            self._values["query_table_definition"] = query_table_definition
        if query_value_definition is not None:
            self._values["query_value_definition"] = query_value_definition
        if scatterplot_definition is not None:
            self._values["scatterplot_definition"] = scatterplot_definition
        if service_level_objective_definition is not None:
            self._values["service_level_objective_definition"] = service_level_objective_definition
        if servicemap_definition is not None:
            self._values["servicemap_definition"] = servicemap_definition
        if sunburst_definition is not None:
            self._values["sunburst_definition"] = sunburst_definition
        if timeseries_definition is not None:
            self._values["timeseries_definition"] = timeseries_definition
        if toplist_definition is not None:
            self._values["toplist_definition"] = toplist_definition
        if trace_service_definition is not None:
            self._values["trace_service_definition"] = trace_service_definition
        if widget_layout is not None:
            self._values["widget_layout"] = widget_layout

    @builtins.property
    def alert_graph_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition"]:
        '''alert_graph_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_graph_definition Dashboard#alert_graph_definition}
        '''
        result = self._values.get("alert_graph_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition"], result)

    @builtins.property
    def alert_value_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetAlertValueDefinition"]:
        '''alert_value_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_value_definition Dashboard#alert_value_definition}
        '''
        result = self._values.get("alert_value_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetAlertValueDefinition"], result)

    @builtins.property
    def change_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinition"]:
        '''change_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_definition Dashboard#change_definition}
        '''
        result = self._values.get("change_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinition"], result)

    @builtins.property
    def check_status_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition"]:
        '''check_status_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check_status_definition Dashboard#check_status_definition}
        '''
        result = self._values.get("check_status_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition"], result)

    @builtins.property
    def distribution_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetDistributionDefinition"]:
        '''distribution_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#distribution_definition Dashboard#distribution_definition}
        '''
        result = self._values.get("distribution_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetDistributionDefinition"], result)

    @builtins.property
    def event_stream_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetEventStreamDefinition"]:
        '''event_stream_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_stream_definition Dashboard#event_stream_definition}
        '''
        result = self._values.get("event_stream_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetEventStreamDefinition"], result)

    @builtins.property
    def event_timeline_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition"]:
        '''event_timeline_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_timeline_definition Dashboard#event_timeline_definition}
        '''
        result = self._values.get("event_timeline_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition"], result)

    @builtins.property
    def free_text_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetFreeTextDefinition"]:
        '''free_text_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#free_text_definition Dashboard#free_text_definition}
        '''
        result = self._values.get("free_text_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetFreeTextDefinition"], result)

    @builtins.property
    def geomap_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetGeomapDefinition"]:
        '''geomap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#geomap_definition Dashboard#geomap_definition}
        '''
        result = self._values.get("geomap_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetGeomapDefinition"], result)

    @builtins.property
    def heatmap_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetHeatmapDefinition"]:
        '''heatmap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#heatmap_definition Dashboard#heatmap_definition}
        '''
        result = self._values.get("heatmap_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetHeatmapDefinition"], result)

    @builtins.property
    def hostmap_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetHostmapDefinition"]:
        '''hostmap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hostmap_definition Dashboard#hostmap_definition}
        '''
        result = self._values.get("hostmap_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetHostmapDefinition"], result)

    @builtins.property
    def iframe_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetIframeDefinition"]:
        '''iframe_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#iframe_definition Dashboard#iframe_definition}
        '''
        result = self._values.get("iframe_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetIframeDefinition"], result)

    @builtins.property
    def image_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetImageDefinition"]:
        '''image_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_definition Dashboard#image_definition}
        '''
        result = self._values.get("image_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetImageDefinition"], result)

    @builtins.property
    def log_stream_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetLogStreamDefinition"]:
        '''log_stream_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_stream_definition Dashboard#log_stream_definition}
        '''
        result = self._values.get("log_stream_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetLogStreamDefinition"], result)

    @builtins.property
    def manage_status_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetManageStatusDefinition"]:
        '''manage_status_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#manage_status_definition Dashboard#manage_status_definition}
        '''
        result = self._values.get("manage_status_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetManageStatusDefinition"], result)

    @builtins.property
    def note_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetNoteDefinition"]:
        '''note_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#note_definition Dashboard#note_definition}
        '''
        result = self._values.get("note_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetNoteDefinition"], result)

    @builtins.property
    def query_table_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetQueryTableDefinition"]:
        '''query_table_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_table_definition Dashboard#query_table_definition}
        '''
        result = self._values.get("query_table_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetQueryTableDefinition"], result)

    @builtins.property
    def query_value_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetQueryValueDefinition"]:
        '''query_value_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_value_definition Dashboard#query_value_definition}
        '''
        result = self._values.get("query_value_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetQueryValueDefinition"], result)

    @builtins.property
    def scatterplot_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetScatterplotDefinition"]:
        '''scatterplot_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scatterplot_definition Dashboard#scatterplot_definition}
        '''
        result = self._values.get("scatterplot_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetScatterplotDefinition"], result)

    @builtins.property
    def service_level_objective_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetServiceLevelObjectiveDefinition"]:
        '''service_level_objective_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service_level_objective_definition Dashboard#service_level_objective_definition}
        '''
        result = self._values.get("service_level_objective_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetServiceLevelObjectiveDefinition"], result)

    @builtins.property
    def servicemap_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetServicemapDefinition"]:
        '''servicemap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#servicemap_definition Dashboard#servicemap_definition}
        '''
        result = self._values.get("servicemap_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetServicemapDefinition"], result)

    @builtins.property
    def sunburst_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetSunburstDefinition"]:
        '''sunburst_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sunburst_definition Dashboard#sunburst_definition}
        '''
        result = self._values.get("sunburst_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetSunburstDefinition"], result)

    @builtins.property
    def timeseries_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetTimeseriesDefinition"]:
        '''timeseries_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeseries_definition Dashboard#timeseries_definition}
        '''
        result = self._values.get("timeseries_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetTimeseriesDefinition"], result)

    @builtins.property
    def toplist_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetToplistDefinition"]:
        '''toplist_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#toplist_definition Dashboard#toplist_definition}
        '''
        result = self._values.get("toplist_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetToplistDefinition"], result)

    @builtins.property
    def trace_service_definition(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetTraceServiceDefinition"]:
        '''trace_service_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#trace_service_definition Dashboard#trace_service_definition}
        '''
        result = self._values.get("trace_service_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetTraceServiceDefinition"], result)

    @builtins.property
    def widget_layout(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetWidgetLayout"]:
        '''widget_layout block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget_layout Dashboard#widget_layout}
        '''
        result = self._values.get("widget_layout")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetWidgetLayout"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "alert_id": "alertId",
        "viz_type": "vizType",
        "live_span": "liveSpan",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition:
    def __init__(
        self,
        *,
        alert_id: builtins.str,
        viz_type: builtins.str,
        live_span: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alert_id: The ID of the monitor used by the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        :param viz_type: Type of visualization to use when displaying the widget. Valid values are ``timeseries``, ``toplist``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alert_id": alert_id,
            "viz_type": viz_type,
        }
        if live_span is not None:
            self._values["live_span"] = live_span
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def alert_id(self) -> builtins.str:
        '''The ID of the monitor used by the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        '''
        result = self._values.get("alert_id")
        assert result is not None, "Required property 'alert_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def viz_type(self) -> builtins.str:
        '''Type of visualization to use when displaying the widget. Valid values are ``timeseries``, ``toplist``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
        '''
        result = self._values.get("viz_type")
        assert result is not None, "Required property 'viz_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alertIdInput")
    def alert_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alertIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="vizTypeInput")
    def viz_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "vizTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alertId")
    def alert_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alertId"))

    @alert_id.setter
    def alert_id(self, value: builtins.str) -> None:
        jsii.set(self, "alertId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="vizType")
    def viz_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "vizType"))

    @viz_type.setter
    def viz_type(self, value: builtins.str) -> None:
        jsii.set(self, "vizType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetAlertValueDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "alert_id": "alertId",
        "precision": "precision",
        "text_align": "textAlign",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
        "unit": "unit",
    },
)
class DashboardWidgetGroupDefinitionWidgetAlertValueDefinition:
    def __init__(
        self,
        *,
        alert_id: builtins.str,
        precision: typing.Optional[jsii.Number] = None,
        text_align: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alert_id: The ID of the monitor used by the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        :param precision: The precision to use when displaying the value. Use ``*`` for maximum precision. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
        :param text_align: The alignment of the text in the widget. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        :param unit: The unit for the value displayed in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alert_id": alert_id,
        }
        if precision is not None:
            self._values["precision"] = precision
        if text_align is not None:
            self._values["text_align"] = text_align
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def alert_id(self) -> builtins.str:
        '''The ID of the monitor used by the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        '''
        result = self._values.get("alert_id")
        assert result is not None, "Required property 'alert_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def precision(self) -> typing.Optional[jsii.Number]:
        '''The precision to use when displaying the value. Use ``*`` for maximum precision.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
        '''
        result = self._values.get("precision")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def text_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the text in the widget. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
        '''
        result = self._values.get("text_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''The unit for the value displayed in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
        '''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetAlertValueDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionWidgetAlertValueDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetAlertValueDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetPrecision")
    def reset_precision(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrecision", []))

    @jsii.member(jsii_name="resetTextAlign")
    def reset_text_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTextAlign", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @jsii.member(jsii_name="resetUnit")
    def reset_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUnit", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alertIdInput")
    def alert_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alertIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="precisionInput")
    def precision_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "precisionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textAlignInput")
    def text_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "textAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="unitInput")
    def unit_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "unitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alertId")
    def alert_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alertId"))

    @alert_id.setter
    def alert_id(self, value: builtins.str) -> None:
        jsii.set(self, "alertId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="precision")
    def precision(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "precision"))

    @precision.setter
    def precision(self, value: jsii.Number) -> None:
        jsii.set(self, "precision", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="textAlign")
    def text_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "textAlign"))

    @text_align.setter
    def text_align(self, value: builtins.str) -> None:
        jsii.set(self, "textAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="unit")
    def unit(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "unit"))

    @unit.setter
    def unit(self, value: builtins.str) -> None:
        jsii.set(self, "unit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetAlertValueDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetAlertValueDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinitionWidgetAlertValueDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "custom_link": "customLink",
        "live_span": "liveSpan",
        "request": "request",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinition:
    def __init__(
        self,
        *,
        custom_link: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink"]]] = None,
        live_span: typing.Optional[builtins.str] = None,
        request: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest"]]] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param custom_link: custom_link block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param request: request block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if custom_link is not None:
            self._values["custom_link"] = custom_link
        if live_span is not None:
            self._values["live_span"] = live_span
        if request is not None:
            self._values["request"] = request
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def custom_link(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink"]]]:
        '''custom_link block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
        '''
        result = self._values.get("custom_link")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink"]]], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def request(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest"]]]:
        '''request block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        '''
        result = self._values.get("request")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest"]]], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink",
    jsii_struct_bases=[],
    name_mapping={
        "is_hidden": "isHidden",
        "label": "label",
        "link": "link",
        "override_label": "overrideLabel",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink:
    def __init__(
        self,
        *,
        is_hidden: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        label: typing.Optional[builtins.str] = None,
        link: typing.Optional[builtins.str] = None,
        override_label: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param is_hidden: The flag for toggling context menu link visibility. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
        :param label: The label for the custom link URL. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
        :param link: The URL of the custom link. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
        :param override_label: The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if is_hidden is not None:
            self._values["is_hidden"] = is_hidden
        if label is not None:
            self._values["label"] = label
        if link is not None:
            self._values["link"] = link
        if override_label is not None:
            self._values["override_label"] = override_label

    @builtins.property
    def is_hidden(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''The flag for toggling context menu link visibility.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
        '''
        result = self._values.get("is_hidden")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def label(self) -> typing.Optional[builtins.str]:
        '''The label for the custom link URL.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
        '''
        result = self._values.get("label")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def link(self) -> typing.Optional[builtins.str]:
        '''The URL of the custom link.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
        '''
        result = self._values.get("link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def override_label(self) -> typing.Optional[builtins.str]:
        '''The label id that refers to a context menu link item.

        When override_label is provided, the client request omits the label field.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
        '''
        result = self._values.get("override_label")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionWidgetChangeDefinitionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetCustomLink")
    def reset_custom_link(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomLink", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetRequest")
    def reset_request(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRequest", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customLinkInput")
    def custom_link_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink]]], jsii.get(self, "customLinkInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="requestInput")
    def request_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest"]]], jsii.get(self, "requestInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customLink")
    def custom_link(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink]], jsii.get(self, "customLink"))

    @custom_link.setter
    def custom_link(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink]],
    ) -> None:
        jsii.set(self, "customLink", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        jsii.set(self, "liveSpan", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="request")
    def request(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest"]], jsii.get(self, "request"))

    @request.setter
    def request(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest"]],
    ) -> None:
        jsii.set(self, "request", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        jsii.set(self, "titleAlign", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        jsii.set(self, "titleSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinition],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest",
    jsii_struct_bases=[],
    name_mapping={
        "apm_query": "apmQuery",
        "change_type": "changeType",
        "compare_to": "compareTo",
        "formula": "formula",
        "increase_good": "increaseGood",
        "log_query": "logQuery",
        "order_by": "orderBy",
        "order_dir": "orderDir",
        "process_query": "processQuery",
        "q": "q",
        "query": "query",
        "rum_query": "rumQuery",
        "security_query": "securityQuery",
        "show_present": "showPresent",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest:
    def __init__(
        self,
        *,
        apm_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery"] = None,
        change_type: typing.Optional[builtins.str] = None,
        compare_to: typing.Optional[builtins.str] = None,
        formula: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula"]]] = None,
        increase_good: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        log_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery"] = None,
        order_by: typing.Optional[builtins.str] = None,
        order_dir: typing.Optional[builtins.str] = None,
        process_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery"] = None,
        q: typing.Optional[builtins.str] = None,
        query: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQuery"]]] = None,
        rum_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery"] = None,
        security_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery"] = None,
        show_present: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param apm_query: apm_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        :param change_type: Whether to show absolute or relative change. Valid values are ``absolute``, ``relative``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
        :param compare_to: Choose from when to compare current data to. Valid values are ``hour_before``, ``day_before``, ``week_before``, ``month_before``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
        :param formula: formula block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
        :param increase_good: A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
        :param log_query: log_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        :param order_by: What to order by. Valid values are ``change``, ``name``, ``present``, ``past``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
        :param order_dir: Widget sorting method. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
        :param process_query: process_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        :param q: The metric query to use for this widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        :param query: query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param rum_query: rum_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        :param security_query: security_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        :param show_present: If set to ``true``, displays the current value. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
        '''
        if isinstance(apm_query, dict):
            apm_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery(**apm_query)
        if isinstance(log_query, dict):
            log_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery(**log_query)
        if isinstance(process_query, dict):
            process_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery(**process_query)
        if isinstance(rum_query, dict):
            rum_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery(**rum_query)
        if isinstance(security_query, dict):
            security_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery(**security_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if apm_query is not None:
            self._values["apm_query"] = apm_query
        if change_type is not None:
            self._values["change_type"] = change_type
        if compare_to is not None:
            self._values["compare_to"] = compare_to
        if formula is not None:
            self._values["formula"] = formula
        if increase_good is not None:
            self._values["increase_good"] = increase_good
        if log_query is not None:
            self._values["log_query"] = log_query
        if order_by is not None:
            self._values["order_by"] = order_by
        if order_dir is not None:
            self._values["order_dir"] = order_dir
        if process_query is not None:
            self._values["process_query"] = process_query
        if q is not None:
            self._values["q"] = q
        if query is not None:
            self._values["query"] = query
        if rum_query is not None:
            self._values["rum_query"] = rum_query
        if security_query is not None:
            self._values["security_query"] = security_query
        if show_present is not None:
            self._values["show_present"] = show_present

    @builtins.property
    def apm_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery"]:
        '''apm_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        '''
        result = self._values.get("apm_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery"], result)

    @builtins.property
    def change_type(self) -> typing.Optional[builtins.str]:
        '''Whether to show absolute or relative change. Valid values are ``absolute``, ``relative``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
        '''
        result = self._values.get("change_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def compare_to(self) -> typing.Optional[builtins.str]:
        '''Choose from when to compare current data to. Valid values are ``hour_before``, ``day_before``, ``week_before``, ``month_before``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
        '''
        result = self._values.get("compare_to")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def formula(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula"]]]:
        '''formula block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
        '''
        result = self._values.get("formula")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula"]]], result)

    @builtins.property
    def increase_good(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
        '''
        result = self._values.get("increase_good")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def log_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery"]:
        '''log_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        '''
        result = self._values.get("log_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery"], result)

    @builtins.property
    def order_by(self) -> typing.Optional[builtins.str]:
        '''What to order by. Valid values are ``change``, ``name``, ``present``, ``past``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
        '''
        result = self._values.get("order_by")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def order_dir(self) -> typing.Optional[builtins.str]:
        '''Widget sorting method. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
        '''
        result = self._values.get("order_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def process_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery"]:
        '''process_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        result = self._values.get("process_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery"], result)

    @builtins.property
    def q(self) -> typing.Optional[builtins.str]:
        '''The metric query to use for this widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        '''
        result = self._values.get("q")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def query(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQuery"]]]:
        '''query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQuery"]]], result)

    @builtins.property
    def rum_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery"]:
        '''rum_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        '''
        result = self._values.get("rum_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery"], result)

    @builtins.property
    def security_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery"]:
        '''security_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        '''
        result = self._values.get("security_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery"], result)

    @builtins.property
    def show_present(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''If set to ``true``, displays the current value.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
        '''
        result = self._values.get("show_present")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy]], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy]],
    ) -> None:
        jsii.set(self, "groupBy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        jsii.set(self, "index", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute]], jsii.get(self, "multiCompute"))

    @multi_compute.setter
    def multi_compute(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute]],
    ) -> None:
        jsii.set(self, "multiCompute", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        jsii.set(self, "searchQuery", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula",
    jsii_struct_bases=[],
    name_mapping={
        "formula_expression": "formulaExpression",
        "alias": "alias",
        "cell_display_mode": "cellDisplayMode",
        "conditional_formats": "conditionalFormats",
        "limit": "limit",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula:
    def __init__(
        self,
        *,
        formula_expression: builtins.str,
        alias: typing.Optional[builtins.str] = None,
        cell_display_mode: typing.Optional[builtins.str] = None,
        conditional_formats: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats"]]] = None,
        limit: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit"] = None,
    ) -> None:
        '''
        :param formula_expression: A string expression built from queries, formulas, and functions. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
        :param alias: An expression alias. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        :param cell_display_mode: A list of display modes for each table cell. Valid values are ``number``, ``bar``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        :param conditional_formats: conditional_formats block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
        :param limit: limit block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        if isinstance(limit, dict):
            limit = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit(**limit)
        self._values: typing.Dict[str, typing.Any] = {
            "formula_expression": formula_expression,
        }
        if alias is not None:
            self._values["alias"] = alias
        if cell_display_mode is not None:
            self._values["cell_display_mode"] = cell_display_mode
        if conditional_formats is not None:
            self._values["conditional_formats"] = conditional_formats
        if limit is not None:
            self._values["limit"] = limit

    @builtins.property
    def formula_expression(self) -> builtins.str:
        '''A string expression built from queries, formulas, and functions.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
        '''
        result = self._values.get("formula_expression")
        assert result is not None, "Required property 'formula_expression' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alias(self) -> typing.Optional[builtins.str]:
        '''An expression alias.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        '''
        result = self._values.get("alias")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cell_display_mode(self) -> typing.Optional[builtins.str]:
        '''A list of display modes for each table cell. Valid values are ``number``, ``bar``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        '''
        result = self._values.get("cell_display_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def conditional_formats(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats"]]]:
        '''conditional_formats block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
        '''
        result = self._values.get("conditional_formats")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats"]]], result)

    @builtins.property
    def limit(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit"]:
        '''limit block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats",
    jsii_struct_bases=[],
    name_mapping={
        "comparator": "comparator",
        "palette": "palette",
        "value": "value",
        "custom_bg_color": "customBgColor",
        "custom_fg_color": "customFgColor",
        "hide_value": "hideValue",
        "image_url": "imageUrl",
        "metric": "metric",
        "timeframe": "timeframe",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats:
    def __init__(
        self,
        *,
        comparator: builtins.str,
        palette: builtins.str,
        value: jsii.Number,
        custom_bg_color: typing.Optional[builtins.str] = None,
        custom_fg_color: typing.Optional[builtins.str] = None,
        hide_value: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        image_url: typing.Optional[builtins.str] = None,
        metric: typing.Optional[builtins.str] = None,
        timeframe: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param comparator: The comparator to use. Valid values are ``>``, ``>=``, ``<``, ``<=``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
        :param palette: The color palette to apply. Valid values are ``blue``, ``custom_bg``, ``custom_image``, ``custom_text``, ``gray_on_white``, ``grey``, ``green``, ``orange``, ``red``, ``red_on_white``, ``white_on_gray``, ``white_on_green``, ``green_on_white``, ``white_on_red``, ``white_on_yellow``, ``yellow_on_white``, ``black_on_light_yellow``, ``black_on_light_green``, ``black_on_light_red``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        :param value: A value for the comparator. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        :param custom_bg_color: The color palette to apply to the background, same values available as palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
        :param custom_fg_color: The color palette to apply to the foreground, same values available as palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
        :param hide_value: Setting this to True hides values. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
        :param image_url: Displays an image as the background. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
        :param metric: The metric from the request to correlate with this conditional format. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param timeframe: Defines the displayed timeframe. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "comparator": comparator,
            "palette": palette,
            "value": value,
        }
        if custom_bg_color is not None:
            self._values["custom_bg_color"] = custom_bg_color
        if custom_fg_color is not None:
            self._values["custom_fg_color"] = custom_fg_color
        if hide_value is not None:
            self._values["hide_value"] = hide_value
        if image_url is not None:
            self._values["image_url"] = image_url
        if metric is not None:
            self._values["metric"] = metric
        if timeframe is not None:
            self._values["timeframe"] = timeframe

    @builtins.property
    def comparator(self) -> builtins.str:
        '''The comparator to use. Valid values are ``>``, ``>=``, ``<``, ``<=``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
        '''
        result = self._values.get("comparator")
        assert result is not None, "Required property 'comparator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def palette(self) -> builtins.str:
        '''The color palette to apply.

        Valid values are ``blue``, ``custom_bg``, ``custom_image``, ``custom_text``, ``gray_on_white``, ``grey``, ``green``, ``orange``, ``red``, ``red_on_white``, ``white_on_gray``, ``white_on_green``, ``green_on_white``, ``white_on_red``, ``white_on_yellow``, ``yellow_on_white``, ``black_on_light_yellow``, ``black_on_light_green``, ``black_on_light_red``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        result = self._values.get("palette")
        assert result is not None, "Required property 'palette' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> jsii.Number:
        '''A value for the comparator.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def custom_bg_color(self) -> typing.Optional[builtins.str]:
        '''The color palette to apply to the background, same values available as palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
        '''
        result = self._values.get("custom_bg_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def custom_fg_color(self) -> typing.Optional[builtins.str]:
        '''The color palette to apply to the foreground, same values available as palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
        '''
        result = self._values.get("custom_fg_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def hide_value(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Setting this to True hides values.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
        '''
        result = self._values.get("hide_value")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def image_url(self) -> typing.Optional[builtins.str]:
        '''Displays an image as the background.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
        '''
        result = self._values.get("image_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The metric from the request to correlate with this conditional format.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def timeframe(self) -> typing.Optional[builtins.str]:
        '''Defines the displayed timeframe.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
        '''
        result = self._values.get("timeframe")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit",
    jsii_struct_bases=[],
    name_mapping={"count": "count", "order": "order"},
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit:
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param count: The number of results to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        :param order: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if count is not None:
            self._values["count"] = count
        if order is not None:
            self._values["order"] = order

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''The number of results to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def order(self) -> typing.Optional[builtins.str]:
        '''The direction of the sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetCount")
    def reset_count(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCount", []))

    @jsii.member(jsii_name="resetOrder")
    def reset_order(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrder", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="countInput")
    def count_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "countInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="count")
    def count(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "count"))

    @count.setter
    def count(self, value: jsii.Number) -> None:
        jsii.set(self, "count", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        jsii.set(self, "order", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery"] = None,
        group_by: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy"]]] = None,
        multi_compute: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute"]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery(**compute_query)
        self._values: typing.Dict[str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        is_single_item: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param is_single_item: True if this is a block, false if it's a list.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, is_single_item])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        jsii.set(self, "aggregation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        jsii.set(self, "facet", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        jsii.set(self, "interval", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery(**sort_query)
        self._values: typing.Dict[str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Re