import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name for Application Key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/application_key#name ApplicationKey#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/application_key datadog_application_key}.
 *
 * @stability stable
 */
export declare class ApplicationKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/application_key datadog_application_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationKeyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get key(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
