import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ChildOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name for Child Organization after creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/child_organization#name ChildOrganization#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export declare class ChildOrganizationApiKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class ChildOrganizationApplicationKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hash(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get owner(): string;
}
/**
 * @stability stable
 */
export declare class ChildOrganizationSettingsSaml extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ChildOrganizationSettingsSamlAutocreateUsersDomains extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get domains(): string[];
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ChildOrganizationSettingsSamlIdpInitiatedLogin extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ChildOrganizationSettingsSamlStrictMode extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ChildOrganizationSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get privateWidgetShare(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get saml(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get samlAutocreateAccessRole(): string;
    /**
     * @stability stable
     */
    get samlAutocreateUsersDomains(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get samlCanBeEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get samlIdpEndpoint(): string;
    /**
     * @stability stable
     */
    get samlIdpInitiatedLogin(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get samlIdpMetadataUploaded(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get samlLoginUrl(): string;
    /**
     * @stability stable
     */
    get samlStrictMode(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ChildOrganizationUser extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accessRole(): string;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/child_organization datadog_child_organization}.
 *
 * @stability stable
 */
export declare class ChildOrganization extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/child_organization datadog_child_organization} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ChildOrganizationConfig);
    /**
     * @stability stable
     */
    apiKey(index: string): ChildOrganizationApiKey;
    /**
     * @stability stable
     */
    applicationKey(index: string): ChildOrganizationApplicationKey;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicId(): string;
    /**
     * @stability stable
     */
    settings(index: string): ChildOrganizationSettings;
    /**
     * @stability stable
     */
    user(index: string): ChildOrganizationUser;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
