import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DashboardListConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Dashboard List.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#name DashboardList#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * dash_item block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_item DashboardList#dash_item}
     *
     * @stability stable
     */
    readonly dashItem?: DashboardListDashItem[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DashboardListDashItem {
    /**
     * The ID of the dashboard to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_id DashboardList#dash_id}
     *
     * @stability stable
     */
    readonly dashId: string;
    /**
     * The type of this dashboard. Valid values are `custom_timeboard`, `custom_screenboard`, `integration_screenboard`, `integration_timeboard`, `host_timeboard`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#type DashboardList#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function dashboardListDashItemToTerraform(struct?: DashboardListDashItem | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list datadog_dashboard_list}.
 *
 * @stability stable
 */
export declare class DashboardList extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list datadog_dashboard_list} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DashboardListConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _dashItem?;
    /**
     * @stability stable
     */
    get dashItem(): DashboardListDashItem[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dashItem(value: DashboardListDashItem[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDashItem(): void;
    /**
     * @stability stable
     */
    get dashItemInput(): cdktf.IResolvable | DashboardListDashItem[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
