import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DashboardTemplateVariable {
    /**
     * The list of values that the template variable drop-down is be limited to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#available_values Dashboard#available_values}
     *
     * @stability stable
     */
    readonly availableValues?: string[];
    /**
     * The default value for the template variable on dashboard load.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#default Dashboard#default}
     *
     * @stability stable
     */
    readonly default?: string;
    /**
     * The name of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The tag prefix associated with the variable. Only tags with this prefix appear in the variable dropdown.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#prefix Dashboard#prefix}
     *
     * @stability stable
     */
    readonly prefix?: string;
}
export declare function dashboardTemplateVariableToTerraform(struct?: DashboardTemplateVariable | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardTemplateVariablePresetTemplateVariable {
    /**
     * The name of the template variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The value that should be assumed by the template variable in this preset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function dashboardTemplateVariablePresetTemplateVariableToTerraform(struct?: DashboardTemplateVariablePresetTemplateVariable | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardTemplateVariablePreset {
    /**
     * The name of the preset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * template_variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
     *
     * @stability stable
     */
    readonly templateVariable?: DashboardTemplateVariablePresetTemplateVariable[] | cdktf.IResolvable;
}
export declare function dashboardTemplateVariablePresetToTerraform(struct?: DashboardTemplateVariablePreset | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetAlertGraphDefinition {
    /**
     * The ID of the monitor used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
     *
     * @stability stable
     */
    readonly alertId: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * Type of visualization to use when displaying the widget. Valid values are `timeseries`, `toplist`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
     *
     * @stability stable
     */
    readonly vizType: string;
}
export declare function dashboardWidgetAlertGraphDefinitionToTerraform(struct?: DashboardWidgetAlertGraphDefinitionOutputReference | DashboardWidgetAlertGraphDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetAlertGraphDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetAlertGraphDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetAlertGraphDefinition | undefined);
    private _alertId?;
    /**
     * @stability stable
     */
    get alertId(): string;
    /**
     * @stability stable
     */
    set alertId(value: string);
    /**
     * @stability stable
     */
    get alertIdInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _vizType?;
    /**
     * @stability stable
     */
    get vizType(): string;
    /**
     * @stability stable
     */
    set vizType(value: string);
    /**
     * @stability stable
     */
    get vizTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetAlertValueDefinition {
    /**
     * The ID of the monitor used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
     *
     * @stability stable
     */
    readonly alertId: string;
    /**
     * The precision to use when displaying the value. Use `*` for maximum precision.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
     *
     * @stability stable
     */
    readonly precision?: number;
    /**
     * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * The unit for the value displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
     *
     * @stability stable
     */
    readonly unit?: string;
}
export declare function dashboardWidgetAlertValueDefinitionToTerraform(struct?: DashboardWidgetAlertValueDefinitionOutputReference | DashboardWidgetAlertValueDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetAlertValueDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetAlertValueDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetAlertValueDefinition | undefined);
    private _alertId?;
    /**
     * @stability stable
     */
    get alertId(): string;
    /**
     * @stability stable
     */
    set alertId(value: string);
    /**
     * @stability stable
     */
    get alertIdInput(): string | undefined;
    private _precision?;
    /**
     * @stability stable
     */
    get precision(): number;
    /**
     * @stability stable
     */
    set precision(value: number);
    /**
     * @stability stable
     */
    resetPrecision(): void;
    /**
     * @stability stable
     */
    get precisionInput(): number | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string;
    /**
     * @stability stable
     */
    set textAlign(value: string);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string;
    /**
     * @stability stable
     */
    set unit(value: string);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetChangeDefinitionCustomLinkToTerraform(struct?: DashboardWidgetChangeDefinitionCustomLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryOutputReference | DashboardWidgetChangeDefinitionRequestApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function dashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference | DashboardWidgetChangeDefinitionRequestFormulaLimit): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestFormulaLimit | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestFormulaLimit | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetChangeDefinitionRequestFormulaLimit;
}
export declare function dashboardWidgetChangeDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetChangeDefinitionRequestFormula | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryOutputReference | DashboardWidgetChangeDefinitionRequestLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference | DashboardWidgetChangeDefinitionRequestProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[];
    /**
     * @stability stable
     */
    set filterBy(value: string[]);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string;
    /**
     * @stability stable
     */
    set searchBy(value: string);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[];
    /**
     * @stability stable
     */
    set groupBy(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryEventQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryEventQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[];
    /**
     * @stability stable
     */
    set indexes(value: string[]);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get computeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryMetricQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryMetricQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string;
    /**
     * @stability stable
     */
    set sort(value: string);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[];
    /**
     * @stability stable
     */
    set tagFilters(value: string[]);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string;
    /**
     * @stability stable
     */
    set textFilter(value: string);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetChangeDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetChangeDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetChangeDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQuery | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryOutputReference | DashboardWidgetChangeDefinitionRequestRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference | DashboardWidgetChangeDefinitionRequestSecurityQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinitionRequestSecurityQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinitionRequestSecurityQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequest {
    /**
     * Whether to show absolute or relative change. Valid values are `absolute`, `relative`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
     *
     * @stability stable
     */
    readonly changeType?: string;
    /**
     * Choose from when to compare current data to. Valid values are `hour_before`, `day_before`, `week_before`, `month_before`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
     *
     * @stability stable
     */
    readonly compareTo?: string;
    /**
     * A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
     *
     * @stability stable
     */
    readonly increaseGood?: boolean | cdktf.IResolvable;
    /**
     * What to order by. Valid values are `change`, `name`, `present`, `past`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
     *
     * @stability stable
     */
    readonly orderBy?: string;
    /**
     * Widget sorting method. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
     *
     * @stability stable
     */
    readonly orderDir?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * If set to `true`, displays the current value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
     *
     * @stability stable
     */
    readonly showPresent?: boolean | cdktf.IResolvable;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetChangeDefinitionRequestApmQuery;
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetChangeDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetChangeDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetChangeDefinitionRequestProcessQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetChangeDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetChangeDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetChangeDefinitionRequestSecurityQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestToTerraform(struct?: DashboardWidgetChangeDefinitionRequest | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetChangeDefinitionRequest[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionToTerraform(struct?: DashboardWidgetChangeDefinitionOutputReference | DashboardWidgetChangeDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetChangeDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetChangeDefinition | undefined);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetChangeDefinitionRequest[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetChangeDefinitionRequest[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetCheckStatusDefinition {
    /**
     * The check to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check Dashboard#check}
     *
     * @stability stable
     */
    readonly check: string;
    /**
     * The check group to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group Dashboard#group}
     *
     * @stability stable
     */
    readonly group?: string;
    /**
     * When `grouping = "cluster"`, indicates a list of tags to use for grouping.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The kind of grouping to use. Valid values are `check`, `cluster`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#grouping Dashboard#grouping}
     *
     * @stability stable
     */
    readonly grouping: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * A list of tags to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags Dashboard#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
export declare function dashboardWidgetCheckStatusDefinitionToTerraform(struct?: DashboardWidgetCheckStatusDefinitionOutputReference | DashboardWidgetCheckStatusDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetCheckStatusDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetCheckStatusDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetCheckStatusDefinition | undefined);
    private _check?;
    /**
     * @stability stable
     */
    get check(): string;
    /**
     * @stability stable
     */
    set check(value: string);
    /**
     * @stability stable
     */
    get checkInput(): string | undefined;
    private _group?;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    set group(value: string);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[];
    /**
     * @stability stable
     */
    set groupBy(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _grouping?;
    /**
     * @stability stable
     */
    get grouping(): string;
    /**
     * @stability stable
     */
    set grouping(value: string);
    /**
     * @stability stable
     */
    get groupingInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference | DashboardWidgetDistributionDefinitionRequestApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference | DashboardWidgetDistributionDefinitionRequestLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference | DashboardWidgetDistributionDefinitionRequestProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[];
    /**
     * @stability stable
     */
    set filterBy(value: string[]);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string;
    /**
     * @stability stable
     */
    set searchBy(value: string);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference | DashboardWidgetDistributionDefinitionRequestRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference | DashboardWidgetDistributionDefinitionRequestSecurityQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestSecurityQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestSecurityQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestStyle {
    /**
     * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette?: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestStyleToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestStyleOutputReference | DashboardWidgetDistributionDefinitionRequestStyle): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinitionRequestStyle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestStyle | undefined);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string;
    /**
     * @stability stable
     */
    set palette(value: string);
    /**
     * @stability stable
     */
    resetPalette(): void;
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetDistributionDefinitionRequestApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetDistributionDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetDistributionDefinitionRequestProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetDistributionDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQuery;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetDistributionDefinitionRequestStyle;
}
export declare function dashboardWidgetDistributionDefinitionRequestToTerraform(struct?: DashboardWidgetDistributionDefinitionRequest | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinition {
    /**
     * The size of the legend displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#legend_size Dashboard#legend_size}
     *
     * @stability stable
     */
    readonly legendSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * Whether or not to show the legend on this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_legend Dashboard#show_legend}
     *
     * @stability stable
     */
    readonly showLegend?: boolean | cdktf.IResolvable;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetDistributionDefinitionRequest[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionToTerraform(struct?: DashboardWidgetDistributionDefinitionOutputReference | DashboardWidgetDistributionDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetDistributionDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetDistributionDefinition | undefined);
    private _legendSize?;
    /**
     * @stability stable
     */
    get legendSize(): string;
    /**
     * @stability stable
     */
    set legendSize(value: string);
    /**
     * @stability stable
     */
    resetLegendSize(): void;
    /**
     * @stability stable
     */
    get legendSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _showLegend?;
    /**
     * @stability stable
     */
    get showLegend(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showLegend(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowLegend(): void;
    /**
     * @stability stable
     */
    get showLegendInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetDistributionDefinitionRequest[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetDistributionDefinitionRequest[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetEventStreamDefinition {
    /**
     * The size to use to display an event. Valid values are `s`, `l`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_size Dashboard#event_size}
     *
     * @stability stable
     */
    readonly eventSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The execution method for multi-value filters, options: `and` or `or`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
export declare function dashboardWidgetEventStreamDefinitionToTerraform(struct?: DashboardWidgetEventStreamDefinitionOutputReference | DashboardWidgetEventStreamDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetEventStreamDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetEventStreamDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetEventStreamDefinition | undefined);
    private _eventSize?;
    /**
     * @stability stable
     */
    get eventSize(): string;
    /**
     * @stability stable
     */
    set eventSize(value: string);
    /**
     * @stability stable
     */
    resetEventSize(): void;
    /**
     * @stability stable
     */
    get eventSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _tagsExecution?;
    /**
     * @stability stable
     */
    get tagsExecution(): string;
    /**
     * @stability stable
     */
    set tagsExecution(value: string);
    /**
     * @stability stable
     */
    resetTagsExecution(): void;
    /**
     * @stability stable
     */
    get tagsExecutionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetEventTimelineDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The execution method for multi-value filters, options: `and` or `or`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
export declare function dashboardWidgetEventTimelineDefinitionToTerraform(struct?: DashboardWidgetEventTimelineDefinitionOutputReference | DashboardWidgetEventTimelineDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetEventTimelineDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetEventTimelineDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetEventTimelineDefinition | undefined);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _tagsExecution?;
    /**
     * @stability stable
     */
    get tagsExecution(): string;
    /**
     * @stability stable
     */
    set tagsExecution(value: string);
    /**
     * @stability stable
     */
    resetTagsExecution(): void;
    /**
     * @stability stable
     */
    get tagsExecutionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetFreeTextDefinition {
    /**
     * The color of the text in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#color Dashboard#color}
     *
     * @stability stable
     */
    readonly color?: string;
    /**
     * The size of the text in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#font_size Dashboard#font_size}
     *
     * @stability stable
     */
    readonly fontSize?: string;
    /**
     * The text to display in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text Dashboard#text}
     *
     * @stability stable
     */
    readonly text: string;
    /**
     * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
}
export declare function dashboardWidgetFreeTextDefinitionToTerraform(struct?: DashboardWidgetFreeTextDefinitionOutputReference | DashboardWidgetFreeTextDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetFreeTextDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetFreeTextDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetFreeTextDefinition | undefined);
    private _color?;
    /**
     * @stability stable
     */
    get color(): string;
    /**
     * @stability stable
     */
    set color(value: string);
    /**
     * @stability stable
     */
    resetColor(): void;
    /**
     * @stability stable
     */
    get colorInput(): string | undefined;
    private _fontSize?;
    /**
     * @stability stable
     */
    get fontSize(): string;
    /**
     * @stability stable
     */
    set fontSize(value: string);
    /**
     * @stability stable
     */
    resetFontSize(): void;
    /**
     * @stability stable
     */
    get fontSizeInput(): string | undefined;
    private _text?;
    /**
     * @stability stable
     */
    get text(): string;
    /**
     * @stability stable
     */
    set text(value: string);
    /**
     * @stability stable
     */
    get textInput(): string | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string;
    /**
     * @stability stable
     */
    set textAlign(value: string);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGeomapDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGeomapDefinitionCustomLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestFormulaLimitOutputReference | DashboardWidgetGeomapDefinitionRequestFormulaLimit): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestFormulaLimit | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestFormulaLimit | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetGeomapDefinitionRequestFormulaLimit;
}
export declare function dashboardWidgetGeomapDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestFormula | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryOutputReference | DashboardWidgetGeomapDefinitionRequestLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[];
    /**
     * @stability stable
     */
    set groupBy(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryEventQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryEventQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[];
    /**
     * @stability stable
     */
    set indexes(value: string[]);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get computeInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryMetricQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryMetricQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string;
    /**
     * @stability stable
     */
    set sort(value: string);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[];
    /**
     * @stability stable
     */
    set tagFilters(value: string[]);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string;
    /**
     * @stability stable
     */
    set textFilter(value: string);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetGeomapDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetGeomapDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGeomapDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQuery | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryOutputReference | DashboardWidgetGeomapDefinitionRequestRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionRequestRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetGeomapDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGeomapDefinitionRequestLogQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetGeomapDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGeomapDefinitionRequestRumQuery;
}
export declare function dashboardWidgetGeomapDefinitionRequestToTerraform(struct?: DashboardWidgetGeomapDefinitionRequest | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionStyle {
    /**
     * The color palette to apply to the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * A Boolean indicating whether to flip the palette tones.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_flip Dashboard#palette_flip}
     *
     * @stability stable
     */
    readonly paletteFlip: boolean | cdktf.IResolvable;
}
export declare function dashboardWidgetGeomapDefinitionStyleToTerraform(struct?: DashboardWidgetGeomapDefinitionStyleOutputReference | DashboardWidgetGeomapDefinitionStyle): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionStyle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionStyle | undefined);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string;
    /**
     * @stability stable
     */
    set palette(value: string);
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
    private _paletteFlip?;
    /**
     * @stability stable
     */
    get paletteFlip(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set paletteFlip(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get paletteFlipInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionView {
    /**
     * The two-letter ISO code of a country to focus the map on (or `WORLD`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#focus Dashboard#focus}
     *
     * @stability stable
     */
    readonly focus: string;
}
export declare function dashboardWidgetGeomapDefinitionViewToTerraform(struct?: DashboardWidgetGeomapDefinitionViewOutputReference | DashboardWidgetGeomapDefinitionView): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinitionView | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinitionView | undefined);
    private _focus?;
    /**
     * @stability stable
     */
    get focus(): string;
    /**
     * @stability stable
     */
    set focus(value: string);
    /**
     * @stability stable
     */
    get focusInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGeomapDefinitionRequest[] | cdktf.IResolvable;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGeomapDefinitionStyle;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#view Dashboard#view}
     *
     * @stability stable
     */
    readonly view: DashboardWidgetGeomapDefinitionView;
}
export declare function dashboardWidgetGeomapDefinitionToTerraform(struct?: DashboardWidgetGeomapDefinitionOutputReference | DashboardWidgetGeomapDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGeomapDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGeomapDefinition | undefined);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGeomapDefinitionRequest[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGeomapDefinitionRequest[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequest[] | undefined;
    private _style;
    /**
     * @stability stable
     */
    get style(): DashboardWidgetGeomapDefinitionStyleOutputReference;
    /**
     * @stability stable
     */
    putStyle(value: DashboardWidgetGeomapDefinitionStyle): void;
    /**
     * @stability stable
     */
    resetStyle(): void;
    /**
     * @stability stable
     */
    get styleInput(): DashboardWidgetGeomapDefinitionStyle | undefined;
    private _view;
    /**
     * @stability stable
     */
    get view(): DashboardWidgetGeomapDefinitionViewOutputReference;
    /**
     * @stability stable
     */
    putView(value: DashboardWidgetGeomapDefinitionView): void;
    /**
     * @stability stable
     */
    get viewInput(): DashboardWidgetGeomapDefinitionView | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition {
    /**
     * The ID of the monitor used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
     *
     * @stability stable
     */
    readonly alertId: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * Type of visualization to use when displaying the widget. Valid values are `timeseries`, `toplist`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
     *
     * @stability stable
     */
    readonly vizType: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition | undefined);
    private _alertId?;
    /**
     * @stability stable
     */
    get alertId(): string;
    /**
     * @stability stable
     */
    set alertId(value: string);
    /**
     * @stability stable
     */
    get alertIdInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _vizType?;
    /**
     * @stability stable
     */
    get vizType(): string;
    /**
     * @stability stable
     */
    set vizType(value: string);
    /**
     * @stability stable
     */
    get vizTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetAlertValueDefinition {
    /**
     * The ID of the monitor used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
     *
     * @stability stable
     */
    readonly alertId: string;
    /**
     * The precision to use when displaying the value. Use `*` for maximum precision.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
     *
     * @stability stable
     */
    readonly precision?: number;
    /**
     * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * The unit for the value displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
     *
     * @stability stable
     */
    readonly unit?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetAlertValueDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetAlertValueDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetAlertValueDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetAlertValueDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetAlertValueDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetAlertValueDefinition | undefined);
    private _alertId?;
    /**
     * @stability stable
     */
    get alertId(): string;
    /**
     * @stability stable
     */
    set alertId(value: string);
    /**
     * @stability stable
     */
    get alertIdInput(): string | undefined;
    private _precision?;
    /**
     * @stability stable
     */
    get precision(): number;
    /**
     * @stability stable
     */
    set precision(value: number);
    /**
     * @stability stable
     */
    resetPrecision(): void;
    /**
     * @stability stable
     */
    get precisionInput(): number | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string;
    /**
     * @stability stable
     */
    set textAlign(value: string);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string;
    /**
     * @stability stable
     */
    set unit(value: string);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[];
    /**
     * @stability stable
     */
    set filterBy(value: string[]);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string;
    /**
     * @stability stable
     */
    set searchBy(value: string);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmResourceStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmResourceStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[];
    /**
     * @stability stable
     */
    set groupBy(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBySort): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBySort | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearch): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[];
    /**
     * @stability stable
     */
    set indexes(value: string[]);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get computeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearch): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryMetricQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryMetricQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string;
    /**
     * @stability stable
     */
    set sort(value: string);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[];
    /**
     * @stability stable
     */
    set tagFilters(value: string[]);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string;
    /**
     * @stability stable
     */
    set textFilter(value: string);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQuery | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest {
    /**
     * Whether to show absolute or relative change. Valid values are `absolute`, `relative`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
     *
     * @stability stable
     */
    readonly changeType?: string;
    /**
     * Choose from when to compare current data to. Valid values are `hour_before`, `day_before`, `week_before`, `month_before`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
     *
     * @stability stable
     */
    readonly compareTo?: string;
    /**
     * A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
     *
     * @stability stable
     */
    readonly increaseGood?: boolean | cdktf.IResolvable;
    /**
     * What to order by. Valid values are `change`, `name`, `present`, `past`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
     *
     * @stability stable
     */
    readonly orderBy?: string;
    /**
     * Widget sorting method. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
     *
     * @stability stable
     */
    readonly orderDir?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * If set to `true`, displays the current value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
     *
     * @stability stable
     */
    readonly showPresent?: boolean | cdktf.IResolvable;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery;
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinition | undefined);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition {
    /**
     * The check to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check Dashboard#check}
     *
     * @stability stable
     */
    readonly check: string;
    /**
     * The check group to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group Dashboard#group}
     *
     * @stability stable
     */
    readonly group?: string;
    /**
     * When `grouping = "cluster"`, indicates a list of tags to use for grouping.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The kind of grouping to use. Valid values are `check`, `cluster`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#grouping Dashboard#grouping}
     *
     * @stability stable
     */
    readonly grouping: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * A list of tags to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags Dashboard#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetCheckStatusDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetCheckStatusDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetCheckStatusDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition | undefined);
    private _check?;
    /**
     * @stability stable
     */
    get check(): string;
    /**
     * @stability stable
     */
    set check(value: string);
    /**
     * @stability stable
     */
    get checkInput(): string | undefined;
    private _group?;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    set group(value: string);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[];
    /**
     * @stability stable
     */
    set groupBy(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _grouping?;
    /**
     * @stability stable
     */
    get grouping(): string;
    /**
     * @stability stable
     */
    set grouping(value: string);
    /**
     * @stability stable
     */
    get groupingInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[];
    /**
     * @stability stable
     */
    set filterBy(value: string[]);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string;
    /**
     * @stability stable
     */
    set searchBy(value: string);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyle {
    /**
     * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyleToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyleOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyle): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyle | undefined);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string;
    /**
     * @stability stable
     */
    set palette(value: string);
    /**
     * @stability stable
     */
    resetPalette(): void;
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQuery;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyle;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinition {
    /**
     * The size of the legend displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#legend_size Dashboard#legend_size}
     *
     * @stability stable
     */
    readonly legendSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * Whether or not to show the legend on this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_legend Dashboard#show_legend}
     *
     * @stability stable
     */
    readonly showLegend?: boolean | cdktf.IResolvable;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetDistributionDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetDistributionDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetDistributionDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinition | undefined);
    private _legendSize?;
    /**
     * @stability stable
     */
    get legendSize(): string;
    /**
     * @stability stable
     */
    set legendSize(value: string);
    /**
     * @stability stable
     */
    resetLegendSize(): void;
    /**
     * @stability stable
     */
    get legendSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _showLegend?;
    /**
     * @stability stable
     */
    get showLegend(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showLegend(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowLegend(): void;
    /**
     * @stability stable
     */
    get showLegendInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetEventStreamDefinition {
    /**
     * The size to use to display an event. Valid values are `s`, `l`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_size Dashboard#event_size}
     *
     * @stability stable
     */
    readonly eventSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The execution method for multi-value filters, options: `and` or `or`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetEventStreamDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetEventStreamDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetEventStreamDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetEventStreamDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetEventStreamDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetEventStreamDefinition | undefined);
    private _eventSize?;
    /**
     * @stability stable
     */
    get eventSize(): string;
    /**
     * @stability stable
     */
    set eventSize(value: string);
    /**
     * @stability stable
     */
    resetEventSize(): void;
    /**
     * @stability stable
     */
    get eventSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _tagsExecution?;
    /**
     * @stability stable
     */
    get tagsExecution(): string;
    /**
     * @stability stable
     */
    set tagsExecution(value: string);
    /**
     * @stability stable
     */
    resetTagsExecution(): void;
    /**
     * @stability stable
     */
    get tagsExecutionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The execution method for multi-value filters, options: `and` or `or`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetEventTimelineDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetEventTimelineDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetEventTimelineDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition | undefined);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _tagsExecution?;
    /**
     * @stability stable
     */
    get tagsExecution(): string;
    /**
     * @stability stable
     */
    set tagsExecution(value: string);
    /**
     * @stability stable
     */
    resetTagsExecution(): void;
    /**
     * @stability stable
     */
    get tagsExecutionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetFreeTextDefinition {
    /**
     * The color of the text in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#color Dashboard#color}
     *
     * @stability stable
     */
    readonly color?: string;
    /**
     * The size of the text in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#font_size Dashboard#font_size}
     *
     * @stability stable
     */
    readonly fontSize?: string;
    /**
     * The text to display in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text Dashboard#text}
     *
     * @stability stable
     */
    readonly text: string;
    /**
     * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetFreeTextDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetFreeTextDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetFreeTextDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetFreeTextDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetFreeTextDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetFreeTextDefinition | undefined);
    private _color?;
    /**
     * @stability stable
     */
    get color(): string;
    /**
     * @stability stable
     */
    set color(value: string);
    /**
     * @stability stable
     */
    resetColor(): void;
    /**
     * @stability stable
     */
    get colorInput(): string | undefined;
    private _fontSize?;
    /**
     * @stability stable
     */
    get fontSize(): string;
    /**
     * @stability stable
     */
    set fontSize(value: string);
    /**
     * @stability stable
     */
    resetFontSize(): void;
    /**
     * @stability stable
     */
    get fontSizeInput(): string | undefined;
    private _text?;
    /**
     * @stability stable
     */
    get text(): string;
    /**
     * @stability stable
     */
    set text(value: string);
    /**
     * @stability stable
     */
    get textInput(): string | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string;
    /**
     * @stability stable
     */
    set textAlign(value: string);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimitOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimit): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimit | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimit | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimit;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormula | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[];
    /**
     * @stability stable
     */
    set groupBy(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[];
    /**
     * @stability stable
     */
    set indexes(value: string[]);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get computeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string;
    /**
     * @stability stable
     */
    set sort(value: string);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[];
    /**
     * @stability stable
     */
    set tagFilters(value: string[]);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string;
    /**
     * @stability stable
     */
    set textFilter(value: string);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQuery | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle {
    /**
     * The color palette to apply to the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * A Boolean indicating whether to flip the palette tones.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_flip Dashboard#palette_flip}
     *
     * @stability stable
     */
    readonly paletteFlip: boolean | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyleToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyleOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle | undefined);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string;
    /**
     * @stability stable
     */
    set palette(value: string);
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
    private _paletteFlip?;
    /**
     * @stability stable
     */
    get paletteFlip(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set paletteFlip(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get paletteFlipInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView {
    /**
     * The two-letter ISO code of a country to focus the map on (or `WORLD`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#focus Dashboard#focus}
     *
     * @stability stable
     */
    readonly focus: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionViewToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionViewOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView | undefined);
    private _focus?;
    /**
     * @stability stable
     */
    get focus(): string;
    /**
     * @stability stable
     */
    set focus(value: string);
    /**
     * @stability stable
     */
    get focusInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest[] | cdktf.IResolvable;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#view Dashboard#view}
     *
     * @stability stable
     */
    readonly view: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView;
}
export declare function dashboardWidgetGroupDefinitionWidgetGeomapDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetGeomapDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetGeomapDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinition | undefined);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest[] | undefined;
    private _style;
    /**
     * @stability stable
     */
    get style(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyleOutputReference;
    /**
     * @stability stable
     */
    putStyle(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle): void;
    /**
     * @stability stable
     */
    resetStyle(): void;
    /**
     * @stability stable
     */
    get styleInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle | undefined;
    private _view;
    /**
     * @stability stable
     */
    get view(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionViewOutputReference;
    /**
     * @stability stable
     */
    putView(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView): void;
    /**
     * @stability stable
     */
    get viewInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent {
    /**
     * The event query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q: string;
    /**
     * The execution method for multi-value filters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEventToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[];
    /**
     * @stability stable
     */
    set filterBy(value: string[]);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string;
    /**
     * @stability stable
     */
    set searchBy(value: string);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyle {
    /**
     * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyleToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyleOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyle): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyle | undefined);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string;
    /**
     * @stability stable
     */
    set palette(value: string);
    /**
     * @stability stable
     */
    resetPalette(): void;
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQuery;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyle;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis {
    /**
     * Always include zero or fit the axis to the data range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#include_zero Dashboard#include_zero}
     *
     * @stability stable
     */
    readonly includeZero?: boolean | cdktf.IResolvable;
    /**
     * The label of the axis to display on the graph.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Specify the maximum value to show on the Y-axis.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#max Dashboard#max}
     *
     * @stability stable
     */
    readonly max?: string;
    /**
     * Specify the minimum value to show on the Y-axis.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#min Dashboard#min}
     *
     * @stability stable
     */
    readonly min?: string;
    /**
     * Specify the scale type, options: `linear`, `log`, `pow`, `sqrt`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scale Dashboard#scale}
     *
     * @stability stable
     */
    readonly scale?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxisToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxisOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis | undefined);
    private _includeZero?;
    /**
     * @stability stable
     */
    get includeZero(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeZero(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeZero(): void;
    /**
     * @stability stable
     */
    get includeZeroInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _max?;
    /**
     * @stability stable
     */
    get max(): string;
    /**
     * @stability stable
     */
    set max(value: string);
    /**
     * @stability stable
     */
    resetMax(): void;
    /**
     * @stability stable
     */
    get maxInput(): string | undefined;
    private _min?;
    /**
     * @stability stable
     */
    get min(): string;
    /**
     * @stability stable
     */
    set min(value: string);
    /**
     * @stability stable
     */
    resetMin(): void;
    /**
     * @stability stable
     */
    get minInput(): string | undefined;
    private _scale?;
    /**
     * @stability stable
     */
    get scale(): string;
    /**
     * @stability stable
     */
    set scale(value: string);
    /**
     * @stability stable
     */
    resetScale(): void;
    /**
     * @stability stable
     */
    get scaleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinition {
    /**
     * The size of the legend displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#legend_size Dashboard#legend_size}
     *
     * @stability stable
     */
    readonly legendSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * Whether or not to show the legend on this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_legend Dashboard#show_legend}
     *
     * @stability stable
     */
    readonly showLegend?: boolean | cdktf.IResolvable;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * event block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event Dashboard#event}
     *
     * @stability stable
     */
    readonly event?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent[] | cdktf.IResolvable;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest[] | cdktf.IResolvable;
    /**
     * yaxis block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#yaxis Dashboard#yaxis}
     *
     * @stability stable
     */
    readonly yaxis?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis;
}
export declare function dashboardWidgetGroupDefinitionWidgetHeatmapDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetHeatmapDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinition | undefined);
    private _legendSize?;
    /**
     * @stability stable
     */
    get legendSize(): string;
    /**
     * @stability stable
     */
    set legendSize(value: string);
    /**
     * @stability stable
     */
    resetLegendSize(): void;
    /**
     * @stability stable
     */
    get legendSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _showLegend?;
    /**
     * @stability stable
     */
    get showLegend(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showLegend(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowLegend(): void;
    /**
     * @stability stable
     */
    get showLegendInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink[] | undefined;
    private _event?;
    /**
     * @stability stable
     */
    get event(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set event(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEvent(): void;
    /**
     * @stability stable
     */
    get eventInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest[] | undefined;
    private _yaxis;
    /**
     * @stability stable
     */
    get yaxis(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxisOutputReference;
    /**
     * @stability stable
     */
    putYaxis(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis): void;
    /**
     * @stability stable
     */
    resetYaxis(): void;
    /**
     * @stability stable
     */
    get yaxisInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQuery | undefined);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[];
    /**
     * @stability stable
     */
    set filterBy(value: string[]);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string;
    /**
     * @stability stable
     */
    set searchBy(value: string);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQuery | undefined);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[];
    /**
     * @stability stable
     */
    set filterBy(value: string[]);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string;
    /**
     * @stability stable
     */
    set searchBy(value: string);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest {
    /**
     * fill block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#fill Dashboard#fill}
     *
     * @stability stable
     */
    readonly fill?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill[] | cdktf.IResolvable;
    /**
     * size block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#size Dashboard#size}
     *
     * @stability stable
     */
    readonly size?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest | undefined);
    private _fill?;
    /**
     * @stability stable
     */
    get fill(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fill(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFill(): void;
    /**
     * @stability stable
     */
    get fillInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill[] | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set size(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle {
    /**
     * The max value to use to color the map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#fill_max Dashboard#fill_max}
     *
     * @stability stable
     */
    readonly fillMax?: string;
    /**
     * The min value to use to color the map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#fill_min Dashboard#fill_min}
     *
     * @stability stable
     */
    readonly fillMin?: string;
    /**
     * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette?: string;
    /**
     * A Boolean indicating whether to flip the palette tones.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_flip Dashboard#palette_flip}
     *
     * @stability stable
     */
    readonly paletteFlip?: boolean | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyleToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyleOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle | undefined);
    private _fillMax?;
    /**
     * @stability stable
     */
    get fillMax(): string;
    /**
     * @stability stable
     */
    set fillMax(value: string);
    /**
     * @stability stable
     */
    resetFillMax(): void;
    /**
     * @stability stable
     */
    get fillMaxInput(): string | undefined;
    private _fillMin?;
    /**
     * @stability stable
     */
    get fillMin(): string;
    /**
     * @stability stable
     */
    set fillMin(value: string);
    /**
     * @stability stable
     */
    resetFillMin(): void;
    /**
     * @stability stable
     */
    get fillMinInput(): string | undefined;
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string;
    /**
     * @stability stable
     */
    set palette(value: string);
    /**
     * @stability stable
     */
    resetPalette(): void;
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
    private _paletteFlip?;
    /**
     * @stability stable
     */
    get paletteFlip(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set paletteFlip(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPaletteFlip(): void;
    /**
     * @stability stable
     */
    get paletteFlipInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinition {
    /**
     * The list of tags to group nodes by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group Dashboard#group}
     *
     * @stability stable
     */
    readonly group?: string[];
    /**
     * A Boolean indicating whether to show ungrouped nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#no_group_hosts Dashboard#no_group_hosts}
     *
     * @stability stable
     */
    readonly noGroupHosts?: boolean | cdktf.IResolvable;
    /**
     * A Boolean indicating whether to show nodes with no metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#no_metric_hosts Dashboard#no_metric_hosts}
     *
     * @stability stable
     */
    readonly noMetricHosts?: boolean | cdktf.IResolvable;
    /**
     * The type of node used. Valid values are `host`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#node_type Dashboard#node_type}
     *
     * @stability stable
     */
    readonly nodeType?: string;
    /**
     * The list of tags to filter nodes by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scope Dashboard#scope}
     *
     * @stability stable
     */
    readonly scope?: string[];
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle;
}
export declare function dashboardWidgetGroupDefinitionWidgetHostmapDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetHostmapDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetHostmapDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinition | undefined);
    private _group?;
    /**
     * @stability stable
     */
    get group(): string[];
    /**
     * @stability stable
     */
    set group(value: string[]);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): string[] | undefined;
    private _noGroupHosts?;
    /**
     * @stability stable
     */
    get noGroupHosts(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noGroupHosts(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoGroupHosts(): void;
    /**
     * @stability stable
     */
    get noGroupHostsInput(): boolean | cdktf.IResolvable | undefined;
    private _noMetricHosts?;
    /**
     * @stability stable
     */
    get noMetricHosts(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noMetricHosts(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoMetricHosts(): void;
    /**
     * @stability stable
     */
    get noMetricHostsInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeType?;
    /**
     * @stability stable
     */
    get nodeType(): string;
    /**
     * @stability stable
     */
    set nodeType(value: string);
    /**
     * @stability stable
     */
    resetNodeType(): void;
    /**
     * @stability stable
     */
    get nodeTypeInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string[];
    /**
     * @stability stable
     */
    set scope(value: string[]);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string[] | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink[] | undefined;
    private _request;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestOutputReference;
    /**
     * @stability stable
     */
    putRequest(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest): void;
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest | undefined;
    private _style;
    /**
     * @stability stable
     */
    get style(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyleOutputReference;
    /**
     * @stability stable
     */
    putStyle(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle): void;
    /**
     * @stability stable
     */
    resetStyle(): void;
    /**
     * @stability stable
     */
    get styleInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetIframeDefinition {
    /**
     * The URL to use as a data source for the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetIframeDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetIframeDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetIframeDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetIframeDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetIframeDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetIframeDefinition | undefined);
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetImageDefinition {
    /**
     * Whether to display a background or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#has_background Dashboard#has_background}
     *
     * @stability stable
     */
    readonly hasBackground?: boolean | cdktf.IResolvable;
    /**
     * Whether to display a border or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#has_border Dashboard#has_border}
     *
     * @stability stable
     */
    readonly hasBorder?: boolean | cdktf.IResolvable;
    /**
     * The horizontal alignment for the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#horizontal_align Dashboard#horizontal_align}
     *
     * @stability stable
     */
    readonly horizontalAlign?: string;
    /**
     * The margins to use around the image.
     *
     * Note: `small` and `large` values are deprecated. Valid values are `sm`, `md`, `lg`, `small`, `large`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#margin Dashboard#margin}
     *
     * @stability stable
     */
    readonly margin?: string;
    /**
     * The preferred method to adapt the dimensions of the image.
     *
     * The values are based on the image `object-fit` CSS properties. Note: `zoom`, `fit` and `center` values are deprecated. Valid values are `fill`, `contain`, `cover`, `none`, `scale-down`, `zoom`, `fit`, `center`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sizing Dashboard#sizing}
     *
     * @stability stable
     */
    readonly sizing?: string;
    /**
     * The URL to use as a data source for the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * The URL in dark mode to use as a data source for the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url_dark_theme Dashboard#url_dark_theme}
     *
     * @stability stable
     */
    readonly urlDarkTheme?: string;
    /**
     * The vertical alignment for the widget. Valid values are `center`, `top`, `bottom`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#vertical_align Dashboard#vertical_align}
     *
     * @stability stable
     */
    readonly verticalAlign?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetImageDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetImageDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetImageDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetImageDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetImageDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetImageDefinition | undefined);
    private _hasBackground?;
    /**
     * @stability stable
     */
    get hasBackground(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hasBackground(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHasBackground(): void;
    /**
     * @stability stable
     */
    get hasBackgroundInput(): boolean | cdktf.IResolvable | undefined;
    private _hasBorder?;
    /**
     * @stability stable
     */
    get hasBorder(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hasBorder(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHasBorder(): void;
    /**
     * @stability stable
     */
    get hasBorderInput(): boolean | cdktf.IResolvable | undefined;
    private _horizontalAlign?;
    /**
     * @stability stable
     */
    get horizontalAlign(): string;
    /**
     * @stability stable
     */
    set horizontalAlign(value: string);
    /**
     * @stability stable
     */
    resetHorizontalAlign(): void;
    /**
     * @stability stable
     */
    get horizontalAlignInput(): string | undefined;
    private _margin?;
    /**
     * @stability stable
     */
    get margin(): string;
    /**
     * @stability stable
     */
    set margin(value: string);
    /**
     * @stability stable
     */
    resetMargin(): void;
    /**
     * @stability stable
     */
    get marginInput(): string | undefined;
    private _sizing?;
    /**
     * @stability stable
     */
    get sizing(): string;
    /**
     * @stability stable
     */
    set sizing(value: string);
    /**
     * @stability stable
     */
    resetSizing(): void;
    /**
     * @stability stable
     */
    get sizingInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _urlDarkTheme?;
    /**
     * @stability stable
     */
    get urlDarkTheme(): string;
    /**
     * @stability stable
     */
    set urlDarkTheme(value: string);
    /**
     * @stability stable
     */
    resetUrlDarkTheme(): void;
    /**
     * @stability stable
     */
    get urlDarkThemeInput(): string | undefined;
    private _verticalAlign?;
    /**
     * @stability stable
     */
    get verticalAlign(): string;
    /**
     * @stability stable
     */
    set verticalAlign(value: string);
    /**
     * @stability stable
     */
    resetVerticalAlign(): void;
    /**
     * @stability stable
     */
    get verticalAlignInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort {
    /**
     * The facet path for the column.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#column Dashboard#column}
     *
     * @stability stable
     */
    readonly column: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSortToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSortOutputReference | DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort | undefined);
    private _column?;
    /**
     * @stability stable
     */
    get column(): string;
    /**
     * @stability stable
     */
    set column(value: string);
    /**
     * @stability stable
     */
    get columnInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetLogStreamDefinition {
    /**
     * Stringified list of columns to use, for example: `["column1","column2","column3"]`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#columns Dashboard#columns}
     *
     * @stability stable
     */
    readonly columns?: string[];
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The number of log lines to display. Valid values are `inline`, `expanded-md`, `expanded-lg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#message_display Dashboard#message_display}
     *
     * @stability stable
     */
    readonly messageDisplay?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: string;
    /**
     * If the date column should be displayed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_date_column Dashboard#show_date_column}
     *
     * @stability stable
     */
    readonly showDateColumn?: boolean | cdktf.IResolvable;
    /**
     * If the message column should be displayed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_message_column Dashboard#show_message_column}
     *
     * @stability stable
     */
    readonly showMessageColumn?: boolean | cdktf.IResolvable;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort;
}
export declare function dashboardWidgetGroupDefinitionWidgetLogStreamDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetLogStreamDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetLogStreamDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetLogStreamDefinition | undefined);
    private _columns?;
    /**
     * @stability stable
     */
    get columns(): string[];
    /**
     * @stability stable
     */
    set columns(value: string[]);
    /**
     * @stability stable
     */
    resetColumns(): void;
    /**
     * @stability stable
     */
    get columnsInput(): string[] | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[];
    /**
     * @stability stable
     */
    set indexes(value: string[]);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _messageDisplay?;
    /**
     * @stability stable
     */
    get messageDisplay(): string;
    /**
     * @stability stable
     */
    set messageDisplay(value: string);
    /**
     * @stability stable
     */
    resetMessageDisplay(): void;
    /**
     * @stability stable
     */
    get messageDisplayInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    resetQuery(): void;
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _showDateColumn?;
    /**
     * @stability stable
     */
    get showDateColumn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showDateColumn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowDateColumn(): void;
    /**
     * @stability stable
     */
    get showDateColumnInput(): boolean | cdktf.IResolvable | undefined;
    private _showMessageColumn?;
    /**
     * @stability stable
     */
    get showMessageColumn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showMessageColumn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowMessageColumn(): void;
    /**
     * @stability stable
     */
    get showMessageColumnInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _sort;
    /**
     * @stability stable
     */
    get sort(): DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSortOutputReference;
    /**
     * @stability stable
     */
    putSort(value: DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort): void;
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetManageStatusDefinition {
    /**
     * Whether to colorize text or background. Valid values are `background`, `text`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#color_preference Dashboard#color_preference}
     *
     * @stability stable
     */
    readonly colorPreference?: string;
    /**
     * The display setting to use. Valid values are `counts`, `countsAndList`, `list`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#display_format Dashboard#display_format}
     *
     * @stability stable
     */
    readonly displayFormat?: string;
    /**
     * A Boolean indicating whether to hide empty categories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_zero_counts Dashboard#hide_zero_counts}
     *
     * @stability stable
     */
    readonly hideZeroCounts?: boolean | cdktf.IResolvable;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * A Boolean indicating whether to show when monitors/groups last triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_last_triggered Dashboard#show_last_triggered}
     *
     * @stability stable
     */
    readonly showLastTriggered?: boolean | cdktf.IResolvable;
    /**
     * The method to sort the monitors.
     *
     * Valid values are `name`, `group`, `status`, `tags`, `triggered`, `group,asc`, `group,desc`, `name,asc`, `name,desc`, `status,asc`, `status,desc`, `tags,asc`, `tags,desc`, `triggered,asc`, `triggered,desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * The summary type to use. Valid values are `monitors`, `groups`, `combined`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#summary_type Dashboard#summary_type}
     *
     * @stability stable
     */
    readonly summaryType?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetManageStatusDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetManageStatusDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetManageStatusDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetManageStatusDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetManageStatusDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetManageStatusDefinition | undefined);
    private _colorPreference?;
    /**
     * @stability stable
     */
    get colorPreference(): string;
    /**
     * @stability stable
     */
    set colorPreference(value: string);
    /**
     * @stability stable
     */
    resetColorPreference(): void;
    /**
     * @stability stable
     */
    get colorPreferenceInput(): string | undefined;
    private _displayFormat?;
    /**
     * @stability stable
     */
    get displayFormat(): string;
    /**
     * @stability stable
     */
    set displayFormat(value: string);
    /**
     * @stability stable
     */
    resetDisplayFormat(): void;
    /**
     * @stability stable
     */
    get displayFormatInput(): string | undefined;
    private _hideZeroCounts?;
    /**
     * @stability stable
     */
    get hideZeroCounts(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideZeroCounts(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideZeroCounts(): void;
    /**
     * @stability stable
     */
    get hideZeroCountsInput(): boolean | cdktf.IResolvable | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _showLastTriggered?;
    /**
     * @stability stable
     */
    get showLastTriggered(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showLastTriggered(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowLastTriggered(): void;
    /**
     * @stability stable
     */
    get showLastTriggeredInput(): boolean | cdktf.IResolvable | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string;
    /**
     * @stability stable
     */
    set sort(value: string);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _summaryType?;
    /**
     * @stability stable
     */
    get summaryType(): string;
    /**
     * @stability stable
     */
    set summaryType(value: string);
    /**
     * @stability stable
     */
    resetSummaryType(): void;
    /**
     * @stability stable
     */
    get summaryTypeInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetNoteDefinition {
    /**
     * The background color of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#background_color Dashboard#background_color}
     *
     * @stability stable
     */
    readonly backgroundColor?: string;
    /**
     * The content of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#content Dashboard#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * The size of the text.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#font_size Dashboard#font_size}
     *
     * @stability stable
     */
    readonly fontSize?: string;
    /**
     * Whether to add padding or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#has_padding Dashboard#has_padding}
     *
     * @stability stable
     */
    readonly hasPadding?: boolean | cdktf.IResolvable;
    /**
     * Whether to show a tick or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_tick Dashboard#show_tick}
     *
     * @stability stable
     */
    readonly showTick?: boolean | cdktf.IResolvable;
    /**
     * The alignment of the widget's text. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
    /**
     * When `tick = true`, a string indicating on which side of the widget the tick should be displayed.
     *
     * Valid values are `bottom`, `left`, `right`, `top`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tick_edge Dashboard#tick_edge}
     *
     * @stability stable
     */
    readonly tickEdge?: string;
    /**
     * When `tick = true`, a string with a percent sign indicating the position of the tick, for example: `tick_pos = "50%"` is centered alignment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tick_pos Dashboard#tick_pos}
     *
     * @stability stable
     */
    readonly tickPos?: string;
    /**
     * The vertical alignment for the widget. Valid values are `center`, `top`, `bottom`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#vertical_align Dashboard#vertical_align}
     *
     * @stability stable
     */
    readonly verticalAlign?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetNoteDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetNoteDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetNoteDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetNoteDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetNoteDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetNoteDefinition | undefined);
    private _backgroundColor?;
    /**
     * @stability stable
     */
    get backgroundColor(): string;
    /**
     * @stability stable
     */
    set backgroundColor(value: string);
    /**
     * @stability stable
     */
    resetBackgroundColor(): void;
    /**
     * @stability stable
     */
    get backgroundColorInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _fontSize?;
    /**
     * @stability stable
     */
    get fontSize(): string;
    /**
     * @stability stable
     */
    set fontSize(value: string);
    /**
     * @stability stable
     */
    resetFontSize(): void;
    /**
     * @stability stable
     */
    get fontSizeInput(): string | undefined;
    private _hasPadding?;
    /**
     * @stability stable
     */
    get hasPadding(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hasPadding(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHasPadding(): void;
    /**
     * @stability stable
     */
    get hasPaddingInput(): boolean | cdktf.IResolvable | undefined;
    private _showTick?;
    /**
     * @stability stable
     */
    get showTick(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showTick(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowTick(): void;
    /**
     * @stability stable
     */
    get showTickInput(): boolean | cdktf.IResolvable | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string;
    /**
     * @stability stable
     */
    set textAlign(value: string);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
    private _tickEdge?;
    /**
     * @stability stable
     */
    get tickEdge(): string;
    /**
     * @stability stable
     */
    set tickEdge(value: string);
    /**
     * @stability stable
     */
    resetTickEdge(): void;
    /**
     * @stability stable
     */
    get tickEdgeInput(): string | undefined;
    private _tickPos?;
    /**
     * @stability stable
     */
    get tickPos(): string;
    /**
     * @stability stable
     */
    set tickPos(value: string);
    /**
     * @stability stable
     */
    resetTickPos(): void;
    /**
     * @stability stable
     */
    get tickPosInput(): string | undefined;
    private _verticalAlign?;
    /**
     * @stability stable
     */
    get verticalAlign(): string;
    /**
     * @stability stable
     */
    set verticalAlign(value: string);
    /**
     * @stability stable
     */
    resetVerticalAlign(): void;
    /**
     * @stability stable
     */
    get verticalAlignInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns {
    /**
     * A user-assigned alias for the column.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * The column name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumnsToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQuery {
    /**
     * The environment name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * The operation name associated with the service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The organization's host group name and value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag Dashboard#primary_tag}
     *
     * @stability stable
     */
    readonly primaryTag: string;
    /**
     * The resource name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource Dashboard#resource}
     *
     * @stability stable
     */
    readonly resource?: string;
    /**
     * The level of detail for the request. Valid values are `service`, `resource`, `span`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#row_type Dashboard#row_type}
     *
     * @stability stable
     */
    readonly rowType: string;
    /**
     * The service name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * columns block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#columns Dashboard#columns}
     *
     * @stability stable
     */
    readonly columns?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQuery | undefined);
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _primaryTag?;
    /**
     * @stability stable
     */
    get primaryTag(): string;
    /**
     * @stability stable
     */
    set primaryTag(value: string);
    /**
     * @stability stable
     */
    get primaryTagInput(): string | undefined;
    private _resource?;
    /**
     * @stability stable
     */
    get resource(): string;
    /**
     * @stability stable
     */
    set resource(value: string);
    /**
     * @stability stable
     */
    resetResource(): void;
    /**
     * @stability stable
     */
    get resourceInput(): string | undefined;
    private _rowType?;
    /**
     * @stability stable
     */
    get rowType(): string;
    /**
     * @stability stable
     */
    set rowType(value: string);
    /**
     * @stability stable
     */
    get rowTypeInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _columns?;
    /**
     * @stability stable
     */
    get columns(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set columns(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetColumns(): void;
    /**
     * @stability stable
     */
    get columnsInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestConditionalFormatsToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestConditionalFormats | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimitOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimit): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimit | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimit | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimit;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormula | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[];
    /**
     * @stability stable
     */
    set filterBy(value: string[]);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string;
    /**
     * @stability stable
     */
    set searchBy(value: string);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[];
    /**
     * @stability stable
     */
    set groupBy(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string;
    /**
     * @stability stable
     */
    set primaryTagName(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[];
    /**
     * @stability stable
     */
    set indexes(value: string[]);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get computeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string;
    /**
     * @stability stable
     */
    set aggregator(value: string);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number;
    /**
     * @stability stable
     */
    set limit(value: number);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string;
    /**
     * @stability stable
     */
    set sort(value: string);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[];
    /**
     * @stability stable
     */
    set tagFilters(value: string[]);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string;
    /**
     * @stability stable
     */
    set textFilter(value: string);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQuery | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest {
    /**
     * The aggregator to use for time aggregation. Valid values are `avg`, `last`, `max`, `min`, `sum`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The alias for the column name (defaults to metric name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell.
     *
     * List items one of `number`, `bar`. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string[];
    /**
     * The number of lines to show in the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The sort order for the rows. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQuery;
    /**
     * apm_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_stats_query Dashboard#apm_stats_query}
     *
     * @stability stable
     */
    readonly apmStatsQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQuery;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestConditionalFormats[] | cdktf.IResolvable;
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinition {
    /**
     * Controls the display of the search bar. Valid values are `always`, `never`, `auto`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#has_search_bar Dashboard#has_search_bar}
     *
     * @stability stable
     */
    readonly hasSearchBar?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryTableDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetQueryTableDefinition): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinition | undefined);
    private _hasSearchBar?;
    /**
     * @stability stable
     */
    get hasSearchBar(): string;
    /**
     * @stability stable
     */
    set hasSearchBar(value: string);
    /**
     * @stability stable
     */
    resetHasSearchBar(): void;
    /**
     * @stability stable
     */
    get hasSearchBarInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string;
    /**
     * @stability stable
     */
    set liveSpan(value: string);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string;
    /**
     * @stability stable
     */
    set titleAlign(value: string);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string;
    /**
     * @stability stable
     */
    set titleSize(value: string);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionCustomLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string;
    /**
     * @stability stable
     */
    set facet(value: string);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | cdktf.IResolvable;
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryOutputReference | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQuery): any;
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQuery | undefined);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string;
    /**
     * @stability stable
     */
    set searchQuery(value: string);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/da