import { DashboardTemplateVariable, DashboardTemplateVariablePreset, DashboardWidget } from './dashboard-structs';
export * from './dashboard-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DashboardConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of dashboard lists this dashboard belongs to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dashboard_lists Dashboard#dashboard_lists}
     *
     * @stability stable
     */
    readonly dashboardLists?: number[];
    /**
     * The description of the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#description Dashboard#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_read_only Dashboard#is_read_only}
     *
     * @stability stable
     */
    readonly isReadOnly?: boolean | cdktf.IResolvable;
    /**
     * The layout type of the dashboard. Valid values are `ordered`, `free`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
     *
     * @stability stable
     */
    readonly layoutType: string;
    /**
     * The list of handles for the users to notify when changes are made to this dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#notify_list Dashboard#notify_list}
     *
     * @stability stable
     */
    readonly notifyList?: string[];
    /**
     * The reflow type of a new dashboard layout.
     *
     * Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#reflow_type Dashboard#reflow_type}
     *
     * @stability stable
     */
    readonly reflowType?: string;
    /**
     * UUIDs of roles whose associated users are authorized to edit the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#restricted_roles Dashboard#restricted_roles}
     *
     * @stability stable
     */
    readonly restrictedRoles?: string[];
    /**
     * The title of the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * The URL of the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
     *
     * @stability stable
     */
    readonly url?: string;
    /**
     * template_variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
     *
     * @stability stable
     */
    readonly templateVariable?: DashboardTemplateVariable[] | cdktf.IResolvable;
    /**
     * template_variable_preset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable_preset Dashboard#template_variable_preset}
     *
     * @stability stable
     */
    readonly templateVariablePreset?: DashboardTemplateVariablePreset[] | cdktf.IResolvable;
    /**
     * widget block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
     *
     * @stability stable
     */
    readonly widget?: DashboardWidget[] | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard}.
 *
 * @stability stable
 */
export declare class Dashboard extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DashboardConfig);
    private _dashboardLists?;
    /**
     * @stability stable
     */
    get dashboardLists(): number[];
    /**
     * @stability stable
     */
    set dashboardLists(value: number[]);
    /**
     * @stability stable
     */
    resetDashboardLists(): void;
    /**
     * @stability stable
     */
    get dashboardListsInput(): number[] | undefined;
    /**
     * @stability stable
     */
    get dashboardListsRemoved(): number[];
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isReadOnly?;
    /**
     * @stability stable
     */
    get isReadOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isReadOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsReadOnly(): void;
    /**
     * @stability stable
     */
    get isReadOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _layoutType?;
    /**
     * @stability stable
     */
    get layoutType(): string;
    /**
     * @stability stable
     */
    set layoutType(value: string);
    /**
     * @stability stable
     */
    get layoutTypeInput(): string | undefined;
    private _notifyList?;
    /**
     * @stability stable
     */
    get notifyList(): string[];
    /**
     * @stability stable
     */
    set notifyList(value: string[]);
    /**
     * @stability stable
     */
    resetNotifyList(): void;
    /**
     * @stability stable
     */
    get notifyListInput(): string[] | undefined;
    private _reflowType?;
    /**
     * @stability stable
     */
    get reflowType(): string;
    /**
     * @stability stable
     */
    set reflowType(value: string);
    /**
     * @stability stable
     */
    resetReflowType(): void;
    /**
     * @stability stable
     */
    get reflowTypeInput(): string | undefined;
    private _restrictedRoles?;
    /**
     * @stability stable
     */
    get restrictedRoles(): string[];
    /**
     * @stability stable
     */
    set restrictedRoles(value: string[]);
    /**
     * @stability stable
     */
    resetRestrictedRoles(): void;
    /**
     * @stability stable
     */
    get restrictedRolesInput(): string[] | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _templateVariable?;
    /**
     * @stability stable
     */
    get templateVariable(): DashboardTemplateVariable[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set templateVariable(value: DashboardTemplateVariable[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTemplateVariable(): void;
    /**
     * @stability stable
     */
    get templateVariableInput(): cdktf.IResolvable | DashboardTemplateVariable[] | undefined;
    private _templateVariablePreset?;
    /**
     * @stability stable
     */
    get templateVariablePreset(): DashboardTemplateVariablePreset[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set templateVariablePreset(value: DashboardTemplateVariablePreset[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTemplateVariablePreset(): void;
    /**
     * @stability stable
     */
    get templateVariablePresetInput(): cdktf.IResolvable | DashboardTemplateVariablePreset[] | undefined;
    private _widget?;
    /**
     * @stability stable
     */
    get widget(): DashboardWidget[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set widget(value: DashboardWidget[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWidget(): void;
    /**
     * @stability stable
     */
    get widgetInput(): cdktf.IResolvable | DashboardWidget[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
