import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogDashboardListConfig extends cdktf.TerraformMetaArguments {
    /**
     * A dashboard list name to limit the search.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/dashboard_list#name DataDatadogDashboardList#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/dashboard_list datadog_dashboard_list}.
 *
 * @stability stable
 */
export declare class DataDatadogDashboardList extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/dashboard_list datadog_dashboard_list} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataDatadogDashboardListConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
