import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogIpRangesConfig extends cdktf.TerraformMetaArguments {
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/ip_ranges datadog_ip_ranges}.
 *
 * @stability stable
 */
export declare class DataDatadogIpRanges extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/ip_ranges datadog_ip_ranges} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDatadogIpRangesConfig);
    /**
     * @stability stable
     */
    get agentsIpv4(): string[];
    /**
     * @stability stable
     */
    get agentsIpv6(): string[];
    /**
     * @stability stable
     */
    get apiIpv4(): string[];
    /**
     * @stability stable
     */
    get apiIpv6(): string[];
    /**
     * @stability stable
     */
    get apmIpv4(): string[];
    /**
     * @stability stable
     */
    get apmIpv6(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get logsIpv4(): string[];
    /**
     * @stability stable
     */
    get logsIpv6(): string[];
    /**
     * @stability stable
     */
    get processIpv4(): string[];
    /**
     * @stability stable
     */
    get processIpv6(): string[];
    /**
     * @stability stable
     */
    get syntheticsIpv4(): string[];
    /**
     * @stability stable
     */
    syntheticsIpv4ByLocation(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get syntheticsIpv6(): string[];
    /**
     * @stability stable
     */
    syntheticsIpv6ByLocation(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get webhooksIpv4(): string[];
    /**
     * @stability stable
     */
    get webhooksIpv6(): string[];
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
