import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogRolesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Filter all roles by the given string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/roles#filter DataDatadogRoles#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
}
/**
 * @stability stable
 */
export declare class DataDatadogRolesRoles extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get userCount(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/roles datadog_roles}.
 *
 * @stability stable
 */
export declare class DataDatadogRoles extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/roles datadog_roles} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDatadogRolesConfig);
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    roles(index: string): DataDatadogRolesRoles;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
