import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogSecurityMonitoringRulesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Limit the search to default rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#default_only_filter DataDatadogSecurityMonitoringRules#default_only_filter}
     *
     * @stability stable
     */
    readonly defaultOnlyFilter?: boolean | cdktf.IResolvable;
    /**
     * A rule name to limit the search.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#name_filter DataDatadogSecurityMonitoringRules#name_filter}
     *
     * @stability stable
     */
    readonly nameFilter?: string;
    /**
     * A list of tags to limit the search.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#tags_filter DataDatadogSecurityMonitoringRules#tags_filter}
     *
     * @stability stable
     */
    readonly tagsFilter?: string[];
    /**
     * Limit the search to user rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#user_only_filter DataDatadogSecurityMonitoringRules#user_only_filter}
     *
     * @stability stable
     */
    readonly userOnlyFilter?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataDatadogSecurityMonitoringRulesRulesCase extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get condition(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get notifications(): string[];
    /**
     * @stability stable
     */
    get status(): string;
}
/**
 * @stability stable
 */
export declare class DataDatadogSecurityMonitoringRulesRulesFilter extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    get query(): string;
}
/**
 * @stability stable
 */
export declare class DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get forgetAfter(): number;
    /**
     * @stability stable
     */
    get learningDuration(): number;
}
/**
 * @stability stable
 */
export declare class DataDatadogSecurityMonitoringRulesRulesOptions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get detectionMethod(): string;
    /**
     * @stability stable
     */
    get evaluationWindow(): number;
    /**
     * @stability stable
     */
    get keepAlive(): number;
    /**
     * @stability stable
     */
    get maxSignalDuration(): number;
    /**
     * @stability stable
     */
    get newValueOptions(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataDatadogSecurityMonitoringRulesRulesQueryAgentRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get agentRuleId(): string;
    /**
     * @stability stable
     */
    get expression(): string;
}
/**
 * @stability stable
 */
export declare class DataDatadogSecurityMonitoringRulesRulesQuery extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get agentRule(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    get distinctFields(): string[];
    /**
     * @stability stable
     */
    get groupByFields(): string[];
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get query(): string;
}
/**
 * @stability stable
 */
export declare class DataDatadogSecurityMonitoringRulesRules extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get case(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get filter(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get hasExtendedTitle(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get options(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get query(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules datadog_security_monitoring_rules}.
 *
 * @stability stable
 */
export declare class DataDatadogSecurityMonitoringRules extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules datadog_security_monitoring_rules} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDatadogSecurityMonitoringRulesConfig);
    private _defaultOnlyFilter?;
    /**
     * @stability stable
     */
    get defaultOnlyFilter(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set defaultOnlyFilter(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDefaultOnlyFilter(): void;
    /**
     * @stability stable
     */
    get defaultOnlyFilterInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _nameFilter?;
    /**
     * @stability stable
     */
    get nameFilter(): string;
    /**
     * @stability stable
     */
    set nameFilter(value: string);
    /**
     * @stability stable
     */
    resetNameFilter(): void;
    /**
     * @stability stable
     */
    get nameFilterInput(): string | undefined;
    /**
     * @stability stable
     */
    get ruleIds(): string[];
    /**
     * @stability stable
     */
    rules(index: string): DataDatadogSecurityMonitoringRulesRules;
    private _tagsFilter?;
    /**
     * @stability stable
     */
    get tagsFilter(): string[];
    /**
     * @stability stable
     */
    set tagsFilter(value: string[]);
    /**
     * @stability stable
     */
    resetTagsFilter(): void;
    /**
     * @stability stable
     */
    get tagsFilterInput(): string[] | undefined;
    private _userOnlyFilter?;
    /**
     * @stability stable
     */
    get userOnlyFilter(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set userOnlyFilter(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUserOnlyFilter(): void;
    /**
     * @stability stable
     */
    get userOnlyFilterInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
