import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DatadogProviderConfig {
    /**
     * (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#api_key DatadogProvider#api_key}
     *
     * @stability stable
     */
    readonly apiKey?: string;
    /**
     * The API URL.
     *
     * This can also be set via the DD_HOST environment variable. Note that this URL must not end with the /api/ path. For example, https://api.datadoghq.com/ is a correct value, while https://api.datadoghq.com/api/ is not. And if you're working with "EU" version of Datadog, use https://api.datadoghq.eu/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#api_url DatadogProvider#api_url}
     *
     * @stability stable
     */
    readonly apiUrl?: string;
    /**
     * (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#app_key DatadogProvider#app_key}
     *
     * @stability stable
     */
    readonly appKey?: string;
    /**
     * Enables request retries on HTTP status codes 429 and 5xx.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#http_client_retry_enabled DatadogProvider#http_client_retry_enabled}
     *
     * @stability stable
     */
    readonly httpClientRetryEnabled?: boolean | cdktf.IResolvable;
    /**
     * The HTTP request retry timeout period.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#http_client_retry_timeout DatadogProvider#http_client_retry_timeout}
     *
     * @stability stable
     */
    readonly httpClientRetryTimeout?: number;
    /**
     * Enables validation of the provided API and APP keys during provider initialization.
     *
     * Default is true. When false, api_key and app_key won't be checked.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#validate DatadogProvider#validate}
     *
     * @stability stable
     */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#alias DatadogProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog datadog}.
 *
 * @stability stable
 */
export declare class DatadogProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog datadog} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DatadogProviderConfig);
    private _apiKey?;
    /**
     * @stability stable
     */
    get apiKey(): string | undefined;
    /**
     * @stability stable
     */
    set apiKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetApiKey(): void;
    /**
     * @stability stable
     */
    get apiKeyInput(): string | undefined;
    private _apiUrl?;
    /**
     * @stability stable
     */
    get apiUrl(): string | undefined;
    /**
     * @stability stable
     */
    set apiUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetApiUrl(): void;
    /**
     * @stability stable
     */
    get apiUrlInput(): string | undefined;
    private _appKey?;
    /**
     * @stability stable
     */
    get appKey(): string | undefined;
    /**
     * @stability stable
     */
    set appKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetAppKey(): void;
    /**
     * @stability stable
     */
    get appKeyInput(): string | undefined;
    private _httpClientRetryEnabled?;
    /**
     * @stability stable
     */
    get httpClientRetryEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set httpClientRetryEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHttpClientRetryEnabled(): void;
    /**
     * @stability stable
     */
    get httpClientRetryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpClientRetryTimeout?;
    /**
     * @stability stable
     */
    get httpClientRetryTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set httpClientRetryTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetHttpClientRetryTimeout(): void;
    /**
     * @stability stable
     */
    get httpClientRetryTimeoutInput(): number | undefined;
    private _validate?;
    /**
     * @stability stable
     */
    get validate(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set validate(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValidate(): void;
    /**
     * @stability stable
     */
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
