import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationAwsLambdaArnConfig extends cdktf.TerraformMetaArguments {
    /**
     * Your AWS Account ID without dashes. If your account is a GovCloud or China account, specify the `access_key_id` here.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn#account_id IntegrationAwsLambdaArn#account_id}
     *
     * @stability stable
     */
    readonly accountId: string;
    /**
     * The ARN of the Datadog forwarder Lambda.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn#lambda_arn IntegrationAwsLambdaArn#lambda_arn}
     *
     * @stability stable
     */
    readonly lambdaArn: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn datadog_integration_aws_lambda_arn}.
 *
 * @stability stable
 */
export declare class IntegrationAwsLambdaArn extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn datadog_integration_aws_lambda_arn} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IntegrationAwsLambdaArnConfig);
    private _accountId?;
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    set accountId(value: string);
    /**
     * @stability stable
     */
    get accountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _lambdaArn?;
    /**
     * @stability stable
     */
    get lambdaArn(): string;
    /**
     * @stability stable
     */
    set lambdaArn(value: string);
    /**
     * @stability stable
     */
    get lambdaArnInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
