import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationAwsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#access_key_id IntegrationAws#access_key_id}
     *
     * @stability stable
     */
    readonly accessKeyId?: string;
    /**
     * Your AWS Account ID without dashes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#account_id IntegrationAws#account_id}
     *
     * @stability stable
     */
    readonly accountId?: string;
    /**
     * Enables or disables metric collection for specific AWS namespaces for this AWS account only.
     *
     * A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#account_specific_namespace_rules IntegrationAws#account_specific_namespace_rules}
     *
     * @stability stable
     */
    readonly accountSpecificNamespaceRules?: {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    /**
     * An array of AWS regions to exclude from metrics collection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#excluded_regions IntegrationAws#excluded_regions}
     *
     * @stability stable
     */
    readonly excludedRegions?: string[];
    /**
     * Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2.
     *
     * Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#filter_tags IntegrationAws#filter_tags}
     *
     * @stability stable
     */
    readonly filterTags?: string[];
    /**
     * Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#host_tags IntegrationAws#host_tags}
     *
     * @stability stable
     */
    readonly hostTags?: string[];
    /**
     * Your Datadog role delegation name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#role_name IntegrationAws#role_name}
     *
     * @stability stable
     */
    readonly roleName?: string;
    /**
     * Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#secret_access_key IntegrationAws#secret_access_key}
     *
     * @stability stable
     */
    readonly secretAccessKey?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws datadog_integration_aws}.
 *
 * @stability stable
 */
export declare class IntegrationAws extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws datadog_integration_aws} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: IntegrationAwsConfig);
    private _accessKeyId?;
    /**
     * @stability stable
     */
    get accessKeyId(): string;
    /**
     * @stability stable
     */
    set accessKeyId(value: string);
    /**
     * @stability stable
     */
    resetAccessKeyId(): void;
    /**
     * @stability stable
     */
    get accessKeyIdInput(): string | undefined;
    private _accountId?;
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    set accountId(value: string);
    /**
     * @stability stable
     */
    resetAccountId(): void;
    /**
     * @stability stable
     */
    get accountIdInput(): string | undefined;
    private _accountSpecificNamespaceRules?;
    /**
     * @stability stable
     */
    get accountSpecificNamespaceRules(): {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    /**
     * @stability stable
     */
    set accountSpecificNamespaceRules(value: {
        [key: string]: (boolean | cdktf.IResolvable);
    });
    /**
     * @stability stable
     */
    resetAccountSpecificNamespaceRules(): void;
    /**
     * @stability stable
     */
    get accountSpecificNamespaceRulesInput(): {
        [key: string]: boolean | cdktf.IResolvable;
    } | undefined;
    private _excludedRegions?;
    /**
     * @stability stable
     */
    get excludedRegions(): string[];
    /**
     * @stability stable
     */
    set excludedRegions(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedRegions(): void;
    /**
     * @stability stable
     */
    get excludedRegionsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get externalId(): string;
    private _filterTags?;
    /**
     * @stability stable
     */
    get filterTags(): string[];
    /**
     * @stability stable
     */
    set filterTags(value: string[]);
    /**
     * @stability stable
     */
    resetFilterTags(): void;
    /**
     * @stability stable
     */
    get filterTagsInput(): string[] | undefined;
    private _hostTags?;
    /**
     * @stability stable
     */
    get hostTags(): string[];
    /**
     * @stability stable
     */
    set hostTags(value: string[]);
    /**
     * @stability stable
     */
    resetHostTags(): void;
    /**
     * @stability stable
     */
    get hostTagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _roleName?;
    /**
     * @stability stable
     */
    get roleName(): string;
    /**
     * @stability stable
     */
    set roleName(value: string);
    /**
     * @stability stable
     */
    resetRoleName(): void;
    /**
     * @stability stable
     */
    get roleNameInput(): string | undefined;
    private _secretAccessKey?;
    /**
     * @stability stable
     */
    get secretAccessKey(): string;
    /**
     * @stability stable
     */
    set secretAccessKey(value: string);
    /**
     * @stability stable
     */
    resetSecretAccessKey(): void;
    /**
     * @stability stable
     */
    get secretAccessKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
