import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationPagerdutyServiceObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * Your Service name associated service key in PagerDuty.
     *
     * Note: Since the Datadog API never returns service keys, it is impossible to detect [drifts](https://www.hashicorp.com/blog/detecting-and-managing-drift-with-terraform). The best way to solve a drift is to manually mark the Service Object resource with [terraform taint](https://www.terraform.io/docs/commands/taint.html) to have it destroyed and recreated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty_service_object#service_key IntegrationPagerdutyServiceObject#service_key}
     *
     * @stability stable
     */
    readonly serviceKey: string;
    /**
     * Your Service name in PagerDuty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty_service_object#service_name IntegrationPagerdutyServiceObject#service_name}
     *
     * @stability stable
     */
    readonly serviceName: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty_service_object datadog_integration_pagerduty_service_object}.
 *
 * @stability stable
 */
export declare class IntegrationPagerdutyServiceObject extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty_service_object datadog_integration_pagerduty_service_object} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IntegrationPagerdutyServiceObjectConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _serviceKey?;
    /**
     * @stability stable
     */
    get serviceKey(): string;
    /**
     * @stability stable
     */
    set serviceKey(value: string);
    /**
     * @stability stable
     */
    get serviceKeyInput(): string | undefined;
    private _serviceName?;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    set serviceName(value: string);
    /**
     * @stability stable
     */
    get serviceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
