import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationSlackChannelConfig extends cdktf.TerraformMetaArguments {
    /**
     * Slack account name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#account_name IntegrationSlackChannel#account_name}
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Slack channel name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#channel_name IntegrationSlackChannel#channel_name}
     *
     * @stability stable
     */
    readonly channelName: string;
    /**
     * display block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#display IntegrationSlackChannel#display}
     *
     * @stability stable
     */
    readonly display: IntegrationSlackChannelDisplay;
}
/**
 * @stability stable
 */
export interface IntegrationSlackChannelDisplay {
    /**
     * Show the main body of the alert event.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#message IntegrationSlackChannel#message}
     *
     * @stability stable
     */
    readonly message?: boolean | cdktf.IResolvable;
    /**
     * Show the list of @-handles in the alert event.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#notified IntegrationSlackChannel#notified}
     *
     * @stability stable
     */
    readonly notified?: boolean | cdktf.IResolvable;
    /**
     * Show the alert event's snapshot image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#snapshot IntegrationSlackChannel#snapshot}
     *
     * @stability stable
     */
    readonly snapshot?: boolean | cdktf.IResolvable;
    /**
     * Show the scopes on which the monitor alerted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#tags IntegrationSlackChannel#tags}
     *
     * @stability stable
     */
    readonly tags?: boolean | cdktf.IResolvable;
}
export declare function integrationSlackChannelDisplayToTerraform(struct?: IntegrationSlackChannelDisplayOutputReference | IntegrationSlackChannelDisplay): any;
/**
 * @stability stable
 */
export declare class IntegrationSlackChannelDisplayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IntegrationSlackChannelDisplay | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IntegrationSlackChannelDisplay | undefined);
    private _message?;
    /**
     * @stability stable
     */
    get message(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set message(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMessage(): void;
    /**
     * @stability stable
     */
    get messageInput(): boolean | cdktf.IResolvable | undefined;
    private _notified?;
    /**
     * @stability stable
     */
    get notified(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set notified(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNotified(): void;
    /**
     * @stability stable
     */
    get notifiedInput(): boolean | cdktf.IResolvable | undefined;
    private _snapshot?;
    /**
     * @stability stable
     */
    get snapshot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set snapshot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSnapshot(): void;
    /**
     * @stability stable
     */
    get snapshotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel datadog_integration_slack_channel}.
 *
 * @stability stable
 */
export declare class IntegrationSlackChannel extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel datadog_integration_slack_channel} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IntegrationSlackChannelConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _channelName?;
    /**
     * @stability stable
     */
    get channelName(): string;
    /**
     * @stability stable
     */
    set channelName(value: string);
    /**
     * @stability stable
     */
    get channelNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _display;
    /**
     * @stability stable
     */
    get display(): IntegrationSlackChannelDisplayOutputReference;
    /**
     * @stability stable
     */
    putDisplay(value: IntegrationSlackChannelDisplay): void;
    /**
     * @stability stable
     */
    get displayInput(): IntegrationSlackChannelDisplay | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
