import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogsArchiveOrderConfig extends cdktf.TerraformMetaArguments {
    /**
     * The archive IDs list.
     *
     * The order of archive IDs in this attribute defines the overall archive order for logs. If `archive_ids` is empty or not specified, it will import the actual archive order, and create the resource. Otherwise, it will try to update the order.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive_order#archive_ids LogsArchiveOrder#archive_ids}
     *
     * @stability stable
     */
    readonly archiveIds?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive_order datadog_logs_archive_order}.
 *
 * @stability stable
 */
export declare class LogsArchiveOrder extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive_order datadog_logs_archive_order} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: LogsArchiveOrderConfig);
    private _archiveIds?;
    /**
     * @stability stable
     */
    get archiveIds(): string[];
    /**
     * @stability stable
     */
    set archiveIds(value: string[]);
    /**
     * @stability stable
     */
    resetArchiveIds(): void;
    /**
     * @stability stable
     */
    get archiveIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
