import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogsArchiveConfig extends cdktf.TerraformMetaArguments {
    /**
     * To store the tags in the archive, set the value `true`.
     *
     * If it is set to `false`, the tags will be dropped when the logs are sent to the archive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#include_tags LogsArchive#include_tags}
     *
     * @stability stable
     */
    readonly includeTags?: boolean | cdktf.IResolvable;
    /**
     * Your archive name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#name LogsArchive#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The archive query/filter. Logs matching this query are included in the archive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#query LogsArchive#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * An array of tags to add to rehydrated logs from an archive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#rehydration_tags LogsArchive#rehydration_tags}
     *
     * @stability stable
     */
    readonly rehydrationTags?: string[];
    /**
     * azure_archive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#azure_archive LogsArchive#azure_archive}
     *
     * @stability stable
     */
    readonly azureArchive?: LogsArchiveAzureArchive;
    /**
     * gcs_archive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#gcs_archive LogsArchive#gcs_archive}
     *
     * @stability stable
     */
    readonly gcsArchive?: LogsArchiveGcsArchive;
    /**
     * s3_archive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#s3_archive LogsArchive#s3_archive}
     *
     * @stability stable
     */
    readonly s3Archive?: LogsArchiveS3Archive;
}
/**
 * @stability stable
 */
export interface LogsArchiveAzureArchive {
    /**
     * Your client id.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#client_id LogsArchive#client_id}
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * The container where the archive will be stored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#container LogsArchive#container}
     *
     * @stability stable
     */
    readonly container: string;
    /**
     * The path where the archive will be stored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#path LogsArchive#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * The associated storage account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#storage_account LogsArchive#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount: string;
    /**
     * Your tenant id.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#tenant_id LogsArchive#tenant_id}
     *
     * @stability stable
     */
    readonly tenantId: string;
}
export declare function logsArchiveAzureArchiveToTerraform(struct?: LogsArchiveAzureArchiveOutputReference | LogsArchiveAzureArchive): any;
/**
 * @stability stable
 */
export declare class LogsArchiveAzureArchiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogsArchiveAzureArchive | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogsArchiveAzureArchive | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _container?;
    /**
     * @stability stable
     */
    get container(): string;
    /**
     * @stability stable
     */
    set container(value: string);
    /**
     * @stability stable
     */
    get containerInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): string;
    /**
     * @stability stable
     */
    set storageAccount(value: string);
    /**
     * @stability stable
     */
    get storageAccountInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsArchiveGcsArchive {
    /**
     * Name of your GCS bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#bucket LogsArchive#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Your client email.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#client_email LogsArchive#client_email}
     *
     * @stability stable
     */
    readonly clientEmail: string;
    /**
     * Path where the archive will be stored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#path LogsArchive#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Your project id.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#project_id LogsArchive#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
}
export declare function logsArchiveGcsArchiveToTerraform(struct?: LogsArchiveGcsArchiveOutputReference | LogsArchiveGcsArchive): any;
/**
 * @stability stable
 */
export declare class LogsArchiveGcsArchiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogsArchiveGcsArchive | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogsArchiveGcsArchive | undefined);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _clientEmail?;
    /**
     * @stability stable
     */
    get clientEmail(): string;
    /**
     * @stability stable
     */
    set clientEmail(value: string);
    /**
     * @stability stable
     */
    get clientEmailInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsArchiveS3Archive {
    /**
     * Your AWS account id.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#account_id LogsArchive#account_id}
     *
     * @stability stable
     */
    readonly accountId: string;
    /**
     * Name of your s3 bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#bucket LogsArchive#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Path where the archive will be stored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#path LogsArchive#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Your AWS role name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#role_name LogsArchive#role_name}
     *
     * @stability stable
     */
    readonly roleName: string;
}
export declare function logsArchiveS3ArchiveToTerraform(struct?: LogsArchiveS3ArchiveOutputReference | LogsArchiveS3Archive): any;
/**
 * @stability stable
 */
export declare class LogsArchiveS3ArchiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogsArchiveS3Archive | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogsArchiveS3Archive | undefined);
    private _accountId?;
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    set accountId(value: string);
    /**
     * @stability stable
     */
    get accountIdInput(): string | undefined;
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _roleName?;
    /**
     * @stability stable
     */
    get roleName(): string;
    /**
     * @stability stable
     */
    set roleName(value: string);
    /**
     * @stability stable
     */
    get roleNameInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive datadog_logs_archive}.
 *
 * @stability stable
 */
export declare class LogsArchive extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive datadog_logs_archive} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogsArchiveConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _includeTags?;
    /**
     * @stability stable
     */
    get includeTags(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeTags(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeTags(): void;
    /**
     * @stability stable
     */
    get includeTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _rehydrationTags?;
    /**
     * @stability stable
     */
    get rehydrationTags(): string[];
    /**
     * @stability stable
     */
    set rehydrationTags(value: string[]);
    /**
     * @stability stable
     */
    resetRehydrationTags(): void;
    /**
     * @stability stable
     */
    get rehydrationTagsInput(): string[] | undefined;
    private _azureArchive;
    /**
     * @stability stable
     */
    get azureArchive(): LogsArchiveAzureArchiveOutputReference;
    /**
     * @stability stable
     */
    putAzureArchive(value: LogsArchiveAzureArchive): void;
    /**
     * @stability stable
     */
    resetAzureArchive(): void;
    /**
     * @stability stable
     */
    get azureArchiveInput(): LogsArchiveAzureArchive | undefined;
    private _gcsArchive;
    /**
     * @stability stable
     */
    get gcsArchive(): LogsArchiveGcsArchiveOutputReference;
    /**
     * @stability stable
     */
    putGcsArchive(value: LogsArchiveGcsArchive): void;
    /**
     * @stability stable
     */
    resetGcsArchive(): void;
    /**
     * @stability stable
     */
    get gcsArchiveInput(): LogsArchiveGcsArchive | undefined;
    private _s3Archive;
    /**
     * @stability stable
     */
    get s3Archive(): LogsArchiveS3ArchiveOutputReference;
    /**
     * @stability stable
     */
    putS3Archive(value: LogsArchiveS3Archive): void;
    /**
     * @stability stable
     */
    resetS3Archive(): void;
    /**
     * @stability stable
     */
    get s3ArchiveInput(): LogsArchiveS3Archive | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
