import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogsIndexOrderConfig extends cdktf.TerraformMetaArguments {
    /**
     * The index resource list.
     *
     * Logs are tested against the query filter of each index one by one following the order of the list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index_order#indexes LogsIndexOrder#indexes}
     *
     * @stability stable
     */
    readonly indexes: string[];
    /**
     * The unique name of the index order resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index_order#name LogsIndexOrder#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_index_order datadog_logs_index_order}.
 *
 * @stability stable
 */
export declare class LogsIndexOrder extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_index_order datadog_logs_index_order} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogsIndexOrderConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[];
    /**
     * @stability stable
     */
    set indexes(value: string[]);
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
