import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogsMetricConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the log-based metric. This field can't be updated after creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#name LogsMetric#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#compute LogsMetric#compute}
     *
     * @stability stable
     */
    readonly compute: LogsMetricCompute;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#filter LogsMetric#filter}
     *
     * @stability stable
     */
    readonly filter: LogsMetricFilter;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#group_by LogsMetric#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: LogsMetricGroupBy[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface LogsMetricCompute {
    /**
     * The type of aggregation to use. This field can't be updated after creation. Valid values are `count`, `distribution`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#aggregation_type LogsMetric#aggregation_type}
     *
     * @stability stable
     */
    readonly aggregationType: string;
    /**
     * The path to the value the log-based metric will aggregate on (only used if the aggregation type is a "distribution").
     *
     * This field can't be updated after creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#path LogsMetric#path}
     *
     * @stability stable
     */
    readonly path?: string;
}
export declare function logsMetricComputeToTerraform(struct?: LogsMetricComputeOutputReference | LogsMetricCompute): any;
/**
 * @stability stable
 */
export declare class LogsMetricComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogsMetricCompute | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogsMetricCompute | undefined);
    private _aggregationType?;
    /**
     * @stability stable
     */
    get aggregationType(): string;
    /**
     * @stability stable
     */
    set aggregationType(value: string);
    /**
     * @stability stable
     */
    get aggregationTypeInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsMetricFilter {
    /**
     * The search query - following the log search syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#query LogsMetric#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function logsMetricFilterToTerraform(struct?: LogsMetricFilterOutputReference | LogsMetricFilter): any;
/**
 * @stability stable
 */
export declare class LogsMetricFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogsMetricFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogsMetricFilter | undefined);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsMetricGroupBy {
    /**
     * The path to the value the log-based metric will be aggregated over.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#path LogsMetric#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Name of the tag that gets created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#tag_name LogsMetric#tag_name}
     *
     * @stability stable
     */
    readonly tagName: string;
}
export declare function logsMetricGroupByToTerraform(struct?: LogsMetricGroupBy | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric datadog_logs_metric}.
 *
 * @stability stable
 */
export declare class LogsMetric extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric datadog_logs_metric} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogsMetricConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute;
    /**
     * @stability stable
     */
    get compute(): LogsMetricComputeOutputReference;
    /**
     * @stability stable
     */
    putCompute(value: LogsMetricCompute): void;
    /**
     * @stability stable
     */
    get computeInput(): LogsMetricCompute | undefined;
    private _filter;
    /**
     * @stability stable
     */
    get filter(): LogsMetricFilterOutputReference;
    /**
     * @stability stable
     */
    putFilter(value: LogsMetricFilter): void;
    /**
     * @stability stable
     */
    get filterInput(): LogsMetricFilter | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): LogsMetricGroupBy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set groupBy(value: LogsMetricGroupBy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): cdktf.IResolvable | LogsMetricGroupBy[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
