import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MetricTagConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Toggle to include/exclude percentiles for a distribution metric.
     *
     * Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#include_percentiles MetricTagConfiguration#include_percentiles}
     *
     * @stability stable
     */
    readonly includePercentiles?: boolean | cdktf.IResolvable;
    /**
     * The metric name for this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#metric_name MetricTagConfiguration#metric_name}
     *
     * @stability stable
     */
    readonly metricName: string;
    /**
     * The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#metric_type MetricTagConfiguration#metric_type}
     *
     * @stability stable
     */
    readonly metricType: string;
    /**
     * A list of tag keys that will be queryable for your metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#tags MetricTagConfiguration#tags}
     *
     * @stability stable
     */
    readonly tags: string[];
    /**
     * aggregations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#aggregations MetricTagConfiguration#aggregations}
     *
     * @stability stable
     */
    readonly aggregations?: MetricTagConfigurationAggregations[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface MetricTagConfigurationAggregations {
    /**
     * A space aggregation for use in query. Valid values are `avg`, `max`, `min`, `sum`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#space MetricTagConfiguration#space}
     *
     * @stability stable
     */
    readonly space: string;
    /**
     * A time aggregation for use in query. Valid values are `avg`, `count`, `max`, `min`, `sum`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#time MetricTagConfiguration#time}
     *
     * @stability stable
     */
    readonly time: string;
}
export declare function metricTagConfigurationAggregationsToTerraform(struct?: MetricTagConfigurationAggregations | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration datadog_metric_tag_configuration}.
 *
 * @stability stable
 */
export declare class MetricTagConfiguration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration datadog_metric_tag_configuration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MetricTagConfigurationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _includePercentiles?;
    /**
     * @stability stable
     */
    get includePercentiles(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includePercentiles(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludePercentiles(): void;
    /**
     * @stability stable
     */
    get includePercentilesInput(): boolean | cdktf.IResolvable | undefined;
    private _metricName?;
    /**
     * @stability stable
     */
    get metricName(): string;
    /**
     * @stability stable
     */
    set metricName(value: string);
    /**
     * @stability stable
     */
    get metricNameInput(): string | undefined;
    private _metricType?;
    /**
     * @stability stable
     */
    get metricType(): string;
    /**
     * @stability stable
     */
    set metricType(value: string);
    /**
     * @stability stable
     */
    get metricTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _aggregations?;
    /**
     * @stability stable
     */
    get aggregations(): MetricTagConfigurationAggregations[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set aggregations(value: MetricTagConfigurationAggregations[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAggregations(): void;
    /**
     * @stability stable
     */
    get aggregationsInput(): cdktf.IResolvable | MetricTagConfigurationAggregations[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
