import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorJsonConfig extends cdktf.TerraformMetaArguments {
    /**
     * The JSON formatted definition of the monitor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json#monitor MonitorJson#monitor}
     *
     * @stability stable
     */
    readonly monitor: string;
    /**
     * The URL of the monitor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json#url MonitorJson#url}
     *
     * @stability stable
     */
    readonly url?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json datadog_monitor_json}.
 *
 * @stability stable
 */
export declare class MonitorJson extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json datadog_monitor_json} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorJsonConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _monitor?;
    /**
     * @stability stable
     */
    get monitor(): string;
    /**
     * @stability stable
     */
    set monitor(value: string);
    /**
     * @stability stable
     */
    get monitorInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
