import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityMonitoringDefaultRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Enable the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#enabled SecurityMonitoringDefaultRule#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * case block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#case SecurityMonitoringDefaultRule#case}
     *
     * @stability stable
     */
    readonly case?: SecurityMonitoringDefaultRuleCase[] | cdktf.IResolvable;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#filter SecurityMonitoringDefaultRule#filter}
     *
     * @stability stable
     */
    readonly filter?: SecurityMonitoringDefaultRuleFilter[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface SecurityMonitoringDefaultRuleCase {
    /**
     * Notification targets for each rule case.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#notifications SecurityMonitoringDefaultRule#notifications}
     *
     * @stability stable
     */
    readonly notifications: string[];
    /**
     * Status of the rule case to match. Valid values are `info`, `low`, `medium`, `high`, `critical`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#status SecurityMonitoringDefaultRule#status}
     *
     * @stability stable
     */
    readonly status: string;
}
export declare function securityMonitoringDefaultRuleCaseToTerraform(struct?: SecurityMonitoringDefaultRuleCase | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SecurityMonitoringDefaultRuleFilter {
    /**
     * The type of filtering action. Allowed enum values: require, suppress Valid values are `require`, `suppress`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#action SecurityMonitoringDefaultRule#action}
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Query for selecting logs to apply the filtering action.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#query SecurityMonitoringDefaultRule#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function securityMonitoringDefaultRuleFilterToTerraform(struct?: SecurityMonitoringDefaultRuleFilter | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule datadog_security_monitoring_default_rule}.
 *
 * @stability stable
 */
export declare class SecurityMonitoringDefaultRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule datadog_security_monitoring_default_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: SecurityMonitoringDefaultRuleConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _case?;
    /**
     * @stability stable
     */
    get case(): SecurityMonitoringDefaultRuleCase[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set case(value: SecurityMonitoringDefaultRuleCase[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCase(): void;
    /**
     * @stability stable
     */
    get caseInput(): cdktf.IResolvable | SecurityMonitoringDefaultRuleCase[] | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): SecurityMonitoringDefaultRuleFilter[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set filter(value: SecurityMonitoringDefaultRuleFilter[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): cdktf.IResolvable | SecurityMonitoringDefaultRuleFilter[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
