import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityMonitoringFilterConfig extends cdktf.TerraformMetaArguments {
    /**
     * The filtered data type. Valid values are `logs`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#filtered_data_type SecurityMonitoringFilter#filtered_data_type}
     *
     * @stability stable
     */
    readonly filteredDataType?: string;
    /**
     * Whether the security filter is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#is_enabled SecurityMonitoringFilter#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
     * The name of the security filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#name SecurityMonitoringFilter#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The query of the security filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#query SecurityMonitoringFilter#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * exclusion_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#exclusion_filter SecurityMonitoringFilter#exclusion_filter}
     *
     * @stability stable
     */
    readonly exclusionFilter?: SecurityMonitoringFilterExclusionFilter[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface SecurityMonitoringFilterExclusionFilter {
    /**
     * Exclusion filter name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#name SecurityMonitoringFilter#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Exclusion filter query. Logs that match this query are excluded from the security filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#query SecurityMonitoringFilter#query}
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function securityMonitoringFilterExclusionFilterToTerraform(struct?: SecurityMonitoringFilterExclusionFilter | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter datadog_security_monitoring_filter}.
 *
 * @stability stable
 */
export declare class SecurityMonitoringFilter extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter datadog_security_monitoring_filter} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecurityMonitoringFilterConfig);
    private _filteredDataType?;
    /**
     * @stability stable
     */
    get filteredDataType(): string;
    /**
     * @stability stable
     */
    set filteredDataType(value: string);
    /**
     * @stability stable
     */
    resetFilteredDataType(): void;
    /**
     * @stability stable
     */
    get filteredDataTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    /**
     * @stability stable
     */
    get version(): number;
    private _exclusionFilter?;
    /**
     * @stability stable
     */
    get exclusionFilter(): SecurityMonitoringFilterExclusionFilter[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set exclusionFilter(value: SecurityMonitoringFilterExclusionFilter[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExclusionFilter(): void;
    /**
     * @stability stable
     */
    get exclusionFilterInput(): cdktf.IResolvable | SecurityMonitoringFilterExclusionFilter[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
