import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceLevelObjectiveConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of this service level objective.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#description ServiceLevelObjective#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. dashboards).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#force_delete ServiceLevelObjective#force_delete}
     *
     * @stability stable
     */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
     * A static set of groups to filter monitor-based SLOs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#groups ServiceLevelObjective#groups}
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * A static set of monitor IDs to use as part of the SLO.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#monitor_ids ServiceLevelObjective#monitor_ids}
     *
     * @stability stable
     */
    readonly monitorIds?: number[];
    /**
     * Name of Datadog service level objective.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#name ServiceLevelObjective#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A list of tags to associate with your service level objective.
     *
     * This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#tags ServiceLevelObjective#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The type of the service level objective.
     *
     * The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#type ServiceLevelObjective#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Whether or not to validate the SLO.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#validate ServiceLevelObjective#validate}
     *
     * @stability stable
     */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#query ServiceLevelObjective#query}
     *
     * @stability stable
     */
    readonly query?: ServiceLevelObjectiveQuery;
    /**
     * thresholds block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#thresholds ServiceLevelObjective#thresholds}
     *
     * @stability stable
     */
    readonly thresholds: ServiceLevelObjectiveThresholds[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface ServiceLevelObjectiveQuery {
    /**
     * The sum of the `total` events.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#denominator ServiceLevelObjective#denominator}
     *
     * @stability stable
     */
    readonly denominator: string;
    /**
     * The sum of all the `good` events.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#numerator ServiceLevelObjective#numerator}
     *
     * @stability stable
     */
    readonly numerator: string;
}
export declare function serviceLevelObjectiveQueryToTerraform(struct?: ServiceLevelObjectiveQueryOutputReference | ServiceLevelObjectiveQuery): any;
/**
 * @stability stable
 */
export declare class ServiceLevelObjectiveQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceLevelObjectiveQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceLevelObjectiveQuery | undefined);
    private _denominator?;
    /**
     * @stability stable
     */
    get denominator(): string;
    /**
     * @stability stable
     */
    set denominator(value: string);
    /**
     * @stability stable
     */
    get denominatorInput(): string | undefined;
    private _numerator?;
    /**
     * @stability stable
     */
    get numerator(): string;
    /**
     * @stability stable
     */
    set numerator(value: string);
    /**
     * @stability stable
     */
    get numeratorInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServiceLevelObjectiveThresholds {
    /**
     * The objective's target in`[0,100]`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#target ServiceLevelObjective#target}
     *
     * @stability stable
     */
    readonly target: number;
    /**
     * The time frame for the objective.
     *
     * The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#timeframe ServiceLevelObjective#timeframe}
     *
     * @stability stable
     */
    readonly timeframe: string;
    /**
     * The objective's warning value in `[0,100]`. This must be greater than the target value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#warning ServiceLevelObjective#warning}
     *
     * @stability stable
     */
    readonly warning?: number;
}
export declare function serviceLevelObjectiveThresholdsToTerraform(struct?: ServiceLevelObjectiveThresholds | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective datadog_service_level_objective}.
 *
 * @stability stable
 */
export declare class ServiceLevelObjective extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective datadog_service_level_objective} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceLevelObjectiveConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _forceDelete?;
    /**
     * @stability stable
     */
    get forceDelete(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceDelete(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceDelete(): void;
    /**
     * @stability stable
     */
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    resetGroups(): void;
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _monitorIds?;
    /**
     * @stability stable
     */
    get monitorIds(): number[];
    /**
     * @stability stable
     */
    set monitorIds(value: number[]);
    /**
     * @stability stable
     */
    resetMonitorIds(): void;
    /**
     * @stability stable
     */
    get monitorIdsInput(): number[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _validate?;
    /**
     * @stability stable
     */
    get validate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set validate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetValidate(): void;
    /**
     * @stability stable
     */
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _query;
    /**
     * @stability stable
     */
    get query(): ServiceLevelObjectiveQueryOutputReference;
    /**
     * @stability stable
     */
    putQuery(value: ServiceLevelObjectiveQuery): void;
    /**
     * @stability stable
     */
    resetQuery(): void;
    /**
     * @stability stable
     */
    get queryInput(): ServiceLevelObjectiveQuery | undefined;
    private _thresholds?;
    /**
     * @stability stable
     */
    get thresholds(): ServiceLevelObjectiveThresholds[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set thresholds(value: ServiceLevelObjectiveThresholds[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get thresholdsInput(): cdktf.IResolvable | ServiceLevelObjectiveThresholds[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
