import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SloCorrectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#category SloCorrection#category}
     *
     * @stability stable
     */
    readonly category: string;
    /**
     * Description of the correction being made.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#description SloCorrection#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#duration SloCorrection#duration}
     *
     * @stability stable
     */
    readonly duration?: number;
    /**
     * Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#end SloCorrection#end}
     *
     * @stability stable
     */
    readonly end?: number;
    /**
     * Recurrence rules as defined in the iCalendar RFC 5545.
     *
     * Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#rrule SloCorrection#rrule}
     *
     * @stability stable
     */
    readonly rrule?: string;
    /**
     * ID of the SLO that this correction will be applied to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#slo_id SloCorrection#slo_id}
     *
     * @stability stable
     */
    readonly sloId: string;
    /**
     * Starting time of the correction in epoch seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#start SloCorrection#start}
     *
     * @stability stable
     */
    readonly start: number;
    /**
     * The timezone to display in the UI for the correction times (defaults to "UTC").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#timezone SloCorrection#timezone}
     *
     * @stability stable
     */
    readonly timezone?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction datadog_slo_correction}.
 *
 * @stability stable
 */
export declare class SloCorrection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction datadog_slo_correction} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SloCorrectionConfig);
    private _category?;
    /**
     * @stability stable
     */
    get category(): string;
    /**
     * @stability stable
     */
    set category(value: string);
    /**
     * @stability stable
     */
    get categoryInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): number;
    /**
     * @stability stable
     */
    set duration(value: number);
    /**
     * @stability stable
     */
    resetDuration(): void;
    /**
     * @stability stable
     */
    get durationInput(): number | undefined;
    private _end?;
    /**
     * @stability stable
     */
    get end(): number;
    /**
     * @stability stable
     */
    set end(value: number);
    /**
     * @stability stable
     */
    resetEnd(): void;
    /**
     * @stability stable
     */
    get endInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _rrule?;
    /**
     * @stability stable
     */
    get rrule(): string;
    /**
     * @stability stable
     */
    set rrule(value: string);
    /**
     * @stability stable
     */
    resetRrule(): void;
    /**
     * @stability stable
     */
    get rruleInput(): string | undefined;
    private _sloId?;
    /**
     * @stability stable
     */
    get sloId(): string;
    /**
     * @stability stable
     */
    set sloId(value: string);
    /**
     * @stability stable
     */
    get sloIdInput(): string | undefined;
    private _start?;
    /**
     * @stability stable
     */
    get start(): number;
    /**
     * @stability stable
     */
    set start(value: number);
    /**
     * @stability stable
     */
    get startInput(): number | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
