import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SyntheticsGlobalVariableConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the global variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#description SyntheticsGlobalVariable#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Synthetics global variable name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#name SyntheticsGlobalVariable#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Id of the Synthetics test to use for a variable from test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#parse_test_id SyntheticsGlobalVariable#parse_test_id}
     *
     * @stability stable
     */
    readonly parseTestId?: string;
    /**
     * A list of role identifiers to associate with the Synthetics global variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#restricted_roles SyntheticsGlobalVariable#restricted_roles}
     *
     * @stability stable
     */
    readonly restrictedRoles?: string[];
    /**
     * If set to true, the value of the global variable is hidden. Defaults to `false`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#secure SyntheticsGlobalVariable#secure}
     *
     * @stability stable
     */
    readonly secure?: boolean | cdktf.IResolvable;
    /**
     * A list of tags to associate with your synthetics global variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#tags SyntheticsGlobalVariable#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The value of the global variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#value SyntheticsGlobalVariable#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * parse_test_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#parse_test_options SyntheticsGlobalVariable#parse_test_options}
     *
     * @stability stable
     */
    readonly parseTestOptions?: SyntheticsGlobalVariableParseTestOptions;
}
/**
 * @stability stable
 */
export interface SyntheticsGlobalVariableParseTestOptionsParser {
    /**
     * Type of parser to extract the value. Valid values are `raw`, `json_path`, `regex`, `x_path`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#type SyntheticsGlobalVariable#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Value for the parser to use, required for type `json_path` or `regex`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#value SyntheticsGlobalVariable#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function syntheticsGlobalVariableParseTestOptionsParserToTerraform(struct?: SyntheticsGlobalVariableParseTestOptionsParserOutputReference | SyntheticsGlobalVariableParseTestOptionsParser): any;
/**
 * @stability stable
 */
export declare class SyntheticsGlobalVariableParseTestOptionsParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsGlobalVariableParseTestOptionsParser | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsGlobalVariableParseTestOptionsParser | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    resetValue(): void;
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsGlobalVariableParseTestOptions {
    /**
     * Required when type = `http_header`. Defines the header to use to extract the value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#field SyntheticsGlobalVariable#field}
     *
     * @stability stable
     */
    readonly field?: string;
    /**
     * Defines the source to use to extract the value. Valid values are `http_body`, `http_header`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#type SyntheticsGlobalVariable#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#parser SyntheticsGlobalVariable#parser}
     *
     * @stability stable
     */
    readonly parser: SyntheticsGlobalVariableParseTestOptionsParser;
}
export declare function syntheticsGlobalVariableParseTestOptionsToTerraform(struct?: SyntheticsGlobalVariableParseTestOptionsOutputReference | SyntheticsGlobalVariableParseTestOptions): any;
/**
 * @stability stable
 */
export declare class SyntheticsGlobalVariableParseTestOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsGlobalVariableParseTestOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsGlobalVariableParseTestOptions | undefined);
    private _field?;
    /**
     * @stability stable
     */
    get field(): string;
    /**
     * @stability stable
     */
    set field(value: string);
    /**
     * @stability stable
     */
    resetField(): void;
    /**
     * @stability stable
     */
    get fieldInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _parser;
    /**
     * @stability stable
     */
    get parser(): SyntheticsGlobalVariableParseTestOptionsParserOutputReference;
    /**
     * @stability stable
     */
    putParser(value: SyntheticsGlobalVariableParseTestOptionsParser): void;
    /**
     * @stability stable
     */
    get parserInput(): SyntheticsGlobalVariableParseTestOptionsParser | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable datadog_synthetics_global_variable}.
 *
 * @stability stable
 */
export declare class SyntheticsGlobalVariable extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable datadog_synthetics_global_variable} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SyntheticsGlobalVariableConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parseTestId?;
    /**
     * @stability stable
     */
    get parseTestId(): string;
    /**
     * @stability stable
     */
    set parseTestId(value: string);
    /**
     * @stability stable
     */
    resetParseTestId(): void;
    /**
     * @stability stable
     */
    get parseTestIdInput(): string | undefined;
    private _restrictedRoles?;
    /**
     * @stability stable
     */
    get restrictedRoles(): string[];
    /**
     * @stability stable
     */
    set restrictedRoles(value: string[]);
    /**
     * @stability stable
     */
    resetRestrictedRoles(): void;
    /**
     * @stability stable
     */
    get restrictedRolesInput(): string[] | undefined;
    private _secure?;
    /**
     * @stability stable
     */
    get secure(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secure(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecure(): void;
    /**
     * @stability stable
     */
    get secureInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _parseTestOptions;
    /**
     * @stability stable
     */
    get parseTestOptions(): SyntheticsGlobalVariableParseTestOptionsOutputReference;
    /**
     * @stability stable
     */
    putParseTestOptions(value: SyntheticsGlobalVariableParseTestOptions): void;
    /**
     * @stability stable
     */
    resetParseTestOptions(): void;
    /**
     * @stability stable
     */
    get parseTestOptionsInput(): SyntheticsGlobalVariableParseTestOptions | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
