import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SyntheticsTestConfig extends cdktf.TerraformMetaArguments {
    /**
     * Required if `type = "browser"`.
     *
     * Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#device_ids SyntheticsTest#device_ids}
     *
     * @stability stable
     */
    readonly deviceIds?: string[];
    /**
     * Array of locations used to run the test. Refer to [Datadog documentation](https://docs.datadoghq.com/synthetics/api_test/#request) for available locations (e.g. `aws:eu-central-1`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#locations SyntheticsTest#locations}
     *
     * @stability stable
     */
    readonly locations: string[];
    /**
     * A message to include with notifications for this synthetics test.
     *
     * Email notifications can be sent to specific users by using the same `@username` notation as events.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#message SyntheticsTest#message}
     *
     * @stability stable
     */
    readonly message?: string;
    /**
     * Name of Datadog synthetics test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Header name and value map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_headers SyntheticsTest#request_headers}
     *
     * @stability stable
     */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
     * Query arguments name and value map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_query SyntheticsTest#request_query}
     *
     * @stability stable
     */
    readonly requestQuery?: {
        [key: string]: string;
    };
    /**
     * Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#set_cookie SyntheticsTest#set_cookie}
     *
     * @stability stable
     */
    readonly setCookie?: string;
    /**
     * Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#status SyntheticsTest#status}
     *
     * @stability stable
     */
    readonly status: string;
    /**
     * The subtype of the Synthetic API test.
     *
     * Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#subtype SyntheticsTest#subtype}
     *
     * @stability stable
     */
    readonly subtype?: string;
    /**
     * A list of tags to associate with your synthetics test.
     *
     * This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#tags SyntheticsTest#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * Synthetics test type. Valid values are `api`, `browser`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * api_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#api_step SyntheticsTest#api_step}
     *
     * @stability stable
     */
    readonly apiStep?: SyntheticsTestApiStep[] | cdktf.IResolvable;
    /**
     * assertion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#assertion SyntheticsTest#assertion}
     *
     * @stability stable
     */
    readonly assertion?: SyntheticsTestAssertion[] | cdktf.IResolvable;
    /**
     * browser_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#browser_step SyntheticsTest#browser_step}
     *
     * @stability stable
     */
    readonly browserStep?: SyntheticsTestBrowserStep[] | cdktf.IResolvable;
    /**
     * browser_variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#browser_variable SyntheticsTest#browser_variable}
     *
     * @stability stable
     */
    readonly browserVariable?: SyntheticsTestBrowserVariable[] | cdktf.IResolvable;
    /**
     * config_variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#config_variable SyntheticsTest#config_variable}
     *
     * @stability stable
     */
    readonly configVariable?: SyntheticsTestConfigVariable[] | cdktf.IResolvable;
    /**
     * options_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#options_list SyntheticsTest#options_list}
     *
     * @stability stable
     */
    readonly optionsList?: SyntheticsTestOptionsList;
    /**
     * request_basicauth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_basicauth SyntheticsTest#request_basicauth}
     *
     * @stability stable
     */
    readonly requestBasicauth?: SyntheticsTestRequestBasicauth;
    /**
     * request_client_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_client_certificate SyntheticsTest#request_client_certificate}
     *
     * @stability stable
     */
    readonly requestClientCertificate?: SyntheticsTestRequestClientCertificate;
    /**
     * request_definition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_definition SyntheticsTest#request_definition}
     *
     * @stability stable
     */
    readonly requestDefinition?: SyntheticsTestRequestDefinition;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepAssertionTargetjsonpath {
    /**
     * The JSON path to assert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#jsonpath SyntheticsTest#jsonpath}
     *
     * @stability stable
     */
    readonly jsonpath: string;
    /**
     * The specific operator to use on the path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Expected matching value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetvalue SyntheticsTest#targetvalue}
     *
     * @stability stable
     */
    readonly targetvalue: string;
}
export declare function syntheticsTestApiStepAssertionTargetjsonpathToTerraform(struct?: SyntheticsTestApiStepAssertionTargetjsonpathOutputReference | SyntheticsTestApiStepAssertionTargetjsonpath): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepAssertionTargetjsonpathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestApiStepAssertionTargetjsonpath | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestApiStepAssertionTargetjsonpath | undefined);
    private _jsonpath?;
    /**
     * @stability stable
     */
    get jsonpath(): string;
    /**
     * @stability stable
     */
    set jsonpath(value: string);
    /**
     * @stability stable
     */
    get jsonpathInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _targetvalue?;
    /**
     * @stability stable
     */
    get targetvalue(): string;
    /**
     * @stability stable
     */
    set targetvalue(value: string);
    /**
     * @stability stable
     */
    get targetvalueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepAssertion {
    /**
     * Assertion operator. **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * If assertion type is `header`, this is the header name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#property SyntheticsTest#property}
     *
     * @stability stable
     */
    readonly property?: string;
    /**
     * Expected value. Depends on the assertion type, refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test) for details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#target SyntheticsTest#target}
     *
     * @stability stable
     */
    readonly target?: string;
    /**
     * Type of assertion.
     *
     * **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)). Valid values are `body`, `header`, `statusCode`, `certificate`, `responseTime`, `property`, `recordEvery`, `recordSome`, `tlsVersion`, `minTlsVersion`, `latency`, `packetLossPercentage`, `packetsReceived`, `networkHop`, `receivedMessage`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * targetjsonpath block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetjsonpath SyntheticsTest#targetjsonpath}
     *
     * @stability stable
     */
    readonly targetjsonpath?: SyntheticsTestApiStepAssertionTargetjsonpath;
}
export declare function syntheticsTestApiStepAssertionToTerraform(struct?: SyntheticsTestApiStepAssertion | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepExtractedValueParser {
    /**
     * Type of parser for a Synthetics global variable from a synthetics test. Valid values are `raw`, `json_path`, `regex`, `x_path`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Regex or JSON path used for the parser. Not used with type `raw`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#value SyntheticsTest#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function syntheticsTestApiStepExtractedValueParserToTerraform(struct?: SyntheticsTestApiStepExtractedValueParserOutputReference | SyntheticsTestApiStepExtractedValueParser): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepExtractedValueParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestApiStepExtractedValueParser | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestApiStepExtractedValueParser | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    resetValue(): void;
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepExtractedValue {
    /**
     * When type is `http_header`, name of the header to use to extract the value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#field SyntheticsTest#field}
     *
     * @stability stable
     */
    readonly field?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Property of the Synthetics Test Response to use for the variable. Valid values are `http_body`, `http_header`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#parser SyntheticsTest#parser}
     *
     * @stability stable
     */
    readonly parser: SyntheticsTestApiStepExtractedValueParser;
}
export declare function syntheticsTestApiStepExtractedValueToTerraform(struct?: SyntheticsTestApiStepExtractedValue | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestBasicauth {
    /**
     * Password for authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#password SyntheticsTest#password}
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Username for authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#username SyntheticsTest#username}
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function syntheticsTestApiStepRequestBasicauthToTerraform(struct?: SyntheticsTestApiStepRequestBasicauthOutputReference | SyntheticsTestApiStepRequestBasicauth): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestBasicauthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestApiStepRequestBasicauth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestApiStepRequestBasicauth | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestClientCertificateCert {
    /**
     * Content of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#content SyntheticsTest#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * File name for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#filename SyntheticsTest#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
}
export declare function syntheticsTestApiStepRequestClientCertificateCertToTerraform(struct?: SyntheticsTestApiStepRequestClientCertificateCertOutputReference | SyntheticsTestApiStepRequestClientCertificateCert): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestClientCertificateCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestApiStepRequestClientCertificateCert | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestApiStepRequestClientCertificateCert | undefined);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestClientCertificateKey {
    /**
     * Content of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#content SyntheticsTest#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * File name for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#filename SyntheticsTest#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
}
export declare function syntheticsTestApiStepRequestClientCertificateKeyToTerraform(struct?: SyntheticsTestApiStepRequestClientCertificateKeyOutputReference | SyntheticsTestApiStepRequestClientCertificateKey): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestClientCertificateKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestApiStepRequestClientCertificateKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestApiStepRequestClientCertificateKey | undefined);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestClientCertificate {
    /**
     * cert block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#cert SyntheticsTest#cert}
     *
     * @stability stable
     */
    readonly cert: SyntheticsTestApiStepRequestClientCertificateCert;
    /**
     * key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#key SyntheticsTest#key}
     *
     * @stability stable
     */
    readonly key: SyntheticsTestApiStepRequestClientCertificateKey;
}
export declare function syntheticsTestApiStepRequestClientCertificateToTerraform(struct?: SyntheticsTestApiStepRequestClientCertificateOutputReference | SyntheticsTestApiStepRequestClientCertificate): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestClientCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestApiStepRequestClientCertificate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestApiStepRequestClientCertificate | undefined);
    private _cert;
    /**
     * @stability stable
     */
    get cert(): SyntheticsTestApiStepRequestClientCertificateCertOutputReference;
    /**
     * @stability stable
     */
    putCert(value: SyntheticsTestApiStepRequestClientCertificateCert): void;
    /**
     * @stability stable
     */
    get certInput(): SyntheticsTestApiStepRequestClientCertificateCert | undefined;
    private _key;
    /**
     * @stability stable
     */
    get key(): SyntheticsTestApiStepRequestClientCertificateKeyOutputReference;
    /**
     * @stability stable
     */
    putKey(value: SyntheticsTestApiStepRequestClientCertificateKey): void;
    /**
     * @stability stable
     */
    get keyInput(): SyntheticsTestApiStepRequestClientCertificateKey | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestDefinition {
    /**
     * Allows loading insecure content for an HTTP test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#allow_insecure SyntheticsTest#allow_insecure}
     *
     * @stability stable
     */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
     * The request body.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#body SyntheticsTest#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * DNS server to use for DNS tests (`subtype = "dns"`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#dns_server SyntheticsTest#dns_server}
     *
     * @stability stable
     */
    readonly dnsServer?: string;
    /**
     * DNS server port to use for DNS tests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#dns_server_port SyntheticsTest#dns_server_port}
     *
     * @stability stable
     */
    readonly dnsServerPort?: number;
    /**
     * Determines whether or not the API HTTP test should follow redirects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#follow_redirects SyntheticsTest#follow_redirects}
     *
     * @stability stable
     */
    readonly followRedirects?: boolean | cdktf.IResolvable;
    /**
     * Host name to perform the test with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#host SyntheticsTest#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * For UDP and websocket tests, message to send with the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#message SyntheticsTest#message}
     *
     * @stability stable
     */
    readonly message?: string;
    /**
     * The HTTP method. Valid values are `GET`, `POST`, `PATCH`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#method SyntheticsTest#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Determines whether or not to save the response body.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#no_saving_response_body SyntheticsTest#no_saving_response_body}
     *
     * @stability stable
     */
    readonly noSavingResponseBody?: boolean | cdktf.IResolvable;
    /**
     * Number of pings to use per test for ICMP tests (`subtype = "icmp"`) between 0 and 10.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#number_of_packets SyntheticsTest#number_of_packets}
     *
     * @stability stable
     */
    readonly numberOfPackets?: number;
    /**
     * Port to use when performing the test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#port SyntheticsTest#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * For SSL tests, it specifies on which server you want to initiate the TLS handshake, allowing the server to present one of multiple possible certificates on the same IP address and TCP port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#servername SyntheticsTest#servername}
     *
     * @stability stable
     */
    readonly servername?: string;
    /**
     * This will turn on a traceroute probe to discover all gateways along the path to the host destination.
     *
     * For ICMP tests (`subtype = "icmp"`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#should_track_hops SyntheticsTest#should_track_hops}
     *
     * @stability stable
     */
    readonly shouldTrackHops?: boolean | cdktf.IResolvable;
    /**
     * Timeout in seconds for the test. Defaults to `60`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#timeout SyntheticsTest#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * The URL to send the request to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#url SyntheticsTest#url}
     *
     * @stability stable
     */
    readonly url?: string;
}
export declare function syntheticsTestApiStepRequestDefinitionToTerraform(struct?: SyntheticsTestApiStepRequestDefinitionOutputReference | SyntheticsTestApiStepRequestDefinition): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestApiStepRequestDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestApiStepRequestDefinition | undefined);
    private _allowInsecure?;
    /**
     * @stability stable
     */
    get allowInsecure(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowInsecure(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowInsecure(): void;
    /**
     * @stability stable
     */
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _dnsServer?;
    /**
     * @stability stable
     */
    get dnsServer(): string;
    /**
     * @stability stable
     */
    set dnsServer(value: string);
    /**
     * @stability stable
     */
    resetDnsServer(): void;
    /**
     * @stability stable
     */
    get dnsServerInput(): string | undefined;
    private _dnsServerPort?;
    /**
     * @stability stable
     */
    get dnsServerPort(): number;
    /**
     * @stability stable
     */
    set dnsServerPort(value: number);
    /**
     * @stability stable
     */
    resetDnsServerPort(): void;
    /**
     * @stability stable
     */
    get dnsServerPortInput(): number | undefined;
    private _followRedirects?;
    /**
     * @stability stable
     */
    get followRedirects(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set followRedirects(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFollowRedirects(): void;
    /**
     * @stability stable
     */
    get followRedirectsInput(): boolean | cdktf.IResolvable | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _message?;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    set message(value: string);
    /**
     * @stability stable
     */
    resetMessage(): void;
    /**
     * @stability stable
     */
    get messageInput(): string | undefined;
    private _method?;
    /**
     * @stability stable
     */
    get method(): string;
    /**
     * @stability stable
     */
    set method(value: string);
    /**
     * @stability stable
     */
    resetMethod(): void;
    /**
     * @stability stable
     */
    get methodInput(): string | undefined;
    private _noSavingResponseBody?;
    /**
     * @stability stable
     */
    get noSavingResponseBody(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noSavingResponseBody(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoSavingResponseBody(): void;
    /**
     * @stability stable
     */
    get noSavingResponseBodyInput(): boolean | cdktf.IResolvable | undefined;
    private _numberOfPackets?;
    /**
     * @stability stable
     */
    get numberOfPackets(): number;
    /**
     * @stability stable
     */
    set numberOfPackets(value: number);
    /**
     * @stability stable
     */
    resetNumberOfPackets(): void;
    /**
     * @stability stable
     */
    get numberOfPacketsInput(): number | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _servername?;
    /**
     * @stability stable
     */
    get servername(): string;
    /**
     * @stability stable
     */
    set servername(value: string);
    /**
     * @stability stable
     */
    resetServername(): void;
    /**
     * @stability stable
     */
    get servernameInput(): string | undefined;
    private _shouldTrackHops?;
    /**
     * @stability stable
     */
    get shouldTrackHops(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set shouldTrackHops(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShouldTrackHops(): void;
    /**
     * @stability stable
     */
    get shouldTrackHopsInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    set timeout(value: number);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRetry {
    /**
     * Number of retries needed to consider a location as failed before sending a notification alert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#count SyntheticsTest#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Interval between a failed test and the next retry in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#interval SyntheticsTest#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function syntheticsTestApiStepRetryToTerraform(struct?: SyntheticsTestApiStepRetryOutputReference | SyntheticsTestApiStepRetry): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestApiStepRetry | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestApiStepRetry | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStep {
    /**
     * Determines whether or not to continue with test if this step fails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#allow_failure SyntheticsTest#allow_failure}
     *
     * @stability stable
     */
    readonly allowFailure?: boolean | cdktf.IResolvable;
    /**
     * Determines whether or not to consider the entire test as failed if this step fails.
     *
     * Can be used only if `allow_failure` is `true`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#is_critical SyntheticsTest#is_critical}
     *
     * @stability stable
     */
    readonly isCritical?: boolean | cdktf.IResolvable;
    /**
     * The name of the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Header name and value map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_headers SyntheticsTest#request_headers}
     *
     * @stability stable
     */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
     * Query arguments name and value map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_query SyntheticsTest#request_query}
     *
     * @stability stable
     */
    readonly requestQuery?: {
        [key: string]: string;
    };
    /**
     * The subtype of the Synthetic multistep API test step. Valid values are `http`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#subtype SyntheticsTest#subtype}
     *
     * @stability stable
     */
    readonly subtype?: string;
    /**
     * assertion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#assertion SyntheticsTest#assertion}
     *
     * @stability stable
     */
    readonly assertion?: SyntheticsTestApiStepAssertion[] | cdktf.IResolvable;
    /**
     * extracted_value block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#extracted_value SyntheticsTest#extracted_value}
     *
     * @stability stable
     */
    readonly extractedValue?: SyntheticsTestApiStepExtractedValue[] | cdktf.IResolvable;
    /**
     * request_basicauth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_basicauth SyntheticsTest#request_basicauth}
     *
     * @stability stable
     */
    readonly requestBasicauth?: SyntheticsTestApiStepRequestBasicauth;
    /**
     * request_client_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_client_certificate SyntheticsTest#request_client_certificate}
     *
     * @stability stable
     */
    readonly requestClientCertificate?: SyntheticsTestApiStepRequestClientCertificate;
    /**
     * request_definition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_definition SyntheticsTest#request_definition}
     *
     * @stability stable
     */
    readonly requestDefinition?: SyntheticsTestApiStepRequestDefinition;
    /**
     * retry block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#retry SyntheticsTest#retry}
     *
     * @stability stable
     */
    readonly retry?: SyntheticsTestApiStepRetry;
}
export declare function syntheticsTestApiStepToTerraform(struct?: SyntheticsTestApiStep | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SyntheticsTestAssertionTargetjsonpath {
    /**
     * The JSON path to assert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#jsonpath SyntheticsTest#jsonpath}
     *
     * @stability stable
     */
    readonly jsonpath: string;
    /**
     * The specific operator to use on the path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Expected matching value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetvalue SyntheticsTest#targetvalue}
     *
     * @stability stable
     */
    readonly targetvalue: string;
}
export declare function syntheticsTestAssertionTargetjsonpathToTerraform(struct?: SyntheticsTestAssertionTargetjsonpathOutputReference | SyntheticsTestAssertionTargetjsonpath): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestAssertionTargetjsonpathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestAssertionTargetjsonpath | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestAssertionTargetjsonpath | undefined);
    private _jsonpath?;
    /**
     * @stability stable
     */
    get jsonpath(): string;
    /**
     * @stability stable
     */
    set jsonpath(value: string);
    /**
     * @stability stable
     */
    get jsonpathInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _targetvalue?;
    /**
     * @stability stable
     */
    get targetvalue(): string;
    /**
     * @stability stable
     */
    set targetvalue(value: string);
    /**
     * @stability stable
     */
    get targetvalueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestAssertion {
    /**
     * Assertion operator. **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * If assertion type is `header`, this is the header name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#property SyntheticsTest#property}
     *
     * @stability stable
     */
    readonly property?: string;
    /**
     * Expected value. Depends on the assertion type, refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test) for details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#target SyntheticsTest#target}
     *
     * @stability stable
     */
    readonly target?: string;
    /**
     * Type of assertion.
     *
     * **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)). Valid values are `body`, `header`, `statusCode`, `certificate`, `responseTime`, `property`, `recordEvery`, `recordSome`, `tlsVersion`, `minTlsVersion`, `latency`, `packetLossPercentage`, `packetsReceived`, `networkHop`, `receivedMessage`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * targetjsonpath block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetjsonpath SyntheticsTest#targetjsonpath}
     *
     * @stability stable
     */
    readonly targetjsonpath?: SyntheticsTestAssertionTargetjsonpath;
}
export declare function syntheticsTestAssertionToTerraform(struct?: SyntheticsTestAssertion | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SyntheticsTestBrowserStepParamsVariable {
    /**
     * Example of the extracted variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#example SyntheticsTest#example}
     *
     * @stability stable
     */
    readonly example?: string;
    /**
     * Name of the extracted variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
export declare function syntheticsTestBrowserStepParamsVariableToTerraform(struct?: SyntheticsTestBrowserStepParamsVariableOutputReference | SyntheticsTestBrowserStepParamsVariable): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestBrowserStepParamsVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestBrowserStepParamsVariable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestBrowserStepParamsVariable | undefined);
    private _example?;
    /**
     * @stability stable
     */
    get example(): string;
    /**
     * @stability stable
     */
    set example(value: string);
    /**
     * @stability stable
     */
    resetExample(): void;
    /**
     * @stability stable
     */
    get exampleInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestBrowserStepParams {
    /**
     * Name of the attribute to use for an "assert attribute" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#attribute SyntheticsTest#attribute}
     *
     * @stability stable
     */
    readonly attribute?: string;
    /**
     * Check type to use for an assertion step.
     *
     * Valid values are `equals`, `notEquals`, `contains`, `notContains`, `startsWith`, `notStartsWith`, `greater`, `lower`, `greaterEquals`, `lowerEquals`, `matchRegex`, `between`, `isEmpty`, `notIsEmpty`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#check SyntheticsTest#check}
     *
     * @stability stable
     */
    readonly check?: string;
    /**
     * Type of click to use for a "click" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#click_type SyntheticsTest#click_type}
     *
     * @stability stable
     */
    readonly clickType?: string;
    /**
     * Javascript code to use for the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#code SyntheticsTest#code}
     *
     * @stability stable
     */
    readonly code?: string;
    /**
     * Delay between each key stroke for a "type test" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#delay SyntheticsTest#delay}
     *
     * @stability stable
     */
    readonly delay?: number;
    /**
     * Element to use for the step, json encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#element SyntheticsTest#element}
     *
     * @stability stable
     */
    readonly element?: string;
    /**
     * Details of the email for an "assert email" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#email SyntheticsTest#email}
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * For an "assert download" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#file SyntheticsTest#file}
     *
     * @stability stable
     */
    readonly file?: string;
    /**
     * Details of the files for an "upload files" step, json encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#files SyntheticsTest#files}
     *
     * @stability stable
     */
    readonly files?: string;
    /**
     * Modifier to use for a "press key" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#modifiers SyntheticsTest#modifiers}
     *
     * @stability stable
     */
    readonly modifiers?: string[];
    /**
     * ID of the tab to play the subtest.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#playing_tab_id SyntheticsTest#playing_tab_id}
     *
     * @stability stable
     */
    readonly playingTabId?: string;
    /**
     * Request for an API step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request SyntheticsTest#request}
     *
     * @stability stable
     */
    readonly request?: string;
    /**
     * ID of the Synthetics test to use as subtest.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#subtest_public_id SyntheticsTest#subtest_public_id}
     *
     * @stability stable
     */
    readonly subtestPublicId?: string;
    /**
     * Value of the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#value SyntheticsTest#value}
     *
     * @stability stable
     */
    readonly value?: string;
    /**
     * For "file upload" steps.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#with_click SyntheticsTest#with_click}
     *
     * @stability stable
     */
    readonly withClick?: boolean | cdktf.IResolvable;
    /**
     * X coordinates for a "scroll step".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#x SyntheticsTest#x}
     *
     * @stability stable
     */
    readonly x?: number;
    /**
     * Y coordinates for a "scroll step".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#y SyntheticsTest#y}
     *
     * @stability stable
     */
    readonly y?: number;
    /**
     * variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#variable SyntheticsTest#variable}
     *
     * @stability stable
     */
    readonly variable?: SyntheticsTestBrowserStepParamsVariable;
}
export declare function syntheticsTestBrowserStepParamsToTerraform(struct?: SyntheticsTestBrowserStepParamsOutputReference | SyntheticsTestBrowserStepParams): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestBrowserStepParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestBrowserStepParams | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestBrowserStepParams | undefined);
    private _attribute?;
    /**
     * @stability stable
     */
    get attribute(): string;
    /**
     * @stability stable
     */
    set attribute(value: string);
    /**
     * @stability stable
     */
    resetAttribute(): void;
    /**
     * @stability stable
     */
    get attributeInput(): string | undefined;
    private _check?;
    /**
     * @stability stable
     */
    get check(): string;
    /**
     * @stability stable
     */
    set check(value: string);
    /**
     * @stability stable
     */
    resetCheck(): void;
    /**
     * @stability stable
     */
    get checkInput(): string | undefined;
    private _clickType?;
    /**
     * @stability stable
     */
    get clickType(): string;
    /**
     * @stability stable
     */
    set clickType(value: string);
    /**
     * @stability stable
     */
    resetClickType(): void;
    /**
     * @stability stable
     */
    get clickTypeInput(): string | undefined;
    private _code?;
    /**
     * @stability stable
     */
    get code(): string;
    /**
     * @stability stable
     */
    set code(value: string);
    /**
     * @stability stable
     */
    resetCode(): void;
    /**
     * @stability stable
     */
    get codeInput(): string | undefined;
    private _delay?;
    /**
     * @stability stable
     */
    get delay(): number;
    /**
     * @stability stable
     */
    set delay(value: number);
    /**
     * @stability stable
     */
    resetDelay(): void;
    /**
     * @stability stable
     */
    get delayInput(): number | undefined;
    private _element?;
    /**
     * @stability stable
     */
    get element(): string;
    /**
     * @stability stable
     */
    set element(value: string);
    /**
     * @stability stable
     */
    resetElement(): void;
    /**
     * @stability stable
     */
    get elementInput(): string | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _file?;
    /**
     * @stability stable
     */
    get file(): string;
    /**
     * @stability stable
     */
    set file(value: string);
    /**
     * @stability stable
     */
    resetFile(): void;
    /**
     * @stability stable
     */
    get fileInput(): string | undefined;
    private _files?;
    /**
     * @stability stable
     */
    get files(): string;
    /**
     * @stability stable
     */
    set files(value: string);
    /**
     * @stability stable
     */
    resetFiles(): void;
    /**
     * @stability stable
     */
    get filesInput(): string | undefined;
    private _modifiers?;
    /**
     * @stability stable
     */
    get modifiers(): string[];
    /**
     * @stability stable
     */
    set modifiers(value: string[]);
    /**
     * @stability stable
     */
    resetModifiers(): void;
    /**
     * @stability stable
     */
    get modifiersInput(): string[] | undefined;
    private _playingTabId?;
    /**
     * @stability stable
     */
    get playingTabId(): string;
    /**
     * @stability stable
     */
    set playingTabId(value: string);
    /**
     * @stability stable
     */
    resetPlayingTabId(): void;
    /**
     * @stability stable
     */
    get playingTabIdInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): string;
    /**
     * @stability stable
     */
    set request(value: string);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): string | undefined;
    private _subtestPublicId?;
    /**
     * @stability stable
     */
    get subtestPublicId(): string;
    /**
     * @stability stable
     */
    set subtestPublicId(value: string);
    /**
     * @stability stable
     */
    resetSubtestPublicId(): void;
    /**
     * @stability stable
     */
    get subtestPublicIdInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    resetValue(): void;
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _withClick?;
    /**
     * @stability stable
     */
    get withClick(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withClick(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithClick(): void;
    /**
     * @stability stable
     */
    get withClickInput(): boolean | cdktf.IResolvable | undefined;
    private _x?;
    /**
     * @stability stable
     */
    get x(): number;
    /**
     * @stability stable
     */
    set x(value: number);
    /**
     * @stability stable
     */
    resetX(): void;
    /**
     * @stability stable
     */
    get xInput(): number | undefined;
    private _y?;
    /**
     * @stability stable
     */
    get y(): number;
    /**
     * @stability stable
     */
    set y(value: number);
    /**
     * @stability stable
     */
    resetY(): void;
    /**
     * @stability stable
     */
    get yInput(): number | undefined;
    private _variable;
    /**
     * @stability stable
     */
    get variable(): SyntheticsTestBrowserStepParamsVariableOutputReference;
    /**
     * @stability stable
     */
    putVariable(value: SyntheticsTestBrowserStepParamsVariable): void;
    /**
     * @stability stable
     */
    resetVariable(): void;
    /**
     * @stability stable
     */
    get variableInput(): SyntheticsTestBrowserStepParamsVariable | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestBrowserStep {
    /**
     * Determines if the step should be allowed to fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#allow_failure SyntheticsTest#allow_failure}
     *
     * @stability stable
     */
    readonly allowFailure?: boolean | cdktf.IResolvable;
    /**
     * Force update of the "element" parameter for the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#force_element_update SyntheticsTest#force_element_update}
     *
     * @stability stable
     */
    readonly forceElementUpdate?: boolean | cdktf.IResolvable;
    /**
     * Name of the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Used to override the default timeout of a step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#timeout SyntheticsTest#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * Type of the step.
     *
     * Valid values are `assertCurrentUrl`, `assertElementAttribute`, `assertElementContent`, `assertElementPresent`, `assertEmail`, `assertFileDownload`, `assertFromJavascript`, `assertPageContains`, `assertPageLacks`, `click`, `extractFromJavascript`, `extractVariable`, `goToEmailLink`, `goToUrl`, `goToUrlAndMeasureTti`, `hover`, `playSubTest`, `pressKey`, `refresh`, `runApiTest`, `scroll`, `selectOption`, `typeText`, `uploadFiles`, `wait`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#params SyntheticsTest#params}
     *
     * @stability stable
     */
    readonly params: SyntheticsTestBrowserStepParams;
}
export declare function syntheticsTestBrowserStepToTerraform(struct?: SyntheticsTestBrowserStep | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SyntheticsTestBrowserVariable {
    /**
     * Example for the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#example SyntheticsTest#example}
     *
     * @stability stable
     */
    readonly example?: string;
    /**
     * ID of the global variable to use.
     *
     * This is actually only used (and required) in the case of using a variable of type `global`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#id SyntheticsTest#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Name of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Pattern of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#pattern SyntheticsTest#pattern}
     *
     * @stability stable
     */
    readonly pattern?: string;
    /**
     * Type of browser test variable. Valid values are `element`, `email`, `global`, `javascript`, `text`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function syntheticsTestBrowserVariableToTerraform(struct?: SyntheticsTestBrowserVariable | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SyntheticsTestConfigVariable {
    /**
     * Example for the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#example SyntheticsTest#example}
     *
     * @stability stable
     */
    readonly example?: string;
    /**
     * When type = `global`, ID of the global variable to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#id SyntheticsTest#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Name of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Pattern of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#pattern SyntheticsTest#pattern}
     *
     * @stability stable
     */
    readonly pattern?: string;
    /**
     * Type of test configuration variable. Valid values are `global`, `text`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function syntheticsTestConfigVariableToTerraform(struct?: SyntheticsTestConfigVariable | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SyntheticsTestOptionsListMonitorOptions {
    /**
     * Specify a renotification frequency.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#renotify_interval SyntheticsTest#renotify_interval}
     *
     * @stability stable
     */
    readonly renotifyInterval?: number;
}
export declare function syntheticsTestOptionsListMonitorOptionsToTerraform(struct?: SyntheticsTestOptionsListMonitorOptionsOutputReference | SyntheticsTestOptionsListMonitorOptions): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestOptionsListMonitorOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestOptionsListMonitorOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestOptionsListMonitorOptions | undefined);
    private _renotifyInterval?;
    /**
     * @stability stable
     */
    get renotifyInterval(): number;
    /**
     * @stability stable
     */
    set renotifyInterval(value: number);
    /**
     * @stability stable
     */
    resetRenotifyInterval(): void;
    /**
     * @stability stable
     */
    get renotifyIntervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestOptionsListRetry {
    /**
     * Number of retries needed to consider a location as failed before sending a notification alert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#count SyntheticsTest#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Interval between a failed test and the next retry in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#interval SyntheticsTest#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function syntheticsTestOptionsListRetryToTerraform(struct?: SyntheticsTestOptionsListRetryOutputReference | SyntheticsTestOptionsListRetry): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestOptionsListRetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestOptionsListRetry | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestOptionsListRetry | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestOptionsList {
    /**
     * For SSL test, whether or not the test should allow self signed certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#accept_self_signed SyntheticsTest#accept_self_signed}
     *
     * @stability stable
     */
    readonly acceptSelfSigned?: boolean | cdktf.IResolvable;
    /**
     * Allows loading insecure content for an HTTP test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#allow_insecure SyntheticsTest#allow_insecure}
     *
     * @stability stable
     */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
     * Determines whether or not the API HTTP test should follow redirects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#follow_redirects SyntheticsTest#follow_redirects}
     *
     * @stability stable
     */
    readonly followRedirects?: boolean | cdktf.IResolvable;
    /**
     * Minimum amount of time in failure required to trigger an alert. Default is `0`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#min_failure_duration SyntheticsTest#min_failure_duration}
     *
     * @stability stable
     */
    readonly minFailureDuration?: number;
    /**
     * Minimum number of locations in failure required to trigger an alert. Default is `1`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#min_location_failed SyntheticsTest#min_location_failed}
     *
     * @stability stable
     */
    readonly minLocationFailed?: number;
    /**
     * The monitor name is used for the alert title as well as for all monitor dashboard widgets and SLOs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#monitor_name SyntheticsTest#monitor_name}
     *
     * @stability stable
     */
    readonly monitorName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#monitor_priority SyntheticsTest#monitor_priority}.
     *
     * @stability stable
     */
    readonly monitorPriority?: number;
    /**
     * Prevents saving screenshots of the steps.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#no_screenshot SyntheticsTest#no_screenshot}
     *
     * @stability stable
     */
    readonly noScreenshot?: boolean | cdktf.IResolvable;
    /**
     * How often the test should run (in seconds).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#tick_every SyntheticsTest#tick_every}
     *
     * @stability stable
     */
    readonly tickEvery: number;
    /**
     * monitor_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#monitor_options SyntheticsTest#monitor_options}
     *
     * @stability stable
     */
    readonly monitorOptions?: SyntheticsTestOptionsListMonitorOptions;
    /**
     * retry block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#retry SyntheticsTest#retry}
     *
     * @stability stable
     */
    readonly retry?: SyntheticsTestOptionsListRetry;
}
export declare function syntheticsTestOptionsListToTerraform(struct?: SyntheticsTestOptionsListOutputReference | SyntheticsTestOptionsList): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestOptionsListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestOptionsList | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestOptionsList | undefined);
    private _acceptSelfSigned?;
    /**
     * @stability stable
     */
    get acceptSelfSigned(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set acceptSelfSigned(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAcceptSelfSigned(): void;
    /**
     * @stability stable
     */
    get acceptSelfSignedInput(): boolean | cdktf.IResolvable | undefined;
    private _allowInsecure?;
    /**
     * @stability stable
     */
    get allowInsecure(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowInsecure(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowInsecure(): void;
    /**
     * @stability stable
     */
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _followRedirects?;
    /**
     * @stability stable
     */
    get followRedirects(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set followRedirects(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFollowRedirects(): void;
    /**
     * @stability stable
     */
    get followRedirectsInput(): boolean | cdktf.IResolvable | undefined;
    private _minFailureDuration?;
    /**
     * @stability stable
     */
    get minFailureDuration(): number;
    /**
     * @stability stable
     */
    set minFailureDuration(value: number);
    /**
     * @stability stable
     */
    resetMinFailureDuration(): void;
    /**
     * @stability stable
     */
    get minFailureDurationInput(): number | undefined;
    private _minLocationFailed?;
    /**
     * @stability stable
     */
    get minLocationFailed(): number;
    /**
     * @stability stable
     */
    set minLocationFailed(value: number);
    /**
     * @stability stable
     */
    resetMinLocationFailed(): void;
    /**
     * @stability stable
     */
    get minLocationFailedInput(): number | undefined;
    private _monitorName?;
    /**
     * @stability stable
     */
    get monitorName(): string;
    /**
     * @stability stable
     */
    set monitorName(value: string);
    /**
     * @stability stable
     */
    resetMonitorName(): void;
    /**
     * @stability stable
     */
    get monitorNameInput(): string | undefined;
    private _monitorPriority?;
    /**
     * @stability stable
     */
    get monitorPriority(): number;
    /**
     * @stability stable
     */
    set monitorPriority(value: number);
    /**
     * @stability stable
     */
    resetMonitorPriority(): void;
    /**
     * @stability stable
     */
    get monitorPriorityInput(): number | undefined;
    private _noScreenshot?;
    /**
     * @stability stable
     */
    get noScreenshot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noScreenshot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoScreenshot(): void;
    /**
     * @stability stable
     */
    get noScreenshotInput(): boolean | cdktf.IResolvable | undefined;
    private _tickEvery?;
    /**
     * @stability stable
     */
    get tickEvery(): number;
    /**
     * @stability stable
     */
    set tickEvery(value: number);
    /**
     * @stability stable
     */
    get tickEveryInput(): number | undefined;
    private _monitorOptions;
    /**
     * @stability stable
     */
    get monitorOptions(): SyntheticsTestOptionsListMonitorOptionsOutputReference;
    /**
     * @stability stable
     */
    putMonitorOptions(value: SyntheticsTestOptionsListMonitorOptions): void;
    /**
     * @stability stable
     */
    resetMonitorOptions(): void;
    /**
     * @stability stable
     */
    get monitorOptionsInput(): SyntheticsTestOptionsListMonitorOptions | undefined;
    private _retry;
    /**
     * @stability stable
     */
    get retry(): SyntheticsTestOptionsListRetryOutputReference;
    /**
     * @stability stable
     */
    putRetry(value: SyntheticsTestOptionsListRetry): void;
    /**
     * @stability stable
     */
    resetRetry(): void;
    /**
     * @stability stable
     */
    get retryInput(): SyntheticsTestOptionsListRetry | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestBasicauth {
    /**
     * Password for authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#password SyntheticsTest#password}
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Username for authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#username SyntheticsTest#username}
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function syntheticsTestRequestBasicauthToTerraform(struct?: SyntheticsTestRequestBasicauthOutputReference | SyntheticsTestRequestBasicauth): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestBasicauthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestRequestBasicauth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestRequestBasicauth | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestClientCertificateCert {
    /**
     * Content of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#content SyntheticsTest#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * File name for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#filename SyntheticsTest#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
}
export declare function syntheticsTestRequestClientCertificateCertToTerraform(struct?: SyntheticsTestRequestClientCertificateCertOutputReference | SyntheticsTestRequestClientCertificateCert): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestClientCertificateCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestRequestClientCertificateCert | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestRequestClientCertificateCert | undefined);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestClientCertificateKey {
    /**
     * Content of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#content SyntheticsTest#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * File name for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#filename SyntheticsTest#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
}
export declare function syntheticsTestRequestClientCertificateKeyToTerraform(struct?: SyntheticsTestRequestClientCertificateKeyOutputReference | SyntheticsTestRequestClientCertificateKey): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestClientCertificateKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestRequestClientCertificateKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestRequestClientCertificateKey | undefined);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestClientCertificate {
    /**
     * cert block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#cert SyntheticsTest#cert}
     *
     * @stability stable
     */
    readonly cert: SyntheticsTestRequestClientCertificateCert;
    /**
     * key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#key SyntheticsTest#key}
     *
     * @stability stable
     */
    readonly key: SyntheticsTestRequestClientCertificateKey;
}
export declare function syntheticsTestRequestClientCertificateToTerraform(struct?: SyntheticsTestRequestClientCertificateOutputReference | SyntheticsTestRequestClientCertificate): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestClientCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestRequestClientCertificate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestRequestClientCertificate | undefined);
    private _cert;
    /**
     * @stability stable
     */
    get cert(): SyntheticsTestRequestClientCertificateCertOutputReference;
    /**
     * @stability stable
     */
    putCert(value: SyntheticsTestRequestClientCertificateCert): void;
    /**
     * @stability stable
     */
    get certInput(): SyntheticsTestRequestClientCertificateCert | undefined;
    private _key;
    /**
     * @stability stable
     */
    get key(): SyntheticsTestRequestClientCertificateKeyOutputReference;
    /**
     * @stability stable
     */
    putKey(value: SyntheticsTestRequestClientCertificateKey): void;
    /**
     * @stability stable
     */
    get keyInput(): SyntheticsTestRequestClientCertificateKey | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestDefinition {
    /**
     * The request body.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#body SyntheticsTest#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * DNS server to use for DNS tests (`subtype = "dns"`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#dns_server SyntheticsTest#dns_server}
     *
     * @stability stable
     */
    readonly dnsServer?: string;
    /**
     * DNS server port to use for DNS tests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#dns_server_port SyntheticsTest#dns_server_port}
     *
     * @stability stable
     */
    readonly dnsServerPort?: number;
    /**
     * Host name to perform the test with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#host SyntheticsTest#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * For UDP and websocket tests, message to send with the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#message SyntheticsTest#message}
     *
     * @stability stable
     */
    readonly message?: string;
    /**
     * The HTTP method. Valid values are `GET`, `POST`, `PATCH`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#method SyntheticsTest#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Determines whether or not to save the response body.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#no_saving_response_body SyntheticsTest#no_saving_response_body}
     *
     * @stability stable
     */
    readonly noSavingResponseBody?: boolean | cdktf.IResolvable;
    /**
     * Number of pings to use per test for ICMP tests (`subtype = "icmp"`) between 0 and 10.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#number_of_packets SyntheticsTest#number_of_packets}
     *
     * @stability stable
     */
    readonly numberOfPackets?: number;
    /**
     * Port to use when performing the test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#port SyntheticsTest#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * For SSL tests, it specifies on which server you want to initiate the TLS handshake, allowing the server to present one of multiple possible certificates on the same IP address and TCP port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#servername SyntheticsTest#servername}
     *
     * @stability stable
     */
    readonly servername?: string;
    /**
     * This will turn on a traceroute probe to discover all gateways along the path to the host destination.
     *
     * For ICMP tests (`subtype = "icmp"`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#should_track_hops SyntheticsTest#should_track_hops}
     *
     * @stability stable
     */
    readonly shouldTrackHops?: boolean | cdktf.IResolvable;
    /**
     * Timeout in seconds for the test. Defaults to `60`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#timeout SyntheticsTest#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * The URL to send the request to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#url SyntheticsTest#url}
     *
     * @stability stable
     */
    readonly url?: string;
}
export declare function syntheticsTestRequestDefinitionToTerraform(struct?: SyntheticsTestRequestDefinitionOutputReference | SyntheticsTestRequestDefinition): any;
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SyntheticsTestRequestDefinition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SyntheticsTestRequestDefinition | undefined);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _dnsServer?;
    /**
     * @stability stable
     */
    get dnsServer(): string;
    /**
     * @stability stable
     */
    set dnsServer(value: string);
    /**
     * @stability stable
     */
    resetDnsServer(): void;
    /**
     * @stability stable
     */
    get dnsServerInput(): string | undefined;
    private _dnsServerPort?;
    /**
     * @stability stable
     */
    get dnsServerPort(): number;
    /**
     * @stability stable
     */
    set dnsServerPort(value: number);
    /**
     * @stability stable
     */
    resetDnsServerPort(): void;
    /**
     * @stability stable
     */
    get dnsServerPortInput(): number | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _message?;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    set message(value: string);
    /**
     * @stability stable
     */
    resetMessage(): void;
    /**
     * @stability stable
     */
    get messageInput(): string | undefined;
    private _method?;
    /**
     * @stability stable
     */
    get method(): string;
    /**
     * @stability stable
     */
    set method(value: string);
    /**
     * @stability stable
     */
    resetMethod(): void;
    /**
     * @stability stable
     */
    get methodInput(): string | undefined;
    private _noSavingResponseBody?;
    /**
     * @stability stable
     */
    get noSavingResponseBody(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noSavingResponseBody(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoSavingResponseBody(): void;
    /**
     * @stability stable
     */
    get noSavingResponseBodyInput(): boolean | cdktf.IResolvable | undefined;
    private _numberOfPackets?;
    /**
     * @stability stable
     */
    get numberOfPackets(): number;
    /**
     * @stability stable
     */
    set numberOfPackets(value: number);
    /**
     * @stability stable
     */
    resetNumberOfPackets(): void;
    /**
     * @stability stable
     */
    get numberOfPacketsInput(): number | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _servername?;
    /**
     * @stability stable
     */
    get servername(): string;
    /**
     * @stability stable
     */
    set servername(value: string);
    /**
     * @stability stable
     */
    resetServername(): void;
    /**
     * @stability stable
     */
    get servernameInput(): string | undefined;
    private _shouldTrackHops?;
    /**
     * @stability stable
     */
    get shouldTrackHops(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set shouldTrackHops(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShouldTrackHops(): void;
    /**
     * @stability stable
     */
    get shouldTrackHopsInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    set timeout(value: number);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test datadog_synthetics_test}.
 *
 * @stability stable
 */
export declare class SyntheticsTest extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test datadog_synthetics_test} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SyntheticsTestConfig);
    private _deviceIds?;
    /**
     * @stability stable
     */
    get deviceIds(): string[];
    /**
     * @stability stable
     */
    set deviceIds(value: string[]);
    /**
     * @stability stable
     */
    resetDeviceIds(): void;
    /**
     * @stability stable
     */
    get deviceIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _locations?;
    /**
     * @stability stable
     */
    get locations(): string[];
    /**
     * @stability stable
     */
    set locations(value: string[]);
    /**
     * @stability stable
     */
    get locationsInput(): string[] | undefined;
    private _message?;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    set message(value: string);
    /**
     * @stability stable
     */
    resetMessage(): void;
    /**
     * @stability stable
     */
    get messageInput(): string | undefined;
    /**
     * @stability stable
     */
    get monitorId(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _requestHeaders?;
    /**
     * @stability stable
     */
    get requestHeaders(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set requestHeaders(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetRequestHeaders(): void;
    /**
     * @stability stable
     */
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _requestQuery?;
    /**
     * @stability stable
     */
    get requestQuery(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set requestQuery(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetRequestQuery(): void;
    /**
     * @stability stable
     */
    get requestQueryInput(): {
        [key: string]: string;
    } | undefined;
    private _setCookie?;
    /**
     * @stability stable
     */
    get setCookie(): string;
    /**
     * @stability stable
     */
    set setCookie(value: string);
    /**
     * @stability stable
     */
    resetSetCookie(): void;
    /**
     * @stability stable
     */
    get setCookieInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _subtype?;
    /**
     * @stability stable
     */
    get subtype(): string;
    /**
     * @stability stable
     */
    set subtype(value: string);
    /**
     * @stability stable
     */
    resetSubtype(): void;
    /**
     * @stability stable
     */
    get subtypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _apiStep?;
    /**
     * @stability stable
     */
    get apiStep(): SyntheticsTestApiStep[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set apiStep(value: SyntheticsTestApiStep[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetApiStep(): void;
    /**
     * @stability stable
     */
    get apiStepInput(): cdktf.IResolvable | SyntheticsTestApiStep[] | undefined;
    private _assertion?;
    /**
     * @stability stable
     */
    get assertion(): SyntheticsTestAssertion[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set assertion(value: SyntheticsTestAssertion[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAssertion(): void;
    /**
     * @stability stable
     */
    get assertionInput(): cdktf.IResolvable | SyntheticsTestAssertion[] | undefined;
    private _browserStep?;
    /**
     * @stability stable
     */
    get browserStep(): SyntheticsTestBrowserStep[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set browserStep(value: SyntheticsTestBrowserStep[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBrowserStep(): void;
    /**
     * @stability stable
     */
    get browserStepInput(): cdktf.IResolvable | SyntheticsTestBrowserStep[] | undefined;
    private _browserVariable?;
    /**
     * @stability stable
     */
    get browserVariable(): SyntheticsTestBrowserVariable[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set browserVariable(value: SyntheticsTestBrowserVariable[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBrowserVariable(): void;
    /**
     * @stability stable
     */
    get browserVariableInput(): cdktf.IResolvable | SyntheticsTestBrowserVariable[] | undefined;
    private _configVariable?;
    /**
     * @stability stable
     */
    get configVariable(): SyntheticsTestConfigVariable[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set configVariable(value: SyntheticsTestConfigVariable[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetConfigVariable(): void;
    /**
     * @stability stable
     */
    get configVariableInput(): cdktf.IResolvable | SyntheticsTestConfigVariable[] | undefined;
    private _optionsList;
    /**
     * @stability stable
     */
    get optionsList(): SyntheticsTestOptionsListOutputReference;
    /**
     * @stability stable
     */
    putOptionsList(value: SyntheticsTestOptionsList): void;
    /**
     * @stability stable
     */
    resetOptionsList(): void;
    /**
     * @stability stable
     */
    get optionsListInput(): SyntheticsTestOptionsList | undefined;
    private _requestBasicauth;
    /**
     * @stability stable
     */
    get requestBasicauth(): SyntheticsTestRequestBasicauthOutputReference;
    /**
     * @stability stable
     */
    putRequestBasicauth(value: SyntheticsTestRequestBasicauth): void;
    /**
     * @stability stable
     */
    resetRequestBasicauth(): void;
    /**
     * @stability stable
     */
    get requestBasicauthInput(): SyntheticsTestRequestBasicauth | undefined;
    private _requestClientCertificate;
    /**
     * @stability stable
     */
    get requestClientCertificate(): SyntheticsTestRequestClientCertificateOutputReference;
    /**
     * @stability stable
     */
    putRequestClientCertificate(value: SyntheticsTestRequestClientCertificate): void;
    /**
     * @stability stable
     */
    resetRequestClientCertificate(): void;
    /**
     * @stability stable
     */
    get requestClientCertificateInput(): SyntheticsTestRequestClientCertificate | undefined;
    private _requestDefinition;
    /**
     * @stability stable
     */
    get requestDefinition(): SyntheticsTestRequestDefinitionOutputReference;
    /**
     * @stability stable
     */
    putRequestDefinition(value: SyntheticsTestRequestDefinition): void;
    /**
     * @stability stable
     */
    resetRequestDefinition(): void;
    /**
     * @stability stable
     */
    get requestDefinitionInput(): SyntheticsTestRequestDefinition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
