import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WebhookCustomVariableConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether the custom variable is secret or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable#is_secret WebhookCustomVariable#is_secret}
     *
     * @stability stable
     */
    readonly isSecret: boolean | cdktf.IResolvable;
    /**
     * The name of the variable. It corresponds with `<CUSTOM_VARIABLE_NAME>`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable#name WebhookCustomVariable#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The value of the custom variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable#value WebhookCustomVariable#value}
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable datadog_webhook_custom_variable}.
 *
 * @stability stable
 */
export declare class WebhookCustomVariable extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable datadog_webhook_custom_variable} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WebhookCustomVariableConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _isSecret?;
    /**
     * @stability stable
     */
    get isSecret(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isSecret(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isSecretInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
