import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WebhookConfig extends cdktf.TerraformMetaArguments {
    /**
     * The headers attached to the webhook.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#custom_headers Webhook#custom_headers}
     *
     * @stability stable
     */
    readonly customHeaders?: string;
    /**
     * Encoding type. Valid values are `json`, `form`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#encode_as Webhook#encode_as}
     *
     * @stability stable
     */
    readonly encodeAs?: string;
    /**
     * The name of the webhook. It corresponds with `<WEBHOOK_NAME>`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#name Webhook#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The payload of the webhook.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#payload Webhook#payload}
     *
     * @stability stable
     */
    readonly payload?: string;
    /**
     * The URL of the webhook.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#url Webhook#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/webhook datadog_webhook}.
 *
 * @stability stable
 */
export declare class Webhook extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/webhook datadog_webhook} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WebhookConfig);
    private _customHeaders?;
    /**
     * @stability stable
     */
    get customHeaders(): string;
    /**
     * @stability stable
     */
    set customHeaders(value: string);
    /**
     * @stability stable
     */
    resetCustomHeaders(): void;
    /**
     * @stability stable
     */
    get customHeadersInput(): string | undefined;
    private _encodeAs?;
    /**
     * @stability stable
     */
    get encodeAs(): string;
    /**
     * @stability stable
     */
    set encodeAs(value: string);
    /**
     * @stability stable
     */
    resetEncodeAs(): void;
    /**
     * @stability stable
     */
    get encodeAsInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _payload?;
    /**
     * @stability stable
     */
    get payload(): string;
    /**
     * @stability stable
     */
    set payload(value: string);
    /**
     * @stability stable
     */
    resetPayload(): void;
    /**
     * @stability stable
     */
    get payloadInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
